/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.java.diagnostics.healthcenter.memory.postprocessor;

import com.ibm.java.diagnostics.common.datamodel.data.DataBuilder;
import com.ibm.java.diagnostics.common.datamodel.data.DataPointBuilder;
import com.ibm.java.diagnostics.common.datamodel.data.SubsystemDataBuilder;
import com.ibm.java.diagnostics.common.datamodel.data.TwoDimensionalDataBuilder;
import com.ibm.java.diagnostics.common.datamodel.data.axes.AxisPair;
import com.ibm.java.diagnostics.common.datamodel.factory.DataFactory;
import com.ibm.java.diagnostics.common.datamodel.properties.OutputProperties;
import com.ibm.java.diagnostics.common.extensions.postprocessing.PostProcessor;
import com.ibm.java.diagnostics.common.util.logging.LogFactory;
import com.ibm.java.diagnostics.healthcenter.JVMLabels;
import com.ibm.java.diagnostics.healthcenter.memory.MemoryLabels;
import com.ibm.java.diagnostics.healthcenter.memory.data.MemoryTableDataImpl;
import com.ibm.java.diagnostics.healthcenter.memory.data.MemoryTableDataRowImpl;
import java.util.logging.Logger;

public class MemoryDerivedDataPostProcessor
implements PostProcessor {
    private static final String CLASS_NAME = MemoryDerivedDataPostProcessor.class.getName();
    private static final Logger TRACE = LogFactory.getTrace(MemoryDerivedDataPostProcessor.class);
    public static final DataFactory factory = DataFactory.getFactory();
    private int currentSequenceID = 0;
    AxisPair axisPair = null;
    DataBuilder cumulativeData;

    @Override
    public void postprocess(DataBuilder dataBuilder, OutputProperties outputProperties) {
        TRACE.entering(CLASS_NAME, "postprocess");
        SubsystemDataBuilder subsystemDataBuilder = (SubsystemDataBuilder)dataBuilder.getTopLevelData(JVMLabels.MEMORY);
        if (subsystemDataBuilder != null) {
            this.calculateTableData(subsystemDataBuilder);
        }
        TRACE.exiting(CLASS_NAME, "postprocess");
    }

    private void calculateTableData(SubsystemDataBuilder subsystemDataBuilder) {
        MemoryTableDataImpl memoryTableDataImpl = (MemoryTableDataImpl)subsystemDataBuilder.getData(MemoryLabels.MEMORY_SUMMARY);
        if (memoryTableDataImpl == null) {
            memoryTableDataImpl = new MemoryTableDataImpl(MemoryLabels.MEMORY_SUMMARY);
            subsystemDataBuilder.addData(memoryTableDataImpl);
        }
        for (DataBuilder dataBuilder : subsystemDataBuilder.getChildren()) {
            TwoDimensionalDataBuilder twoDimensionalDataBuilder;
            if (!(dataBuilder instanceof TwoDimensionalDataBuilder) || (twoDimensionalDataBuilder = (TwoDimensionalDataBuilder)dataBuilder).isEmpty()) continue;
            String string = twoDimensionalDataBuilder.getLabel();
            DataPointBuilder dataPointBuilder = twoDimensionalDataBuilder.getLastDataPoint();
            DataPointBuilder[] dataPointBuilderArray = twoDimensionalDataBuilder.getDataPoints();
            DataPointBuilder dataPointBuilder2 = null;
            if (dataPointBuilderArray.length > 1) {
                dataPointBuilder2 = dataPointBuilderArray[dataPointBuilderArray.length - 2];
            }
            MemoryTableDataRowImpl memoryTableDataRowImpl = new MemoryTableDataRowImpl(string, dataPointBuilder, dataPointBuilder2, twoDimensionalDataBuilder.getMinY(), twoDimensionalDataBuilder.getMaxY());
            memoryTableDataImpl.addRow(string, memoryTableDataRowImpl);
        }
    }
}

