/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.java.diagnostics.healthcenter.impl.jmx;

import com.ibm.java.diagnostics.common.util.logging.LogFactory;
import com.ibm.java.diagnostics.healthcenter.agent.mbean.HCSslRMIClientSocketFactory;
import com.ibm.java.diagnostics.healthcenter.agent.mbean.HCSslSocketFactory;
import com.ibm.java.diagnostics.healthcenter.agent.mbean.HealthCenterMBean;
import com.ibm.java.diagnostics.healthcenter.connection.AgentConnection;
import com.ibm.java.diagnostics.healthcenter.connection.AgentConnectionManager;
import com.ibm.java.diagnostics.healthcenter.connection.HealthCenterConnectionException;
import com.ibm.java.diagnostics.healthcenter.impl.jmx.JMXAgentConnection;
import com.ibm.java.diagnostics.healthcenter.impl.marshalling.connection.ConnectionProperties;
import com.ibm.java.diagnostics.healthcenter.marshalling.util.Messages;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.Socket;
import java.rmi.ConnectIOException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.rmi.server.RMIClientSocketFactory;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanServerConnection;
import javax.management.MBeanServerInvocationHandler;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.remote.rmi.RMIConnector;
import javax.management.remote.rmi.RMIServer;

public class JMXAgentConnectionManager
implements AgentConnectionManager {
    static final String AUTH_REQUIRED = "";
    private static final String IBM_STAR = "IBM:*";
    private static final int SECOND_IN_MILLIS = 1000;
    public static final int CONNECT_TIMEOUT = 60000;
    private static final String NON_JRMP_MSG = "non-JRMP server at remote endpoint";
    private static final String HCMBEAN_CLASSNAME = HealthCenterMBean.class.getName();
    private final ConnectionProperties properties;
    private static final Logger TRACE = LogFactory.getTrace(JMXAgentConnectionManager.class);

    public JMXAgentConnectionManager(ConnectionProperties connectionProperties) {
        this.properties = connectionProperties;
    }

    private JMXAgentConnection probeMbean(int n) throws HealthCenterConnectionException {
        JMXAgentConnection jMXAgentConnection = null;
        try {
            if (this.properties.isSSLEnabled()) {
                Map<String, Object> map = this.generateJMXProperties();
                jMXAgentConnection = this.createAgentConnection(map, n);
            } else {
                HashMap hashMap = new HashMap();
                jMXAgentConnection = this.createAgentConnection(hashMap, n);
                if (this.properties.isAuthenticationEnabled()) {
                    String string = Messages.getString("AgentConnectionManager.redundant.credentials");
                    if (TRACE.isLoggable(Level.FINE)) {
                        TRACE.fine(string);
                    }
                }
            }
        }
        catch (SecurityException securityException) {
            if (this.properties.isAuthenticationEnabled()) {
                Map<String, Object> map = this.generateJMXProperties();
                try {
                    jMXAgentConnection = this.createAgentConnection(map, n);
                }
                catch (SecurityException securityException2) {
                    jMXAgentConnection = new JMXAgentConnection(this.properties.getHostName(), n, null);
                    jMXAgentConnection.setIsCredentialsCorrect(false);
                }
                catch (Exception exception) {
                    throw new HealthCenterConnectionException(exception.toString());
                }
            } else {
                jMXAgentConnection = new JMXAgentConnection(this.properties.getHostName(), n, null);
            }
            jMXAgentConnection.setSecurityEnabled(true);
        }
        catch (ConnectIOException connectIOException) {
            if (connectIOException.getMessage().equals(NON_JRMP_MSG)) {
                return null;
            }
            if (connectIOException.getCause() == null) {
                jMXAgentConnection = new JMXAgentConnection(this.properties.getHostName(), n, null);
                jMXAgentConnection.setSSLProbablyUsed(true);
            }
        }
        catch (IOException iOException) {
            throw new HealthCenterConnectionException(iOException.toString());
        }
        catch (InstanceNotFoundException instanceNotFoundException) {
            throw new HealthCenterConnectionException(instanceNotFoundException.toString());
        }
        catch (MalformedObjectNameException malformedObjectNameException) {
            String string = Messages.getString("AgentConnection.malformed.object.name");
            String string2 = MessageFormat.format(string, malformedObjectNameException.getLocalizedMessage());
            if (TRACE.isLoggable(Level.FINE)) {
                TRACE.fine(string2);
            }
            throw new HealthCenterConnectionException(malformedObjectNameException.toString());
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return jMXAgentConnection;
    }

    private JMXAgentConnection createAgentConnection(Map<String, ?> map, int n) throws IOException, MalformedObjectNameException, InstanceNotFoundException {
        JMXAgentConnection jMXAgentConnection = null;
        MBeanServerConnection mBeanServerConnection = this.getMBeanServerConnection(map, n);
        if (mBeanServerConnection != null) {
            ObjectName objectName = new ObjectName(IBM_STAR);
            Set<ObjectName> set = mBeanServerConnection.queryNames(objectName, null);
            for (ObjectName objectName2 : set) {
                if (!mBeanServerConnection.isInstanceOf(objectName2, HCMBEAN_CLASSNAME)) continue;
                HealthCenterMBean healthCenterMBean = MBeanServerInvocationHandler.newProxyInstance(mBeanServerConnection, objectName2, HealthCenterMBean.class, true);
                jMXAgentConnection = new JMXAgentConnection(this.properties.getHostName(), n, healthCenterMBean);
                break;
            }
        }
        return jMXAgentConnection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private MBeanServerConnection getMBeanServerConnection(Map<String, ?> map, int n) throws MalformedURLException, IOException {
        Throwable throwable;
        ConnectorThread connectorThread = new ConnectorThread(map, n);
        connectorThread.start();
        try {
            connectorThread.join(60000L);
            throwable = connectorThread.getThrowable();
        }
        catch (InterruptedException interruptedException) {
            Throwable throwable2 = connectorThread.getThrowable();
            if (throwable2 instanceof SecurityException) {
                SecurityException securityException = (SecurityException)throwable2;
                throw securityException;
            }
            if (throwable2 instanceof ConnectIOException) {
                ConnectIOException connectIOException = (ConnectIOException)throwable2;
                throw connectIOException;
            }
            if (throwable2 != null) {
                String string = Messages.getString("AgentConnection.problem.checking.port");
                String string2 = MessageFormat.format(string, String.valueOf(n), throwable2.toString());
                if (TRACE.isLoggable(Level.FINE)) {
                    TRACE.fine(string2);
                }
            }
            catch (Throwable throwable3) {
                Throwable throwable4 = connectorThread.getThrowable();
                if (throwable4 instanceof SecurityException) {
                    SecurityException securityException = (SecurityException)throwable4;
                    throw securityException;
                }
                if (throwable4 instanceof ConnectIOException) {
                    ConnectIOException connectIOException = (ConnectIOException)throwable4;
                    throw connectIOException;
                }
                if (throwable4 != null) {
                    String string = Messages.getString("AgentConnection.problem.checking.port");
                    String string3 = MessageFormat.format(string, String.valueOf(n), throwable4.toString());
                    if (TRACE.isLoggable(Level.FINE)) {
                        TRACE.fine(string3);
                    }
                }
                throw throwable3;
            }
        }
        if (throwable instanceof SecurityException) {
            SecurityException securityException = (SecurityException)throwable;
            throw securityException;
        }
        if (throwable instanceof ConnectIOException) {
            ConnectIOException connectIOException = (ConnectIOException)throwable;
            throw connectIOException;
        }
        if (throwable != null) {
            String string = Messages.getString("AgentConnection.problem.checking.port");
            String string4 = MessageFormat.format(string, String.valueOf(n), throwable.toString());
            if (TRACE.isLoggable(Level.FINE)) {
                TRACE.fine(string4);
            }
        }
        return connectorThread.mbeanServerConnection;
    }

    private Map<String, Object> generateJMXProperties() {
        Object object;
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        if (this.properties.isAuthenticationEnabled()) {
            object = Messages.getString("AgentConnection.authenticating.with.username");
            String string = MessageFormat.format((String)object, this.properties.getUserName());
            if (TRACE.isLoggable(Level.FINE)) {
                TRACE.fine(string);
            }
            String[] stringArray = new String[]{this.properties.getUserName(), this.properties.getPassword()};
            hashMap.put("jmx.remote.credentials", stringArray);
        }
        if (this.properties.isSSLEnabled()) {
            HCSslSocketFactory.setSSLValues(this.properties.getSSLTruststoreLocation(), this.properties.getSSLTruststorePassword(), this.properties.getSSLTruststoreCertificatePassword());
            object = new HCSslRMIClientSocketFactory();
            hashMap.put("com.sun.jndi.rmi.factory.socket", object);
        }
        return hashMap;
    }

    public boolean isSocketInUse(int n) {
        boolean bl = false;
        Socket socket = new Socket();
        try {
            socket.bind(null);
            socket.connect(new InetSocketAddress(this.properties.getHostName(), n), 60000);
            socket.close();
            bl = true;
        }
        catch (Exception exception) {
            bl = false;
        }
        return bl;
    }

    @Override
    public AgentConnection getHealthCenterAgent() throws HealthCenterConnectionException {
        if (this.isSocketInUse(this.properties.getPort())) {
            return this.probeMbean(this.properties.getPort());
        }
        return null;
    }

    public AgentConnection getHealthCenterAgent(String string) throws HealthCenterConnectionException {
        if (this.isSocketInUse(this.properties.getPort())) {
            JMXAgentConnection jMXAgentConnection = this.probeMbean(this.properties.getPort());
            if (jMXAgentConnection.getDescription().equals(string)) {
                return jMXAgentConnection;
            }
            String string2 = Messages.getString("AgentConnection.no.agent.with.that.name");
            String string3 = MessageFormat.format(string2, string, this.properties.getHostName(), this.properties.getPort());
            if (TRACE.isLoggable(Level.INFO)) {
                TRACE.info(string3);
            }
            return null;
        }
        return null;
    }

    public JMXAgentConnection getHealthCenterAgentForPort(int n) throws HealthCenterConnectionException {
        if (this.isSocketInUse(n)) {
            return this.probeMbean(n);
        }
        return null;
    }

    class ConnectorThread
    extends Thread {
        private static final String JMXRMI = "jmxrmi";
        private Map<String, ?> environment;
        private MBeanServerConnection mbeanServerConnection;
        private Throwable throwable;
        private int port;

        public ConnectorThread(Map<String, ?> map, int n) {
            this.environment = map;
            this.port = n;
            this.throwable = null;
        }

        @Override
        public void run() {
            this.initialiseMbeanConnectorByRMI();
        }

        private synchronized void initialiseMbeanConnectorByRMI() {
            try {
                Registry registry;
                Object object;
                if (JMXAgentConnectionManager.this.properties.isSSLEnabled()) {
                    object = (RMIClientSocketFactory)this.environment.get("com.sun.jndi.rmi.factory.socket");
                    registry = LocateRegistry.getRegistry(JMXAgentConnectionManager.this.properties.getHostName(), this.port, (RMIClientSocketFactory)object);
                } else {
                    registry = LocateRegistry.getRegistry(JMXAgentConnectionManager.this.properties.getHostName(), this.port);
                }
                object = registry.lookup(JMXRMI);
                if (object instanceof RMIServer) {
                    RMIServer rMIServer = (RMIServer)object;
                    RMIConnector rMIConnector = new RMIConnector(rMIServer, this.environment);
                    rMIConnector.connect();
                    this.mbeanServerConnection = rMIConnector.getMBeanServerConnection();
                } else {
                    String string = Messages.getString("AgentConnection.agent.not.found");
                    if (TRACE.isLoggable(Level.FINE)) {
                        TRACE.fine(string);
                    }
                }
            }
            catch (Throwable throwable) {
                this.setThrowable(throwable);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Throwable getThrowable() {
            ConnectorThread connectorThread = this;
            synchronized (connectorThread) {
                return this.throwable;
            }
        }

        private void setThrowable(Throwable throwable) {
            this.throwable = throwable;
        }
    }
}

