/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.java.diagnostics.common.datamodel.factory;

import com.ibm.java.diagnostics.common.datamodel.data.StringDataBuilder;
import com.ibm.java.diagnostics.common.datamodel.data.StructuredStringDataBuilder;
import com.ibm.java.diagnostics.common.datamodel.data.SubsystemDataBuilder;
import com.ibm.java.diagnostics.common.datamodel.data.TableDataBuilder;
import com.ibm.java.diagnostics.common.datamodel.data.TwoDimensionalDataBuilder;
import com.ibm.java.diagnostics.common.datamodel.data.axes.AxisPair;
import com.ibm.java.diagnostics.common.datamodel.data.axes.XAxis;
import com.ibm.java.diagnostics.common.datamodel.data.axes.XDataAxis;
import com.ibm.java.diagnostics.common.datamodel.data.axes.YAxis;
import com.ibm.java.diagnostics.common.datamodel.data.axes.YDataAxis;
import com.ibm.java.diagnostics.common.datamodel.factory.Messages;

public abstract class DataFactory {
    private static final String DATA_FACTORY_IMPL_CLASSNAME = "com.ibm.java.diagnostics.common.datamodel.impl.factory.DataFactoryImpl";
    protected String category;
    private static Class<?> clazz = null;

    public static DataFactory getFactory(String string) {
        try {
            if (clazz == null) {
                clazz = Class.forName(DATA_FACTORY_IMPL_CLASSNAME);
            }
            DataFactory dataFactory = (DataFactory)clazz.newInstance();
            dataFactory.setCategory(string);
            return dataFactory;
        }
        catch (Exception exception) {
            System.out.println(Messages.getString("DataFactory.could.not.instantiate") + exception);
            return null;
        }
    }

    public static DataFactory getFactory() {
        try {
            if (clazz == null) {
                clazz = Class.forName(DATA_FACTORY_IMPL_CLASSNAME);
            }
            DataFactory dataFactory = (DataFactory)clazz.newInstance();
            return dataFactory;
        }
        catch (Exception exception) {
            System.out.println(Messages.getString("DataFactory.could.not.instantiate") + exception);
            return null;
        }
    }

    private void setCategory(String string) {
        this.category = string;
    }

    public abstract XAxis createXAxis(String var1, String var2);

    public abstract XAxis createXAxis(String var1, String var2, int var3);

    public abstract YAxis createYAxis(String var1, String var2);

    public abstract YAxis createYAxis(String var1, String var2, int var3);

    public abstract AxisPair createAxisPair(XDataAxis var1, YDataAxis var2);

    public abstract TableDataBuilder createTableData(String var1);

    public abstract StringDataBuilder createStringData(String var1);

    public abstract StructuredStringDataBuilder createStructuredStringData(String var1);

    public abstract TwoDimensionalDataBuilder createTwoDimensionalData(String var1, AxisPair var2);

    public abstract TwoDimensionalDataBuilder createTwoDimensionalData(String var1, XDataAxis var2, YDataAxis var3);

    public abstract SubsystemDataBuilder createSubsystemData(String var1, String var2);
}

