/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.fs;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.List;
import sun.nio.fs.NativeBuffer;
import sun.nio.fs.NativeBuffers;
import sun.nio.fs.UnixException;
import sun.nio.fs.UnixMountEntry;
import sun.nio.fs.UnixNativeDispatcher;

class AixNativeDispatcher
extends UnixNativeDispatcher {
    private AixNativeDispatcher() {
    }

    private static native void init();

    static native UnixMountEntry[] getmntctl() throws UnixException;

    static void getAixMountEntries(List<UnixMountEntry> list) {
        int n = AixNativeDispatcher.queryMountEntrySize();
        if (n != 0) {
            NativeBuffer nativeBuffer = NativeBuffers.allocNativeBuffer(n);
            AixNativeDispatcher.getAixMountEntries(list, nativeBuffer.address(), n);
            nativeBuffer.release();
        }
    }

    private static native int queryMountEntrySize();

    private static native void getAixMountEntries(List<UnixMountEntry> var0, long var1, int var3);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static int fgetxattr(int n, byte[] byArray, long l, int n2) throws UnixException {
        NativeBuffer nativeBuffer = NativeBuffers.asNativeBuffer(byArray);
        try {
            int n3 = AixNativeDispatcher.fgetxattr0(n, nativeBuffer.address(), l, n2);
            return n3;
        }
        finally {
            nativeBuffer.release();
        }
    }

    private static native int fgetxattr0(int var0, long var1, long var3, int var5) throws UnixException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void fsetxattr(int n, byte[] byArray, long l, int n2) throws UnixException {
        NativeBuffer nativeBuffer = NativeBuffers.asNativeBuffer(byArray);
        try {
            AixNativeDispatcher.fsetxattr0(n, nativeBuffer.address(), l, n2);
        }
        finally {
            nativeBuffer.release();
        }
    }

    private static native void fsetxattr0(int var0, long var1, long var3, int var5) throws UnixException;

    static void fremovexattr(int n, byte[] byArray) throws UnixException {
        NativeBuffer nativeBuffer = NativeBuffers.asNativeBuffer(byArray);
        try {
            AixNativeDispatcher.fremovexattr0(n, nativeBuffer.address());
        }
        finally {
            nativeBuffer.release();
        }
    }

    private static native void fremovexattr0(int var0, long var1) throws UnixException;

    static native int flistxattr(int var0, long var1, int var3) throws UnixException;

    static {
        AccessController.doPrivileged(new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                System.loadLibrary("nio");
                return null;
            }
        });
        AixNativeDispatcher.init();
    }
}

