/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.ch;

import java.io.IOException;
import java.nio.channels.spi.AsynchronousChannelProvider;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import sun.nio.ch.IOUtil;
import sun.nio.ch.PollArrayWrapper;
import sun.nio.ch.Port;
import sun.nio.ch.ThreadPool;

final class UnixEventPort
extends Port {
    private boolean closed;
    private final int[] sp;
    private PollArrayWrapper poller;
    private int fdCount;
    protected final Lock pollLock = new ReentrantLock(true);
    private final AtomicInteger wakeupCount = new AtomicInteger();
    private static final int MAX_EPOLL_EVENTS = 512;
    private final ArrayBlockingQueue<Event> queue;
    private final Event NEED_TO_POLL = new Event(null, 0);
    private final Event EXECUTE_TASK_OR_SHUTDOWN = new Event(null, 0);

    UnixEventPort(AsynchronousChannelProvider asynchronousChannelProvider, ThreadPool threadPool) throws IOException {
        super(asynchronousChannelProvider, threadPool);
        this.fdToChannelLock.readLock().lock();
        this.fdCount = this.fdToChannel.size();
        this.poller = new PollArrayWrapper(this.fdCount);
        int n = 1;
        for (Integer n2 : this.fdToChannel.keySet()) {
            if (n > this.fdCount) continue;
            this.poller.putDescriptor(n, n2);
            this.poller.putEventOps(n, 0);
            this.poller.putReventOps(n, 0);
            ++n;
        }
        this.poller.totalChannels = this.fdCount + 1;
        this.fdToChannelLock.readLock().unlock();
        Object object = new int[2];
        UnixEventPort.socketpair((int[])object);
        this.poller.initInterrupt((int)object[0], (int)object[1]);
        this.sp = (int[])object;
        this.queue = new ArrayBlockingQueue(512);
        this.queue.offer(this.NEED_TO_POLL);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void startPoll(int n, int n2) {
        this.pollLock.lock();
        try {
            for (int i = 1; i <= this.fdCount; ++i) {
                if (this.poller.getDescriptor(i) != n) continue;
                int n3 = this.poller.getEventOps(i);
                this.poller.putEventOps(i, n3 |= n2);
                return;
            }
            ++this.fdCount;
            this.poller.grow(this.fdCount);
            this.poller.putDescriptor(this.fdCount, n);
            this.poller.putEventOps(this.fdCount, n2);
            this.poller.putReventOps(this.fdCount, 0);
            this.poller.totalChannels = this.fdCount + 1;
            this.poller.initInterrupt(this.sp[0], this.sp[1]);
        }
        finally {
            this.pollLock.unlock();
        }
    }

    UnixEventPort start() {
        this.startThreads(new EventHandlerTask());
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void executeOnHandlerTask(Runnable runnable) {
        UnixEventPort unixEventPort = this;
        synchronized (unixEventPort) {
            if (this.closed) {
                throw new RejectedExecutionException();
            }
            this.offerTask(runnable);
            this.wakeup();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void implClose() {
        UnixEventPort unixEventPort = this;
        synchronized (unixEventPort) {
            if (this.closed) {
                return;
            }
            this.closed = true;
        }
        this.pollLock.lock();
        try {
            this.poller.free();
        }
        finally {
            this.pollLock.unlock();
        }
        UnixEventPort.close0(this.sp[0]);
        UnixEventPort.close0(this.sp[1]);
    }

    @Override
    void shutdownHandlerTasks() {
        int n = this.threadCount();
        if (n == 0) {
            this.implClose();
        } else {
            while (n-- > 0) {
                this.wakeup();
            }
        }
    }

    private void wakeup() {
        if (this.wakeupCount.incrementAndGet() == 1) {
            this.poller.interrupt();
        }
    }

    private static native void socketpair(int[] var0) throws IOException;

    private static native void drain1(int var0) throws IOException;

    private static native void close0(int var0);

    static /* synthetic */ void access$900(UnixEventPort unixEventPort) {
        unixEventPort.implClose();
    }

    static {
        IOUtil.load();
    }

    static class Event {
        final Port.PollableChannel channel;
        final int events;

        Event(Port.PollableChannel pollableChannel, int n) {
            this.channel = pollableChannel;
            this.events = n;
        }

        Port.PollableChannel channel() {
            return this.channel;
        }

        int events() {
            return this.events;
        }
    }

    private class EventHandlerTask
    implements Runnable {
        private EventHandlerTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private Event poll() throws IOException {
            try {
                block16: while (true) {
                    int n;
                    int n2;
                    int n3;
                    int n4;
                    UnixEventPort.this.pollLock.lock();
                    UnixEventPort.this.fdToChannelLock.readLock().lock();
                    try {
                        if (UnixEventPort.this.fdRegistrationUpdated) {
                            n4 = UnixEventPort.this.fdToChannel.size();
                            PollArrayWrapper pollArrayWrapper = new PollArrayWrapper(n4);
                            n3 = 0;
                            for (n2 = 1; n2 <= UnixEventPort.this.fdCount; ++n2) {
                                n = UnixEventPort.this.poller.getDescriptor(n2);
                                if (UnixEventPort.this.fdToChannel.get(n) == null) continue;
                                pollArrayWrapper.putDescriptor(++n3, n);
                                int n5 = UnixEventPort.this.poller.getEventOps(n2);
                                pollArrayWrapper.putEventOps(n3, n5);
                                int n6 = UnixEventPort.this.poller.getReventOps(n2);
                                pollArrayWrapper.putReventOps(n3, n6);
                            }
                            UnixEventPort.this.fdCount = n3;
                            UnixEventPort.this.poller.free();
                            UnixEventPort.this.poller = pollArrayWrapper;
                            ((UnixEventPort)UnixEventPort.this).poller.totalChannels = UnixEventPort.this.fdCount + 1;
                            UnixEventPort.this.poller.initInterrupt(UnixEventPort.this.sp[0], UnixEventPort.this.sp[1]);
                            UnixEventPort.this.fdRegistrationUpdated = false;
                        }
                    }
                    finally {
                        UnixEventPort.this.fdToChannelLock.readLock().unlock();
                        UnixEventPort.this.pollLock.unlock();
                    }
                    n4 = 0;
                    UnixEventPort.this.pollLock.lock();
                    try {
                        n4 = UnixEventPort.this.poller.poll(UnixEventPort.this.fdCount + 1, 0, 100L);
                    }
                    finally {
                        UnixEventPort.this.pollLock.unlock();
                    }
                    UnixEventPort.this.pollLock.lock();
                    UnixEventPort.this.fdToChannelLock.readLock().lock();
                    try {
                        int n7 = 0;
                        while (true) {
                            if (n7 > UnixEventPort.this.fdCount) continue block16;
                            n3 = UnixEventPort.this.poller.getDescriptor(n7);
                            n2 = UnixEventPort.this.poller.getReventOps(n7);
                            n = UnixEventPort.this.poller.getEventOps(n7);
                            if (n2 != 0) {
                                UnixEventPort.this.poller.putReventOps(n7, 0);
                                --n4;
                            }
                            if (n != 0 && n2 != 0 && (n2 & n) != 0) {
                                if (n7 == 0) {
                                    if (UnixEventPort.this.wakeupCount.decrementAndGet() == 0) {
                                        UnixEventPort.drain1(n3);
                                    }
                                    if (n4 <= 0) {
                                        Event event = UnixEventPort.this.EXECUTE_TASK_OR_SHUTDOWN;
                                        return event;
                                    }
                                    UnixEventPort.this.queue.offer(UnixEventPort.this.EXECUTE_TASK_OR_SHUTDOWN);
                                } else {
                                    UnixEventPort.this.poller.putEventOps(n7, 0);
                                    Port.PollableChannel pollableChannel = (Port.PollableChannel)UnixEventPort.this.fdToChannel.get(n3);
                                    if (pollableChannel != null) {
                                        Event event = new Event(pollableChannel, n2);
                                        if (n4 <= 0) {
                                            Event event2 = event;
                                            return event2;
                                        }
                                        UnixEventPort.this.queue.offer(event);
                                    }
                                }
                            }
                            ++n7;
                        }
                    }
                    finally {
                        UnixEventPort.this.fdToChannelLock.readLock().unlock();
                        UnixEventPort.this.pollLock.unlock();
                        continue;
                    }
                    break;
                }
            }
            finally {
                UnixEventPort.this.queue.offer(UnixEventPort.this.NEED_TO_POLL);
            }
        }

        /*
         * Exception decompiling
         */
        @Override
        public void run() {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 12[UNCONDITIONALDOLOOP]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }
    }
}

