/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.crypto.dsig.dom;

import com.ibm.xml.crypto.dsig.dom.AlgorithmFactory;
import com.ibm.xml.crypto.dsig.dom.XMLStructureImpl;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.xml.crypto.dsig.Manifest;
import javax.xml.crypto.dsig.Reference;
import javax.xml.crypto.dsig.XMLSignatureException;
import javax.xml.crypto.dsig.XMLValidateContext;

class ManifestImpl
extends XMLStructureImpl
implements Manifest {
    List content;
    private String id;

    ManifestImpl(AlgorithmFactory f, List references, String id) {
        super(f);
        if (references == null) {
            throw new NullPointerException("Reference List must not be null.");
        }
        if (references.size() == 0) {
            throw new IllegalArgumentException("Reference List is empty.");
        }
        this.content = new ArrayList(references.size());
        for (Reference obj : references) {
            this.content.add(obj);
        }
        this.id = id;
    }

    @Override
    public String getId() {
        return this.id;
    }

    public List getReferences() {
        return Collections.unmodifiableList(this.content);
    }

    public boolean validate(XMLValidateContext vcontext) throws XMLSignatureException {
        boolean result = true;
        for (int i = 0; i < this.content.size(); ++i) {
            result = ((Reference)this.content.get(i)).validate(vcontext) && result;
        }
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Manifest)) {
            return false;
        }
        Manifest oman = (Manifest)o;
        boolean idsEqual = this.id == null ? oman.getId() == null : this.id.equals(oman.getId());
        boolean referencesEqual = this.content.equals(oman.getReferences());
        return idsEqual && referencesEqual;
    }

    public int hashCode() {
        int result = 17;
        if (this.id != null) {
            result = 31 * result + this.id.hashCode();
        }
        result = 31 * result + this.content.hashCode();
        return result;
    }
}

