/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm27.j9.gc;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm27.events.EventManager;
import com.ibm.j9ddr.vm27.j9.ObjectAccessBarrier;
import com.ibm.j9ddr.vm27.j9.gc.GCIterator;
import com.ibm.j9ddr.vm27.j9.tenant.TenantModel;
import com.ibm.j9ddr.vm27.pointer.VoidPointer;
import com.ibm.j9ddr.vm27.pointer.generated.GC_FinalizeListManagerMultiTenantPointer;
import com.ibm.j9ddr.vm27.pointer.generated.GC_FinalizeListManagerPointer;
import com.ibm.j9ddr.vm27.pointer.generated.J9ObjectPointer;
import java.util.NoSuchElementException;

public class GCFinalizableObjectIterator
extends GCIterator {
    public static final int state_start = 0;
    public static final int state_system = 1;
    public static final int state_default = 2;
    public static final int state_reference = 3;
    public static final int state_end = 4;
    protected int _state = 0;
    protected J9ObjectPointer _currentSystemObject;
    protected J9ObjectPointer _currentDefaultObject;
    protected J9ObjectPointer _currentReferenceObject;
    GC_FinalizeListManagerPointer _manager = null;
    GC_FinalizeListManagerMultiTenantPointer _multiTenantManager = null;
    int _tenantSystemObjectListIndex = -1;
    int _tenantDefaultObjectListIndex = -1;

    protected GCFinalizableObjectIterator(GC_FinalizeListManagerPointer manager) throws CorruptDataException {
        this._manager = manager;
        if (TenantModel.isTenantEnabled()) {
            this._multiTenantManager = GC_FinalizeListManagerMultiTenantPointer.cast(manager);
        }
        this._currentSystemObject = this.getFirstSystemFinalizableObject();
        this._currentDefaultObject = this.getFirstDefaultFinalizableObject();
        this._currentReferenceObject = manager._referenceObjects();
    }

    public static GCFinalizableObjectIterator from() throws CorruptDataException {
        return new GCFinalizableObjectIterator(GCFinalizableObjectIterator.getExtensions().finalizeListManager());
    }

    @Override
    public boolean hasNext() {
        if (this._state == 4) {
            return false;
        }
        switch (this._state) {
            case 0: {
                ++this._state;
            }
            case 1: {
                if (this._currentSystemObject.notNull()) {
                    return true;
                }
                ++this._state;
            }
            case 2: {
                if (this._currentDefaultObject.notNull()) {
                    return true;
                }
                ++this._state;
            }
            case 3: {
                if (this._currentReferenceObject.notNull()) {
                    return true;
                }
                ++this._state;
            }
        }
        return false;
    }

    @Override
    public J9ObjectPointer next() {
        try {
            if (this.hasNext()) {
                J9ObjectPointer result = J9ObjectPointer.NULL;
                switch (this._state) {
                    case 1: {
                        result = this._currentSystemObject;
                        this.advanceToNextSystemFinalizableObject();
                        break;
                    }
                    case 2: {
                        result = this._currentDefaultObject;
                        this.advanceToNextDefaultFinalizableObject();
                        break;
                    }
                    case 3: {
                        result = this._currentReferenceObject;
                        this._currentReferenceObject = ObjectAccessBarrier.getReferenceLink(this._currentReferenceObject);
                    }
                }
                return result;
            }
            throw new NoSuchElementException("There are no more items available through this iterator");
        }
        catch (CorruptDataException cde) {
            EventManager.raiseCorruptDataEvent("Error getting next item", cde, false);
            if (this._state < 4) {
                ++this._state;
            }
            return null;
        }
    }

    @Override
    public VoidPointer nextAddress() {
        throw new UnsupportedOperationException("This iterator cannot return addresses");
    }

    public int getState() {
        return this._state;
    }

    private J9ObjectPointer getFirstSystemFinalizableObject() throws CorruptDataException {
        J9ObjectPointer firstSystemObject = this._manager._systemFinalizableObjects();
        if (null != this._multiTenantManager && firstSystemObject.isNull()) {
            this._tenantSystemObjectListIndex = 0;
            while (this._tenantSystemObjectListIndex < this._multiTenantManager._tenantCount().intValue() && (firstSystemObject = J9ObjectPointer.cast(this._multiTenantManager._tenantSystemFinalizableObjects().at(this._tenantSystemObjectListIndex))).isNull()) {
                ++this._tenantSystemObjectListIndex;
            }
        }
        return firstSystemObject;
    }

    private J9ObjectPointer getFirstDefaultFinalizableObject() throws CorruptDataException {
        J9ObjectPointer firstDefaultObject = this._manager._defaultFinalizableObjects();
        if (null != this._multiTenantManager && firstDefaultObject.isNull()) {
            this._tenantDefaultObjectListIndex = 0;
            while (this._tenantDefaultObjectListIndex < this._multiTenantManager._tenantCount().intValue() && (firstDefaultObject = J9ObjectPointer.cast(this._multiTenantManager._tenantDefaultFinalizableObjects().at(this._tenantDefaultObjectListIndex))).isNull()) {
                ++this._tenantDefaultObjectListIndex;
            }
        }
        return firstDefaultObject;
    }

    private void advanceToNextSystemFinalizableObject() throws CorruptDataException {
        this._currentSystemObject = ObjectAccessBarrier.getFinalizeLink(this._currentSystemObject);
        if (null != this._multiTenantManager && this._currentSystemObject.isNull() && this._tenantSystemObjectListIndex < this._multiTenantManager._tenantCount().intValue() - 1) {
            ++this._tenantSystemObjectListIndex;
            while (this._tenantSystemObjectListIndex < this._multiTenantManager._tenantCount().intValue()) {
                this._currentSystemObject = J9ObjectPointer.cast(this._multiTenantManager._tenantSystemFinalizableObjects().at(this._tenantSystemObjectListIndex));
                if (!this._currentSystemObject.isNull()) break;
                ++this._tenantSystemObjectListIndex;
            }
        }
    }

    private void advanceToNextDefaultFinalizableObject() throws CorruptDataException {
        this._currentDefaultObject = ObjectAccessBarrier.getFinalizeLink(this._currentDefaultObject);
        if (null != this._multiTenantManager && this._currentDefaultObject.isNull() && this._tenantDefaultObjectListIndex < this._multiTenantManager._tenantCount().intValue() - 1) {
            ++this._tenantDefaultObjectListIndex;
            while (this._tenantDefaultObjectListIndex < this._multiTenantManager._tenantCount().intValue()) {
                this._currentDefaultObject = J9ObjectPointer.cast(this._multiTenantManager._tenantDefaultFinalizableObjects().at(this._tenantDefaultObjectListIndex));
                if (!this._currentDefaultObject.isNull()) break;
                ++this._tenantDefaultObjectListIndex;
            }
        }
    }
}

