/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm27.j9;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm27.events.EventManager;
import com.ibm.j9ddr.vm27.j9.DataType;
import com.ibm.j9ddr.vm27.j9.GCVMThreadStackSlotIterator;
import com.ibm.j9ddr.vm27.j9.gc.GCClassHeapIterator;
import com.ibm.j9ddr.vm27.j9.gc.GCClassLoaderIterator;
import com.ibm.j9ddr.vm27.j9.gc.GCExtensions;
import com.ibm.j9ddr.vm27.j9.gc.GCFinalizableObjectIterator;
import com.ibm.j9ddr.vm27.j9.gc.GCHeapRegionDescriptor;
import com.ibm.j9ddr.vm27.j9.gc.GCHeapRegionIterator;
import com.ibm.j9ddr.vm27.j9.gc.GCJNIGlobalReferenceIterator;
import com.ibm.j9ddr.vm27.j9.gc.GCJNIWeakGlobalReferenceIterator;
import com.ibm.j9ddr.vm27.j9.gc.GCJVMTIObjectTagTableIterator;
import com.ibm.j9ddr.vm27.j9.gc.GCJVMTIObjectTagTableListIterator;
import com.ibm.j9ddr.vm27.j9.gc.GCMonitorReferenceIterator;
import com.ibm.j9ddr.vm27.j9.gc.GCObjectHeapIterator;
import com.ibm.j9ddr.vm27.j9.gc.GCObjectIterator;
import com.ibm.j9ddr.vm27.j9.gc.GCOwnableSynchronizerObjectListIterator;
import com.ibm.j9ddr.vm27.j9.gc.GCRememberedSetIterator;
import com.ibm.j9ddr.vm27.j9.gc.GCRememberedSetSlotIterator;
import com.ibm.j9ddr.vm27.j9.gc.GCSegmentIterator;
import com.ibm.j9ddr.vm27.j9.gc.GCStringCacheTableIterator;
import com.ibm.j9ddr.vm27.j9.gc.GCStringTableIterator;
import com.ibm.j9ddr.vm27.j9.gc.GCUnfinalizedObjectListIterator;
import com.ibm.j9ddr.vm27.j9.gc.GCVMClassSlotIterator;
import com.ibm.j9ddr.vm27.j9.gc.GCVMThreadJNISlotIterator;
import com.ibm.j9ddr.vm27.j9.gc.GCVMThreadListIterator;
import com.ibm.j9ddr.vm27.j9.gc.GCVMThreadMonitorRecordSlotIterator;
import com.ibm.j9ddr.vm27.j9.gc.GCVMThreadSlotIterator;
import com.ibm.j9ddr.vm27.j9.stackwalker.FrameCallbackResult;
import com.ibm.j9ddr.vm27.j9.stackwalker.IStackWalkerCallbacks;
import com.ibm.j9ddr.vm27.j9.stackwalker.WalkState;
import com.ibm.j9ddr.vm27.pointer.ObjectMonitorReferencePointer;
import com.ibm.j9ddr.vm27.pointer.ObjectReferencePointer;
import com.ibm.j9ddr.vm27.pointer.PointerPointer;
import com.ibm.j9ddr.vm27.pointer.VoidPointer;
import com.ibm.j9ddr.vm27.pointer.generated.J9BuildFlags;
import com.ibm.j9ddr.vm27.pointer.generated.J9ClassLoaderPointer;
import com.ibm.j9ddr.vm27.pointer.generated.J9ClassPointer;
import com.ibm.j9ddr.vm27.pointer.generated.J9JVMTIDataPointer;
import com.ibm.j9ddr.vm27.pointer.generated.J9JVMTIEnvPointer;
import com.ibm.j9ddr.vm27.pointer.generated.J9JavaVMPointer;
import com.ibm.j9ddr.vm27.pointer.generated.J9MemorySegmentPointer;
import com.ibm.j9ddr.vm27.pointer.generated.J9ObjectMonitorPointer;
import com.ibm.j9ddr.vm27.pointer.generated.J9ObjectPointer;
import com.ibm.j9ddr.vm27.pointer.generated.J9VMThreadPointer;
import com.ibm.j9ddr.vm27.pointer.generated.MM_GCExtensionsPointer;
import com.ibm.j9ddr.vm27.pointer.generated.MM_SublistPuddlePointer;
import com.ibm.j9ddr.vm27.pointer.helper.J9ObjectHelper;
import com.ibm.j9ddr.vm27.pointer.helper.J9RASHelper;
import com.ibm.j9ddr.vm27.structure.J9MemorySegment;
import com.ibm.j9ddr.vm27.structure.J9VMThread;
import com.ibm.j9ddr.vm27.structure.MM_GCExtensionsBase$DynamicClassUnloading;
import com.ibm.j9ddr.vm27.types.UDATA;

public abstract class RootScanner {
    private Reachability _reachability = Reachability.STRONG;
    private J9JavaVMPointer _vm;
    private MM_GCExtensionsPointer _extensions;
    private boolean _classDataAsRoots = true;
    private boolean _includeJVMTIObjectTagTables = true;
    private boolean _includeStackFrameClassReferences = true;
    private boolean _trackVisibleStackFrameDepth = false;
    private boolean _scanStackSlots = true;
    private boolean _stringTableAsRoot = true;
    private boolean _nurseryReferencesOnly = false;
    private boolean _nurseryReferencesPossibly = false;
    private boolean _includeRememberedSetReferences;
    private RootScannerStackWalkerCallbacks _stackWalkerCallbacks = new RootScannerStackWalkerCallbacks();

    protected RootScanner() throws CorruptDataException {
        this._vm = J9RASHelper.getVM(DataType.getJ9RASPointer());
        this._extensions = GCExtensions.getGCExtensionsPointer();
        this._includeRememberedSetReferences = this._extensions.scavengerEnabled();
        boolean bl = this._stringTableAsRoot = !this._extensions.collectStringConstants();
        this._classDataAsRoots = J9BuildFlags.gc_dynamicClassUnloading ? MM_GCExtensionsBase$DynamicClassUnloading.DYNAMIC_CLASS_UNLOADING_NEVER == this._extensions.dynamicClassUnloading() : true;
    }

    public void setStringTableAsRoot(boolean stringTableAsRoot) {
        this._stringTableAsRoot = stringTableAsRoot;
    }

    public void setNurseryReferencesOnly(boolean nurseryReferencesOnly) {
        if (J9BuildFlags.gc_modronScavenger) {
            throw new UnsupportedOperationException("Not supported with non-scavenger based garbage collection");
        }
        this._nurseryReferencesOnly = nurseryReferencesOnly;
    }

    public void setNurseryReferencesPossibly(boolean nurseryReferencesPossibly) {
        if (J9BuildFlags.gc_modronScavenger) {
            throw new UnsupportedOperationException("Not supported with non-scavenger based garbage collection");
        }
        this._nurseryReferencesPossibly = nurseryReferencesPossibly;
    }

    public void setIncludeRememberedSetReferences(boolean includeRememberedSetReferences) {
        if (J9BuildFlags.gc_modronScavenger) {
            throw new UnsupportedOperationException("Not supported with non-scavenger based garbage collection");
        }
        this._includeRememberedSetReferences = includeRememberedSetReferences;
    }

    public void setIncludeStackFrameClassReferences(boolean includeStackFrameClassReferences) {
        this._includeStackFrameClassReferences = includeStackFrameClassReferences;
    }

    public void setClassDataAsRoots(boolean classDataAsRoots) {
        if (J9BuildFlags.gc_dynamicClassUnloading) {
            throw new UnsupportedOperationException("Not supoprted without dynamic class unloading");
        }
        this._classDataAsRoots = classDataAsRoots;
    }

    public void setTrackVisibleStackFrameDepth(boolean trackVisibleStackFrameDepth) {
        this._trackVisibleStackFrameDepth = trackVisibleStackFrameDepth;
    }

    public void setScanStackSlots(boolean scanStackSlots) {
        this._scanStackSlots = scanStackSlots;
    }

    protected abstract void doClassSlot(J9ClassPointer var1);

    protected abstract void doClass(J9ClassPointer var1);

    protected abstract void doClassLoader(J9ClassLoaderPointer var1);

    protected abstract void doWeakReferenceSlot(J9ObjectPointer var1);

    protected abstract void doSoftReferenceSlot(J9ObjectPointer var1);

    protected abstract void doPhantomReferenceSlot(J9ObjectPointer var1);

    protected abstract void doFinalizableObject(J9ObjectPointer var1);

    protected abstract void doUnfinalizedObject(J9ObjectPointer var1);

    protected abstract void doOwnableSynchronizerObject(J9ObjectPointer var1);

    protected abstract void doMonitorReference(J9ObjectMonitorPointer var1);

    protected abstract void doMonitorLookupCacheSlot(J9ObjectMonitorPointer var1);

    protected abstract void doJNIWeakGlobalReference(J9ObjectPointer var1);

    protected abstract void doJNIGlobalReferenceSlot(J9ObjectPointer var1);

    protected abstract void doRememberedSlot(J9ObjectPointer var1);

    protected abstract void doJVMTIObjectTagSlot(J9ObjectPointer var1);

    protected abstract void doStringTableSlot(J9ObjectPointer var1);

    protected abstract void doStringCacheTableSlot(J9ObjectPointer var1);

    protected abstract void doVMClassSlot(J9ClassPointer var1);

    protected abstract void doVMThreadSlot(J9ObjectPointer var1);

    protected abstract void doVMThreadJNISlot(J9ObjectPointer var1);

    protected abstract void doVMThreadMonitorRecordSlot(J9ObjectPointer var1);

    protected abstract void doNonCollectableObjectSlot(J9ObjectPointer var1);

    protected abstract void doMemorySpaceSlot(J9ObjectPointer var1);

    protected abstract void doStackSlot(J9ObjectPointer var1);

    protected void doClassSlot(J9ClassPointer slot, VoidPointer address) {
        this.doClassSlot(slot);
    }

    protected void doClass(J9ClassPointer clazz, VoidPointer address) {
        this.doClass(clazz);
    }

    protected void doClassLoader(J9ClassLoaderPointer slot, VoidPointer address) {
        this.doClassLoader(slot);
    }

    protected void doWeakReferenceSlot(J9ObjectPointer slot, VoidPointer address) {
        this.doWeakReferenceSlot(slot);
    }

    protected void doSoftReferenceSlot(J9ObjectPointer slot, VoidPointer address) {
        this.doSoftReferenceSlot(slot);
    }

    protected void doPhantomReferenceSlot(J9ObjectPointer slot, VoidPointer address) {
        this.doPhantomReferenceSlot(slot);
    }

    protected void doMonitorLookupCacheSlot(J9ObjectMonitorPointer objectMonitor, ObjectMonitorReferencePointer slotAddress) {
        this.doMonitorLookupCacheSlot(objectMonitor);
    }

    protected void doJNIWeakGlobalReference(J9ObjectPointer slot, VoidPointer address) {
        this.doJNIWeakGlobalReference(slot);
    }

    protected void doJNIGlobalReferenceSlot(J9ObjectPointer slot, VoidPointer address) {
        this.doJNIGlobalReferenceSlot(slot);
    }

    protected void doRememberedSlot(J9ObjectPointer slot, VoidPointer address) {
        this.doRememberedSlot(slot);
    }

    protected void doJVMTIObjectTagSlot(J9ObjectPointer slot, VoidPointer address) {
        this.doJVMTIObjectTagSlot(slot);
    }

    protected void doStringTableSlot(J9ObjectPointer slot, VoidPointer address) {
        this.doStringTableSlot(slot);
    }

    protected void doStringCacheTableSlot(J9ObjectPointer slot, VoidPointer address) {
        this.doStringCacheTableSlot(slot);
    }

    protected void doVMClassSlot(J9ClassPointer slot, VoidPointer address) {
        this.doVMClassSlot(slot);
    }

    protected void doVMThreadSlot(J9ObjectPointer slot, VoidPointer address) {
        this.doVMThreadSlot(slot);
    }

    protected void doVMThreadJNISlot(J9ObjectPointer slot, VoidPointer address) {
        this.doVMThreadJNISlot(slot);
    }

    protected void doVMThreadMonitorRecordSlot(J9ObjectPointer slot, VoidPointer address) {
        this.doVMThreadMonitorRecordSlot(slot);
    }

    protected void doNonCollectableObjectSlot(J9ObjectPointer slot, VoidPointer address) {
        this.doNonCollectableObjectSlot(slot);
    }

    protected void doMemoryAreaSlot(J9ObjectPointer slot, VoidPointer address) {
        this.doMemorySpaceSlot(slot);
    }

    protected void doStackSlot(J9ObjectPointer slot, WalkState walkState, VoidPointer stackLocation) {
        this.doStackSlot(slot);
    }

    protected void scanPermanentClasses() throws CorruptDataException {
        J9ClassLoaderPointer sysClassLoader = this._vm.systemClassLoader();
        J9ClassLoaderPointer appClassLoader = J9ClassLoaderPointer.cast(this._vm.applicationClassLoader());
        GCSegmentIterator segmentIterator = GCSegmentIterator.fromJ9MemorySegmentList(this._vm.classMemorySegments(), J9MemorySegment.MEMORY_TYPE_RAM_CLASS);
        this.setReachability(Reachability.STRONG);
        while (segmentIterator.hasNext()) {
            J9MemorySegmentPointer segment = segmentIterator.next();
            if (!segment.classLoader().equals(sysClassLoader) && !segment.classLoader().equals(appClassLoader)) continue;
            GCClassHeapIterator classHeapIterator = GCClassHeapIterator.fromJ9MemorySegment(segment);
            while (classHeapIterator.hasNext()) {
                this.doClass(classHeapIterator.next());
            }
        }
    }

    public void scanAllSlots() throws CorruptDataException {
        this.scanClasses();
        this.scanVMClassSlots();
        this.scanClassLoaders();
        this.scanThreads();
        if (J9BuildFlags.gc_finalization) {
            this.scanFinalizableObjects();
        }
        this.scanJNIGlobalReferences();
        this.scanStringTable();
        if (J9BuildFlags.gc_weakReferenceObjects) {
            this.scanWeakReferenceObjects();
        }
        if (J9BuildFlags.gc_referenceObjects) {
            this.scanSoftReferenceObjects();
            this.scanPhantomReferenceObjects();
        }
        if (J9BuildFlags.gc_finalization) {
            this.scanUnfinalizedObjects();
        }
        this.scanMonitorReferences();
        this.scanJNIWeakGlobalReferences();
        if (J9BuildFlags.gc_modronScavenger && this._extensions.scavengerEnabled()) {
            this.scanRememberedSet();
        }
        if (J9BuildFlags.opt_jvmti) {
            this.scanJVMTIObjectTagTables();
        }
        this.scanOwnableSynchronizerObjects();
    }

    public void scanRoots() throws CorruptDataException {
        if (this._classDataAsRoots || this._nurseryReferencesOnly || this._nurseryReferencesPossibly) {
            this.scanClassLoaders();
        }
        if (!this._nurseryReferencesOnly && !this._nurseryReferencesPossibly) {
            if (J9BuildFlags.gc_dynamicClassUnloading) {
                if (this._classDataAsRoots) {
                    this.scanClasses();
                    this.setIncludeStackFrameClassReferences(false);
                } else {
                    this.scanPermanentClasses();
                    this.setIncludeStackFrameClassReferences(true);
                }
            } else {
                this.scanClasses();
                this.setIncludeStackFrameClassReferences(false);
            }
        }
        this.scanThreads();
        if (J9BuildFlags.gc_finalization) {
            this.scanFinalizableObjects();
        }
        this.scanJNIGlobalReferences();
        if (this._stringTableAsRoot && !this._nurseryReferencesOnly && !this._nurseryReferencesPossibly) {
            this.scanStringTable();
        }
    }

    public void scanClearable() throws CorruptDataException {
        if (J9BuildFlags.gc_referenceObjects) {
            this.scanSoftReferenceObjects();
        }
        if (J9BuildFlags.gc_weakReferenceObjects) {
            this.scanWeakReferenceObjects();
        }
        if (J9BuildFlags.gc_finalization) {
            this.scanUnfinalizedObjects();
        }
        this.scanJNIWeakGlobalReferences();
        if (J9BuildFlags.gc_referenceObjects) {
            this.scanPhantomReferenceObjects();
        }
        this.scanMonitorLookupCaches();
        this.scanMonitorReferences();
        if (!(this._stringTableAsRoot || this._nurseryReferencesOnly || this._nurseryReferencesPossibly)) {
            this.scanStringTable();
        }
        this.scanOwnableSynchronizerObjects();
        if (J9BuildFlags.gc_modronScavenger && this._includeRememberedSetReferences && !this._nurseryReferencesOnly && !this._nurseryReferencesPossibly) {
            this.scanRememberedSet();
        }
        if (J9BuildFlags.opt_jvmti && this._includeJVMTIObjectTagTables) {
            this.scanJVMTIObjectTagTables();
        }
    }

    protected void scanJVMTIObjectTagTables() throws CorruptDataException {
        if (!J9BuildFlags.opt_jvmti) {
            return;
        }
        this.setReachability(Reachability.WEAK);
        J9JVMTIDataPointer jvmtiData = J9JVMTIDataPointer.cast(this._vm.jvmtiData());
        if (jvmtiData.notNull()) {
            GCJVMTIObjectTagTableListIterator objectTagTableList = GCJVMTIObjectTagTableListIterator.fromJ9JVMTIData(jvmtiData);
            while (objectTagTableList.hasNext()) {
                J9JVMTIEnvPointer list = objectTagTableList.next();
                GCJVMTIObjectTagTableIterator objectTagTableIterator = GCJVMTIObjectTagTableIterator.fromJ9JVMTIEnv(list);
                GCJVMTIObjectTagTableIterator addressIterator = GCJVMTIObjectTagTableIterator.fromJ9JVMTIEnv(list);
                while (objectTagTableIterator.hasNext()) {
                    this.doJVMTIObjectTagSlot(objectTagTableIterator.next(), addressIterator.nextAddress());
                }
            }
        }
    }

    protected void scanNonCollectableObjects() throws CorruptDataException {
        this.scanNonCollectableObjectsInternal(J9MemorySegment.MEMORY_TYPE_IMMORTAL);
        this.scanNonCollectableObjectsInternal(J9MemorySegment.MEMORY_TYPE_SCOPED);
    }

    private void scanNonCollectableObjectsInternal(long memoryType) throws CorruptDataException {
        GCHeapRegionIterator regionIterator = GCHeapRegionIterator.from();
        while (regionIterator.hasNext()) {
            GCHeapRegionDescriptor region = regionIterator.next();
            if (!new UDATA(region.getTypeFlags()).allBitsIn(memoryType)) continue;
            GCObjectHeapIterator objectIterator = GCObjectHeapIterator.fromHeapRegionDescriptor(region, true, false);
            while (objectIterator.hasNext()) {
                J9ObjectPointer object = objectIterator.next();
                this.doClassSlot(J9ObjectHelper.clazz(object));
                GCObjectIterator fieldIterator = GCObjectIterator.fromJ9Object(object, true);
                GCObjectIterator fieldAddressIterator = GCObjectIterator.fromJ9Object(object, true);
                while (fieldIterator.hasNext()) {
                    this.doNonCollectableObjectSlot(fieldIterator.next(), fieldAddressIterator.nextAddress());
                }
            }
        }
    }

    protected void scanRememberedSet() throws CorruptDataException {
        if (!J9BuildFlags.gc_modronScavenger) {
            return;
        }
        this.setReachability(Reachability.WEAK);
        GCRememberedSetIterator rememberedSetIterator = GCRememberedSetIterator.from();
        while (rememberedSetIterator.hasNext()) {
            MM_SublistPuddlePointer puddle = rememberedSetIterator.next();
            GCRememberedSetSlotIterator rememberedSetSlotIterator = GCRememberedSetSlotIterator.fromSublistPuddle(puddle);
            GCRememberedSetSlotIterator addressIterator = GCRememberedSetSlotIterator.fromSublistPuddle(puddle);
            while (rememberedSetSlotIterator.hasNext()) {
                this.doRememberedSlot(rememberedSetSlotIterator.next(), addressIterator.nextAddress());
            }
        }
    }

    protected void scanJNIWeakGlobalReferences() throws CorruptDataException {
        this.setReachability(Reachability.WEAK);
        GCJNIWeakGlobalReferenceIterator jniWeakGlobalReferenceIterator = GCJNIWeakGlobalReferenceIterator.from();
        GCJNIWeakGlobalReferenceIterator addressIterator = GCJNIWeakGlobalReferenceIterator.from();
        while (jniWeakGlobalReferenceIterator.hasNext()) {
            this.doJNIWeakGlobalReference(jniWeakGlobalReferenceIterator.next(), addressIterator.nextAddress());
        }
    }

    protected void scanMonitorReferences() throws CorruptDataException {
        this.setReachability(Reachability.WEAK);
        GCMonitorReferenceIterator monitorReferenceIterator = GCMonitorReferenceIterator.from();
        while (monitorReferenceIterator.hasNext()) {
            this.doMonitorReference(monitorReferenceIterator.next());
        }
    }

    protected void scanUnfinalizedObjects() throws CorruptDataException {
        if (!J9BuildFlags.gc_finalization) {
            return;
        }
        this.setReachability(Reachability.WEAK);
        GCUnfinalizedObjectListIterator unfinalizedObjectListIterator = GCUnfinalizedObjectListIterator.from();
        while (unfinalizedObjectListIterator.hasNext()) {
            this.doUnfinalizedObject(unfinalizedObjectListIterator.next());
        }
    }

    protected void scanOwnableSynchronizerObjects() throws CorruptDataException {
        this.setReachability(Reachability.WEAK);
        GCOwnableSynchronizerObjectListIterator ownableSynchronizerObjectListIterator = GCOwnableSynchronizerObjectListIterator.from();
        while (ownableSynchronizerObjectListIterator.hasNext()) {
            J9ObjectPointer ownableSynchronizerObject = ownableSynchronizerObjectListIterator.next();
            this.doOwnableSynchronizerObject(ownableSynchronizerObject);
        }
    }

    protected void scanMonitorLookupCaches() throws CorruptDataException {
        this.setReachability(Reachability.WEAK);
        GCVMThreadListIterator vmThreadListIterator = GCVMThreadListIterator.from();
        while (vmThreadListIterator.hasNext()) {
            J9VMThreadPointer walkThread = vmThreadListIterator.next();
            if (J9BuildFlags.thr_lockNursery) {
                ObjectMonitorReferencePointer objectMonitorLookupCache = walkThread.objectMonitorLookupCacheEA();
                for (long cacheIndex = 0L; cacheIndex < J9VMThread.J9VMTHREAD_OBJECT_MONITOR_CACHE_SIZE; ++cacheIndex) {
                    ObjectMonitorReferencePointer slotAddress = objectMonitorLookupCache.add(cacheIndex);
                    this.doMonitorLookupCacheSlot(slotAddress.at(0L), slotAddress);
                }
                continue;
            }
            throw new UnsupportedOperationException("Not implemented");
        }
    }

    protected void scanPhantomReferenceObjects() throws CorruptDataException {
    }

    protected void scanSoftReferenceObjects() throws CorruptDataException {
    }

    protected void scanWeakReferenceObjects() throws CorruptDataException {
    }

    protected void scanStringTable() throws CorruptDataException {
        if (this._extensions.collectStringConstants()) {
            this.setReachability(Reachability.WEAK);
        } else {
            this.setReachability(Reachability.STRONG);
        }
        GCStringTableIterator stringTableIterator = GCStringTableIterator.from();
        GCStringTableIterator stringTableAddressIterator = GCStringTableIterator.from();
        while (stringTableIterator.hasNext()) {
            this.doStringTableSlot(stringTableIterator.next(), stringTableAddressIterator.nextAddress());
        }
        GCStringCacheTableIterator cacheIterator = GCStringCacheTableIterator.from();
        GCStringCacheTableIterator cacheAddressIterator = GCStringCacheTableIterator.from();
        while (cacheIterator.hasNext()) {
            this.doStringCacheTableSlot(cacheIterator.next(), cacheAddressIterator.nextAddress());
        }
    }

    protected void scanJNIGlobalReferences() throws CorruptDataException {
        this.setReachability(Reachability.STRONG);
        GCJNIGlobalReferenceIterator jniGlobalReferenceIterator = GCJNIGlobalReferenceIterator.from();
        GCJNIGlobalReferenceIterator addressIterator = GCJNIGlobalReferenceIterator.from();
        while (jniGlobalReferenceIterator.hasNext()) {
            this.doJNIGlobalReferenceSlot(jniGlobalReferenceIterator.next(), addressIterator.nextAddress());
        }
    }

    protected void scanFinalizableObjects() throws CorruptDataException {
        if (!J9BuildFlags.gc_finalization) {
            return;
        }
        this.setReachability(Reachability.STRONG);
        GCFinalizableObjectIterator finalizableObjectIterator = GCFinalizableObjectIterator.from();
        while (finalizableObjectIterator.hasNext()) {
            this.doFinalizableObject(finalizableObjectIterator.next());
        }
    }

    protected void scanThreads() throws CorruptDataException {
        this.setReachability(Reachability.STRONG);
        GCVMThreadListIterator vmThreadListIterator = GCVMThreadListIterator.from();
        while (vmThreadListIterator.hasNext()) {
            J9VMThreadPointer walkThread = vmThreadListIterator.next();
            GCVMThreadSlotIterator threadSlotIterator = GCVMThreadSlotIterator.fromJ9VMThread(walkThread);
            GCVMThreadSlotIterator threadSlotAddressIterator = GCVMThreadSlotIterator.fromJ9VMThread(walkThread);
            while (threadSlotIterator.hasNext()) {
                this.doVMThreadSlot(threadSlotIterator.next(), threadSlotAddressIterator.nextAddress());
            }
            GCVMThreadJNISlotIterator jniSlotIterator = GCVMThreadJNISlotIterator.fromJ9VMThread(walkThread);
            GCVMThreadJNISlotIterator jniSlotAddressIterator = GCVMThreadJNISlotIterator.fromJ9VMThread(walkThread);
            while (jniSlotIterator.hasNext()) {
                this.doVMThreadJNISlot(jniSlotIterator.next(), jniSlotAddressIterator.nextAddress());
            }
            if (J9BuildFlags.interp_hotCodeReplacement) {
                GCVMThreadMonitorRecordSlotIterator monitorRecordSlotIterator = GCVMThreadMonitorRecordSlotIterator.fromJ9VMThread(walkThread);
                GCVMThreadMonitorRecordSlotIterator addressIterator = GCVMThreadMonitorRecordSlotIterator.fromJ9VMThread(walkThread);
                while (monitorRecordSlotIterator.hasNext()) {
                    this.doVMThreadMonitorRecordSlot(monitorRecordSlotIterator.next(), addressIterator.nextAddress());
                }
            }
            if (!this._scanStackSlots) continue;
            GCVMThreadStackSlotIterator.scanSlots(walkThread, this._stackWalkerCallbacks, this._includeStackFrameClassReferences, this._trackVisibleStackFrameDepth);
        }
    }

    protected void scanClassLoaders() throws CorruptDataException {
        J9ClassLoaderPointer sysClassLoader = this._vm.systemClassLoader();
        J9ClassLoaderPointer appClassLoader = J9ClassLoaderPointer.cast(this._vm.applicationClassLoader());
        GCClassLoaderIterator classLoaderIterator = GCClassLoaderIterator.from();
        while (classLoaderIterator.hasNext()) {
            long dynamicClassUnloadingFlag;
            J9ClassLoaderPointer loader = classLoaderIterator.next();
            Reachability reachability = J9BuildFlags.gc_dynamicClassUnloading ? (MM_GCExtensionsBase$DynamicClassUnloading.DYNAMIC_CLASS_UNLOADING_NEVER == (dynamicClassUnloadingFlag = this._extensions.dynamicClassUnloading()) ? Reachability.STRONG : (loader.eq(sysClassLoader) || loader.eq(appClassLoader) ? Reachability.STRONG : Reachability.WEAK)) : Reachability.STRONG;
            this.setReachability(reachability);
            this.doClassLoader(loader);
        }
    }

    protected void scanVMClassSlots() throws CorruptDataException {
        GCVMClassSlotIterator classSlotIterator = GCVMClassSlotIterator.from();
        GCVMClassSlotIterator addressIterator = GCVMClassSlotIterator.from();
        this.setReachability(Reachability.STRONG);
        while (classSlotIterator.hasNext()) {
            this.doVMClassSlot(classSlotIterator.next(), addressIterator.nextAddress());
        }
    }

    protected void scanClasses() throws CorruptDataException {
        J9ClassLoaderPointer sysClassLoader = this._vm.systemClassLoader();
        J9ClassLoaderPointer appClassLoader = J9ClassLoaderPointer.cast(this._vm.applicationClassLoader());
        GCSegmentIterator segmentIterator = GCSegmentIterator.fromJ9MemorySegmentList(this._vm.classMemorySegments(), J9MemorySegment.MEMORY_TYPE_RAM_CLASS);
        while (segmentIterator.hasNext()) {
            J9MemorySegmentPointer segment = segmentIterator.next();
            GCClassHeapIterator classHeapIterator = GCClassHeapIterator.fromJ9MemorySegment(segment);
            while (classHeapIterator.hasNext()) {
                long dynamicClassUnloadingFlag;
                J9ClassPointer clazz = classHeapIterator.next();
                Reachability reachability = J9BuildFlags.gc_dynamicClassUnloading ? (MM_GCExtensionsBase$DynamicClassUnloading.DYNAMIC_CLASS_UNLOADING_NEVER == (dynamicClassUnloadingFlag = this._extensions.dynamicClassUnloading()) ? Reachability.STRONG : (clazz.classLoader().eq(sysClassLoader) || clazz.classLoader().eq(appClassLoader) ? Reachability.STRONG : Reachability.WEAK)) : Reachability.STRONG;
                this.setReachability(reachability);
                this.doClass(clazz);
            }
        }
    }

    private void setReachability(Reachability r) {
        this._reachability = r;
    }

    protected Reachability getReachability() {
        return this._reachability;
    }

    public static enum Reachability {
        STRONG,
        WEAK;

    }

    private class RootScannerStackWalkerCallbacks
    implements IStackWalkerCallbacks {
        private RootScannerStackWalkerCallbacks() {
        }

        @Override
        public FrameCallbackResult frameWalkFunction(J9VMThreadPointer walkThread, WalkState walkState) {
            return FrameCallbackResult.KEEP_ITERATING;
        }

        @Override
        public void objectSlotWalkFunction(J9VMThreadPointer walkThread, WalkState walkState, PointerPointer objectSlot, VoidPointer stackLocation) {
            try {
                J9ObjectPointer object = J9ObjectPointer.cast(objectSlot.at(0L));
                if (object.notNull()) {
                    RootScanner.this.doStackSlot(object, walkState, stackLocation);
                }
            }
            catch (CorruptDataException e) {
                EventManager.raiseCorruptDataEvent("Corrupt stack object slot detected", e, false);
            }
        }

        @Override
        public void fieldSlotWalkFunction(J9VMThreadPointer walkThread, WalkState walkState, ObjectReferencePointer objectSlot, VoidPointer stackLocation) {
            try {
                J9ObjectPointer object = objectSlot.at(0L);
                if (object.notNull()) {
                    RootScanner.this.doStackSlot(object, walkState, stackLocation);
                }
            }
            catch (CorruptDataException e) {
                EventManager.raiseCorruptDataEvent("Corrupt stack object slot detected", e, false);
            }
        }
    }
}

