/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm26.tools.ddrinteractive.gccheck;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm26.events.EventManager;
import com.ibm.j9ddr.vm26.j9.StringTable;
import com.ibm.j9ddr.vm26.pointer.PointerPointer;
import com.ibm.j9ddr.vm26.pointer.VoidPointer;
import com.ibm.j9ddr.vm26.pointer.generated.MM_StringTablePointer;
import com.ibm.j9ddr.vm26.tools.ddrinteractive.gccheck.Check;
import com.ibm.j9ddr.vm26.tools.ddrinteractive.gccheck.ScanFormatter;

class CheckStringTable
extends Check {
    CheckStringTable() {
    }

    @Override
    public void check() {
        try {
            StringTable.StringSlotIterator it = StringTable.from().iterator();
            while (it.hasNext()) {
                PointerPointer slot = PointerPointer.cast(it.nextAddress());
                if (!slot.notNull() || this._engine.checkSlotPool(slot, VoidPointer.cast(it.getCurrentHashTable())) == 0) continue;
                return;
            }
        }
        catch (CorruptDataException e) {
            EventManager.raiseCorruptDataEvent("Error checking string table", e, false);
        }
    }

    @Override
    public String getCheckName() {
        return "STRING TABLE";
    }

    @Override
    public void print() {
        try {
            StringTable.StringSlotIterator it = StringTable.from().iterator();
            MM_StringTablePointer stringTable = this.getGCExtensions().stringTable();
            ScanFormatter formatter = new ScanFormatter(this, "StringTable", stringTable);
            while (it.hasNext()) {
                PointerPointer slot = PointerPointer.cast(it.nextAddress());
                if (!slot.notNull()) continue;
                formatter.entry(slot.at(0L));
            }
        }
        catch (CorruptDataException e) {
            EventManager.raiseCorruptDataEvent("Error checking string table", e, false);
        }
    }
}

