/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.certclient.util;

import com.ibm.crypto.provider.PBMParameterSpec;
import com.ibm.misc.Debug;
import com.ibm.security.certclient.PkEeFactory;
import com.ibm.security.certclient.base.PkAttrs;
import com.ibm.security.certclient.base.PkConstants;
import com.ibm.security.certclient.base.PkException;
import com.ibm.security.certclient.base.PkIoException;
import com.ibm.security.certclient.base.PkNLSConstants;
import com.ibm.security.certclient.base.PkRejectionException;
import com.ibm.security.certclient.util.PkBase64InputStream;
import com.ibm.security.certclient.util.PkSsCertFactory;
import com.ibm.security.certclient.util.PkString;
import com.ibm.security.cmp.InfoTypeAndValue;
import com.ibm.security.cmp.InfoValue;
import com.ibm.security.cmp.PKIHeader;
import com.ibm.security.cmp.PKIMessage;
import com.ibm.security.cmp.RevPassphraseInfoValue;
import com.ibm.security.crmf.EncryptedValue;
import com.ibm.security.pkcs10.CertificationRequest;
import com.ibm.security.pkcs10.CertificationRequestInfo;
import com.ibm.security.pkcs9.PKCS9;
import com.ibm.security.pkcsutil.PKCSAttribute;
import com.ibm.security.util.DerInputStream;
import com.ibm.security.util.DerValue;
import com.ibm.security.util.ObjectIdentifier;
import com.ibm.security.x509.AlgorithmId;
import com.ibm.security.x509.CertAttrSet;
import com.ibm.security.x509.CertificateExtensions;
import com.ibm.security.x509.ExtKeyUsageExtension;
import com.ibm.security.x509.Extension;
import com.ibm.security.x509.GeneralName;
import com.ibm.security.x509.GeneralNameInterface;
import com.ibm.security.x509.KeyIdentifier;
import com.ibm.security.x509.KeyUsageExtension;
import com.ibm.security.x509.PKIXExtensions;
import com.ibm.security.x509.SubjectAlternativeNameExtension;
import com.ibm.security.x509.SubjectKeyIdentifierExtension;
import com.ibm.security.x509.X500Name;
import com.ibm.security.x509.X509CertImpl;
import com.ibm.security.x509.X509Key;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.security.AlgorithmParameters;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.interfaces.DSAPrivateKey;
import java.security.interfaces.ECPrivateKey;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidParameterSpecException;
import java.util.Arrays;
import java.util.Date;
import java.util.Enumeration;
import java.util.Vector;

public class JPKI
implements PkConstants {
    private static Debug debug = Debug.getInstance((String)"keycertmanage");
    private static final Object className = "com.ibm.security.certclient.JPKI";
    private static BigInteger BIG_ONE = BigInteger.valueOf(1L);
    private static final ObjectIdentifier EXT_OID = JPKI.getOID();
    private static int APPROVEDAPPLIED = 3;

    private static final ObjectIdentifier getOID() {
        try {
            return new ObjectIdentifier("1.3.6.1.4.1.311.2.1.14");
        }
        catch (Exception exception) {
            if (debug != null) {
                debug.exception(4L, className, "getOID", (Throwable)exception);
            }
            return null;
        }
    }

    public PkAttrs initialCertRequest(String[] stringArray, String[] stringArray2, String[] stringArray3, PublicKey publicKey, PrivateKey privateKey, String string) throws Exception {
        return this.initialCertRequest(stringArray, stringArray2, stringArray3, null, publicKey, privateKey, string);
    }

    public PkAttrs initialCertRequest(String[] stringArray, String[] stringArray2, String[] stringArray3, String[] stringArray4, PublicKey publicKey, PrivateKey privateKey, String string) throws Exception {
        SubjectAlternativeNameExtension subjectAlternativeNameExtension;
        KeyUsageExtension keyUsageExtension;
        int n;
        if (stringArray == null || stringArray.length < 7) {
            throw new PkRejectionException(PkNLSConstants.INVALID_PARMS_ARRAY_SIZE_WRONG);
        }
        if (debug != null) {
            for (n = 0; n < stringArray.length; n += 1) {
                debug.text(1L, className, "initialCertRequest", "Processing {0}", (Object)stringArray[n]);
            }
        }
        if (stringArray[0] == null && stringArray[1] == null) {
            if (stringArray[0] == null) {
                throw new PkRejectionException("0 " + PkNLSConstants.INVALID_PARMS_VALUE_CANNOT_BE_NULL);
            }
            if (stringArray[1] == null) {
                throw new PkRejectionException("1 " + PkNLSConstants.INVALID_PARMS_VALUE_CANNOT_BE_NULL);
            }
        }
        for (n = 2; n < stringArray.length; n += 1) {
            if (stringArray[n] != null || n == 3 || n == 4) continue;
            throw new PkRejectionException("" + n + " " + PkNLSConstants.INVALID_PARMS_VALUE_CANNOT_BE_NULL);
        }
        if (publicKey == null) {
            throw new PkRejectionException(PkNLSConstants.INVALID_PARMS_VALUE_CANNOT_BE_NULL);
        }
        if (stringArray3 != null) {
            for (n = 0; n < stringArray3.length; n += 1) {
                if (debug == null) continue;
                debug.text(1L, className, "initialCertRequest", "Processing {0}", (Object)stringArray3[n]);
            }
        }
        if (stringArray4 != null && debug != null) {
            for (n = 0; n < stringArray4.length; n += 1) {
                debug.text(1L, className, "initialCertRequest", "Processing {0}", (Object)stringArray4[n]);
            }
        }
        n = publicKey instanceof RSAPublicKey;
        X509Key x509Key = (X509Key)publicKey;
        String string2 = new X500Name(stringArray[1]).getName();
        String string3 = null;
        boolean bl = true;
        boolean bl2 = true;
        if (string2 == null || string2.length() == 0) {
            bl2 = false;
        }
        if (stringArray[0] == null || stringArray[0].length() == 0) {
            bl = false;
        }
        if (bl && bl2) {
            string3 = stringArray[0] + ", " + string2;
        } else if (bl && !bl2) {
            string3 = stringArray[0];
        } else if (!bl && bl2) {
            string3 = string2;
        } else {
            throw new PkException(PkNLSConstants.INVALID_SUBJECT_NAME);
        }
        Integer n2 = new Integer(stringArray[2]);
        if (n2 != 3) {
            throw new PkRejectionException(PkNLSConstants.X509_CERT_VERSION_MUST_BE3);
        }
        n2 = CERT_VERSION_3;
        PkAttrs pkAttrs = new PkAttrs();
        int n3 = 3;
        if (stringArray3 != null && stringArray3.length > 0) {
            keyUsageExtension = this.setKeyUsageExt(stringArray3);
            if (this.keyUsageWrong(n != 0, keyUsageExtension)) {
                if (!n && debug != null) {
                    debug.text(1L, className, "initialCertRequest", "Key usage for DSA should be digitalSignature or nonRepudiation");
                }
                throw new PkRejectionException(PkNLSConstants.CERT_BAD_KEY_USAGE);
            }
            pkAttrs.add("x509.info.extensions.KeyUsage", n3, keyUsageExtension);
        }
        keyUsageExtension = null;
        if (stringArray4 != null) {
            keyUsageExtension = this.setextKeyUsageExt(stringArray4);
        }
        if (keyUsageExtension != null) {
            pkAttrs.add("x509.info.extensions.ExtKeyUsage", n3, keyUsageExtension);
        }
        pkAttrs.add("x509.info.version", n3, n2);
        pkAttrs.add("cert.oper.CMP_VERSION", 1, BIG_ONE);
        pkAttrs.add("x509.info.algorithmID", n3, AlgorithmId.get((String)string));
        pkAttrs.add("x509.info.algorithmName", 2, string);
        pkAttrs.add("cert.oper.PROVIDER", 2, PkEeFactory.getProvider());
        long l = new Long(stringArray[5]);
        Date date = new Date(l);
        pkAttrs.add("x509.info.validity.notBefore", n3, date);
        Date date2 = new Date();
        date2.setTime(date.getTime());
        long l2 = new Long(stringArray[6]);
        date2.setTime(l2 += date2.getTime());
        if (debug != null) {
            debug.text(1L, className, "initialCertRequest", "notAfter {0}", (Object)date2);
        }
        pkAttrs.add("x509.info.validity.notAfter", n3, date2);
        pkAttrs.add("x509.info.subject", n3, new X500Name(string3));
        pkAttrs.add("x509.info.key", n3, x509Key);
        if (stringArray[3] != null) {
            pkAttrs.add("cert.oper.SenderKeyIdentifier", 2, new KeyIdentifier(stringArray[3].getBytes()));
        }
        if (stringArray[4] != null) {
            pkAttrs.add("x509.info.init_pwd", 2, stringArray[4]);
        }
        pkAttrs.add("cert.oper.RECIPIENT_DN", 2, new GeneralName((GeneralNameInterface)new X500Name(string2)));
        if (null != stringArray2 && (subjectAlternativeNameExtension = PkSsCertFactory.createSubjectAltName(Arrays.asList(stringArray2), debug, className)) != null) {
            pkAttrs.add("x509.info.extensions.SubjectAlternativeName", n3, subjectAlternativeNameExtension);
        }
        if (debug != null) {
            debug.text(1L, className, "initialCertRequest", "process complete attrs {0}", (Object)pkAttrs);
        }
        return pkAttrs;
    }

    public PkAttrs initialCertRequest(byte[] byArray, String[] stringArray) throws Exception {
        if (byArray == null) {
            throw new PkRejectionException(PkNLSConstants.INVALID_PARMS_VALUE_CANNOT_BE_NULL);
        }
        CertificationRequest certificationRequest = null;
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        DerValue derValue = new DerValue((InputStream)new PkBase64InputStream(byteArrayInputStream));
        certificationRequest = new CertificationRequest(derValue.toByteArray());
        return this.initialCertRequest(certificationRequest, stringArray);
    }

    public PkAttrs initialCertRequest(CertificationRequest certificationRequest, String[] stringArray) throws Exception {
        int n;
        if (certificationRequest == null) {
            throw new PkRejectionException(PkNLSConstants.INVALID_PARMS_VALUE_CANNOT_BE_NULL);
        }
        certificationRequest.verify();
        if (stringArray == null || stringArray.length < 6) {
            throw new PkRejectionException(PkNLSConstants.INVALID_PARMS_ARRAY_SIZE_WRONG);
        }
        if (debug != null) {
            for (n = 0; n < stringArray.length; ++n) {
                debug.text(1L, className, "initialCertRequest", "Processing {0}", (Object)stringArray[n]);
            }
        }
        for (n = 0; n < stringArray.length; ++n) {
            if (stringArray[n] != null) continue;
            throw new PkRejectionException(PkNLSConstants.INVALID_PARMS_VALUE_CANNOT_BE_NULL);
        }
        String string = new X500Name(stringArray[0]).getName();
        PkAttrs pkAttrs = this.getAttrs(certificationRequest);
        int n2 = 3;
        Integer n3 = new Integer(stringArray[1]);
        if (n3 != 3) {
            throw new PkRejectionException(PkNLSConstants.X509_CERT_VERSION_MUST_BE3);
        }
        n3 = CERT_VERSION_3;
        pkAttrs.add("x509.info.version", n2, n3);
        pkAttrs.add("cert.oper.SenderKeyIdentifier", 2, new KeyIdentifier(stringArray[2].getBytes()));
        pkAttrs.add("x509.info.init_pwd", 2, stringArray[3]);
        pkAttrs.add("cert.oper.RECIPIENT_DN", 2, new GeneralName((GeneralNameInterface)new X500Name(string)));
        pkAttrs.add("cert.oper.PROVIDER", 2, PkEeFactory.getProvider());
        pkAttrs.add("cert.oper.CMP_VERSION", 1, BIG_ONE);
        return pkAttrs;
    }

    public PkAttrs confRequest(String[] stringArray) {
        if (debug != null) {
            debug.text(1L, className, "confRequest", "Processing {0}", (Object[])stringArray);
        }
        PkAttrs pkAttrs = new PkAttrs();
        pkAttrs.add("x509.info.version", 2, CERT_VERSION_3);
        pkAttrs.add("cert.oper.keyStore.initAlias", 2, stringArray[0]);
        pkAttrs.add("cert.oper.keyStore.initentryPwd", 2, stringArray[1].toCharArray());
        pkAttrs.add("x509.info.init_pwd", 2, stringArray[2]);
        pkAttrs.add("cert.oper.SenderKeyIdentifier", 2, new KeyIdentifier(stringArray[3].getBytes()));
        InfoTypeAndValue[] infoTypeAndValueArray = null;
        if (stringArray.length >= 5 && stringArray[4] != null && !stringArray[4].equalsIgnoreCase("") && (infoTypeAndValueArray = this.createRevoPassphrase(stringArray[4])) != null) {
            pkAttrs.add("cert.oper.certRevocationPassphrase", 2, infoTypeAndValueArray);
        }
        if (debug != null) {
            debug.text(1L, className, "confRequest", "Process Complete {0}", (Object)pkAttrs);
        }
        return pkAttrs;
    }

    public PkAttrs confRequest(Object[] objectArray, Object[] objectArray2) throws Exception {
        String string;
        if (debug != null) {
            debug.text(1L, className, "confRequest", "Processing {0}", objectArray);
        }
        if (objectArray == null || objectArray.length < 3) {
            throw new PkRejectionException(PkNLSConstants.INVALID_PARMS_ARRAY_SIZE_WRONG);
        }
        if (objectArray[0] == null) {
            throw new PkRejectionException(PkNLSConstants.INVALID_PARMS_VALUE_CANNOT_BE_NULL);
        }
        PkAttrs pkAttrs = new PkAttrs();
        pkAttrs.add("TMP_MSG_HDR", 2, objectArray[0]);
        pkAttrs.add("x509.info.version", 2, CERT_VERSION_3);
        if (objectArray[1] != null) {
            pkAttrs.add("x509.info.init_pwd", 2, (String)objectArray[1]);
        }
        if (objectArray[2] != null) {
            pkAttrs.add("cert.oper.SenderKeyIdentifier", 2, new KeyIdentifier(((String)objectArray[2]).getBytes()));
        }
        InfoTypeAndValue[] infoTypeAndValueArray = null;
        if (objectArray.length >= 4 && (string = (String)objectArray[3]) != null && !string.equalsIgnoreCase("")) {
            if (string.toCharArray().length < 12) {
                throw new PkRejectionException(PkNLSConstants.REVO_PWD_TO_SHORT);
            }
            infoTypeAndValueArray = this.createRevoPassphrase(string);
            if (infoTypeAndValueArray != null) {
                pkAttrs.add("cert.oper.certRevocationPassphrase", 2, infoTypeAndValueArray);
            }
        }
        if (objectArray2 != null) {
            if (objectArray2.length < 2) {
                throw new PkRejectionException(PkNLSConstants.INVALID_PARMS_ARRAY_SIZE_WRONG);
            }
            for (int i = 0; i < objectArray2.length; ++i) {
                if (objectArray2[i] != null) continue;
                throw new PkRejectionException(PkNLSConstants.INVALID_PARMS_VALUE_CANNOT_BE_NULL);
            }
            pkAttrs.add("cert.oper.messageProtectionKey", 2, objectArray2[0]);
            X509CertImpl x509CertImpl = (X509CertImpl)objectArray2[1];
            String string2 = x509CertImpl.getSigAlgName();
            SubjectKeyIdentifierExtension subjectKeyIdentifierExtension = (SubjectKeyIdentifierExtension)x509CertImpl.get("x509.info.extensions.SubjectKeyIdentifier");
            KeyIdentifier keyIdentifier = subjectKeyIdentifierExtension.get("key_id");
            pkAttrs.add("cert.oper.SenderKeyIdentifier", 2, keyIdentifier);
            int n = 3;
            pkAttrs.add("x509.info.algorithmID", n, AlgorithmId.get((String)string2));
            pkAttrs.add("x509.info.algorithmName", 2, string2);
            pkAttrs.add("cert.oper.PROVIDER", 2, PkEeFactory.getProvider());
        }
        if (debug != null) {
            debug.text(1L, className, "confRequest", "Process Complete {0}", (Object)pkAttrs);
        }
        return pkAttrs;
    }

    public PkAttrs secnRequest(String[] stringArray, String[] stringArray2, String[] stringArray3, PublicKey publicKey, PrivateKey privateKey, String string, Object[] objectArray) throws Exception {
        return this.secnRequest(stringArray, stringArray2, stringArray3, null, publicKey, privateKey, string, objectArray);
    }

    public PkAttrs secnRequest(String[] stringArray, String[] stringArray2, String[] stringArray3, String[] stringArray4, PublicKey publicKey, PrivateKey privateKey, String string, Object[] objectArray) throws Exception {
        SubjectAlternativeNameExtension subjectAlternativeNameExtension;
        AlgorithmId algorithmId;
        String string2;
        int n;
        if (stringArray == null || stringArray.length < 5) {
            throw new PkRejectionException(PkNLSConstants.INVALID_PARMS_ARRAY_SIZE_WRONG);
        }
        for (n = 0; n < stringArray.length; n += 1) {
            if (stringArray[n] != null) continue;
            throw new PkRejectionException(PkNLSConstants.INVALID_PARMS_VALUE_CANNOT_BE_NULL);
        }
        if (publicKey == null) {
            throw new PkRejectionException(PkNLSConstants.INVALID_PARMS_VALUE_CANNOT_BE_NULL);
        }
        if (stringArray4 != null && debug != null) {
            for (n = 0; n < stringArray4.length; n += 1) {
                debug.text(1L, className, "secnCertRequest", "Processing {0}", (Object)stringArray4[n]);
            }
        }
        if (objectArray == null || objectArray.length < 2) {
            throw new PkRejectionException(PkNLSConstants.INVALID_PARMS_ARRAY_SIZE_WRONG);
        }
        for (n = 0; n < objectArray.length; n += 1) {
            if (objectArray[n] != null) continue;
            throw new PkRejectionException(PkNLSConstants.INVALID_PARMS_VALUE_CANNOT_BE_NULL);
        }
        if (debug != null) {
            debug.text(1L, className, "secnRequest", "Processing {0}", (Object[])stringArray);
            debug.text(1L, className, "secnRequest", "Processing {0}", (Object[])stringArray3);
        }
        n = publicKey instanceof RSAPublicKey;
        String string3 = new X500Name(stringArray[1]).getName();
        String string4 = stringArray[0] + ", " + string3;
        Integer n2 = new Integer(stringArray[2]);
        if (n2 != 3) {
            throw new PkRejectionException(PkNLSConstants.X509_CERT_VERSION_MUST_BE3);
        }
        n2 = CERT_VERSION_3;
        KeyUsageExtension keyUsageExtension = null;
        if (stringArray3 != null && this.keyUsageWrong(n != 0, keyUsageExtension = this.setKeyUsageExt(stringArray3))) {
            if (!n && debug != null) {
                debug.text(1L, className, "secnCertRequest", "Key usage for DSA should be digitalSignature or nonRepudiation");
            }
            throw new PkRejectionException(PkNLSConstants.CERT_BAD_KEY_USAGE);
        }
        ExtKeyUsageExtension extKeyUsageExtension = null;
        if (stringArray4 != null) {
            extKeyUsageExtension = this.setextKeyUsageExt(stringArray4);
        }
        PkAttrs pkAttrs = new PkAttrs();
        int n3 = 3;
        if (extKeyUsageExtension != null) {
            pkAttrs.add("x509.info.extensions.ExtKeyUsage", n3, extKeyUsageExtension);
        }
        if (keyUsageExtension != null) {
            pkAttrs.add("x509.info.extensions.KeyUsage", n3, keyUsageExtension);
        }
        pkAttrs.add("x509.info.version", n3, CERT_VERSION_3);
        pkAttrs.add("cert.oper.CMP_VERSION", 1, BIG_ONE);
        int n4 = objectArray[0] instanceof RSAPrivateKey;
        boolean bl = objectArray[0] instanceof DSAPrivateKey;
        boolean bl2 = objectArray[0] instanceof ECPrivateKey;
        if (n4 != n && debug != null) {
            debug.text(1L, className, "secnRequest", "privatekey type mismatch {0}", (Object)new Boolean(n4 != 0));
        }
        pkAttrs.add("x509.info.algorithmName", 2, string);
        pkAttrs.add("x509.info.algorithmID", n3, AlgorithmId.get((String)string));
        if (objectArray.length > 2) {
            string2 = (String)objectArray[2];
            if (string2 == null) {
                string2 = "SHA1";
            }
        } else {
            string2 = "SHA1";
        }
        if (n4) {
            algorithmId = null;
            if (string2.equalsIgnoreCase("SHA1")) {
                string2 = "SHA1withRSA";
                algorithmId = new AlgorithmId(AlgorithmId.sha1WithRSAEncryption_oid);
            } else if (string2.equalsIgnoreCase("MD5")) {
                string2 = "Md5withRSA";
                algorithmId = new AlgorithmId(AlgorithmId.md5WithRSAEncryption_oid);
            } else if (string2.equalsIgnoreCase("MD2")) {
                string2 = "Md2withRSA";
                algorithmId = new AlgorithmId(AlgorithmId.md2WithRSAEncryption_oid);
            } else if (string2.equalsIgnoreCase("SHA-384")) {
                string2 = "SHA384withRSA";
                algorithmId = new AlgorithmId(AlgorithmId.sha384WithRSAEncryption_oid);
            } else if (string2.equalsIgnoreCase("SHA-512")) {
                string2 = "SHA512withRSA";
                algorithmId = new AlgorithmId(AlgorithmId.sha512WithRSAEncryption_oid);
            } else {
                algorithmId = new AlgorithmId(AlgorithmId.sha1WithRSAEncryption_oid);
                string2 = "SHA1withRSA";
            }
            pkAttrs.add("x509.info.messageProtectionAlgorithmID", 2, algorithmId);
            pkAttrs.add("x509.info.messageProtectionAlgorithmName", 2, string2);
        } else if (bl) {
            pkAttrs.add("x509.info.messageProtectionAlgorithmID", 2, AlgorithmId.get((String)"SHA1withDSA"));
            pkAttrs.add("x509.info.messageProtectionAlgorithmName", 2, "SHA1withDSA");
        } else if (bl2) {
            algorithmId = null;
            if (string2.equalsIgnoreCase("SHA1")) {
                string2 = "SHA1withECDSA";
                algorithmId = new AlgorithmId(AlgorithmId.sha1WithECDSA_oid);
            } else if (string2.equalsIgnoreCase("SHA2")) {
                string2 = "SHA2withECDSA";
                algorithmId = new AlgorithmId(AlgorithmId.sha256WithECDSA_oid);
            } else if (string2.equalsIgnoreCase("SHA-512")) {
                string2 = "SHA512withECDSA";
                algorithmId = new AlgorithmId(AlgorithmId.sha512WithECDSA_oid);
            } else {
                algorithmId = new AlgorithmId(AlgorithmId.sha1WithECDSA_oid);
                string2 = "SHA1withECDSA";
            }
            pkAttrs.add("x509.info.messageProtectionAlgorithmID", 2, algorithmId);
            pkAttrs.add("x509.info.messageProtectionAlgorithmName", 2, string2);
        } else {
            algorithmId = null;
            if (string2.equalsIgnoreCase("ED448")) {
                string2 = "Ed448";
                algorithmId = new AlgorithmId(AlgorithmId.Ed448_oid);
            } else {
                algorithmId = new AlgorithmId(AlgorithmId.Ed25519_oid);
                string2 = "Ed25519";
            }
            pkAttrs.add("x509.info.messageProtectionAlgorithmID", 2, algorithmId);
            pkAttrs.add("x509.info.messageProtectionAlgorithmName", 2, string2);
        }
        pkAttrs.add("cert.oper.PROVIDER", 2, PkEeFactory.getProvider());
        long l = new Long(stringArray[3]);
        Date date = new Date(l);
        pkAttrs.add("x509.info.validity.notBefore", n3, date);
        Date date2 = new Date();
        date2.setTime(date.getTime());
        long l2 = new Long(stringArray[4]);
        date2.setTime(l2 += date2.getTime());
        pkAttrs.add("x509.info.validity.notAfter", n3, date2);
        if (debug != null) {
            debug.text(1L, className, "secnRequest", "notAfter {0}", (Object)date2);
        }
        pkAttrs.add("cert.oper.RECIPIENT_DN", 2, new GeneralName((GeneralNameInterface)new X500Name(string3)));
        pkAttrs.add("x509.info.key", n3, publicKey);
        pkAttrs.add("cert.oper.messageProtectionKey", 2, objectArray[0]);
        pkAttrs.add("cert.oper.privateKey", 2, privateKey);
        pkAttrs.add("CERT_X509", 2, objectArray[1]);
        X509CertImpl x509CertImpl = (X509CertImpl)objectArray[1];
        SubjectKeyIdentifierExtension subjectKeyIdentifierExtension = (SubjectKeyIdentifierExtension)x509CertImpl.get("x509.info.extensions.SubjectKeyIdentifier");
        KeyIdentifier keyIdentifier = subjectKeyIdentifierExtension.get("key_id");
        pkAttrs.add("cert.oper.SenderKeyIdentifier", 2, keyIdentifier);
        String string5 = new X500Name(x509CertImpl.getSubjectDN().toString()).getName();
        String string6 = new X500Name(string4).getName();
        if (!string5.equalsIgnoreCase(string6)) {
            if (debug != null) {
                debug.text(1L, className, "secnRequest", "subject mismatch.old subject {0} ", (Object)string5);
                debug.text(1L, className, "secnRequest", "subject mismatch.new subject {0} ", (Object)string6);
            }
            throw new PkRejectionException(PkNLSConstants.SUBJECT_MISMATCH_WITH_INIT_REQ);
        }
        pkAttrs.add("x509.info.subject", n3, new X500Name(string4));
        if (stringArray2 != null && (subjectAlternativeNameExtension = PkSsCertFactory.createSubjectAltName(Arrays.asList(stringArray2), debug, className)) != null) {
            pkAttrs.add("x509.info.extensions.SubjectAlternativeName", n3, subjectAlternativeNameExtension);
        }
        if (debug != null) {
            debug.text(1L, className, "secnRequest", "process complete attrs {0}", (Object)pkAttrs);
        }
        return pkAttrs;
    }

    public PkAttrs revoRequest(Object[] objectArray) throws Exception {
        if (debug != null) {
            debug.text(1L, className, "revoRequest", "Processing {0}", objectArray);
        }
        if (objectArray == null || objectArray.length < 3) {
            throw new PkRejectionException(PkNLSConstants.INVALID_PARMS_ARRAY_SIZE_WRONG);
        }
        for (int i = 0; i < objectArray.length; ++i) {
            if (objectArray[i] != null || i == 2 || i == 3) continue;
            throw new PkRejectionException(PkNLSConstants.INVALID_PARMS_VALUE_CANNOT_BE_NULL);
        }
        if (objectArray.length == 3 && objectArray[2] == null) {
            throw new PkRejectionException(PkNLSConstants.INVALID_PARMS_VALUE_CANNOT_BE_NULL);
        }
        if (objectArray.length == 4 && objectArray[2] == null && objectArray[3] == null) {
            throw new PkRejectionException(PkNLSConstants.INVALID_PARMS_VALUE_CANNOT_BE_NULL);
        }
        PkAttrs pkAttrs = new PkAttrs();
        X509CertImpl x509CertImpl = null;
        BigInteger bigInteger = null;
        String string = null;
        SubjectKeyIdentifierExtension subjectKeyIdentifierExtension = null;
        KeyIdentifier keyIdentifier = null;
        PublicKey publicKey = null;
        String string2 = null;
        x509CertImpl = (X509CertImpl)objectArray[0];
        bigInteger = x509CertImpl.getSerialNumber();
        string = x509CertImpl.getIssuerDN().getName();
        subjectKeyIdentifierExtension = (SubjectKeyIdentifierExtension)x509CertImpl.get("x509.info.extensions.SubjectKeyIdentifier");
        keyIdentifier = subjectKeyIdentifierExtension.get("key_id");
        publicKey = x509CertImpl.getPublicKey();
        string2 = x509CertImpl.getSigAlgName();
        int n = 3;
        pkAttrs.add("x509.info.serialNumber", n, x509CertImpl.getSerialNumber());
        pkAttrs.add("x509.info.subject", n, x509CertImpl.getSubjectDN());
        pkAttrs.add("cert.oper.RECIPIENT_DN", 2, new GeneralName((GeneralNameInterface)new X500Name(new String(string))));
        pkAttrs.add("CERT_X509", 2, objectArray[0]);
        pkAttrs.add("cert.oper.SenderKeyIdentifier", 2, keyIdentifier);
        pkAttrs.add("revo.badSinceDate", 2, new Date());
        if (objectArray[1] != null) {
            int n2 = (Integer)objectArray[1];
            if (0 <= n2 && n2 < 7 || n2 == 8) {
                pkAttrs.add("revo.reasonFlags", 2, objectArray[1]);
            } else {
                throw new PkRejectionException(PkNLSConstants.INCORRECT_REASON);
            }
        }
        pkAttrs.add("cert.oper.privateKey", 2, objectArray[2]);
        pkAttrs.add("cert.oper.CMP_VERSION", 1, BIG_ONE);
        pkAttrs.add("x509.info.algorithmName", 2, string2);
        pkAttrs.add("cert.oper.PROVIDER", 2, PkEeFactory.getProvider());
        if (objectArray.length >= 4) {
            InfoTypeAndValue[] infoTypeAndValueArray = null;
            if (objectArray[3] != null && !((String)objectArray[3]).equalsIgnoreCase("") && (infoTypeAndValueArray = this.createRevoPassphrase((String)objectArray[3])) != null) {
                pkAttrs.add("cert.oper.certRevocationPassphrase", 2, infoTypeAndValueArray);
            }
        }
        if (debug != null) {
            debug.text(1L, className, "revoRequest", "Process Complete {0}", (Object)pkAttrs);
        }
        return pkAttrs;
    }

    public PkAttrs revoRequest(BigInteger bigInteger, Object[] objectArray) throws Exception {
        if (debug != null) {
            debug.text(1L, className, "newrevoRequest", "certSerialNumber {0}", (Object)bigInteger);
            debug.text(1L, className, "newrevoRequest", "Processing {0}", objectArray);
        }
        if (objectArray == null || objectArray.length < 2) {
            throw new PkRejectionException(PkNLSConstants.INVALID_PARMS_ARRAY_SIZE_WRONG);
        }
        for (int i = 0; i < objectArray.length; ++i) {
            if (objectArray[i] != null || i == 1 || i == 2) continue;
            throw new PkRejectionException(PkNLSConstants.INVALID_PARMS_VALUE_CANNOT_BE_NULL);
        }
        if (objectArray.length == 2 && objectArray[1] == null) {
            throw new PkRejectionException(PkNLSConstants.INVALID_PARMS_VALUE_CANNOT_BE_NULL);
        }
        if (objectArray.length == 3 && objectArray[1] == null && objectArray[2] == null) {
            throw new PkRejectionException(PkNLSConstants.INVALID_PARMS_VALUE_CANNOT_BE_NULL);
        }
        PkAttrs pkAttrs = new PkAttrs();
        int n = 3;
        pkAttrs.add("x509.info.serialNumber", n, bigInteger);
        pkAttrs.add("x509.info.subject", n, new X500Name("CN=DSubject"));
        pkAttrs.add("cert.oper.RECIPIENT_DN", 2, new GeneralName((GeneralNameInterface)new X500Name("O=DIssuer")));
        pkAttrs.add("revo.badSinceDate", 2, new Date());
        if (objectArray[0] != null) {
            int n2 = (Integer)objectArray[0];
            if (0 <= n2 && n2 < 7 || n2 == 8) {
                pkAttrs.add("revo.reasonFlags", 2, objectArray[0]);
            } else {
                throw new PkRejectionException(PkNLSConstants.INCORRECT_REASON);
            }
        }
        if (objectArray[1] != null) {
            PrivateKey privateKey = (PrivateKey)objectArray[1];
            if (privateKey instanceof RSAPrivateKey) {
                pkAttrs.add("x509.info.algorithmName", 2, "SHA1withRSA");
            } else if (privateKey instanceof DSAPrivateKey) {
                pkAttrs.add("x509.info.algorithmName", 2, "SHA1withDSA");
            } else if (privateKey instanceof ECPrivateKey) {
                pkAttrs.add("x509.info.algorithmName", 2, "SHA1withECDSA");
            } else {
                pkAttrs.add("x509.info.algorithmName", 2, "Ed25519");
            }
        }
        pkAttrs.add("cert.oper.privateKey", 2, objectArray[1]);
        pkAttrs.add("cert.oper.CMP_VERSION", 1, BIG_ONE);
        pkAttrs.add("cert.oper.PROVIDER", 2, PkEeFactory.getProvider());
        if (objectArray.length >= 3) {
            InfoTypeAndValue[] infoTypeAndValueArray = null;
            if (objectArray[2] != null && !((String)objectArray[2]).equalsIgnoreCase("") && (infoTypeAndValueArray = this.createRevoPassphrase((String)objectArray[2])) != null) {
                pkAttrs.add("cert.oper.certRevocationPassphrase", 2, infoTypeAndValueArray);
            }
        }
        if (debug != null) {
            debug.text(1L, className, "revoRequest", "Process Complete {0}", (Object)pkAttrs);
        }
        return pkAttrs;
    }

    public PkAttrs revoRequest(PublicKey publicKey, Object[] objectArray) throws Exception {
        if (debug != null) {
            debug.text(1L, className, "newrevoRequest", "publicKey {0}", (Object)publicKey);
            debug.text(1L, className, "newrevoRequest", "Processing {0}", objectArray);
        }
        if (objectArray == null || objectArray.length < 2) {
            throw new PkRejectionException(PkNLSConstants.INVALID_PARMS_ARRAY_SIZE_WRONG);
        }
        for (int i = 0; i < objectArray.length; ++i) {
            if (objectArray[i] != null || i == 1 || i == 2) continue;
            throw new PkRejectionException(PkNLSConstants.INVALID_PARMS_VALUE_CANNOT_BE_NULL);
        }
        if (objectArray.length == 2 && objectArray[1] == null) {
            throw new PkRejectionException(PkNLSConstants.INVALID_PARMS_VALUE_CANNOT_BE_NULL);
        }
        if (objectArray.length == 3 && objectArray[1] == null && objectArray[2] == null) {
            throw new PkRejectionException(PkNLSConstants.INVALID_PARMS_VALUE_CANNOT_BE_NULL);
        }
        PkAttrs pkAttrs = new PkAttrs();
        int n = 3;
        pkAttrs.add("x509.info.subject", n, new X500Name("CN=DSubject"));
        pkAttrs.add("cert.oper.RECIPIENT_DN", 2, new GeneralName((GeneralNameInterface)new X500Name("O=DIssuer")));
        pkAttrs.add("x509.info.certrevopublickey", n, publicKey);
        pkAttrs.add("revo.badSinceDate", 2, new Date());
        if (objectArray[0] != null) {
            int n2 = (Integer)objectArray[0];
            if (0 <= n2 && n2 < 7 || n2 == 8) {
                pkAttrs.add("revo.reasonFlags", 2, objectArray[0]);
            } else {
                throw new PkRejectionException(PkNLSConstants.INCORRECT_REASON);
            }
        }
        if (objectArray[1] != null) {
            PrivateKey privateKey = (PrivateKey)objectArray[1];
            if (privateKey instanceof RSAPrivateKey) {
                pkAttrs.add("x509.info.algorithmName", 2, "SHA1withRSA");
            } else if (privateKey instanceof DSAPrivateKey) {
                pkAttrs.add("x509.info.algorithmName", 2, "SHA1withDSA");
            } else if (privateKey instanceof ECPrivateKey) {
                pkAttrs.add("x509.info.algorithmName", 2, "SHA1withECDSA");
            } else {
                pkAttrs.add("x509.info.algorithmName", 2, "Ed25519");
            }
        }
        pkAttrs.add("cert.oper.privateKey", 2, objectArray[1]);
        pkAttrs.add("cert.oper.CMP_VERSION", 1, BIG_ONE);
        pkAttrs.add("cert.oper.PROVIDER", 2, PkEeFactory.getProvider());
        if (objectArray.length >= 3) {
            InfoTypeAndValue[] infoTypeAndValueArray = null;
            if (objectArray[2] != null && !((String)objectArray[2]).equalsIgnoreCase("") && (infoTypeAndValueArray = this.createRevoPassphrase((String)objectArray[2])) != null) {
                pkAttrs.add("cert.oper.certRevocationPassphrase", 2, infoTypeAndValueArray);
            }
        }
        if (debug != null) {
            debug.text(1L, className, "revoRequest", "Process Complete {0}", (Object)pkAttrs);
        }
        return pkAttrs;
    }

    private boolean keyUsageWrong(boolean bl, KeyUsageExtension keyUsageExtension) throws Exception {
        boolean bl2;
        block6: {
            int n;
            boolean[] blArray;
            block5: {
                int n2;
                blArray = keyUsageExtension.getBits();
                bl2 = false;
                if (!bl) break block5;
                for (n2 = 0; n2 < blArray.length; ++n2) {
                    if (debug == null) continue;
                    debug.text(1L, className, "keyUsageWrong", "ba ={0}", (Object)new Boolean(blArray[n2]));
                }
                if (blArray.length <= 5) break block6;
                n2 = blArray.length >= 7 ? 7 : blArray.length;
                for (int i = 5; i < n2; ++i) {
                    bl2 = bl2 || blArray[i];
                }
                break block6;
            }
            for (n = 0; n < blArray.length; ++n) {
                if (debug == null) continue;
                debug.text(1L, className, "keyUsageWrong", "ba ={0}", (Object)new Boolean(blArray[n]));
            }
            if (blArray.length > 2) {
                for (n = 2; n < blArray.length; ++n) {
                    bl2 = bl2 || blArray[n];
                }
            }
        }
        return bl2;
    }

    private PKIMessage getConfMessage(PKIHeader pKIHeader, KeyIdentifier keyIdentifier, String string) throws Exception {
        GeneralName generalName = pKIHeader.getRecipient();
        GeneralName generalName2 = pKIHeader.getSender();
        KeyIdentifier keyIdentifier2 = null;
        byte[] byArray = pKIHeader.getRecipNonce();
        byte[] byArray2 = pKIHeader.getSenderNonce();
        byte[] byArray3 = pKIHeader.getTransactionID();
        byte[] byArray4 = "this is a salt".getBytes();
        AlgorithmId algorithmId = new AlgorithmId(AlgorithmId.SHA_oid);
        int n = 1001;
        AlgorithmId algorithmId2 = new AlgorithmId(AlgorithmId.HmacSHA1_oid);
        PBMParameterSpec pBMParameterSpec = new PBMParameterSpec(byArray4, algorithmId, n, algorithmId2);
        AlgorithmParameters algorithmParameters = null;
        try {
            algorithmParameters = AlgorithmParameters.getInstance("PasswordBasedMac", PkEeFactory.getProvider());
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            if (debug != null) {
                debug.text(1L, className, "getConfMessage", "ERROR : {0} ", (Object)noSuchAlgorithmException.toString());
            }
            throw noSuchAlgorithmException;
        }
        catch (NoSuchProviderException noSuchProviderException) {
            if (debug != null) {
                debug.text(1L, className, "getConfMessage", "ERROR : {0} ", (Object)noSuchProviderException.toString());
            }
            throw noSuchProviderException;
        }
        try {
            algorithmParameters.init((AlgorithmParameterSpec)pBMParameterSpec);
        }
        catch (InvalidParameterSpecException invalidParameterSpecException) {
            if (debug != null) {
                debug.text(1L, className, "getConfMessage", "ERROR : {0} ", (Object)invalidParameterSpecException.toString());
            }
            throw invalidParameterSpecException;
        }
        AlgorithmId algorithmId3 = null;
        try {
            algorithmId3 = new AlgorithmId(AlgorithmId.PasswordBasedMac_oid, algorithmParameters.getEncoded());
        }
        catch (Exception exception) {
            if (debug != null) {
                debug.text(1L, className, "getConfMessage", "ERROR : {0} ", (Object)exception.toString());
            }
            throw exception;
        }
        PKIHeader pKIHeader2 = new PKIHeader(BIG_ONE, generalName, generalName2, new Date(), algorithmId3, keyIdentifier, keyIdentifier2, byArray3, byArray, byArray2, null, null);
        PKIMessage pKIMessage = new PKIMessage(pKIHeader2, 19, null, null, null);
        PKIMessage pKIMessage2 = null;
        try {
            pKIMessage2 = pKIMessage.protect(string.getBytes());
        }
        catch (Exception exception) {
            if (exception instanceof PkException) {
                throw (PkException)exception;
            }
            throw new PkException(exception);
        }
        return pKIMessage2;
    }

    private InfoTypeAndValue[] createRevoPassphrase(String string) {
        InfoTypeAndValue[] infoTypeAndValueArray;
        EncryptedValue encryptedValue = new EncryptedValue(null, null, null, null, null, string.getBytes());
        try {
            RevPassphraseInfoValue revPassphraseInfoValue = new RevPassphraseInfoValue(encryptedValue);
            infoTypeAndValueArray = new InfoTypeAndValue[]{new InfoTypeAndValue((InfoValue)revPassphraseInfoValue)};
        }
        catch (IOException iOException) {
            infoTypeAndValueArray = null;
        }
        return infoTypeAndValueArray;
    }

    private byte[] getIPAddress(String string) {
        String[] stringArray = PkString.split(string, ".");
        byte[] byArray = new byte[]{new Integer(stringArray[0]).byteValue(), new Integer(stringArray[1]).byteValue(), new Integer(stringArray[2]).byteValue(), new Integer(stringArray[3]).byteValue()};
        return byArray;
    }

    private KeyUsageExtension setKeyUsageExt(String[] stringArray) throws IOException, PkRejectionException {
        KeyUsageExtension keyUsageExtension = new KeyUsageExtension();
        for (int i = 0; i < stringArray.length && stringArray[i] != null; ++i) {
            if (stringArray[i].equalsIgnoreCase("digital_signature")) {
                keyUsageExtension.set("digital_signature", (Object)Boolean.TRUE);
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("data_encipherment")) {
                keyUsageExtension.set("data_encipherment", (Object)Boolean.TRUE);
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("encipher_only")) {
                keyUsageExtension.set("encipher_only", (Object)Boolean.TRUE);
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("decipher_only")) {
                keyUsageExtension.set("decipher_only", (Object)Boolean.TRUE);
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("non_repudiation")) {
                keyUsageExtension.set("non_repudiation", (Object)Boolean.TRUE);
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("key_encipherment")) {
                keyUsageExtension.set("key_encipherment", (Object)Boolean.TRUE);
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("key_agreement")) {
                keyUsageExtension.set("key_agreement", (Object)Boolean.TRUE);
                continue;
            }
            if (debug != null) {
                debug.text(1L, className, "setKeyUsageExt", "Key usage {0} is not valid", (Object)stringArray[i]);
            }
            throw new PkRejectionException(PkNLSConstants.CERT_BAD_KEY_USAGE);
        }
        return keyUsageExtension;
    }

    private ExtKeyUsageExtension setextKeyUsageExt(String[] stringArray) throws IOException, PkRejectionException {
        ExtKeyUsageExtension extKeyUsageExtension = null;
        Vector<ObjectIdentifier> vector = new Vector<ObjectIdentifier>();
        for (int i = 0; i < stringArray.length && stringArray[i] != null; ++i) {
            if (stringArray[i].equalsIgnoreCase("ServerAuth_Id")) {
                vector.add(i, PKIXExtensions.ServerAuth_Id);
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("ClientAuth_Id")) {
                vector.add(i, PKIXExtensions.ClientAuth_Id);
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("CodeSigning_Id")) {
                vector.add(i, PKIXExtensions.CodeSigning_Id);
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("EmailProtection_Id")) {
                vector.add(i, PKIXExtensions.EmailProtection_Id);
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("IPSecEndSystem_Id")) {
                vector.add(i, PKIXExtensions.IPSecEndSystem_Id);
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("IPSecTunnel_Id")) {
                vector.add(i, PKIXExtensions.IPSecTunnel_Id);
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("IPSecUser_Id")) {
                vector.add(i, PKIXExtensions.IPSecUser_Id);
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("TimeStamping_Id")) {
                vector.add(i, PKIXExtensions.TimeStamping_Id);
                continue;
            }
            if (debug != null) {
                debug.text(1L, className, "extsetKeyUsageExt", "Key usage {0} is not valid", (Object)stringArray[i]);
            }
            throw new PkRejectionException(PkNLSConstants.CERT_BAD_KEY_USAGE);
        }
        if (vector.size() > 0) {
            extKeyUsageExtension = new ExtKeyUsageExtension(vector);
        }
        return extKeyUsageExtension;
    }

    private PkAttrs getAttrs(CertificationRequest certificationRequest) throws IOException {
        CertificationRequestInfo certificationRequestInfo = certificationRequest.getCertRequestInfo();
        PkAttrs pkAttrs = new PkAttrs();
        pkAttrs.add("x509.info.subject", APPROVEDAPPLIED, certificationRequestInfo.getSubjectName());
        try {
            pkAttrs.add("x509.info.key", APPROVEDAPPLIED, certificationRequestInfo.getSubjectPublicKeyInfo());
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new PkIoException(invalidKeyException);
        }
        PKCSAttribute[] pKCSAttributeArray = certificationRequestInfo.getAttributes().getAttributes();
        for (int i = 0; i < pKCSAttributeArray.length; ++i) {
            ObjectIdentifier objectIdentifier = pKCSAttributeArray[i].getAttributeId();
            String string = PKCS9.getName((ObjectIdentifier)objectIdentifier);
            if (string != null) {
                pkAttrs.add(string, 1, pKCSAttributeArray[i].getAttributeValue());
                continue;
            }
            if (!objectIdentifier.equals(EXT_OID)) continue;
            DerInputStream derInputStream = new DerInputStream((byte[])pKCSAttributeArray[i].getAttributeValue());
            DerValue[] derValueArray = derInputStream.getSet(1);
            DerInputStream derInputStream2 = new DerInputStream(derValueArray[0].toByteArray());
            CertificateExtensions certificateExtensions = new CertificateExtensions(derInputStream2);
            Enumeration enumeration = certificateExtensions.getElements();
            while (enumeration.hasMoreElements()) {
                Object e = enumeration.nextElement();
                String string2 = !(e instanceof CertAttrSet) ? ((Extension)e).getExtensionId().toString() : "x509.info.extensions." + ((CertAttrSet)e).getName();
                pkAttrs.add(string2, 1, e);
            }
        }
        return pkAttrs;
    }
}

