/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xalan.templates;

import javax.xml.transform.TransformerException;
import org.apache.xalan.extensions.ExtensionNamespaceSupport;
import org.apache.xalan.templates.ElemParam;
import org.apache.xalan.templates.ElemTemplate;
import org.apache.xalan.templates.ElemTemplateElement;
import org.apache.xalan.templates.StylesheetRoot;
import org.apache.xalan.transformer.TransformerImpl;
import org.apache.xpath.VariableStack;
import org.apache.xpath.XPathContext;
import org.apache.xpath.objects.XObject;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ElemExsltFunction
extends ElemTemplate {
    static final long serialVersionUID = 272154954793534771L;

    @Override
    public int getXSLToken() {
        return 88;
    }

    @Override
    public String getNodeName() {
        return "function";
    }

    public void execute(TransformerImpl transformerImpl, XObject[] xObjectArray) throws TransformerException {
        XPathContext xPathContext = transformerImpl.getXPathContext();
        VariableStack variableStack = xPathContext.getVarStack();
        int n = variableStack.getStackFrame();
        int n2 = variableStack.link(this.m_frameSize);
        if (this.m_inArgsSize < xObjectArray.length) {
            throw new TransformerException("function called with too many args");
        }
        if (this.m_inArgsSize > 0) {
            variableStack.clearLocalSlots(0, this.m_inArgsSize);
            if (xObjectArray.length > 0) {
                variableStack.setStackFrame(n);
                NodeList nodeList = this.getChildNodes();
                for (int i = 0; i < xObjectArray.length; ++i) {
                    Node node = nodeList.item(i);
                    if (!(nodeList.item(i) instanceof ElemParam)) continue;
                    ElemParam elemParam = (ElemParam)nodeList.item(i);
                    variableStack.setLocalVariable(elemParam.getIndex(), xObjectArray[i], n2);
                }
                variableStack.setStackFrame(n2);
            }
        }
        if (transformerImpl.getDebug()) {
            transformerImpl.getTraceManager().fireTraceEvent(this);
        }
        variableStack.setStackFrame(n2);
        transformerImpl.executeChildTemplates((ElemTemplateElement)this, true);
        variableStack.unlink(n);
        if (transformerImpl.getDebug()) {
            transformerImpl.getTraceManager().fireTraceEndEvent(this);
        }
    }

    @Override
    public void compose(StylesheetRoot stylesheetRoot) throws TransformerException {
        super.compose(stylesheetRoot);
        String string = this.getName().getNamespace();
        String string2 = stylesheetRoot.getExtensionHandlerClass();
        Object[] objectArray = new Object[]{string, stylesheetRoot};
        ExtensionNamespaceSupport extensionNamespaceSupport = new ExtensionNamespaceSupport(string, string2, objectArray);
        stylesheetRoot.getExtensionNamespacesManager().registerExtension(extensionNamespaceSupport);
        if (!string.equals("http://exslt.org/functions")) {
            string = "http://exslt.org/functions";
            objectArray = new Object[]{string, stylesheetRoot};
            extensionNamespaceSupport = new ExtensionNamespaceSupport(string, string2, objectArray);
            stylesheetRoot.getExtensionNamespacesManager().registerExtension(extensionNamespaceSupport);
        }
    }
}

