/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xylem.interpreter;

import com.ibm.xylem.interpreter.IStream;
import com.ibm.xylem.interpreter.StringStream;
import com.ibm.xylem.types.AbstractDataType;
import java.util.Iterator;

public final class AbstractDataObject {
    protected Object[] m_values;
    protected AbstractDataType.Constructor m_constructor;

    public AbstractDataObject(AbstractDataType.Constructor constructor, Object[] objectArray) {
        this.m_constructor = constructor;
        this.m_values = objectArray;
    }

    public final AbstractDataType.Constructor getConstructor() {
        return this.m_constructor;
    }

    public final Object[] getValues() {
        return this.m_values;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer().append('(');
        stringBuffer.append(this.m_constructor.getName());
        for (int i = 0; i < this.m_values.length; ++i) {
            stringBuffer.append(' ');
            String string = this.m_constructor.m_parameters[i].getName().toString();
            Object object = this.m_values[i];
            if (object instanceof String || object instanceof StringStream) {
                object = "\"" + object + "\"";
            } else if (object instanceof IStream) {
                IStream iStream = (IStream)object;
                StringBuffer stringBuffer2 = new StringBuffer("(stream");
                Iterator iterator = iStream.iterator();
                while (iterator.hasNext()) {
                    stringBuffer2.append(' ');
                    stringBuffer2.append(iterator.next());
                }
                stringBuffer2.append(')');
                object = stringBuffer2.toString();
            }
            if (string.startsWith("attribute:")) {
                stringBuffer.append(object);
                continue;
            }
            stringBuffer.append(object);
        }
        stringBuffer.append(")");
        return stringBuffer.toString();
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof AbstractDataObject)) {
            return false;
        }
        AbstractDataObject abstractDataObject = (AbstractDataObject)object;
        if (abstractDataObject.m_constructor != this.m_constructor || abstractDataObject.m_values.length != this.m_values.length) {
            return false;
        }
        for (int i = 0; i < this.m_values.length; ++i) {
            if (this.m_values[i] == null && abstractDataObject.m_values[i] == null) {
                return true;
            }
            if (this.m_values[i].equals(abstractDataObject.m_values[i])) continue;
            return false;
        }
        return true;
    }
}

