/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xlxp.api.stax;

import com.ibm.xml.xlxp.api.stax.DOMStreamReaderImpl;
import com.ibm.xml.xlxp.api.stax.EmptyLocation;
import com.ibm.xml.xlxp.api.stax.JavaXNamespaceContext;
import com.ibm.xml.xlxp.api.stax.SAXStreamReaderImpl;
import com.ibm.xml.xlxp.api.stax.StAXImplConstants;
import com.ibm.xml.xlxp.api.stax.StAXLogger;
import com.ibm.xml.xlxp.api.stax.XMLEventReaderImpl;
import com.ibm.xml.xlxp.api.stax.XMLFilteredEventReaderImpl;
import com.ibm.xml.xlxp.api.stax.XMLFilteredStreamReaderImpl;
import com.ibm.xml.xlxp.api.stax.XMLStreamReaderImpl;
import com.ibm.xml.xlxp.api.stax.msg.StAXMessageProvider;
import com.ibm.xml.xlxp.api.util.Pool;
import java.io.InputStream;
import java.io.Reader;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import javax.xml.stream.EventFilter;
import javax.xml.stream.Location;
import javax.xml.stream.StreamFilter;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLReporter;
import javax.xml.stream.XMLResolver;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.util.XMLEventAllocator;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamSource;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.XMLReader;

public class XMLInputFactoryImpl
extends XMLInputFactory {
    protected static final boolean ENABLE_LOGGING = false;
    protected Properties fProperties = new Properties();
    protected static ClosedXMLStreamReader fgClosedStreamReader = new ClosedXMLStreamReader();
    protected static EndDocumentXMLStreamReader fgEndDocumentXMLStreamReader = new EndDocumentXMLStreamReader();
    protected static EmptyLocation fgEmptyLocation = new EmptyLocation();
    protected static NamespaceContext fgEmptyNSContext = new JavaXNamespaceContext();
    private static final Pool fStreamReaders = new Pool();
    private static final Pool fDOMReaders = new Pool();
    private static final Pool fSAXReaders = new Pool();

    protected XMLStreamReader createProxyFor(XMLStreamReader xMLStreamReader) {
        return new XMLStreamReaderProxy(xMLStreamReader);
    }

    protected XMLStreamReader createXMLStreamReader(InputSource inputSource) throws XMLStreamException {
        this.fProperties.given = true;
        XMLStreamReaderImpl xMLStreamReaderImpl = (XMLStreamReaderImpl)fStreamReaders.get();
        if (xMLStreamReaderImpl == null) {
            xMLStreamReaderImpl = new XMLStreamReaderImpl(inputSource, this.fProperties);
            fStreamReaders.assignToPool(xMLStreamReaderImpl);
        } else {
            try {
                xMLStreamReaderImpl.setDocumentEntity(inputSource, this.fProperties);
            }
            catch (XMLStreamException xMLStreamException) {
                xMLStreamReaderImpl.close();
                throw xMLStreamException;
            }
        }
        return xMLStreamReaderImpl;
    }

    private XMLStreamReader createXMLStreamReader(Node node) throws XMLStreamException {
        this.fProperties.given = true;
        DOMStreamReaderImpl dOMStreamReaderImpl = (DOMStreamReaderImpl)fDOMReaders.get();
        if (dOMStreamReaderImpl == null) {
            dOMStreamReaderImpl = new DOMStreamReaderImpl(node, this.fProperties);
            fDOMReaders.assignToPool(dOMStreamReaderImpl);
        } else {
            try {
                dOMStreamReaderImpl.setNode(node, this.fProperties);
            }
            catch (XMLStreamException xMLStreamException) {
                dOMStreamReaderImpl.close();
                throw xMLStreamException;
            }
        }
        return dOMStreamReaderImpl;
    }

    private XMLStreamReader createXMLStreamReader(InputSource inputSource, XMLReader xMLReader) throws XMLStreamException {
        this.fProperties.given = true;
        SAXStreamReaderImpl sAXStreamReaderImpl = (SAXStreamReaderImpl)fSAXReaders.get();
        if (sAXStreamReaderImpl == null) {
            sAXStreamReaderImpl = new SAXStreamReaderImpl(inputSource, xMLReader, this.fProperties);
            fSAXReaders.assignToPool(sAXStreamReaderImpl);
        } else {
            try {
                sAXStreamReaderImpl.setSource(inputSource, xMLReader, this.fProperties);
            }
            catch (XMLStreamException xMLStreamException) {
                sAXStreamReaderImpl.close();
                throw xMLStreamException;
            }
        }
        return sAXStreamReaderImpl;
    }

    private XMLStreamReader createXMLStreamReaderInternal(Reader reader) throws XMLStreamException {
        return this.createXMLStreamReader(new InputSource(reader));
    }

    private XMLStreamReader createXMLStreamReaderInternal(Source source) throws XMLStreamException {
        if (source instanceof StreamSource) {
            InputSource inputSource = SAXSource.sourceToInputSource(source);
            return this.createXMLStreamReader(inputSource);
        }
        if (source instanceof DOMSource) {
            DOMSource dOMSource = (DOMSource)source;
            return this.createXMLStreamReader(dOMSource.getNode());
        }
        if (source instanceof SAXSource) {
            SAXSource sAXSource = (SAXSource)source;
            return this.createXMLStreamReader(sAXSource.getInputSource(), sAXSource.getXMLReader());
        }
        StAXMessageProvider.throwUnsupportedOperationException(StAXMessageProvider.createMessage(null, 0, "createXMLStreamReader(Source)"));
        return null;
    }

    private XMLStreamReader createXMLStreamReaderInternal(InputStream inputStream) throws XMLStreamException {
        return this.createXMLStreamReader(new InputSource(inputStream));
    }

    private XMLStreamReader createXMLStreamReaderInternal(InputStream inputStream, String string) throws XMLStreamException {
        InputSource inputSource = new InputSource(inputStream);
        inputSource.setEncoding(string);
        return this.createXMLStreamReader(inputSource);
    }

    private XMLStreamReader createXMLStreamReaderInternal(String string, InputStream inputStream) throws XMLStreamException {
        InputSource inputSource = new InputSource(inputStream);
        inputSource.setSystemId(string);
        return this.createXMLStreamReader(inputSource);
    }

    private XMLStreamReader createXMLStreamReaderInternal(String string, Reader reader) throws XMLStreamException {
        InputSource inputSource = new InputSource(reader);
        inputSource.setSystemId(string);
        return this.createXMLStreamReader(inputSource);
    }

    @Override
    public XMLStreamReader createXMLStreamReader(Reader reader) throws XMLStreamException {
        return this.createProxyFor(this.createXMLStreamReaderInternal(reader));
    }

    @Override
    public XMLStreamReader createXMLStreamReader(Source source) throws XMLStreamException {
        return this.createProxyFor(this.createXMLStreamReaderInternal(source));
    }

    @Override
    public XMLStreamReader createXMLStreamReader(InputStream inputStream) throws XMLStreamException {
        return this.createProxyFor(this.createXMLStreamReaderInternal(inputStream));
    }

    @Override
    public XMLStreamReader createXMLStreamReader(InputStream inputStream, String string) throws XMLStreamException {
        return this.createProxyFor(this.createXMLStreamReaderInternal(inputStream, string));
    }

    @Override
    public XMLStreamReader createXMLStreamReader(String string, InputStream inputStream) throws XMLStreamException {
        return this.createProxyFor(this.createXMLStreamReaderInternal(string, inputStream));
    }

    @Override
    public XMLStreamReader createXMLStreamReader(String string, Reader reader) throws XMLStreamException {
        return this.createProxyFor(this.createXMLStreamReaderInternal(string, reader));
    }

    @Override
    public XMLEventReader createXMLEventReader(Reader reader) throws XMLStreamException {
        return this.createXMLEventReader(this.createXMLStreamReaderInternal(reader));
    }

    @Override
    public XMLEventReader createXMLEventReader(String string, Reader reader) throws XMLStreamException {
        return this.createXMLEventReader(this.createXMLStreamReaderInternal(string, reader));
    }

    @Override
    public XMLEventReader createXMLEventReader(XMLStreamReader xMLStreamReader) throws XMLStreamException {
        return new XMLEventReaderImpl(this, xMLStreamReader);
    }

    @Override
    public XMLEventReader createXMLEventReader(Source source) throws XMLStreamException {
        return this.createXMLEventReader(this.createXMLStreamReader(source));
    }

    @Override
    public XMLEventReader createXMLEventReader(InputStream inputStream) throws XMLStreamException {
        return this.createXMLEventReader(this.createXMLStreamReader(inputStream));
    }

    @Override
    public XMLEventReader createXMLEventReader(InputStream inputStream, String string) throws XMLStreamException {
        return this.createXMLEventReader(this.createXMLStreamReader(inputStream, string));
    }

    @Override
    public XMLEventReader createXMLEventReader(String string, InputStream inputStream) throws XMLStreamException {
        return this.createXMLEventReader(this.createXMLStreamReader(string, inputStream));
    }

    @Override
    public XMLStreamReader createFilteredReader(XMLStreamReader xMLStreamReader, StreamFilter streamFilter) throws XMLStreamException {
        return new XMLFilteredStreamReaderImpl(xMLStreamReader, streamFilter);
    }

    @Override
    public XMLEventReader createFilteredReader(XMLEventReader xMLEventReader, EventFilter eventFilter) throws XMLStreamException {
        return new XMLFilteredEventReaderImpl(xMLEventReader, eventFilter);
    }

    @Override
    public XMLResolver getXMLResolver() {
        return this.fProperties.resolver;
    }

    @Override
    public void setXMLResolver(XMLResolver xMLResolver) {
        if (this.fProperties.resolver != xMLResolver) {
            if (this.fProperties.given) {
                this.fProperties = new Properties(this.fProperties);
            }
            this.fProperties.resolver = xMLResolver;
        }
    }

    @Override
    public XMLReporter getXMLReporter() {
        return this.fProperties.reporter;
    }

    @Override
    public void setXMLReporter(XMLReporter xMLReporter) {
        if (this.fProperties.reporter != xMLReporter) {
            if (this.fProperties.given) {
                this.fProperties = new Properties(this.fProperties);
            }
            this.fProperties.reporter = xMLReporter;
        }
    }

    @Override
    public void setProperty(String string, Object object) throws IllegalArgumentException {
        if (string == null) {
            StAXMessageProvider.throwNullPointerException(StAXMessageProvider.createMessage(null, 31));
        }
        if ("javax.xml.stream.isValidating".equals(string)) {
            if (object instanceof Boolean) {
                if (((Boolean)object).booleanValue()) {
                    StAXMessageProvider.throwIllegalArgumentException(StAXMessageProvider.createMessage(null, 4, object, "javax.xml.stream.isValidating"));
                }
            } else {
                StAXMessageProvider.throwIllegalArgumentException(StAXMessageProvider.createMessage(null, 5, object, "javax.xml.stream.isValidating", "Boolean"));
            }
        } else if ("javax.xml.stream.isNamespaceAware".equals(string)) {
            if (object instanceof Boolean) {
                boolean bl = (Boolean)object;
                if (this.fProperties.isNamespaceAware != bl) {
                    if (this.fProperties.given) {
                        this.fProperties = new Properties(this.fProperties);
                    }
                    this.fProperties.isNamespaceAware = bl;
                }
            } else {
                StAXMessageProvider.throwIllegalArgumentException(StAXMessageProvider.createMessage(null, 5, object, "javax.xml.stream.isNamespaceAware", "Boolean"));
            }
        } else if ("javax.xml.stream.isCoalescing".equals(string)) {
            if (object instanceof Boolean) {
                boolean bl = (Boolean)object;
                if (this.fProperties.isCoalescing != bl) {
                    if (this.fProperties.given) {
                        this.fProperties = new Properties(this.fProperties);
                    }
                    this.fProperties.isCoalescing = bl;
                }
            } else {
                StAXMessageProvider.throwIllegalArgumentException(StAXMessageProvider.createMessage(null, 5, object, "javax.xml.stream.isCoalescing", "Boolean"));
            }
        } else if ("javax.xml.stream.isReplacingEntityReferences".equals(string)) {
            if (object instanceof Boolean) {
                boolean bl = (Boolean)object;
                if (this.fProperties.isReplacingEntityReferences != bl) {
                    if (this.fProperties.given) {
                        this.fProperties = new Properties(this.fProperties);
                    }
                    this.fProperties.isReplacingEntityReferences = bl;
                }
            } else {
                StAXMessageProvider.throwIllegalArgumentException(StAXMessageProvider.createMessage(null, 5, object, "javax.xml.stream.isReplacingEntityReferences", "Boolean"));
            }
        } else if ("javax.xml.stream.isSupportingExternalEntities".equals(string)) {
            if (object instanceof Boolean) {
                boolean bl = (Boolean)object;
                if (this.fProperties.isSupportingExternalEntities != bl) {
                    if (this.fProperties.given) {
                        this.fProperties = new Properties(this.fProperties);
                    }
                    this.fProperties.isSupportingExternalEntities = bl;
                }
            } else {
                StAXMessageProvider.throwIllegalArgumentException(StAXMessageProvider.createMessage(null, 5, object, "javax.xml.stream.isSupportingExternalEntities", "Boolean"));
            }
        } else if ("javax.xml.stream.isSupportingLocationCoordinates".equals(string)) {
            if (object instanceof Boolean) {
                boolean bl = (Boolean)object;
                if (this.fProperties.isSupportingLocationCoordinates != bl) {
                    if (this.fProperties.given) {
                        this.fProperties = new Properties(this.fProperties);
                    }
                    this.fProperties.isSupportingLocationCoordinates = bl;
                }
            } else {
                StAXMessageProvider.throwIllegalArgumentException(StAXMessageProvider.createMessage(null, 5, object, "javax.xml.stream.isSupportingLocationCoordinates", "Boolean"));
            }
        } else if ("javax.xml.stream.supportDTD".equals(string)) {
            if (object instanceof Boolean) {
                boolean bl = (Boolean)object;
                if (this.fProperties.supportDTD != bl) {
                    if (this.fProperties.given) {
                        this.fProperties = new Properties(this.fProperties);
                    }
                    this.fProperties.supportDTD = bl;
                }
            } else {
                StAXMessageProvider.throwIllegalArgumentException(StAXMessageProvider.createMessage(null, 5, object, "javax.xml.stream.supportDTD", "Boolean"));
            }
        } else if ("javax.xml.stream.reporter".equals(string)) {
            if (object == null || object instanceof XMLReporter) {
                if (this.fProperties.reporter != object) {
                    if (this.fProperties.given) {
                        this.fProperties = new Properties(this.fProperties);
                    }
                    this.fProperties.reporter = (XMLReporter)object;
                }
            } else {
                StAXMessageProvider.throwIllegalArgumentException(StAXMessageProvider.createMessage(null, 5, object, "javax.xml.stream.reporter", "XMLReporter"));
            }
        } else if ("javax.xml.stream.resolver".equals(string)) {
            if (object == null || object instanceof XMLResolver) {
                if (this.fProperties.resolver != object) {
                    if (this.fProperties.given) {
                        this.fProperties = new Properties(this.fProperties);
                    }
                    this.fProperties.resolver = (XMLResolver)object;
                }
            } else {
                StAXMessageProvider.throwIllegalArgumentException(StAXMessageProvider.createMessage(null, 5, object, "javax.xml.stream.resolver", "XMLResolver"));
            }
        } else if ("javax.xml.stream.allocator".equals(string)) {
            if (object == null || object instanceof XMLEventAllocator) {
                if (this.fProperties.allocator != object) {
                    if (this.fProperties.given) {
                        this.fProperties = new Properties(this.fProperties);
                    }
                    this.fProperties.allocator = (XMLEventAllocator)object;
                }
            } else {
                StAXMessageProvider.throwIllegalArgumentException(StAXMessageProvider.createMessage(null, 5, object, "javax.xml.stream.allocator", "XMLEventAllocator"));
            }
        } else if ("javax.xml.stream.resolve.dtd.uris".equals(string)) {
            if (object instanceof Boolean) {
                boolean bl = (Boolean)object;
                if (this.fProperties.resolveDTDURIs != bl) {
                    if (this.fProperties.given) {
                        this.fProperties = new Properties(this.fProperties);
                    }
                    this.fProperties.resolveDTDURIs = bl;
                }
            } else {
                StAXMessageProvider.throwIllegalArgumentException(StAXMessageProvider.createMessage(null, 5, object, "javax.xml.stream.resolve.dtd.uris", "Boolean"));
            }
        } else if (StAXImplConstants.JAXP15_SUPPORT && "http://javax.xml.XMLConstants/property/accessExternalDTD".equals(string)) {
            if (object == null || object instanceof String) {
                if (this.fProperties.externalDTDPropertyValue == null || !this.fProperties.externalDTDPropertyValue.equals(object)) {
                    if (this.fProperties.given) {
                        this.fProperties = new Properties(this.fProperties);
                    }
                    this.fProperties.externalDTDPropertyValue = (String)object;
                }
            } else {
                StAXMessageProvider.throwIllegalArgumentException(StAXMessageProvider.createMessage(null, 5, object, "http://javax.xml.XMLConstants/property/accessExternalDTD", "String"));
            }
        } else if (StAXImplConstants.JAXP15_SUPPORT && "http://javax.xml.XMLConstants/property/accessExternalSchema".equals(string)) {
            if (object == null || object instanceof String) {
                if (this.fProperties.externalSchemaPropertyValue == null || !this.fProperties.externalSchemaPropertyValue.equals(object)) {
                    if (this.fProperties.given) {
                        this.fProperties = new Properties(this.fProperties);
                    }
                    this.fProperties.externalSchemaPropertyValue = (String)object;
                }
            } else {
                StAXMessageProvider.throwIllegalArgumentException(StAXMessageProvider.createMessage(null, 5, object, "http://javax.xml.XMLConstants/property/accessExternalSchema", "String"));
            }
        } else {
            StAXMessageProvider.throwIllegalArgumentException(StAXMessageProvider.createMessage(null, 3, string));
        }
    }

    @Override
    public Object getProperty(String string) throws IllegalArgumentException {
        if ("javax.xml.stream.isValidating".equals(string)) {
            return Boolean.FALSE;
        }
        if ("javax.xml.stream.isNamespaceAware".equals(string)) {
            return this.fProperties.isNamespaceAware ? Boolean.TRUE : Boolean.FALSE;
        }
        if ("javax.xml.stream.isCoalescing".equals(string)) {
            return this.fProperties.isCoalescing ? Boolean.TRUE : Boolean.FALSE;
        }
        if ("javax.xml.stream.isReplacingEntityReferences".equals(string)) {
            return this.fProperties.isReplacingEntityReferences ? Boolean.TRUE : Boolean.FALSE;
        }
        if ("javax.xml.stream.isSupportingExternalEntities".equals(string)) {
            return this.fProperties.isSupportingExternalEntities ? Boolean.TRUE : Boolean.FALSE;
        }
        if ("javax.xml.stream.isSupportingLocationCoordinates".equals(string)) {
            return this.fProperties.isSupportingLocationCoordinates ? Boolean.TRUE : Boolean.FALSE;
        }
        if ("javax.xml.stream.supportDTD".equals(string)) {
            return this.fProperties.supportDTD ? Boolean.TRUE : Boolean.FALSE;
        }
        if ("javax.xml.stream.reporter".equals(string)) {
            return this.fProperties.reporter;
        }
        if ("javax.xml.stream.resolver".equals(string)) {
            return this.fProperties.resolver;
        }
        if ("javax.xml.stream.allocator".equals(string)) {
            return this.fProperties.allocator;
        }
        if ("javax.xml.stream.resolve.dtd.uris".equals(string)) {
            return this.fProperties.resolveDTDURIs ? Boolean.TRUE : Boolean.FALSE;
        }
        if (StAXImplConstants.JAXP15_SUPPORT && "http://javax.xml.XMLConstants/property/accessExternalDTD".equals(string)) {
            return this.fProperties.externalDTDPropertyValue;
        }
        if (StAXImplConstants.JAXP15_SUPPORT && "http://javax.xml.XMLConstants/property/accessExternalSchema".equals(string)) {
            return this.fProperties.externalSchemaPropertyValue;
        }
        StAXMessageProvider.throwIllegalArgumentException(StAXMessageProvider.createMessage(null, 3, string));
        return null;
    }

    @Override
    public boolean isPropertySupported(String string) {
        if ("javax.xml.stream.isValidating".equals(string)) {
            return true;
        }
        if ("javax.xml.stream.isNamespaceAware".equals(string)) {
            return true;
        }
        if ("javax.xml.stream.isCoalescing".equals(string)) {
            return true;
        }
        if ("javax.xml.stream.isReplacingEntityReferences".equals(string)) {
            return true;
        }
        if ("javax.xml.stream.isSupportingExternalEntities".equals(string)) {
            return true;
        }
        if ("javax.xml.stream.isSupportingLocationCoordinates".equals(string)) {
            return true;
        }
        if ("javax.xml.stream.supportDTD".equals(string)) {
            return true;
        }
        if ("javax.xml.stream.reporter".equals(string)) {
            return true;
        }
        if ("javax.xml.stream.resolver".equals(string)) {
            return true;
        }
        if ("javax.xml.stream.allocator".equals(string)) {
            return true;
        }
        if (StAXImplConstants.JAXP15_SUPPORT && "http://javax.xml.XMLConstants/property/accessExternalDTD".equals(string)) {
            return true;
        }
        return StAXImplConstants.JAXP15_SUPPORT && "http://javax.xml.XMLConstants/property/accessExternalSchema".equals(string);
    }

    @Override
    public void setEventAllocator(XMLEventAllocator xMLEventAllocator) {
        if (this.fProperties.allocator != xMLEventAllocator) {
            if (this.fProperties.given) {
                this.fProperties = new Properties(this.fProperties);
            }
            this.fProperties.allocator = xMLEventAllocator;
        }
    }

    @Override
    public XMLEventAllocator getEventAllocator() {
        return this.fProperties.allocator;
    }

    private static final class ClosedXMLStreamReader
    implements XMLStreamReader {
        @Override
        public Object getProperty(String string) throws IllegalArgumentException {
            StAXMessageProvider.throwIllegalStateException(StAXMessageProvider.createMessage(null, 36));
            return null;
        }

        @Override
        public int next() throws XMLStreamException {
            StAXMessageProvider.throwIllegalStateException(StAXMessageProvider.createMessage(null, 36));
            return 0;
        }

        @Override
        public void require(int n, String string, String string2) throws XMLStreamException {
            StAXMessageProvider.throwIllegalStateException(StAXMessageProvider.createMessage(null, 36));
        }

        @Override
        public String getElementText() throws XMLStreamException {
            StAXMessageProvider.throwIllegalStateException(StAXMessageProvider.createMessage(null, 36));
            return null;
        }

        @Override
        public int nextTag() throws XMLStreamException {
            StAXMessageProvider.throwIllegalStateException(StAXMessageProvider.createMessage(null, 36));
            return 0;
        }

        @Override
        public boolean hasNext() throws XMLStreamException {
            StAXMessageProvider.throwIllegalStateException(StAXMessageProvider.createMessage(null, 36));
            return false;
        }

        @Override
        public void close() throws XMLStreamException {
        }

        @Override
        public String getNamespaceURI(String string) {
            StAXMessageProvider.throwIllegalStateException(StAXMessageProvider.createMessage(null, 36));
            return null;
        }

        @Override
        public boolean isStartElement() {
            StAXMessageProvider.throwIllegalStateException(StAXMessageProvider.createMessage(null, 36));
            return false;
        }

        @Override
        public boolean isEndElement() {
            StAXMessageProvider.throwIllegalStateException(StAXMessageProvider.createMessage(null, 36));
            return false;
        }

        @Override
        public boolean isCharacters() {
            StAXMessageProvider.throwIllegalStateException(StAXMessageProvider.createMessage(null, 36));
            return false;
        }

        @Override
        public boolean isWhiteSpace() {
            StAXMessageProvider.throwIllegalStateException(StAXMessageProvider.createMessage(null, 36));
            return false;
        }

        @Override
        public String getAttributeValue(String string, String string2) {
            StAXMessageProvider.throwIllegalStateException(StAXMessageProvider.createMessage(null, 36));
            return null;
        }

        @Override
        public int getAttributeCount() {
            StAXMessageProvider.throwIllegalStateException(StAXMessageProvider.createMessage(null, 36));
            return 0;
        }

        @Override
        public QName getAttributeName(int n) {
            StAXMessageProvider.throwIllegalStateException(StAXMessageProvider.createMessage(null, 36));
            return null;
        }

        @Override
        public String getAttributeNamespace(int n) {
            StAXMessageProvider.throwIllegalStateException(StAXMessageProvider.createMessage(null, 36));
            return null;
        }

        @Override
        public String getAttributeLocalName(int n) {
            StAXMessageProvider.throwIllegalStateException(StAXMessageProvider.createMessage(null, 36));
            return null;
        }

        @Override
        public String getAttributePrefix(int n) {
            StAXMessageProvider.throwIllegalStateException(StAXMessageProvider.createMessage(null, 36));
            return null;
        }

        @Override
        public String getAttributeType(int n) {
            StAXMessageProvider.throwIllegalStateException(StAXMessageProvider.createMessage(null, 36));
            return null;
        }

        @Override
        public String getAttributeValue(int n) {
            StAXMessageProvider.throwIllegalStateException(StAXMessageProvider.createMessage(null, 36));
            return null;
        }

        @Override
        public boolean isAttributeSpecified(int n) {
            StAXMessageProvider.throwIllegalStateException(StAXMessageProvider.createMessage(null, 36));
            return false;
        }

        @Override
        public int getNamespaceCount() {
            StAXMessageProvider.throwIllegalStateException(StAXMessageProvider.createMessage(null, 36));
            return 0;
        }

        @Override
        public String getNamespacePrefix(int n) {
            StAXMessageProvider.throwIllegalStateException(StAXMessageProvider.createMessage(null, 36));
            return null;
        }

        @Override
        public String getNamespaceURI(int n) {
            StAXMessageProvider.throwIllegalStateException(StAXMessageProvider.createMessage(null, 36));
            return null;
        }

        @Override
        public NamespaceContext getNamespaceContext() {
            StAXMessageProvider.throwIllegalStateException(StAXMessageProvider.createMessage(null, 36));
            return null;
        }

        @Override
        public int getEventType() {
            StAXMessageProvider.throwIllegalStateException(StAXMessageProvider.createMessage(null, 36));
            return 0;
        }

        @Override
        public String getText() {
            StAXMessageProvider.throwIllegalStateException(StAXMessageProvider.createMessage(null, 36));
            return null;
        }

        @Override
        public char[] getTextCharacters() {
            StAXMessageProvider.throwIllegalStateException(StAXMessageProvider.createMessage(null, 36));
            return null;
        }

        @Override
        public int getTextCharacters(int n, char[] cArray, int n2, int n3) throws XMLStreamException {
            StAXMessageProvider.throwIllegalStateException(StAXMessageProvider.createMessage(null, 36));
            return 0;
        }

        @Override
        public int getTextStart() {
            StAXMessageProvider.throwIllegalStateException(StAXMessageProvider.createMessage(null, 36));
            return 0;
        }

        @Override
        public int getTextLength() {
            StAXMessageProvider.throwIllegalStateException(StAXMessageProvider.createMessage(null, 36));
            return 0;
        }

        @Override
        public String getEncoding() {
            StAXMessageProvider.throwIllegalStateException(StAXMessageProvider.createMessage(null, 36));
            return null;
        }

        @Override
        public boolean hasText() {
            StAXMessageProvider.throwIllegalStateException(StAXMessageProvider.createMessage(null, 36));
            return false;
        }

        @Override
        public Location getLocation() {
            StAXMessageProvider.throwIllegalStateException(StAXMessageProvider.createMessage(null, 36));
            return null;
        }

        @Override
        public QName getName() {
            StAXMessageProvider.throwIllegalStateException(StAXMessageProvider.createMessage(null, 36));
            return null;
        }

        @Override
        public String getLocalName() {
            StAXMessageProvider.throwIllegalStateException(StAXMessageProvider.createMessage(null, 36));
            return null;
        }

        @Override
        public boolean hasName() {
            StAXMessageProvider.throwIllegalStateException(StAXMessageProvider.createMessage(null, 36));
            return false;
        }

        @Override
        public String getNamespaceURI() {
            StAXMessageProvider.throwIllegalStateException(StAXMessageProvider.createMessage(null, 36));
            return null;
        }

        @Override
        public String getPrefix() {
            StAXMessageProvider.throwIllegalStateException(StAXMessageProvider.createMessage(null, 36));
            return null;
        }

        @Override
        public String getVersion() {
            StAXMessageProvider.throwIllegalStateException(StAXMessageProvider.createMessage(null, 36));
            return null;
        }

        @Override
        public boolean isStandalone() {
            StAXMessageProvider.throwIllegalStateException(StAXMessageProvider.createMessage(null, 36));
            return false;
        }

        @Override
        public boolean standaloneSet() {
            StAXMessageProvider.throwIllegalStateException(StAXMessageProvider.createMessage(null, 36));
            return false;
        }

        @Override
        public String getCharacterEncodingScheme() {
            StAXMessageProvider.throwIllegalStateException(StAXMessageProvider.createMessage(null, 36));
            return null;
        }

        @Override
        public String getPITarget() {
            StAXMessageProvider.throwIllegalStateException(StAXMessageProvider.createMessage(null, 36));
            return null;
        }

        @Override
        public String getPIData() {
            StAXMessageProvider.throwIllegalStateException(StAXMessageProvider.createMessage(null, 36));
            return null;
        }
    }

    private static final class EndDocumentXMLStreamReader
    implements XMLStreamReader {
        private EndDocumentXMLStreamReader() {
        }

        @Override
        public Object getProperty(String string) throws IllegalArgumentException {
            return null;
        }

        @Override
        public int next() throws XMLStreamException {
            StAXMessageProvider.throwNoSuchElementException(StAXMessageProvider.createMessage(null, 28));
            return 0;
        }

        @Override
        public void require(int n, String string, String string2) throws XMLStreamException {
            if (n == 8) {
                if (string != null) {
                    StAXMessageProvider.throwXMLStreamException(StAXMessageProvider.createMessage(null, 12, string, ""));
                } else if (string2 != null) {
                    StAXMessageProvider.throwXMLStreamException(StAXMessageProvider.createMessage(null, 13, string2, ""));
                }
            } else {
                StAXMessageProvider.throwXMLStreamException(StAXMessageProvider.createMessage(null, 11, new Integer(n), new Integer(8)));
            }
        }

        @Override
        public String getElementText() throws XMLStreamException {
            StAXMessageProvider.throwXMLStreamException(StAXMessageProvider.createMessage(null, 14));
            return null;
        }

        @Override
        public int nextTag() throws XMLStreamException {
            StAXMessageProvider.throwNoSuchElementException(StAXMessageProvider.createMessage(null, 28));
            return 0;
        }

        @Override
        public boolean hasNext() throws XMLStreamException {
            return false;
        }

        @Override
        public void close() throws XMLStreamException {
        }

        @Override
        public String getNamespaceURI(String string) {
            if (string == null) {
                StAXMessageProvider.throwIllegalArgumentException(StAXMessageProvider.createMessage(null, 47));
                return null;
            }
            if ("xml".equals(string)) {
                return "http://www.w3.org/XML/1998/namespace";
            }
            if ("xmlns".equals(string)) {
                return "http://www.w3.org/2000/xmlns/";
            }
            return null;
        }

        @Override
        public boolean isStartElement() {
            return false;
        }

        @Override
        public boolean isEndElement() {
            return false;
        }

        @Override
        public boolean isCharacters() {
            return false;
        }

        @Override
        public boolean isWhiteSpace() {
            return false;
        }

        @Override
        public String getAttributeValue(String string, String string2) {
            StAXMessageProvider.throwIllegalStateException(StAXMessageProvider.createMessage(null, 17));
            return null;
        }

        @Override
        public int getAttributeCount() {
            StAXMessageProvider.throwIllegalStateException(StAXMessageProvider.createMessage(null, 17));
            return 0;
        }

        @Override
        public QName getAttributeName(int n) {
            StAXMessageProvider.throwIllegalStateException(StAXMessageProvider.createMessage(null, 17));
            return null;
        }

        @Override
        public String getAttributeNamespace(int n) {
            StAXMessageProvider.throwIllegalStateException(StAXMessageProvider.createMessage(null, 17));
            return null;
        }

        @Override
        public String getAttributeLocalName(int n) {
            StAXMessageProvider.throwIllegalStateException(StAXMessageProvider.createMessage(null, 17));
            return null;
        }

        @Override
        public String getAttributePrefix(int n) {
            StAXMessageProvider.throwIllegalStateException(StAXMessageProvider.createMessage(null, 17));
            return null;
        }

        @Override
        public String getAttributeType(int n) {
            StAXMessageProvider.throwIllegalStateException(StAXMessageProvider.createMessage(null, 17));
            return null;
        }

        @Override
        public String getAttributeValue(int n) {
            StAXMessageProvider.throwIllegalStateException(StAXMessageProvider.createMessage(null, 17));
            return null;
        }

        @Override
        public boolean isAttributeSpecified(int n) {
            StAXMessageProvider.throwIllegalStateException(StAXMessageProvider.createMessage(null, 17));
            return false;
        }

        @Override
        public int getNamespaceCount() {
            StAXMessageProvider.throwIllegalStateException(StAXMessageProvider.createMessage(null, 18));
            return 0;
        }

        @Override
        public String getNamespacePrefix(int n) {
            StAXMessageProvider.throwIllegalStateException(StAXMessageProvider.createMessage(null, 18));
            return null;
        }

        @Override
        public String getNamespaceURI(int n) {
            StAXMessageProvider.throwIllegalStateException(StAXMessageProvider.createMessage(null, 18));
            return null;
        }

        @Override
        public NamespaceContext getNamespaceContext() {
            return fgEmptyNSContext;
        }

        @Override
        public int getEventType() {
            return 8;
        }

        @Override
        public String getText() {
            StAXMessageProvider.throwIllegalStateException(StAXMessageProvider.createMessage(null, 19));
            return null;
        }

        @Override
        public char[] getTextCharacters() {
            StAXMessageProvider.throwIllegalStateException(StAXMessageProvider.createMessage(null, 19));
            return null;
        }

        @Override
        public int getTextCharacters(int n, char[] cArray, int n2, int n3) throws XMLStreamException {
            StAXMessageProvider.throwIllegalStateException(StAXMessageProvider.createMessage(null, 19));
            return 0;
        }

        @Override
        public int getTextStart() {
            StAXMessageProvider.throwIllegalStateException(StAXMessageProvider.createMessage(null, 19));
            return 0;
        }

        @Override
        public int getTextLength() {
            StAXMessageProvider.throwIllegalStateException(StAXMessageProvider.createMessage(null, 19));
            return 0;
        }

        @Override
        public String getEncoding() {
            StAXMessageProvider.throwIllegalStateException(StAXMessageProvider.createMessage(null, 20));
            return null;
        }

        @Override
        public boolean hasText() {
            return false;
        }

        @Override
        public Location getLocation() {
            return fgEmptyLocation;
        }

        @Override
        public QName getName() {
            StAXMessageProvider.throwIllegalStateException(StAXMessageProvider.createMessage(null, 21));
            return null;
        }

        @Override
        public String getLocalName() {
            StAXMessageProvider.throwIllegalStateException(StAXMessageProvider.createMessage(null, 22));
            return null;
        }

        @Override
        public boolean hasName() {
            return false;
        }

        @Override
        public String getNamespaceURI() {
            StAXMessageProvider.throwIllegalStateException(StAXMessageProvider.createMessage(null, 21));
            return null;
        }

        @Override
        public String getPrefix() {
            StAXMessageProvider.throwIllegalStateException(StAXMessageProvider.createMessage(null, 21));
            return null;
        }

        @Override
        public String getVersion() {
            StAXMessageProvider.throwIllegalStateException(StAXMessageProvider.createMessage(null, 20));
            return null;
        }

        @Override
        public boolean isStandalone() {
            StAXMessageProvider.throwIllegalStateException(StAXMessageProvider.createMessage(null, 20));
            return false;
        }

        @Override
        public boolean standaloneSet() {
            StAXMessageProvider.throwIllegalStateException(StAXMessageProvider.createMessage(null, 20));
            return false;
        }

        @Override
        public String getCharacterEncodingScheme() {
            StAXMessageProvider.throwIllegalStateException(StAXMessageProvider.createMessage(null, 20));
            return null;
        }

        @Override
        public String getPITarget() {
            StAXMessageProvider.throwIllegalStateException(StAXMessageProvider.createMessage(null, 23));
            return null;
        }

        @Override
        public String getPIData() {
            StAXMessageProvider.throwIllegalStateException(StAXMessageProvider.createMessage(null, 23));
            return null;
        }
    }

    public static final class Properties {
        public boolean given = false;
        public boolean isNamespaceAware;
        public boolean isCoalescing;
        public boolean isReplacingEntityReferences;
        public boolean isSupportingExternalEntities;
        public boolean supportDTD;
        public boolean resolveDTDURIs;
        public boolean isSupportingLocationCoordinates;
        public XMLReporter reporter;
        public XMLResolver resolver;
        public XMLEventAllocator allocator;
        public String externalDTDPropertyValue;
        public String externalSchemaPropertyValue;

        public Properties() {
            this.isNamespaceAware = true;
            this.isReplacingEntityReferences = true;
            this.isSupportingExternalEntities = true;
            this.supportDTD = true;
            this.resolveDTDURIs = true;
            this.externalDTDPropertyValue = null;
            this.externalSchemaPropertyValue = null;
        }

        public Properties(Properties properties) {
            this.isNamespaceAware = properties.isNamespaceAware;
            this.isCoalescing = properties.isCoalescing;
            this.isReplacingEntityReferences = properties.isReplacingEntityReferences;
            this.isSupportingExternalEntities = properties.isSupportingExternalEntities;
            this.supportDTD = properties.supportDTD;
            this.resolveDTDURIs = properties.resolveDTDURIs;
            this.isSupportingLocationCoordinates = properties.isSupportingLocationCoordinates;
            this.reporter = properties.reporter;
            this.resolver = properties.resolver;
            this.allocator = properties.allocator;
            this.externalDTDPropertyValue = properties.externalDTDPropertyValue;
            this.externalSchemaPropertyValue = properties.externalSchemaPropertyValue;
        }
    }

    protected static class XMLStreamReaderProxy
    implements XMLStreamReader {
        protected XMLStreamReader fStreamReader;

        public XMLStreamReaderProxy(XMLStreamReader xMLStreamReader) {
            this.fStreamReader = xMLStreamReader;
        }

        public void insertFilter(XMLStreamReader xMLStreamReader) {
            this.fStreamReader = xMLStreamReader;
        }

        @Override
        public Object getProperty(String string) throws IllegalArgumentException {
            return this.fStreamReader.getProperty(string);
        }

        @Override
        public int next() throws XMLStreamException {
            int n = this.fStreamReader.next();
            if (n == 8) {
                this.fStreamReader.close();
                this.fStreamReader = fgEndDocumentXMLStreamReader;
            }
            return n;
        }

        @Override
        public void require(int n, String string, String string2) throws XMLStreamException {
            this.fStreamReader.require(n, string, string2);
        }

        @Override
        public String getElementText() throws XMLStreamException {
            return this.fStreamReader.getElementText();
        }

        @Override
        public int nextTag() throws XMLStreamException {
            return this.fStreamReader.nextTag();
        }

        @Override
        public boolean hasNext() throws XMLStreamException {
            return this.fStreamReader.hasNext();
        }

        @Override
        public void close() throws XMLStreamException {
            if (this.fStreamReader != fgClosedStreamReader) {
                this.fStreamReader.close();
                this.fStreamReader = fgClosedStreamReader;
            }
        }

        @Override
        public String getNamespaceURI(String string) {
            return this.fStreamReader.getNamespaceURI(string);
        }

        @Override
        public boolean isStartElement() {
            return this.fStreamReader.isStartElement();
        }

        @Override
        public boolean isEndElement() {
            return this.fStreamReader.isEndElement();
        }

        @Override
        public boolean isCharacters() {
            return this.fStreamReader.isCharacters();
        }

        @Override
        public boolean isWhiteSpace() {
            return this.fStreamReader.isWhiteSpace();
        }

        @Override
        public String getAttributeValue(String string, String string2) {
            return this.fStreamReader.getAttributeValue(string, string2);
        }

        @Override
        public int getAttributeCount() {
            return this.fStreamReader.getAttributeCount();
        }

        @Override
        public QName getAttributeName(int n) {
            return this.fStreamReader.getAttributeName(n);
        }

        @Override
        public String getAttributeNamespace(int n) {
            return this.fStreamReader.getAttributeNamespace(n);
        }

        @Override
        public String getAttributeLocalName(int n) {
            return this.fStreamReader.getAttributeLocalName(n);
        }

        @Override
        public String getAttributePrefix(int n) {
            return this.fStreamReader.getAttributePrefix(n);
        }

        @Override
        public String getAttributeType(int n) {
            return this.fStreamReader.getAttributeType(n);
        }

        @Override
        public String getAttributeValue(int n) {
            return this.fStreamReader.getAttributeValue(n);
        }

        @Override
        public boolean isAttributeSpecified(int n) {
            return this.fStreamReader.isAttributeSpecified(n);
        }

        @Override
        public int getNamespaceCount() {
            return this.fStreamReader.getNamespaceCount();
        }

        @Override
        public String getNamespacePrefix(int n) {
            return this.fStreamReader.getNamespacePrefix(n);
        }

        @Override
        public String getNamespaceURI(int n) {
            return this.fStreamReader.getNamespaceURI(n);
        }

        @Override
        public NamespaceContext getNamespaceContext() {
            return this.fStreamReader.getNamespaceContext();
        }

        @Override
        public int getEventType() {
            return this.fStreamReader.getEventType();
        }

        @Override
        public String getText() {
            return this.fStreamReader.getText();
        }

        @Override
        public char[] getTextCharacters() {
            return this.fStreamReader.getTextCharacters();
        }

        @Override
        public int getTextCharacters(int n, char[] cArray, int n2, int n3) throws XMLStreamException {
            return this.fStreamReader.getTextCharacters(n, cArray, n2, n3);
        }

        @Override
        public int getTextStart() {
            return this.fStreamReader.getTextStart();
        }

        @Override
        public int getTextLength() {
            return this.fStreamReader.getTextLength();
        }

        @Override
        public String getEncoding() {
            return this.fStreamReader.getEncoding();
        }

        @Override
        public boolean hasText() {
            return this.fStreamReader.hasText();
        }

        @Override
        public Location getLocation() {
            return this.fStreamReader.getLocation();
        }

        @Override
        public QName getName() {
            return this.fStreamReader.getName();
        }

        @Override
        public String getLocalName() {
            return this.fStreamReader.getLocalName();
        }

        @Override
        public boolean hasName() {
            return this.fStreamReader.hasName();
        }

        @Override
        public String getNamespaceURI() {
            return this.fStreamReader.getNamespaceURI();
        }

        @Override
        public String getPrefix() {
            return this.fStreamReader.getPrefix();
        }

        @Override
        public String getVersion() {
            return this.fStreamReader.getVersion();
        }

        @Override
        public boolean isStandalone() {
            return this.fStreamReader.isStandalone();
        }

        @Override
        public boolean standaloneSet() {
            return this.fStreamReader.standaloneSet();
        }

        @Override
        public String getCharacterEncodingScheme() {
            return this.fStreamReader.getCharacterEncodingScheme();
        }

        @Override
        public String getPITarget() {
            return this.fStreamReader.getPITarget();
        }

        @Override
        public String getPIData() {
            return this.fStreamReader.getPIData();
        }

        protected void finalize() throws Throwable {
            if (this.fStreamReader instanceof SAXStreamReaderImpl) {
                ((SAXStreamReaderImpl)this.fStreamReader).endParsing();
            }
            super.finalize();
        }
    }

    public static class XMLStreamReaderTracer
    extends XMLStreamReaderProxy {
        StAXLogger fLogger = new StAXLogger();

        public XMLStreamReaderTracer(XMLStreamReader xMLStreamReader) {
            super(xMLStreamReader);
        }

        public void writeStAXProfile(String string) {
            this.fLogger.writeStAXProfile(string);
        }

        public void writeReadableProfile(String string) {
            this.fLogger.writeReadableProfile(string);
        }

        @Override
        public Object getProperty(String string) throws IllegalArgumentException {
            this.fLogger.log(0, string);
            Object object = super.getProperty(string);
            this.fLogger.logReturn(object);
            return object;
        }

        @Override
        public int next() throws XMLStreamException {
            int n;
            this.fLogger.log(1);
            try {
                n = super.next();
            }
            catch (XMLStreamException xMLStreamException) {
                this.fLogger.logException(xMLStreamException);
                throw xMLStreamException;
            }
            catch (RuntimeException runtimeException) {
                this.fLogger.logException(runtimeException);
                throw runtimeException;
            }
            this.fLogger.logReturn(n);
            return n;
        }

        @Override
        public void require(int n, String string, String string2) throws XMLStreamException {
            this.fLogger.log(2, new Object[]{new Integer(n), string, string2});
            super.require(n, string, string2);
            this.fLogger.logReturn();
        }

        @Override
        public String getElementText() throws XMLStreamException {
            this.fLogger.log(3);
            String string = super.getElementText();
            this.fLogger.logReturn(string);
            return string;
        }

        @Override
        public int nextTag() throws XMLStreamException {
            this.fLogger.log(4);
            int n = super.nextTag();
            this.fLogger.logReturn(n);
            return n;
        }

        @Override
        public boolean hasNext() throws XMLStreamException {
            this.fLogger.log(5);
            boolean bl = super.hasNext();
            this.fLogger.logReturn(bl);
            return bl;
        }

        @Override
        public void close() throws XMLStreamException {
            this.fLogger.log(6);
            this.fLogger.logReturn();
            super.close();
        }

        @Override
        public String getNamespaceURI(String string) {
            this.fLogger.log(7, string);
            String string2 = super.getNamespaceURI(string);
            this.fLogger.logReturn(string2);
            return string2;
        }

        @Override
        public boolean isStartElement() {
            this.fLogger.log(8);
            boolean bl = super.isStartElement();
            this.fLogger.logReturn(bl);
            return bl;
        }

        @Override
        public boolean isEndElement() {
            this.fLogger.log(9);
            boolean bl = super.isEndElement();
            this.fLogger.logReturn(bl);
            return bl;
        }

        @Override
        public boolean isCharacters() {
            this.fLogger.log(10);
            boolean bl = super.isCharacters();
            this.fLogger.logReturn(bl);
            return bl;
        }

        @Override
        public boolean isWhiteSpace() {
            this.fLogger.log(11);
            boolean bl = super.isWhiteSpace();
            this.fLogger.logReturn(bl);
            return bl;
        }

        @Override
        public String getAttributeValue(String string, String string2) {
            this.fLogger.log(12, string, string2);
            String string3 = super.getAttributeValue(string, string2);
            this.fLogger.logReturn(string3);
            return string3;
        }

        @Override
        public int getAttributeCount() {
            this.fLogger.log(13);
            int n = super.getAttributeCount();
            this.fLogger.logReturn(n);
            return n;
        }

        @Override
        public QName getAttributeName(int n) {
            this.fLogger.log(14, n);
            QName qName = super.getAttributeName(n);
            this.fLogger.logReturn(qName);
            return qName;
        }

        @Override
        public String getAttributeNamespace(int n) {
            this.fLogger.log(15, n);
            String string = super.getAttributeNamespace(n);
            this.fLogger.logReturn(string);
            return string;
        }

        @Override
        public String getAttributeLocalName(int n) {
            this.fLogger.log(16, n);
            String string = super.getAttributeLocalName(n);
            this.fLogger.logReturn(string);
            return string;
        }

        @Override
        public String getAttributePrefix(int n) {
            this.fLogger.log(17, n);
            String string = super.getAttributePrefix(n);
            this.fLogger.logReturn(string);
            return string;
        }

        @Override
        public String getAttributeType(int n) {
            this.fLogger.log(18, n);
            String string = super.getAttributeType(n);
            this.fLogger.logReturn(string);
            return string;
        }

        @Override
        public String getAttributeValue(int n) {
            this.fLogger.log(19, n);
            String string = super.getAttributeValue(n);
            this.fLogger.logReturn(string);
            return string;
        }

        @Override
        public boolean isAttributeSpecified(int n) {
            this.fLogger.log(20, n);
            boolean bl = super.isAttributeSpecified(n);
            this.fLogger.logReturn(bl);
            return bl;
        }

        @Override
        public int getNamespaceCount() {
            this.fLogger.log(21);
            int n = super.getNamespaceCount();
            this.fLogger.logReturn(n);
            return n;
        }

        @Override
        public String getNamespacePrefix(int n) {
            this.fLogger.log(22, n);
            String string = super.getNamespacePrefix(n);
            this.fLogger.logReturn(string);
            return string;
        }

        @Override
        public String getNamespaceURI(int n) {
            this.fLogger.log(23, n);
            String string = super.getNamespaceURI(n);
            this.fLogger.logReturn(string);
            return string;
        }

        @Override
        public NamespaceContext getNamespaceContext() {
            this.fLogger.log(25);
            NamespaceContext namespaceContext = super.getNamespaceContext();
            this.fLogger.logReturn(namespaceContext);
            return namespaceContext;
        }

        @Override
        public int getEventType() {
            int n;
            this.fLogger.log(24);
            try {
                n = super.getEventType();
            }
            catch (RuntimeException runtimeException) {
                this.fLogger.logException(runtimeException);
                throw runtimeException;
            }
            this.fLogger.logReturn(n);
            return n;
        }

        @Override
        public String getText() {
            this.fLogger.log(26);
            String string = super.getText();
            this.fLogger.logReturn(string);
            return string;
        }

        @Override
        public char[] getTextCharacters() {
            this.fLogger.log(27);
            char[] cArray = super.getTextCharacters();
            int n = super.getTextStart();
            int n2 = super.getTextLength();
            this.fLogger.logReturn(new String(cArray, n, n2));
            return cArray;
        }

        @Override
        public int getTextCharacters(int n, char[] cArray, int n2, int n3) throws XMLStreamException {
            this.fLogger.log(28, new Object[]{new Integer(n), "[charArray]", new Integer(n2), new Integer(n3)});
            int n4 = super.getTextCharacters(n, cArray, n2, n3);
            this.fLogger.logReturn(n4);
            return n4;
        }

        @Override
        public int getTextStart() {
            this.fLogger.log(29);
            int n = super.getTextStart();
            this.fLogger.logReturn(n);
            return n;
        }

        @Override
        public int getTextLength() {
            this.fLogger.log(30);
            int n = super.getTextLength();
            this.fLogger.logReturn(n);
            return n;
        }

        @Override
        public String getEncoding() {
            this.fLogger.log(31);
            String string = super.getEncoding();
            this.fLogger.logReturn(string);
            return string;
        }

        @Override
        public boolean hasText() {
            this.fLogger.log(32);
            boolean bl = super.hasText();
            this.fLogger.logReturn(bl);
            return bl;
        }

        @Override
        public Location getLocation() {
            this.fLogger.log(33);
            Location location = super.getLocation();
            this.fLogger.logReturn(location);
            return location;
        }

        @Override
        public QName getName() {
            this.fLogger.log(34);
            QName qName = super.getName();
            this.fLogger.logReturn(qName);
            return qName;
        }

        @Override
        public String getLocalName() {
            this.fLogger.log(35);
            String string = super.getLocalName();
            this.fLogger.logReturn(string);
            return string;
        }

        @Override
        public boolean hasName() {
            this.fLogger.log(36);
            boolean bl = super.hasName();
            this.fLogger.logReturn(bl);
            return bl;
        }

        @Override
        public String getNamespaceURI() {
            this.fLogger.log(37);
            String string = super.getNamespaceURI();
            this.fLogger.logReturn(string);
            return string;
        }

        @Override
        public String getPrefix() {
            this.fLogger.log(38);
            String string = super.getPrefix();
            this.fLogger.logReturn(string);
            return string;
        }

        @Override
        public String getVersion() {
            this.fLogger.log(39);
            String string = super.getVersion();
            this.fLogger.logReturn(string);
            return string;
        }

        @Override
        public boolean isStandalone() {
            this.fLogger.log(40);
            boolean bl = super.isStandalone();
            this.fLogger.logReturn(bl);
            return bl;
        }

        @Override
        public boolean standaloneSet() {
            this.fLogger.log(41);
            boolean bl = super.standaloneSet();
            this.fLogger.logReturn(bl);
            return bl;
        }

        @Override
        public String getCharacterEncodingScheme() {
            this.fLogger.log(42);
            String string = super.getCharacterEncodingScheme();
            this.fLogger.logReturn(string);
            return string;
        }

        @Override
        public String getPITarget() {
            this.fLogger.log(43);
            String string = super.getPITarget();
            this.fLogger.logReturn(string);
            return string;
        }

        @Override
        public String getPIData() {
            this.fLogger.log(44);
            String string = super.getPIData();
            this.fLogger.logReturn(string);
            return string;
        }
    }
}

