/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.agent.nativeAdminFixup;

import com.ibm.cic.agent.core.commonNativeInstallAdapter.PlatformOperationsProvider;
import com.ibm.cic.common.core.preferences.CicCommonSettings;
import com.ibm.cic.common.core.utils.NativeUtils;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class NativeAdminFixup {
    private static final String PLUGIN_ID = "com.ibm.cic.agent.nativeAdminFixup";
    public static final String INI_EXT = ".ini";
    public static final String ACCESS_RIGHTS = "-accessRights";
    public static final String ACCESS_RIGHTS_ADMIN = "admin";
    public static final String CMD_TOOL_ID = "-toolId";
    public static final String CMD_LAUNCHER_LIBRARY = "--launcher.library";
    public static final String ACCESS_RIGHTS_NON_ADMIN = "nonAdmin";
    public static final String ACCESS_RIGHTS_GROUP = "group";
    public static final String RENAME_NON_ADMIN_UNINSTALL = "-renameNonAdminUninstall";
    public static final String CLEAN = "-clean";
    private String accessRightsParam = "admin";
    private boolean isAdmin = true;
    private String launcherFolderName;

    public static void main(String[] args) {
        NativeAdminFixup o = new NativeAdminFixup();
        try {
            o.run(args);
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    public void run(String[] args) throws CoreException {
        this.init();
        if (args.length > 0) {
            this.launcherFolderName = args[0];
            int i = 1;
            while (i < args.length) {
                if (RENAME_NON_ADMIN_UNINSTALL.equals(args[i])) {
                    if (++i < args.length && !this.isAdmin) {
                        this.doNonAdminRenames(new File(args[i]));
                    }
                } else {
                    File iniFile = new File(args[i]);
                    String fileName = iniFile.getName();
                    if (fileName.equals("IBMIM.ini")) {
                        this.processIBMIMini(iniFile);
                    } else if (fileName.equals("ibmim-web.ini")) {
                        this.processToolsFile(iniFile, "ibmim");
                    } else if (fileName.equals("silent-install.ini")) {
                        this.processSilentInstallini(iniFile);
                    } else if (fileName.equals("imutilsc.ini")) {
                        this.processToolsFile(iniFile, "imutilsc");
                    } else if (fileName.equals("imcl.ini")) {
                        this.processToolsFile(iniFile, "imcl");
                    } else {
                        this.updateAdminSwitch(iniFile);
                    }
                }
                ++i;
            }
        }
    }

    private void doNonAdminRenames(File dir) {
        if (dir.isDirectory()) {
            File uninstallcExe;
            File uninstallExe = new File(dir, "uninstall.exe");
            if (uninstallExe.exists()) {
                File userinstExe = new File(dir, "userinst.exe");
                if (userinstExe.exists()) {
                    userinstExe.delete();
                }
                uninstallExe.renameTo(userinstExe);
                File uninstallIni = new File(dir, "uninstall.ini");
                if (uninstallIni.exists()) {
                    File userinstIni = new File(dir, "userinst.ini");
                    if (userinstIni.exists()) {
                        userinstIni.delete();
                    }
                    uninstallIni.renameTo(userinstIni);
                }
            }
            if ((uninstallcExe = new File(dir, "uninstallc.exe")).exists()) {
                File userinstcExe = new File(dir, "userinstc.exe");
                if (userinstcExe.exists()) {
                    userinstcExe.delete();
                }
                uninstallcExe.renameTo(userinstcExe);
                File uninstallcIni = new File(dir, "uninstallc.ini");
                if (uninstallcIni.exists()) {
                    File userinstcIni = new File(dir, "userinstc.ini");
                    if (userinstcIni.exists()) {
                        userinstcIni.delete();
                    }
                    uninstallcIni.renameTo(userinstcIni);
                }
            }
        }
    }

    private void updateAdminSwitch(File iniFile) throws CoreException {
        String path = iniFile.getAbsolutePath();
        File tmpFile = this.createAndOpenTmpFile(iniFile);
        File destination = new File(path);
        BufferedReader input = null;
        BufferedWriter output = null;
        try {
            try {
                input = new BufferedReader(new FileReader(tmpFile));
                output = new BufferedWriter(new FileWriter(destination));
                String[] outputCommands = new String[]{ACCESS_RIGHTS, this.accessRightsParam};
                this.writeOutputCommands(outputCommands, output);
                this.writeToOutputsIgnoringCommands(input, outputCommands, output);
            }
            catch (IOException e) {
                this.error("updateAdminSwitch(): can't update '" + iniFile.getAbsolutePath() + "' file. Error: " + e.getMessage());
                try {
                    if (input != null) {
                        input.close();
                    }
                    if (output != null) {
                        output.close();
                    }
                    tmpFile.delete();
                }
                catch (IOException e2) {
                    e2.printStackTrace();
                }
            }
        }
        finally {
            try {
                if (input != null) {
                    input.close();
                }
                if (output != null) {
                    output.close();
                }
                tmpFile.delete();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private File createAndOpenTmpFile(File iniFile) {
        String path = iniFile.getAbsolutePath();
        String pathTmp = String.valueOf(path.substring(0, path.length() - INI_EXT.length())) + "1" + INI_EXT;
        File tmpFile = new File(pathTmp);
        iniFile.renameTo(tmpFile);
        return tmpFile;
    }

    private void writeOutputCommands(String[] outputCommands, BufferedWriter output) throws IOException {
        String[] stringArray = outputCommands;
        int n = outputCommands.length;
        int n2 = 0;
        while (n2 < n) {
            String outputCommand = stringArray[n2];
            output.write(outputCommand);
            output.newLine();
            ++n2;
        }
    }

    private void processIBMIMini(File iniFile) throws CoreException {
        String path = iniFile.getAbsolutePath();
        BufferedReader input = null;
        BufferedWriter output = null;
        File tmpFile = this.createAndOpenTmpFile(iniFile);
        try {
            try {
                File destination = new File(path);
                input = new BufferedReader(new FileReader(tmpFile));
                output = new BufferedWriter(new FileWriter(destination));
                String[] outputCommands = new String[]{CMD_TOOL_ID, "ibmim", ACCESS_RIGHTS, this.accessRightsParam};
                this.writeOutputCommands(outputCommands, output);
                this.writeToOutputsIgnoringCommands(input, outputCommands, output);
            }
            catch (IOException e) {
                this.error("processIBMIMini(): can't update '" + iniFile.getAbsolutePath() + "' file. Error: " + e.getMessage());
                try {
                    if (input != null) {
                        input.close();
                    }
                    if (output != null) {
                        output.close();
                    }
                    tmpFile.delete();
                }
                catch (IOException e2) {
                    e2.printStackTrace();
                }
            }
        }
        finally {
            try {
                if (input != null) {
                    input.close();
                }
                if (output != null) {
                    output.close();
                }
                tmpFile.delete();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private void processToolsFile(File iniFile, String toolId) throws CoreException {
        String path = iniFile.getAbsolutePath();
        BufferedReader input = null;
        BufferedWriter output = null;
        File tmpFile = this.createAndOpenTmpFile(iniFile);
        try {
            try {
                File destination = new File(path);
                input = new BufferedReader(new FileReader(tmpFile));
                output = new BufferedWriter(new FileWriter(destination));
                String[] outputCommands = new String[]{CMD_TOOL_ID, toolId, ACCESS_RIGHTS, this.accessRightsParam, CMD_LAUNCHER_LIBRARY, this.launcherFolderName};
                this.writeOutputCommands(outputCommands, output);
                this.writeToOutputsIgnoringCommands(input, outputCommands, output);
            }
            catch (IOException e) {
                this.error("processToolsFile(): can't update '" + iniFile.getAbsolutePath() + "' file. Error: " + e.getMessage());
                try {
                    if (input != null) {
                        input.close();
                    }
                    if (output != null) {
                        output.close();
                    }
                    tmpFile.delete();
                }
                catch (IOException e2) {
                    e2.printStackTrace();
                }
            }
        }
        finally {
            try {
                if (input != null) {
                    input.close();
                }
                if (output != null) {
                    output.close();
                }
                tmpFile.delete();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private void writeToOutputsIgnoringCommands(BufferedReader input, String[] ignore1, BufferedWriter out1) throws IOException {
        this.writeToOutputsIgnoringCommands(input, ignore1, null, out1, null);
    }

    private void writeToOutputsIgnoringCommands(BufferedReader input, String[] ignore1, String[] ignore2, BufferedWriter out1, BufferedWriter out2) throws IOException {
        String ln = null;
        int skip_line = 0;
        while ((ln = input.readLine()) != null) {
            if (skip_line > 0) {
                --skip_line;
            } else {
                int i;
                ln = ln.trim();
                boolean found = false;
                if (ignore1 != null) {
                    i = 0;
                    while (i < ignore1.length && !found) {
                        if (ln.equalsIgnoreCase(ignore1[i])) {
                            found = true;
                            if (ln.equalsIgnoreCase(CMD_LAUNCHER_LIBRARY) || ln.equalsIgnoreCase(CMD_TOOL_ID)) {
                                skip_line = 1;
                            }
                        }
                        ++i;
                    }
                }
                if (!found && ignore2 != null) {
                    i = 0;
                    while (i < ignore2.length && !found) {
                        if (ln.equalsIgnoreCase(ignore2[i])) {
                            found = true;
                            if (ln.equalsIgnoreCase(CMD_LAUNCHER_LIBRARY) || ln.equalsIgnoreCase(CMD_TOOL_ID)) {
                                skip_line = 1;
                            }
                        }
                        ++i;
                    }
                }
                if (!found && ln.equalsIgnoreCase(CLEAN)) {
                    found = true;
                }
                if (!found) {
                    if (out1 != null) {
                        out1.write(ln);
                        out1.newLine();
                    }
                    if (out2 != null) {
                        out2.write(ln);
                        out2.newLine();
                    }
                }
            }
            if (out1 != null) {
                out1.flush();
            }
            if (out2 == null) continue;
            out2.flush();
        }
    }

    private void processSilentInstallini(File iniFile) throws CoreException {
        String path = iniFile.getAbsolutePath();
        BufferedReader input = null;
        BufferedWriter output1 = null;
        File tmpFile = this.createAndOpenTmpFile(iniFile);
        try {
            try {
                File destination = new File(path);
                input = new BufferedReader(new FileReader(tmpFile));
                output1 = new BufferedWriter(new FileWriter(destination));
                String[] outputCommands1 = new String[]{CMD_TOOL_ID, "silentinstall", ACCESS_RIGHTS, this.accessRightsParam};
                this.writeOutputCommands(outputCommands1, output1);
                this.writeToOutputsIgnoringCommands(input, outputCommands1, null, output1, null);
            }
            catch (IOException e) {
                this.error("processSilentInstallini(): can't update '" + iniFile.getAbsolutePath() + "' file. Error: " + e.getMessage());
                try {
                    if (input != null) {
                        input.close();
                    }
                    if (output1 != null) {
                        output1.close();
                    }
                    tmpFile.delete();
                }
                catch (IOException e2) {
                    e2.printStackTrace();
                }
            }
        }
        finally {
            try {
                if (input != null) {
                    input.close();
                }
                if (output1 != null) {
                    output1.close();
                }
                tmpFile.delete();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private void init() {
        this.isAdmin = this.isAdministrator();
        this.accessRightsParam = this.isAdmin ? ACCESS_RIGHTS_ADMIN : (this.isInGroupMode() ? ACCESS_RIGHTS_GROUP : ACCESS_RIGHTS_NON_ADMIN);
    }

    private boolean isInGroupMode() {
        try {
            return CicCommonSettings.getAccessRightsMode().isGroupMode();
        }
        catch (NoSuchMethodError e) {
            return false;
        }
    }

    private boolean isAdministrator() {
        try {
            return PlatformOperationsProvider.isAdministrator();
        }
        catch (NoSuchMethodError e) {
            return NativeUtils.isAdministrator();
        }
    }

    private void error(String msg) throws CoreException {
        Status status = new Status(4, PLUGIN_ID, msg);
        throw new CoreException((IStatus)status);
    }
}

