/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.nativeAdapterData.linux.internal;

import com.ibm.cic.common.commonNativeAdapterData.ICommonNativeAdapterDataParser;
import com.ibm.cic.common.commonNativeAdapterData.ICommonTopAdapterData;
import com.ibm.cic.common.core.model.IInstallableUnit;
import com.ibm.cic.common.core.model.adapterdata.IAdapterData;
import com.ibm.cic.common.core.model.adapterdata.IArtifact;
import com.ibm.cic.common.core.model.adapterdata.IErrorReporter;
import com.ibm.cic.common.nativeAdapterData.linux.DesktopIconLinuxNativeData;
import com.ibm.cic.common.nativeAdapterData.linux.NativeLinuxAdapterData;
import com.ibm.cic.common.nativeAdapterData.linux.internal.IXMLConstants;
import java.net.URL;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.osgi.framework.Bundle;
import org.xml.sax.Attributes;

public class NativeLinuxAdapterDataParser
extends ICommonNativeAdapterDataParser
implements IXMLConstants {
    private NativeLinuxAdapterData nativeData;
    private IErrorReporter reporter;
    private ICommonNativeAdapterDataParser.ElemStack elemStack;

    public void initialize(IInstallableUnit iu, IErrorReporter errorReporter) {
        this.nativeData = new NativeLinuxAdapterData();
        this.reporter = errorReporter;
        this.elemStack = new ICommonNativeAdapterDataParser.ElemStack();
        super.initialize(iu, (ICommonTopAdapterData)this.nativeData, this.elemStack, errorReporter);
    }

    public IArtifact startArtifact(String uri, String name, String qName, Attributes attributes, String key) {
        this.elemStack.push((Object)new ICommonNativeAdapterDataParser.ElemStackEntry(name));
        String type = attributes.getValue("", "type");
        if (type == null || type.equals("zip")) {
            return this.handleZipAttributes(key, attributes);
        }
        this.reporter.invalidAttributeValue(name, "type", type);
        return null;
    }

    public void endArtifact() {
        this.elemStack.pop();
    }

    public void startElement(String uri, String name, String qName, Attributes attributes) {
        this.elemStack.push((Object)new ICommonNativeAdapterDataParser.ElemStackEntry(name));
        boolean processed = this.processCommonElement(name, attributes);
        if (!processed) {
            if (name.equals("desktopIcon_linux")) {
                this.handleDesktopIconLinuxAttributes(attributes);
            } else {
                this.reporter.unexpectedElement(name, attributes);
            }
        }
    }

    public void endElement(String uri, String name, String qName) {
        this.elemStack.pop();
    }

    public void characters(String chars) {
        String name = this.elemStack.top().name;
        boolean processed = this.processCommonCharacters(name, chars);
        if (!processed) {
            this.reporter.unexpectedCharacterData(chars);
        }
    }

    public IAdapterData getAdapterData() {
        return this.nativeData;
    }

    public URL getSchema() {
        Bundle bundle = Platform.getBundle((String)"com.ibm.cic.common.nativeAdapterData.linux");
        Path path = new Path("schema/nativeAdapterData.xsd");
        return FileLocator.find((Bundle)bundle, (IPath)path, null);
    }

    private void handleDesktopIconLinuxAttributes(Attributes attributes) {
        String command;
        String workingDirectory;
        String name;
        boolean hasErrors = false;
        if (!this.isTopLevelElement()) {
            this.reporter.unexpectedElement("desktopIcon_linux", attributes);
            hasErrors = true;
        }
        if (this.hasUnexpectedAttributes(attributes, "desktopIcon_linux", new String[]{"name", "workingDirectory", "command", "arguments", "iconPath", "context", "categories", "description", "desktopFile"})) {
            hasErrors = true;
        }
        if ((name = attributes.getValue("name")) == null) {
            this.reporter.checkRequiredAttribute("desktopIcon_linux", "name", (Object)name);
            hasErrors = true;
        }
        if ((workingDirectory = attributes.getValue("workingDirectory")) == null) {
            this.reporter.checkRequiredAttribute("desktopIcon_linux", "workingDirectory", (Object)workingDirectory);
            hasErrors = true;
        }
        if ((command = attributes.getValue("command")) == null) {
            this.reporter.checkRequiredAttribute("desktopIcon_linux", "command", (Object)command);
            hasErrors = true;
        }
        String arguments = attributes.getValue("arguments");
        String iconPath = attributes.getValue("iconPath");
        String context = attributes.getValue("context");
        if (context == null) {
            this.reporter.checkRequiredAttribute("desktopIcon_linux", "context", (Object)context);
            hasErrors = true;
        } else if (!context.equals("ALL_USER") && !context.equals("CURR_USER")) {
            this.reporter.invalidAttributeValue("desktopIcon_linux", "context", context);
            hasErrors = true;
        }
        String categories = attributes.getValue("categories");
        if (categories == null) {
            this.reporter.checkRequiredAttribute("desktopIcon_linux", "categories", (Object)categories);
            hasErrors = true;
        }
        String description = attributes.getValue("description");
        String desktopFile = attributes.getValue("desktopFile");
        if (!hasErrors) {
            DesktopIconLinuxNativeData data = new DesktopIconLinuxNativeData(name, workingDirectory, command, arguments, iconPath, context, categories, description, desktopFile);
            this.nativeData.addData(data);
        }
    }
}

