/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sync.core.internal;

import com.ibm.cic.common.core.model.IFeature;
import com.ibm.cic.common.core.model.IOffering;
import com.ibm.ws.sync.core.internal.OfferingDefinitionLoader;
import com.ibm.ws.sync.core.internal.SyncUtil;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;
import org.eclipse.core.runtime.IConfigurationElement;

public class PakToFeatureMap {
    private IOffering offering = null;
    private PakToFeatureMapEntry[] pakToFeatureMapEntries = null;

    public PakToFeatureMap(IOffering offering) {
        this.offering = offering;
    }

    public boolean loadPakToFeatureMapping() {
        if (this.offering == null) {
            return Boolean.FALSE;
        }
        IConfigurationElement[] featureElements = OfferingDefinitionLoader.loadFeatureElements(this.offering.getIdentity().getId());
        this.pakToFeatureMapEntries = featureElements.length > 0 ? this.getPakToFeatureMapEntries(featureElements) : new PakToFeatureMapEntry[0];
        return Boolean.TRUE;
    }

    private PakToFeatureMapEntry[] getPakToFeatureMapEntries(IConfigurationElement[] featureElements) {
        TreeSet<PakToFeatureMapEntry> pakToFeatureMapList = new TreeSet<PakToFeatureMapEntry>();
        List featureList = SyncUtil.getAllFeaturesRecursively(this.offering.getFeatureGroup());
        IConfigurationElement[] iConfigurationElementArray = featureElements;
        int n = featureElements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement featureElement = iConfigurationElementArray[n2];
            String id = featureElement.getAttribute("id");
            String payload = featureElement.getAttribute("checkPayload");
            boolean optional = Boolean.valueOf(featureElement.getAttribute("optional"));
            IFeature feature = null;
            Iterator it = featureList.iterator();
            while (it.hasNext() && feature == null) {
                IFeature currFeature = (IFeature)it.next();
                if (!currFeature.getIdentity().getId().equals(id)) continue;
                feature = currFeature;
            }
            pakToFeatureMapList.add(new PakToFeatureMapEntry(id, payload, optional, feature));
            ++n2;
        }
        return pakToFeatureMapList.toArray(new PakToFeatureMapEntry[pakToFeatureMapList.size()]);
    }

    public PakToFeatureMapEntry[] getPakToFeatureMapEntries() {
        return this.pakToFeatureMapEntries;
    }

    public IFeature[] getAllFeatures() {
        ArrayList<IFeature> features = new ArrayList<IFeature>();
        PakToFeatureMapEntry[] pakToFeatureMapEntryArray = this.pakToFeatureMapEntries;
        int n = this.pakToFeatureMapEntries.length;
        int n2 = 0;
        while (n2 < n) {
            PakToFeatureMapEntry pakToFeatureMapEntrie = pakToFeatureMapEntryArray[n2];
            features.add(pakToFeatureMapEntrie.getFeature());
            ++n2;
        }
        features.trimToSize();
        return features.toArray(new IFeature[features.size()]);
    }

    public static class PakToFeatureMapEntry
    implements Comparable {
        private final String id;
        private final String payload;
        private final boolean optional;
        private final IFeature feature;

        public PakToFeatureMapEntry(String id, String payload, boolean optional, IFeature feature) {
            this.id = id != null ? id : "";
            this.payload = payload != null ? payload : "";
            this.optional = optional;
            this.feature = feature;
        }

        public String getId() {
            return this.id;
        }

        public String getPayload() {
            return this.payload;
        }

        public boolean isOptional() {
            return this.optional;
        }

        public IFeature getFeature() {
            return this.feature;
        }

        public int compareTo(Object arg0) {
            if (!(arg0 instanceof PakToFeatureMapEntry)) {
                throw new ClassCastException("Type mismatch: Expecting an PakToFeatureMapEntry object");
            }
            PakToFeatureMapEntry pakToFeatureMapEntry = (PakToFeatureMapEntry)arg0;
            if (this.id.equals(pakToFeatureMapEntry.id) && this.payload.equals(pakToFeatureMapEntry.payload)) {
                return 0;
            }
            if (this.feature != null && this.feature.isRequired()) {
                return -1;
            }
            return 1;
        }
    }
}

