/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sync.core;

import com.ibm.cic.agent.core.Agent;
import com.ibm.cic.agent.core.Profile;
import com.ibm.cic.agent.core.api.IProfile;
import com.ibm.cic.common.core.model.ExtensionCategory;
import com.ibm.cic.common.core.model.FixUtil;
import com.ibm.cic.common.core.model.IContent;
import com.ibm.cic.common.core.model.IFeature;
import com.ibm.cic.common.core.model.IFeatureGroup;
import com.ibm.cic.common.core.model.IFix;
import com.ibm.cic.common.core.model.IFixApplicableOffering;
import com.ibm.cic.common.core.model.IOffering;
import com.ibm.cic.common.core.model.IOfferingOrFix;
import com.ibm.cic.common.core.model.utils.OfferingProperty;
import com.ibm.cic.common.core.preferences.CicCommonSettings;
import com.ibm.cic.common.core.utils.CicMultiStatus;
import com.ibm.cic.common.core.utils.NLS;
import com.ibm.cic.common.core.utils.SplitProgressMonitor;
import com.ibm.cic.common.core.utils.Statuses;
import com.ibm.cic.common.logging.Logger;
import com.ibm.ws.pak.core.utils.PakUtils;
import com.ibm.ws.sync.core.InstalledProduct;
import com.ibm.ws.sync.core.SyncConstants;
import com.ibm.ws.sync.core.api.IInstalledProduct;
import com.ibm.ws.sync.core.internal.Messages;
import com.ibm.ws.sync.core.internal.PakToFeatureMap;
import com.ibm.ws.sync.core.internal.SyncProductVersionMap;
import com.ibm.ws.sync.core.internal.SyncUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeSet;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.osgi.framework.Version;

public class SyncLocation {
    private String location = null;
    private InstalledOffering[] offeringsToInstall = null;
    private InstalledFix[] ifixesToInstall = null;
    private IOfferingOrFix[] offeringsAndFixesToUninstall = null;
    private InstalledOffering[] unknownInstalledOfferings = null;
    private InstalledOffering[] offeringsWithInvalidVersions = null;
    private IProfile profile = null;
    private IOffering baseOffering = null;
    private String[] outofsyncFixes = null;
    private static final Logger log = Logger.getLogger(SyncLocation.class);
    private static final String SEMI_COLON = ";";

    public SyncLocation(String location) {
        log.debug("SyncLocation enter");
        this.location = location;
        this.profile = SyncUtil.findExistingProfile(location);
        this.reset();
        log.debug("SyncLocation exit");
    }

    private void reset() {
        log.debug("SyncLocation.reset enter");
        this.offeringsToInstall = new InstalledOffering[0];
        this.ifixesToInstall = new InstalledFix[0];
        this.offeringsAndFixesToUninstall = new IOfferingOrFix[0];
        this.unknownInstalledOfferings = new InstalledOffering[0];
        this.offeringsWithInvalidVersions = new InstalledOffering[0];
        log.debug("SyncLocation.reset exit");
    }

    public CicMultiStatus performQuickCheck(IProgressMonitor monitor) {
        return this.performCheck(monitor, false, true);
    }

    public CicMultiStatus performCheck(IProgressMonitor monitor, boolean useRepositories, boolean importedOfferingsOnly) {
        Hashtable offeringsAndIFixesInRepositories = !useRepositories ? new Hashtable() : this.getAllOfferingsAndFixesInRepositories(monitor);
        Hashtable offeringsAndIFixesInInventory = !importedOfferingsOnly ? this.getOfferingsAndIFixesInProfile() : this.getAllUserImportedOfferingsOrIFixes(this.getOfferingsAndIFixesInProfile());
        return this.executeSyncLookup(monitor, offeringsAndIFixesInInventory, offeringsAndIFixesInRepositories);
    }

    public CicMultiStatus performLookup(IProgressMonitor monitor) {
        Hashtable offeringsAndIFixesInRepositories = this.getAllOfferingsAndFixesInRepositories(monitor);
        Hashtable offeringsAndIFixesInInventory = this.getOfferingsAndIFixesInProfile();
        CicMultiStatus lookupStatus = this.executeSyncLookup(monitor, offeringsAndIFixesInInventory, offeringsAndIFixesInRepositories);
        String[] offeringsDescriptions = this.getAllOfferingsWithoutARepository();
        if (offeringsDescriptions.length > 0) {
            lookupStatus = Statuses.ST.createMultiStatus();
            String[] stringArray = offeringsDescriptions;
            int n = offeringsDescriptions.length;
            int n2 = 0;
            while (n2 < n) {
                String offeringsDescription = stringArray[n2];
                lookupStatus.add((IStatus)Statuses.ERROR.get(Messages.NoRepositoryFound, new Object[]{offeringsDescription}));
                ++n2;
            }
        }
        return lookupStatus;
    }

    protected CicMultiStatus executeSyncLookup(IProgressMonitor monitor, Hashtable offeringsAndIFixesInInventory, Hashtable offeringsAndIFixesInRepositories) {
        log.debug("SyncLocation.performLookup enter");
        this.reset();
        CicMultiStatus lookupStatus = Statuses.ST.createMultiStatus();
        IInstalledProduct[] installedProducts = new IInstalledProduct[]{};
        try {
            installedProducts = this.getInstalledProductsAtInstallLocation();
        }
        catch (Exception e) {
            lookupStatus.add((IStatus)Statuses.ERROR.get(Messages.InitializationError, new Object[0]));
            log.error((Throwable)e);
            return lookupStatus;
        }
        TreeSet offeringsToSync = new TreeSet();
        TreeSet ifixesToSync = new TreeSet();
        TreeSet ifixesNotInSync = new TreeSet();
        lookupStatus.addAll((IStatus)this.performSyncCheck(installedProducts, offeringsAndIFixesInInventory, offeringsAndIFixesInRepositories, offeringsToSync, ifixesToSync, ifixesNotInSync));
        if (this.profile != null) {
            lookupStatus.addAll((IStatus)this.performResyncCheck(monitor, installedProducts, offeringsAndIFixesInInventory, offeringsAndIFixesInRepositories, offeringsToSync, ifixesToSync, ifixesNotInSync));
            this.offeringsAndFixesToUninstall = this.determineOfferingsAndFixesToUninstall(offeringsAndIFixesInInventory);
        }
        this.offeringsToInstall = !offeringsToSync.isEmpty() ? offeringsToSync.toArray(new InstalledOffering[offeringsToSync.size()]) : new InstalledOffering[]{};
        this.ifixesToInstall = !ifixesToSync.isEmpty() ? ifixesToSync.toArray(new InstalledFix[ifixesToSync.size()]) : new InstalledFix[]{};
        String[] stringArray = this.outofsyncFixes = !ifixesNotInSync.isEmpty() ? ifixesNotInSync.toArray(new String[ifixesNotInSync.size()]) : new String[]{};
        if (!lookupStatus.isErrorOrCancel() && this.offeringsAndFixesToUninstall.length + this.offeringsToInstall.length + this.ifixesToInstall.length > 0) {
            lookupStatus.add((IStatus)Statuses.WARNING.get(Messages.RequiresSynchronization, new Object[]{this.location}));
        }
        log.debug("SyncLocation.performLookup exit");
        return lookupStatus;
    }

    protected CicMultiStatus performSyncCheck(IInstalledProduct[] installedProducts, Hashtable offeringsAndIFixesInInventory, Hashtable offeringsAndIFixesInRepositories, Set offeringsToSync, Set ifixesToSync, Set ifixesNotInSync) {
        log.debug("SyncLocation.performSyncCheck enter");
        boolean tolerationMode = this.isTolerationModeEnabled();
        CicMultiStatus lookupStatus = Statuses.ST.createMultiStatus();
        ArrayList<InstalledOffering> unknownOfferings = new ArrayList<InstalledOffering>();
        ArrayList<InstalledOffering> invalidOfferings = new ArrayList<InstalledOffering>();
        IInstalledProduct[] iInstalledProductArray = installedProducts;
        int n = installedProducts.length;
        int n2 = 0;
        while (n2 < n) {
            IInstalledProduct installedProduct = iInstalledProductArray[n2];
            String offeringId = this.getOfferingId(installedProduct, offeringsAndIFixesInInventory, offeringsAndIFixesInRepositories);
            String currentlyInstalledVersion = SyncUtil.convertExternalVersionToInternalVersion(installedProduct.getCurrentlyInstalledVersion());
            IOffering repOffering = this.getOfferingFromRepository(offeringId, currentlyInstalledVersion, offeringsAndIFixesInRepositories, tolerationMode);
            InstalledOffering instOffering = this.createInstalledOffering(installedProduct, offeringId);
            instOffering.setRepositoryOffering(repOffering);
            if (!offeringsAndIFixesInInventory.containsKey(offeringId)) {
                if (repOffering != null) {
                    instOffering.setBase(Agent.isSelfContainedOffering((IOffering)repOffering));
                    if (instOffering.isBase()) {
                        this.baseOffering = repOffering;
                    }
                    lookupStatus.addAll(Agent.getInstance().prepare((IOfferingOrFix)repOffering, ExtensionCategory.ALL, (IProgressMonitor)new NullProgressMonitor()));
                    CicMultiStatus versionCheckStatus = this.productsVersionMatchCheck(instOffering);
                    if (versionCheckStatus.getSeverity() == 4) {
                        invalidOfferings.add(instOffering);
                    }
                    lookupStatus.addAll((IStatus)versionCheckStatus);
                    offeringsToSync.add(instOffering);
                    TreeSet installedIfixes = new TreeSet();
                    this.findIFixesToSync(installedProduct, repOffering, offeringsAndIFixesInInventory, offeringsAndIFixesInRepositories, ifixesToSync, ifixesNotInSync);
                    if (tolerationMode) {
                        String repVersion = SyncUtil.convertInternalVersionToExternalVersion(repOffering.getVersion().toString());
                        if (SyncUtil.compareVersion(instOffering.getCurrentVersion(), repVersion) == 0) {
                            ifixesToSync.addAll(installedIfixes);
                        }
                    } else {
                        ifixesToSync.addAll(installedIfixes);
                    }
                } else {
                    unknownOfferings.add(instOffering);
                }
            }
            ++n2;
        }
        this.unknownInstalledOfferings = !unknownOfferings.isEmpty() ? unknownOfferings.toArray(new InstalledOffering[unknownOfferings.size()]) : new InstalledOffering[]{};
        this.addOfferingsWithInvalidVersions(invalidOfferings);
        log.debug("SyncLocation.performSyncCheck exit");
        return lookupStatus;
    }

    protected CicMultiStatus performResyncCheck(IProgressMonitor monitor, IInstalledProduct[] installedProducts, Hashtable offeringsAndIFixesInInventory, Hashtable offeringsAndIFixesInRepositories, Set offeringsToSync, Set ifixesToSync, Set ifixesNotInSync) {
        log.debug("SyncLocation.performResyncCheck enter");
        CicMultiStatus lookupStatus = Statuses.ST.createMultiStatus();
        if (this.profile == null) {
            log.debug("SyncLocation.performResyncCheck exit");
            return lookupStatus;
        }
        boolean tolerationMode = this.isTolerationModeEnabled();
        ArrayList<InstalledOffering> invalidOfferings = new ArrayList<InstalledOffering>();
        IInstalledProduct[] iInstalledProductArray = installedProducts;
        int n = installedProducts.length;
        int n2 = 0;
        while (n2 < n) {
            block16: {
                CicMultiStatus versionCheckStatus;
                InstalledOffering instOffering;
                IOffering repOffering;
                String invOfferingVersion;
                String installedVersion;
                IOffering invOffering;
                IInstalledProduct installedProduct;
                block17: {
                    String repOfferingVersion;
                    installedProduct = iInstalledProductArray[n2];
                    String offeringId = this.getOfferingId(installedProduct, offeringsAndIFixesInInventory, offeringsAndIFixesInRepositories);
                    invOffering = (IOffering)offeringsAndIFixesInInventory.remove(offeringId);
                    if (invOffering == null) break block16;
                    installedVersion = SyncUtil.convertExternalVersionToInternalVersion(installedProduct.getCurrentlyInstalledVersion());
                    invOfferingVersion = SyncUtil.getVersionWithoutQualifier(invOffering.getVersion().toString());
                    repOffering = this.getOfferingFromRepository(offeringId, installedVersion, offeringsAndIFixesInRepositories, tolerationMode);
                    instOffering = this.createInstalledOffering(installedProduct, offeringId);
                    instOffering.setInventoryOffering(invOffering);
                    instOffering.setRepositoryOffering(repOffering);
                    instOffering.setBase(Agent.isSelfContainedOffering((IOffering)invOffering));
                    if (instOffering.isBase()) {
                        this.baseOffering = invOffering;
                    }
                    if (!tolerationMode) break block17;
                    String string = repOfferingVersion = repOffering != null ? SyncUtil.getVersionWithoutQualifier(repOffering.getVersion().toString()) : "0.0.0.0";
                    if (SyncUtil.compareVersion(installedVersion, repOfferingVersion) != 0) break block16;
                }
                if (SyncUtil.compareVersion(installedVersion, invOfferingVersion) == 0) {
                    lookupStatus.addAll(Agent.getInstance().prepare((IOfferingOrFix)invOffering, ExtensionCategory.ALL, monitor));
                    versionCheckStatus = this.productsVersionMatchCheck(instOffering);
                    lookupStatus.addAll((IStatus)versionCheckStatus);
                    if (versionCheckStatus.getSeverity() == 4) {
                        invalidOfferings.add(instOffering);
                    } else {
                        if (!this.areFeaturesInSync(instOffering) || !this.areImportFeaturesInSync(instOffering)) {
                            offeringsToSync.add(instOffering);
                        }
                        this.findIFixesToSync(installedProduct, invOffering, offeringsAndIFixesInInventory, offeringsAndIFixesInRepositories, ifixesToSync, ifixesNotInSync);
                    }
                } else if (repOffering != null) {
                    lookupStatus.addAll(Agent.getInstance().prepare((IOfferingOrFix)repOffering, ExtensionCategory.ALL, monitor));
                    versionCheckStatus = this.productsVersionMatchCheck(instOffering);
                    lookupStatus.addAll((IStatus)versionCheckStatus);
                    if (versionCheckStatus.getSeverity() == 4) {
                        invalidOfferings.add(instOffering);
                    } else {
                        offeringsToSync.add(instOffering);
                        this.findIFixesToSync(installedProduct, repOffering, offeringsAndIFixesInInventory, offeringsAndIFixesInRepositories, ifixesToSync, ifixesNotInSync);
                    }
                    if (instOffering.isBase()) {
                        this.baseOffering = repOffering;
                    }
                } else {
                    offeringsToSync.add(instOffering);
                }
            }
            ++n2;
        }
        this.addOfferingsWithInvalidVersions(invalidOfferings);
        log.debug("SyncLocation.performResyncCheck exit");
        return lookupStatus;
    }

    private void findIFixesToSync(IInstalledProduct installedProduct, IOffering offering, Hashtable importedOfferingAndIFixes, Hashtable offeringsAndIFixesInRepositories, Set ifixesToSync, Set ifixesNotInSync) {
        log.debug("SyncLocation.findIFixesToSync enter");
        PakUtils pakUtils = new PakUtils();
        int j = 0;
        while (j < installedProduct.getInstalledIfixes().length) {
            IFix invIFix = (IFix)importedOfferingAndIFixes.remove(installedProduct.getInstalledIfixes()[j]);
            if (invIFix == null) {
                StringTokenizer imFixIDTokenizer;
                String imFixID = pakUtils.getIMFixId(installedProduct.getInstallLocation(), pakUtils.getInstalledPakNameForThisMaintenanceName(installedProduct.getInstallLocation(), installedProduct.getInstalledIfixes()[j]));
                if (imFixID != null && !imFixID.equals("")) {
                    imFixIDTokenizer = new StringTokenizer(imFixID, SEMI_COLON);
                    while (imFixIDTokenizer.hasMoreTokens() && invIFix == null) {
                        invIFix = (IFix)importedOfferingAndIFixes.remove(imFixIDTokenizer.nextToken());
                    }
                }
                if (invIFix == null) {
                    Iterator it = importedOfferingAndIFixes.keySet().iterator();
                    while (it.hasNext()) {
                        String fixID = it.next().toString();
                        if (!fixID.startsWith(installedProduct.getInstalledIfixes()[j])) continue;
                        invIFix = (IFix)importedOfferingAndIFixes.remove(fixID);
                        break;
                    }
                }
                if (invIFix == null && offering != null) {
                    IFix repIFix = null;
                    String id2 = null;
                    for (String id2 : offeringsAndIFixesInRepositories.keySet()) {
                        InstalledFix instIFix;
                        if (imFixID != null && !imFixID.equals("")) {
                            imFixIDTokenizer = new StringTokenizer(imFixID, SEMI_COLON);
                            while (imFixIDTokenizer.hasMoreTokens() && repIFix == null) {
                                if (!id2.equals(imFixIDTokenizer.nextToken()) || (repIFix = this.getIFixFromRepository(id2, offering, offeringsAndIFixesInRepositories)) == null) continue;
                                instIFix = this.createInstalledIFix(installedProduct, installedProduct.getInstalledIfixes()[j]);
                                instIFix.setInventoryFix(null);
                                instIFix.setRepositoryFix(repIFix);
                                instIFix.setName(repIFix.getName());
                                instIFix.setAssociatedOfferingId(offering.getIdentity().getId());
                                ifixesToSync.add(instIFix);
                            }
                        } else if ((id2.equals(installedProduct.getInstalledIfixes()[j]) || id2.startsWith(installedProduct.getInstalledIfixes()[j])) && (repIFix = this.getIFixFromRepository(id2, offering, offeringsAndIFixesInRepositories)) != null) {
                            instIFix = this.createInstalledIFix(installedProduct, installedProduct.getInstalledIfixes()[j]);
                            instIFix.setInventoryFix(null);
                            instIFix.setRepositoryFix(repIFix);
                            instIFix.setName(repIFix.getName());
                            instIFix.setAssociatedOfferingId(offering.getIdentity().getId());
                            ifixesToSync.add(instIFix);
                        }
                        if (repIFix != null) break;
                    }
                    ifixesNotInSync.add(installedProduct.getInstalledIfixes()[j]);
                }
            }
            ++j;
        }
        log.debug("SyncLocation.findIFixesToSync exit");
    }

    private IOfferingOrFix[] determineOfferingsAndFixesToUninstall(Hashtable importedOfferings) {
        log.debug("SyncLocation.determineOfferingsToUninstall enter");
        ArrayList<IOfferingOrFix> offeringsAndFixes = new ArrayList<IOfferingOrFix>();
        for (IOfferingOrFix offeringOrFix : importedOfferings.values()) {
            if (!this.isUserImported(offeringOrFix)) continue;
            offeringsAndFixes.add(offeringOrFix);
        }
        offeringsAndFixes.trimToSize();
        log.debug("SyncLocation.determineOfferingsToUninstall exit");
        return offeringsAndFixes.toArray(new IOfferingOrFix[offeringsAndFixes.size()]);
    }

    private Hashtable getAllUserImportedOfferingsOrIFixes(Hashtable offeringsAndIFixesInInventory) {
        log.debug("SyncLocation.getAllUserImportedOfferingsOrIFixes enter");
        Hashtable<String, IOfferingOrFix> importedOfferingsOrIFixes = new Hashtable<String, IOfferingOrFix>();
        for (IOfferingOrFix offeringOrFix : offeringsAndIFixesInInventory.values()) {
            if (!this.isUserImported(offeringOrFix)) continue;
            importedOfferingsOrIFixes.put(offeringOrFix.getIdentity().getId(), offeringOrFix);
        }
        log.debug("SyncLocation.getAllUserImportedOfferingsOrIFixes exit");
        return importedOfferingsOrIFixes;
    }

    private IInstalledProduct[] getInstalledProductsAtInstallLocation() throws Exception {
        log.debug("SyncLocation.getInstalledProductsAtInstallLocation enter");
        PakUtils pakUtils = new PakUtils();
        String[] productIds = pakUtils.getProductIds(this.location);
        TreeSet<InstalledProduct> installedProducts = new TreeSet<InstalledProduct>();
        String[] stringArray = productIds;
        int n = productIds.length;
        int n2 = 0;
        while (n2 < n) {
            String productId = stringArray[n2];
            InstalledProduct installedOffering = new InstalledProduct(this.location, productId);
            installedOffering.init();
            installedProducts.add(installedOffering);
            ++n2;
        }
        log.debug("SyncLocation.getInstalledProductsAtInstallLocation exit");
        return installedProducts.toArray(new IInstalledProduct[installedProducts.size()]);
    }

    private Hashtable getOfferingsAndIFixesInProfile() {
        log.debug("SyncLocation.getOfferingsAndIFixesInProfile enter");
        Hashtable<String, IOfferingOrFix> offeringsAndIFixes = new Hashtable<String, IOfferingOrFix>();
        if (this.profile == null) {
            return offeringsAndIFixes;
        }
        IOffering[] offeringsInProfile = this.profile.getInstalledOfferings();
        IFix[] ifixesInProfile = this.profile.getInstalledFixes();
        IOfferingOrFix[] offeringsAndIFixesInProfile = new IOfferingOrFix[offeringsInProfile.length + ifixesInProfile.length];
        int i = 0;
        while (i < offeringsInProfile.length) {
            offeringsAndIFixesInProfile[i] = offeringsInProfile[i];
            ++i;
        }
        i = offeringsInProfile.length;
        int j = 0;
        while (i < offeringsAndIFixesInProfile.length) {
            offeringsAndIFixesInProfile[i] = ifixesInProfile[j];
            ++i;
            ++j;
        }
        IOfferingOrFix[] iOfferingOrFixArray = offeringsAndIFixesInProfile;
        int n = offeringsAndIFixesInProfile.length;
        int n2 = 0;
        while (n2 < n) {
            IOfferingOrFix offeringOrFix = iOfferingOrFixArray[n2];
            String offeringOrFixId = offeringOrFix.getIdentity().getId();
            offeringsAndIFixes.put(offeringOrFixId, offeringOrFix);
            if (offeringOrFix instanceof IOffering && Agent.isSelfContainedOffering((IOffering)((IOffering)offeringOrFix))) {
                this.baseOffering = (IOffering)offeringOrFix;
            }
            ++n2;
        }
        log.debug("SyncLocation.getOfferingsAndIFixesInProfile exit");
        return offeringsAndIFixes;
    }

    private String getOfferingId(IInstalledProduct installedProduct, Hashtable inventoryOfferings, Hashtable repositoryOfferings) {
        log.debug("SyncLocation.getOfferingId enter");
        String offeringId = installedProduct.getOfferingIdFromIMPropertyFile();
        if (offeringId == null || "".equals(offeringId.trim())) {
            String generatedOfferingId = installedProduct.generateOfferingId();
            String instOfferingId = this.determineOfferingId(generatedOfferingId, inventoryOfferings);
            if (instOfferingId.equals("")) {
                instOfferingId = this.determineOfferingId(generatedOfferingId, repositoryOfferings);
            }
            offeringId = !"".equals(instOfferingId) ? instOfferingId : generatedOfferingId;
        }
        log.debug("SyncLocation.getOfferingId exit");
        return offeringId;
    }

    private String determineOfferingId(String offeringId, Hashtable offerings) {
        log.debug("SyncLocation.determineOfferingId enter");
        TreeSet knownOfferingIds = new TreeSet(offerings.keySet());
        String foundOfferingId = "";
        boolean found = Boolean.FALSE;
        Pattern offeringIdPattern = Pattern.compile(SyncConstants.offeringIdPattern(offeringId));
        Iterator it = knownOfferingIds.iterator();
        while (it.hasNext() && !found) {
            String knownOfferingId = (String)it.next();
            found = offeringId.equals(knownOfferingId);
            if (found) {
                foundOfferingId = knownOfferingId;
                continue;
            }
            if (offeringIdPattern.matcher(knownOfferingId).matches()) {
                Version knownVersion;
                if (foundOfferingId.equals("")) {
                    foundOfferingId = knownOfferingId;
                    continue;
                }
                Version foundVersion = ((IOfferingOrFix)((TreeSet)offerings.get(foundOfferingId)).first()).getVersion();
                if (foundVersion.compareTo(knownVersion = ((IOfferingOrFix)((TreeSet)offerings.get(knownOfferingId)).first()).getVersion()) >= 0) continue;
                foundOfferingId = knownOfferingId;
                continue;
            }
            boolean bl = found = !foundOfferingId.equals("");
        }
        log.debug("SyncLocation.determineOfferingId exit");
        return foundOfferingId;
    }

    private IFix getIFixFromRepository(String id, IOffering offering, Hashtable repOfferingsAndFixes) {
        log.debug("SyncLocation.getIFixFromRepository enter");
        IFix ifix = null;
        if (!repOfferingsAndFixes.containsKey(id)) {
            return ifix;
        }
        TreeSet allOfferingsAndFixes = (TreeSet)repOfferingsAndFixes.get(id);
        Iterator it = allOfferingsAndFixes.iterator();
        while (it.hasNext() && ifix == null) {
            IOfferingOrFix repOfferingOrFix = (IOfferingOrFix)it.next();
            if (!(repOfferingOrFix instanceof IFix)) continue;
            IFix repIfix = (IFix)repOfferingOrFix;
            Iterator iterator = repIfix.getApplicableOfferings().iterator();
            while (iterator.hasNext() && ifix == null) {
                IFixApplicableOffering applicableOffering = (IFixApplicableOffering)iterator.next();
                if (!applicableOffering.getIdentity().getId().equals(offering.getIdentity().getId()) || !applicableOffering.getTolerance().isIncluded(offering.getVersion())) continue;
                ifix = repIfix;
            }
        }
        log.debug("SyncLocation.getIFixFromRepository exit");
        return ifix;
    }

    private IOffering getOfferingFromRepository(String id, String version, Hashtable repOfferingsAndFixes, boolean tolerateMode) {
        log.debug("SyncLocation.getOfferingFromRepository enter");
        IOffering offering = null;
        if (!repOfferingsAndFixes.containsKey(id)) {
            return offering;
        }
        TreeSet allOfferingsAndFixes = (TreeSet)repOfferingsAndFixes.get(id);
        Iterator it = allOfferingsAndFixes.iterator();
        while (it.hasNext() && offering == null) {
            IOfferingOrFix repOfferingOrFix = (IOfferingOrFix)it.next();
            if (!(repOfferingOrFix instanceof IOffering)) continue;
            IOffering repOffering = (IOffering)repOfferingOrFix;
            String repOfferingVersion = repOffering.getVersion().toString();
            int versionCompare = SyncUtil.compareVersion(repOfferingVersion = SyncUtil.getVersionWithoutQualifier(repOfferingVersion), version);
            if (versionCompare == 0) {
                offering = repOffering;
                continue;
            }
            if (!tolerateMode || versionCompare != -1) continue;
            offering = repOffering;
        }
        log.debug("SyncLocation.getOfferingFromRepository exit");
        return offering;
    }

    private boolean areImportFeaturesInSync(InstalledOffering instOffering) {
        boolean importFeaturesInSync = Boolean.TRUE;
        List<IFeature> importFeatures = Arrays.asList(instOffering.getImportFeatures());
        if (this.isUserImported((IOfferingOrFix)instOffering.getInventoryOffering()) && !importFeatures.isEmpty()) {
            TreeSet<IFeature> installedImportFeatures = new TreeSet<IFeature>(new SyncUtil.FeatureComparator());
            TreeSet<IFeature> installedFeatures = new TreeSet<IFeature>(new SyncUtil.FeatureComparator());
            installedImportFeatures.addAll(Arrays.asList(instOffering.getInstalledImportFeatures()));
            installedFeatures.addAll(Arrays.asList(Agent.getInstance().getInstalledFeatures(this.profile, instOffering.getInventoryOffering())));
            installedFeatures.retainAll(importFeatures);
            importFeaturesInSync = installedFeatures.equals(installedImportFeatures);
        }
        return importFeaturesInSync;
    }

    private boolean areFeaturesInSync(InstalledOffering instOffering) {
        log.debug("SyncLocation.areFeaturesInSync enter");
        IFeature[] selectedFeatures = instOffering.getInstalledFeatures();
        IFeature[] installedFeatures = this.getInstalledFeaturesFromInventory(instOffering);
        HashSet<IFeature> installedFeatureSet = new HashSet<IFeature>(Arrays.asList(installedFeatures));
        boolean featuresInSync = Boolean.TRUE;
        int i = 0;
        while (i < selectedFeatures.length && featuresInSync) {
            featuresInSync = installedFeatureSet.remove(selectedFeatures[i]);
            ++i;
        }
        log.debug("SyncLocation.areFeaturesInSync exit");
        return featuresInSync && installedFeatureSet.isEmpty();
    }

    private IFeature[] getInstalledFeaturesFromInventory(InstalledOffering instOffering) {
        log.debug("SyncLocation.getInstalledFeaturesFromInventory enter");
        IFeature[] installedFeatures = Agent.getInstance().getInstalledFeatures(this.profile, instOffering.getInventoryOffering());
        PakToFeatureMap pakToFeatureMap = instOffering.getPakToFeatureMap();
        if (pakToFeatureMap == null) {
            log.debug("SyncLocation.getInstalledFeaturesFromInventory exit");
            return installedFeatures;
        }
        ArrayList<IFeature> features = new ArrayList<IFeature>();
        List<IFeature> pakToFeatureMapFeatures = Arrays.asList(pakToFeatureMap.getAllFeatures());
        if (pakToFeatureMapFeatures.isEmpty()) {
            log.debug("SyncLocation.getInstalledFeaturesFromInventory exit");
            return installedFeatures;
        }
        IFeature[] iFeatureArray = installedFeatures;
        int n = installedFeatures.length;
        int n2 = 0;
        while (n2 < n) {
            IFeature installedFeature = iFeatureArray[n2];
            if (pakToFeatureMapFeatures.contains(installedFeature)) {
                features.add(installedFeature);
            }
            ++n2;
        }
        features.trimToSize();
        log.debug("SyncLocation.getInstalledFeaturesFromInventory exit");
        return features.toArray(new IFeature[features.size()]);
    }

    private boolean isUserImported(IOfferingOrFix offeringOrFix) {
        IOffering[] installedOfferings;
        log.debug("SyncLocation.isUserImported enter");
        IOffering offering = null;
        if (offeringOrFix instanceof IOffering) {
            offering = (IOffering)offeringOrFix;
        } else if (offeringOrFix instanceof IFix && (installedOfferings = this.profile.getInstalledOfferings()) != null) {
            offering = FixUtil.findApplicableOffering((IFix)((IFix)offeringOrFix), Arrays.asList(installedOfferings));
        }
        if (offering != null) {
            String value = this.profile.getOfferingUserData("user.cic.imported", offering.getIdentity().getId());
            log.debug("SyncLocation.isUserImported exit");
            return "WAS".equals(value);
        }
        log.debug("SyncLocation.isUserImported exit");
        return false;
    }

    protected InstalledOffering createInstalledOffering(IInstalledProduct installedProduct, String offeringId) {
        log.debug("SyncLocation.createInstalledOffering enter");
        InstalledOffering instOffering = new InstalledOffering(offeringId, installedProduct);
        log.debug("SyncLocation.createInstalledOffering exit");
        return instOffering;
    }

    protected InstalledFix createInstalledIFix(IInstalledProduct installedProduct, String fixId) {
        log.debug("SyncLocation.createInstalledIFix enter");
        InstalledFix instIFix = new InstalledFix(fixId);
        log.debug("SyncLocation.createInstalledIFix exit");
        return instIFix;
    }

    private boolean isTolerationModeEnabled() {
        log.debug("SyncLocation.isTolerationModeEnabled enter");
        log.debug("SyncLocation.isTolerationModeEnabled exit");
        return Boolean.valueOf(System.getProperty("cic.importTolerationMode", Boolean.FALSE.toString()));
    }

    private Hashtable getAllOfferingsAndFixesInRepositories(IProgressMonitor monitor) {
        log.debug("SyncLocation.getAllOfferingsAndFixesInRepositories enter");
        SplitProgressMonitor spm = new SplitProgressMonitor(monitor, 2);
        List offeringsInRepositories = SyncUtil.getAllOfferingsFromRegisteredRepositories(spm.next());
        Hashtable repOfferingsAndFixes = new Hashtable();
        IProgressMonitor monitor2 = spm.next();
        monitor2.beginTask(NLS.bind((String)Messages.RepositoryInfoProgressBarText, (Object[])new Object[0]), offeringsInRepositories.size());
        boolean isGroupMode = CicCommonSettings.getAccessRightsMode().isGroupMode();
        for (IOfferingOrFix repositoryOfferingOrFix : offeringsInRepositories) {
            String id = repositoryOfferingOrFix.getIdentity().getId();
            TreeSet<IOfferingOrFix> offeringsAndFixes = null;
            offeringsAndFixes = repOfferingsAndFixes.containsKey(id) ? (TreeSet<IOfferingOrFix>)repOfferingsAndFixes.get(id) : new TreeSet<IOfferingOrFix>(new OfferingOrFixComparator());
            if (!isGroupMode || !OfferingProperty.hasUnacceptableRequirementForGroupMode((IOfferingOrFix)repositoryOfferingOrFix)) {
                offeringsAndFixes.add(repositoryOfferingOrFix);
                repOfferingsAndFixes.put(id, offeringsAndFixes);
            }
            monitor2.worked(1);
        }
        monitor2.done();
        monitor.done();
        log.debug("SyncLocation.getAllOfferingsAndFixesInRepositories exit");
        return repOfferingsAndFixes;
    }

    public IStatus validateLocation() {
        log.debug("SyncLocation.validateLocation enter");
        File locationFile = new File(this.location);
        if (!locationFile.exists()) {
            return Statuses.ERROR.get(Messages.LocationNotExist, new Object[]{this.location});
        }
        if (!locationFile.isDirectory()) {
            return Statuses.ERROR.get(Messages.NotDirectory, new Object[]{this.location});
        }
        String[] list = locationFile.list();
        if (list == null || list.length == 0) {
            return Statuses.ERROR.get(Messages.DirectoryEmpty, new Object[]{this.location});
        }
        PakUtils pakUtils = new PakUtils();
        String[] productIds = pakUtils.getProductIds(this.location);
        if (productIds == null || productIds.length == 0) {
            return Statuses.ERROR.get(Messages.NoWebSphereProductFound, new Object[]{this.location});
        }
        if (!pakUtils.isNIFStackAvailable(this.location)) {
            return Statuses.ERROR.get(Messages.UnimportableLocationError, new Object[]{this.location});
        }
        log.debug("SyncLocation.validateLocation exit");
        return Status.OK_STATUS;
    }

    public IStatus verifyImportProfile() {
        log.debug("SyncLocation.verifyImportProfile enter");
        IStatus status = Status.OK_STATUS;
        if (!SyncUtil.isEmptyProfile(this.profile)) {
            log.debug("SyncLocation.verifyImportProfile exit");
            return status;
        }
        Profile collisionProfile = SyncUtil.findProfileCollision(this.location);
        if (collisionProfile != null) {
            String packageName = "";
            if (this.baseOffering != null) {
                packageName = OfferingProperty.getDefaultProfile((IOfferingOrFix)this.baseOffering);
            } else if (this.unknownInstalledOfferings.length > 0) {
                packageName = this.unknownInstalledOfferings[0].getProductName();
            }
            status = Statuses.ERROR.get(Messages.ImportNotAllowed, new Object[]{packageName, collisionProfile.getProfileId()});
        }
        log.debug("SyncLocation.verifyImportProfile exit");
        return status;
    }

    public boolean requiresSynchronization() {
        log.debug("SyncLocation.requiresSynchronization enter");
        if (this.profile != null) {
            return this.offeringsToInstall.length > 0 || this.offeringsAndFixesToUninstall.length > 0 || this.ifixesToInstall.length > 0;
        }
        log.debug("SyncLocation.requiresSynchronization exit");
        return this.baseOffering != null && this.offeringsToInstall.length > 0;
    }

    public boolean requiresReSynchronization() {
        log.debug("SyncLocation.requiresReSynchronization enter");
        boolean requireReSync = Boolean.FALSE;
        if (this.profile != null) {
            IOfferingOrFix[] iOfferingOrFixArray = this.offeringsAndFixesToUninstall;
            int n = this.offeringsAndFixesToUninstall.length;
            int n2 = 0;
            while (n2 < n) {
                IOfferingOrFix element = iOfferingOrFixArray[n2];
                if (element instanceof IOffering && Agent.isSelfContainedOffering((IOffering)((IOffering)element))) {
                    return Boolean.FALSE;
                }
                requireReSync = Boolean.TRUE;
                ++n2;
            }
            int i = 0;
            while (i < this.offeringsToInstall.length && !requireReSync) {
                boolean bl = requireReSync = this.offeringsToInstall[i].getInventoryOffering() != null;
            }
        }
        log.debug("SyncLocation.requiresReSynchronization exit");
        return requireReSync;
    }

    public boolean isBaseOfferingInSync() {
        boolean isBaseInSync;
        log.debug("SyncLocation.isBaseOfferingInSync enter");
        boolean bl = isBaseInSync = this.baseOffering != null;
        if (this.baseOffering != null) {
            int i = 0;
            while (i < this.offeringsToInstall.length && isBaseInSync) {
                String offeringId = this.offeringsToInstall[i].getOfferingId();
                isBaseInSync = !offeringId.equals(this.baseOffering.getIdentity().getId());
                ++i;
            }
        }
        log.debug("SyncLocation.isBaseOfferingInSync exit");
        return isBaseInSync;
    }

    public boolean isBaseOfferingInstalled() {
        log.debug("SyncLocation.isBaseOfferingInstalled enter");
        boolean baseInstalled = Boolean.TRUE;
        if (this.baseOffering != null) {
            int i = 0;
            while (i < this.offeringsAndFixesToUninstall.length && baseInstalled) {
                String offeringId = this.offeringsAndFixesToUninstall[i].getIdentity().getId();
                baseInstalled = !offeringId.equals(this.baseOffering.getIdentity().getId());
                ++i;
            }
        }
        log.debug("SyncLocation.isBaseOfferingInstalled enter");
        return baseInstalled;
    }

    public CicMultiStatus productsVersionMatchCheck(InstalledOffering offering) {
        CicMultiStatus status = Statuses.ST.createMultiStatus();
        String offeringName = offering.getOfferingName();
        Map products = offering.getProductsWithOutOfSyncVersion();
        Iterator it = products.entrySet().iterator();
        while (it.hasNext()) {
            String description = (String)it.next().getKey();
            status.add((IStatus)Statuses.ERROR.get(Messages.ProductsOutOfSync, new Object[]{offeringName, description}));
        }
        return status;
    }

    public String[] getAllOfferingsOutOfSync() {
        log.debug("SyncLocation.getAllOfferingsOutOfSync enter");
        ArrayList<String> offeringDescriptions = new ArrayList<String>();
        InstalledOffering[] installedOfferingArray = this.offeringsToInstall;
        int n = this.offeringsToInstall.length;
        int n2 = 0;
        while (n2 < n) {
            InstalledOffering element = installedOfferingArray[n2];
            String name = element.getOfferingName();
            name = name == null || name.equals("") ? element.getProductName() : (element.getInventoryOffering() != null ? String.valueOf(name) + " " + element.getInventoryExternalVersion() : String.valueOf(name) + " " + element.getCurrentVersion());
            offeringDescriptions.add(name);
            ++n2;
        }
        offeringDescriptions.trimToSize();
        log.debug("SyncLocation.getAllOfferingsOutOfSync exit");
        return offeringDescriptions.toArray(new String[offeringDescriptions.size()]);
    }

    public String[] getAllOfferingsWithoutARepository() {
        String name;
        log.debug("SyncLocation.getAllOfferingsWithoutARepository enter");
        ArrayList<String> offeringNames = new ArrayList<String>();
        InstalledOffering[] installedOfferingArray = this.offeringsToInstall;
        int n = this.offeringsToInstall.length;
        int n2 = 0;
        while (n2 < n) {
            InstalledOffering element = installedOfferingArray[n2];
            if (element.getRepositoryOffering() == null) {
                name = element.getOfferingNameAndVersion();
                offeringNames.add(name);
            }
            ++n2;
        }
        if (this.baseOffering == null) {
            installedOfferingArray = this.unknownInstalledOfferings;
            n = this.unknownInstalledOfferings.length;
            n2 = 0;
            while (n2 < n) {
                InstalledOffering unknownInstalledOffering = installedOfferingArray[n2];
                name = unknownInstalledOffering.getProductName();
                offeringNames.add(name);
                ++n2;
            }
        }
        offeringNames.trimToSize();
        log.debug("SyncLocation.getAllOfferingsWithoutARepository exit");
        return offeringNames.toArray(new String[offeringNames.size()]);
    }

    public String[] getRepositoryLocations() {
        log.debug("SyncLocation.getRepositoryLocations enter");
        TreeSet<String> repositoryLocations = new TreeSet<String>();
        InstalledOffering[] installedOfferingArray = this.offeringsToInstall;
        int n = this.offeringsToInstall.length;
        int n2 = 0;
        while (n2 < n) {
            InstalledOffering element = installedOfferingArray[n2];
            IOffering repOfferingOrFix = element.getRepositoryOffering();
            if (repOfferingOrFix != null) {
                repositoryLocations.add(repOfferingOrFix.getRepository().getLocationStr());
            }
            ++n2;
        }
        log.debug("SyncLocation.getRepositoryLocations exit");
        return repositoryLocations.toArray(new String[repositoryLocations.size()]);
    }

    public CicMultiStatus recheckRepositories(IProgressMonitor monitor) {
        String[] offeringsDescriptions;
        log.debug("SyncLocation.checkRepositories enter");
        CicMultiStatus status = Statuses.ST.createMultiStatus();
        this.baseOffering = this.profile != null ? SyncUtil.getBaseOffering((Profile)this.profile) : null;
        boolean tolerationMode = this.isTolerationModeEnabled();
        Hashtable offeringsInRepositories = this.getAllOfferingsAndFixesInRepositories(monitor);
        TreeSet<InstalledOffering> offerings = new TreeSet<InstalledOffering>(Arrays.asList(this.offeringsToInstall));
        offerings.addAll(Arrays.asList(this.unknownInstalledOfferings));
        ArrayList<InstalledOffering> offeringsToSync = new ArrayList<InstalledOffering>();
        ArrayList<InstalledOffering> unknownOfferings = new ArrayList<InstalledOffering>();
        for (InstalledOffering offering : offerings) {
            String offeringId = offering.getOfferingId();
            String installedVersion = SyncUtil.convertExternalVersionToInternalVersion(offering.getCurrentVersion());
            IOffering repOffering = this.getOfferingFromRepository(offeringId, installedVersion, offeringsInRepositories, tolerationMode);
            offering.setRepositoryOffering(repOffering);
            if (offering.getInventoryOffering() == null) {
                if (repOffering == null) {
                    unknownOfferings.add(offering);
                    continue;
                }
            } else if (tolerationMode) {
                String repOfferingVersion;
                String string = repOfferingVersion = repOffering != null ? SyncUtil.getVersionWithoutQualifier(repOffering.getVersion().toString()) : "0.0.0.0";
                if (SyncUtil.compareVersion(installedVersion, repOfferingVersion) != 0) continue;
            }
            if (repOffering != null) {
                offering.setBase(Agent.isSelfContainedOffering((IOffering)repOffering));
                if (offering.isBase()) {
                    this.baseOffering = repOffering;
                }
            }
            offeringsToSync.add(offering);
        }
        this.offeringsToInstall = !offeringsToSync.isEmpty() ? offeringsToSync.toArray(new InstalledOffering[offeringsToSync.size()]) : new InstalledOffering[]{};
        this.unknownInstalledOfferings = !unknownOfferings.isEmpty() ? unknownOfferings.toArray(new InstalledOffering[unknownOfferings.size()]) : new InstalledOffering[]{};
        String[] stringArray = offeringsDescriptions = this.getAllOfferingsWithoutARepository();
        int n = offeringsDescriptions.length;
        int n2 = 0;
        while (n2 < n) {
            String offeringsDescription = stringArray[n2];
            status.add((IStatus)Statuses.ERROR.get(Messages.NoRepositoryFound, new Object[]{offeringsDescription}));
            ++n2;
        }
        log.debug("SyncLocation.checkRepositories exit");
        return status;
    }

    public InstalledOffering[] getOfferingsToInstall() {
        return this.offeringsToInstall;
    }

    public InstalledFix[] getIFixesToInstall() {
        return this.ifixesToInstall;
    }

    public IOfferingOrFix[] getOfferingsAndFixesToUninstall() {
        return this.offeringsAndFixesToUninstall;
    }

    public InstalledOffering[] getUnknownInstalledOfferings() {
        return this.unknownInstalledOfferings;
    }

    public InstalledOffering[] getOfferingsWithInvalidVersions() {
        return this.offeringsWithInvalidVersions;
    }

    public String getLocation() {
        return this.location;
    }

    public IProfile getProfile() {
        return this.profile;
    }

    public IOffering getBaseOffering() {
        return this.baseOffering;
    }

    public String[] getOutOfSyncFixes() {
        return this.outofsyncFixes;
    }

    private void addOfferingsWithInvalidVersions(List offerings) {
        log.debug("SyncLocation.addOfferingsWithInvalidVersions enter");
        if (offerings == null || offerings.isEmpty()) {
            log.debug("SyncLocation.addOfferingsWithInvalidVersions exit");
            return;
        }
        ArrayList<InstalledOffering> invalidOfferings = new ArrayList<InstalledOffering>();
        if (this.offeringsWithInvalidVersions.length > 0) {
            invalidOfferings.addAll(Arrays.asList(this.offeringsWithInvalidVersions));
        }
        invalidOfferings.addAll(offerings);
        this.offeringsWithInvalidVersions = invalidOfferings.toArray(new InstalledOffering[invalidOfferings.size()]);
        log.debug("SyncLocation.addOfferingsWithInvalidVersions exit");
    }

    public static class InstalledFix
    implements Comparable {
        private final String fixId;
        private String name;
        private String offeringId;
        private IFix repositoryFix = null;
        private IFix inventoryFix = null;

        public InstalledFix(String fixId) {
            this.fixId = fixId;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getFixId() {
            return this.fixId;
        }

        public IFix getRepositoryFix() {
            return this.repositoryFix;
        }

        public void setRepositoryFix(IFix repositoryFix) {
            this.repositoryFix = repositoryFix;
        }

        public IFix getInventoryFix() {
            return this.inventoryFix;
        }

        public void setInventoryFix(IFix inventoryFix) {
            this.inventoryFix = inventoryFix;
        }

        public void setAssociatedOfferingId(String offeringId) {
            this.offeringId = offeringId == null ? "" : offeringId;
        }

        public String getAssociatedOfferingId() {
            return this.offeringId;
        }

        public int compareTo(Object arg0) {
            if (!(arg0 instanceof InstalledFix)) {
                throw new ClassCastException("Type mismatch: Expecting an InstalledFix object");
            }
            InstalledFix fix2 = (InstalledFix)arg0;
            int compareValue = this.offeringId.compareTo(fix2.getAssociatedOfferingId());
            if (compareValue != 0) {
                return compareValue;
            }
            return this.fixId.compareTo(fix2.getFixId());
        }
    }

    public class InstalledOffering
    implements Comparable {
        private String offeringId;
        private IInstalledProduct installedProduct = null;
        private IOffering repositoryOffering = null;
        private IOffering inventoryOffering = null;
        private boolean isBaseOffering = Boolean.FALSE;

        public InstalledOffering(String offeringId, IInstalledProduct installedProduct) {
            log.debug("SyncLocation.InstalledOffering enter");
            this.offeringId = offeringId != null ? offeringId : "";
            this.installedProduct = installedProduct;
            log.debug("SyncLocation.InstalledOffering exit");
        }

        public PakToFeatureMap getPakToFeatureMap() {
            log.debug("SyncLocation.InstalledOffering.getPakToFeatureMap enter");
            IOffering offering = null;
            if (this.repositoryOffering != null) {
                offering = this.repositoryOffering;
            } else if (this.inventoryOffering != null) {
                offering = this.inventoryOffering;
            } else {
                return null;
            }
            PakToFeatureMap pakToFeatureMap = new PakToFeatureMap(offering);
            pakToFeatureMap.loadPakToFeatureMapping();
            log.debug("SyncLocation.InstalledOffering.getPakToFeatureMap exit");
            return pakToFeatureMap;
        }

        public IFeature[] getInstalledFeatures() {
            return this.getInstalledFeatures(this.getPakToFeatureMap());
        }

        public IFeature[] getInstalledFeatures(PakToFeatureMap pakToFeatureMap) {
            log.debug("SyncLocation.InstalledOffering.getInstalledFeatures enter");
            PakToFeatureMap.PakToFeatureMapEntry[] pakToFeatureMapEntries = pakToFeatureMap.getPakToFeatureMapEntries();
            String[] installedPaks = this.getInstalledPaks();
            ArrayList<IFeature> features = new ArrayList<IFeature>();
            this.addRequiredFeatures(features);
            PakUtils pakUtils = new PakUtils();
            if (pakToFeatureMapEntries != null) {
                PakToFeatureMap.PakToFeatureMapEntry[] pakToFeatureMapEntryArray = pakToFeatureMapEntries;
                int n = pakToFeatureMapEntries.length;
                int n2 = 0;
                while (n2 < n) {
                    IFeature feature;
                    PakToFeatureMap.PakToFeatureMapEntry pakToFeatureMapEntrie = pakToFeatureMapEntryArray[n2];
                    String payload = pakToFeatureMapEntrie.getPayload();
                    boolean pakInstalled = SyncUtil.compareVersion("0.0.0.0", pakUtils.getPakVersionForThisPayloadId(SyncLocation.this.location, payload)) == -1;
                    int j = 0;
                    while (j < installedPaks.length && !pakInstalled) {
                        pakInstalled = installedPaks[j].endsWith(payload);
                        ++j;
                    }
                    if (pakInstalled && (feature = pakToFeatureMapEntrie.getFeature()) != null && !features.contains(feature)) {
                        features.add(feature);
                    }
                    ++n2;
                }
            }
            features.trimToSize();
            log.debug("SyncLocation.InstalledOffering.getInstalledFeatures exit");
            return features.toArray(new IFeature[features.size()]);
        }

        private void addRequiredFeatures(ArrayList features) {
            log.debug("SyncLocation.InstalledOffering.addRequiredFeatures enter");
            List allFeatures = this.repositoryOffering != null ? this.getAllFeatures(this.repositoryOffering.getFeatureGroup()) : this.getAllFeatures(this.inventoryOffering.getFeatureGroup());
            for (IFeature feature : allFeatures) {
                if (features.contains(feature) || !feature.isRequired()) continue;
                features.add(feature);
            }
            log.debug("SyncLocation.InstalledOffering.addRequiredFeatures exit");
        }

        public IFeature[] getImportFeatures() {
            log.debug("SyncLocation.InstalledOffering.getInvisibleImportFeatures enter");
            List allFeatures = this.repositoryOffering != null ? this.getAllFeatures(this.repositoryOffering.getFeatureGroup()) : this.getAllFeatures(this.inventoryOffering.getFeatureGroup());
            ArrayList<IFeature> features = new ArrayList<IFeature>();
            for (IFeature feature : allFeatures) {
                if (features.contains(feature) || !feature.isSelectedByDefault() || feature.isVisible() || !feature.getIdentity().getId().toLowerCase().startsWith("import.")) continue;
                features.add(feature);
            }
            log.debug("SyncLocation.InstalledOffering.getInvisibleImportFeatures exit");
            return features.toArray(new IFeature[features.size()]);
        }

        public IFeature[] getInstalledImportFeatures() {
            log.debug("SyncLocation.InstalledOffering.addInstalledInvisibleImportFeatures enter");
            if (this.installedProduct.getPropertiesFile().exists()) {
                return this.getImportFeatures();
            }
            log.debug("SyncLocation.InstalledOffering.addInstalledInvisibleImportFeatures exit");
            return new IFeature[0];
        }

        private List getAllFeatures(IFeatureGroup featureGroup) {
            log.debug("SyncLocation.InstalledOffering.getAllFeatures enter");
            ArrayList features = new ArrayList();
            if (featureGroup != null) {
                features.addAll(featureGroup.getFeatures());
                for (IFeatureGroup innerGroup : featureGroup.getGroups()) {
                    features.addAll(this.getAllFeatures(innerGroup));
                }
            }
            log.debug("SyncLocation.InstalledOffering.getAllFeatures exit");
            return features;
        }

        public String getOfferingNameAndVersion() {
            log.debug("SyncLocation.InstalledOffering.getOfferingNameAndVersion enter");
            String description = this.getOfferingName();
            if (!"".equals(description)) {
                description = String.valueOf(description) + " " + this.getCurrentVersion();
            }
            log.debug("SyncLocation.InstalledOffering.getOfferingNameAndVersion exit");
            return description;
        }

        public String getOfferingName() {
            log.debug("SyncLocation.InstalledOffering.getOfferingName enter");
            String description = "";
            if (this.inventoryOffering != null) {
                description = this.inventoryOffering.getInformation().getName();
            } else if (this.repositoryOffering != null) {
                description = this.repositoryOffering.getInformation().getName();
            }
            log.debug("SyncLocation.InstalledOffering.getOfferingName exit");
            return description;
        }

        public String getInventoryExternalVersion() {
            return this.inventoryOffering != null ? SyncUtil.convertInternalVersionToExternalVersion(this.inventoryOffering.getVersion().toString()) : "";
        }

        public Map getProductsWithOutOfSyncVersion() {
            log.debug("SyncLocation.InstalledOffering.getProductsWithOutOfSyncVersions enter");
            IOffering offering = this.repositoryOffering != null ? this.repositoryOffering : this.inventoryOffering;
            SyncProductVersionMap productVersionMap = new SyncProductVersionMap(SyncLocation.this.location, offering);
            HashMap<String, String> descriptionVersionMap = new HashMap<String, String>();
            if (!productVersionMap.loadPakToFeatureMapping()) {
                return descriptionVersionMap;
            }
            SyncProductVersionMap.ProductVersionMapEntry[] productVersionMapEntries = productVersionMap.getProductVersionMapEntries();
            String currentVersion = this.getCurrentVersion();
            SyncProductVersionMap.ProductVersionMapEntry[] productVersionMapEntryArray = productVersionMapEntries;
            int n = productVersionMapEntries.length;
            int n2 = 0;
            while (n2 < n) {
                SyncProductVersionMap.ProductVersionMapEntry productVersionMapEntrie = productVersionMapEntryArray[n2];
                String version = productVersionMapEntrie.getVersion();
                if (!"0.0.0.0".equals(version) && SyncUtil.compareVersion(currentVersion, version) != 0) {
                    descriptionVersionMap.put(productVersionMapEntrie.getDescription(), version);
                }
                ++n2;
            }
            log.debug("SyncLocation.InstalledOffering.getProductsWithOutOfSyncVersions exit");
            return descriptionVersionMap;
        }

        public String getCurrentVersion() {
            return this.installedProduct.getCurrentlyInstalledVersion();
        }

        public String getOfferingId() {
            return this.offeringId;
        }

        public void setOfferingId(String offeringId) {
            this.offeringId = offeringId;
        }

        public String[] getInstalledVersions() {
            return this.installedProduct.isInitialized() ? this.installedProduct.getInstalledVersions() : new String[]{};
        }

        public String[] getInstalledPaks() {
            return this.installedProduct.isInitialized() ? this.installedProduct.getInstalledPaks() : new String[]{};
        }

        public String getProductName() {
            return this.installedProduct.isInitialized() ? this.installedProduct.getProductName() : "";
        }

        public boolean isBase() {
            return this.isBaseOffering;
        }

        public IOffering getRepositoryOffering() {
            return this.repositoryOffering;
        }

        public void setRepositoryOffering(IOffering repositoryOffering) {
            this.repositoryOffering = repositoryOffering;
        }

        public IOffering getInventoryOffering() {
            return this.inventoryOffering;
        }

        public void setInventoryOffering(IOffering inventoryOffering) {
            this.inventoryOffering = inventoryOffering;
        }

        public void setBase(boolean isBase) {
            this.isBaseOffering = isBase;
        }

        public int compareTo(Object arg0) {
            if (!(arg0 instanceof InstalledOffering)) {
                throw new ClassCastException("Type mismatch: Expecting an InstalledOffering object");
            }
            InstalledOffering installedOffering = (InstalledOffering)arg0;
            int compareValue = 0;
            if (this.isBaseOffering && installedOffering.isBase()) {
                compareValue = installedOffering.getOfferingId().compareTo(this.offeringId);
                if (compareValue == 0) {
                    String instVersion = installedOffering.getCurrentVersion();
                    compareValue = SyncUtil.compareVersion(this.getCurrentVersion(), instVersion);
                }
            } else {
                compareValue = this.isBaseOffering ? -1 : 1;
            }
            return compareValue;
        }
    }

    public static class OfferingOrFixComparator
    implements Comparator {
        public int compare(Object arg1, Object arg2) {
            if (arg1 == null && arg2 == null) {
                return 0;
            }
            if (arg1 == null || !(arg1 instanceof IOfferingOrFix)) {
                return 1;
            }
            if (arg2 == null || !(arg2 instanceof IOfferingOrFix)) {
                return -1;
            }
            IOfferingOrFix offeringOrFix1 = (IOfferingOrFix)arg1;
            IOfferingOrFix offeringOrFix2 = (IOfferingOrFix)arg2;
            if (offeringOrFix1.getIdentity().getId().equals(offeringOrFix2.getIdentity().getId())) {
                return offeringOrFix2.compareVersion((IContent)offeringOrFix1);
            }
            return offeringOrFix1.getIdentity().getId().compareTo(offeringOrFix2.getIdentity().getId());
        }
    }
}

