/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.resync.internal;

import com.ibm.cic.agent.core.Agent;
import com.ibm.cic.common.core.utils.CicMultiStatus;
import com.ibm.cic.common.core.utils.SplitProgressMonitor;
import com.ibm.cic.common.core.utils.Statuses;
import com.ibm.cic.common.logging.Logger;
import com.ibm.ws.resync.internal.Messages;
import com.ibm.ws.sync.core.SyncEngine;
import com.ibm.ws.sync.core.SyncLocation;
import com.ibm.ws.sync.core.internal.SyncUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class MultiSyncEngine {
    public static final String pluginId = "com.ibm.ws.resync.internal.MultiSyncEngine";
    private static final Logger log = Logger.getLogger(MultiSyncEngine.class);
    private List syncLocations;
    private final List syncLocsWithRepos = new ArrayList();
    private boolean repositoryError = Boolean.FALSE;

    public MultiSyncEngine(List syncLocations) {
        if (syncLocations != null) {
            this.syncLocations = syncLocations;
        }
    }

    public IStatus validateRepositories(IProgressMonitor monitor) {
        Status validateStatus = new Status(0, pluginId, "");
        if (this.syncLocations.size() > 0) {
            ArrayList offeringsWithoutRepository = null;
            SplitProgressMonitor spm = new SplitProgressMonitor(monitor, Messages.RepositoryValidationProgressText, this.syncLocations.size());
            for (SyncLocation aLoc : this.syncLocations) {
                log.debug("Need to validate: " + aLoc.getLocation());
                CicMultiStatus status = aLoc.recheckRepositories(spm.next());
                if (!status.isOK()) {
                    log.debug("Required repositories not available: " + aLoc.getLocation());
                    if (offeringsWithoutRepository == null) {
                        offeringsWithoutRepository = new ArrayList();
                    }
                    this.addNewElementsToList(Arrays.asList(aLoc.getAllOfferingsWithoutARepository()), offeringsWithoutRepository);
                } else {
                    this.syncLocsWithRepos.add(aLoc);
                }
                if (!monitor.isCanceled()) continue;
                log.debug("User cancels repository validation.");
                return new Status(8, pluginId, Messages.OperationCancelled);
            }
            if (offeringsWithoutRepository != null && offeringsWithoutRepository.size() > 0) {
                validateStatus = Statuses.ST.createMultiStatus(4, Messages.RepositoryValidationError_Packages, new Object[0]);
                this.addChildrenToMultiStatus((CicMultiStatus)validateStatus, offeringsWithoutRepository);
            }
            spm.done();
        }
        return validateStatus;
    }

    public IStatus performMultiSynchronization(IProgressMonitor monitor) {
        Status syncStatus = new Status(0, pluginId, "");
        this.repositoryError = Boolean.FALSE;
        if (this.syncLocsWithRepos.size() > 0) {
            ArrayList<CicMultiStatus> errors = new ArrayList<CicMultiStatus>();
            ArrayList<String> successes = new ArrayList<String>();
            SplitProgressMonitor spm = new SplitProgressMonitor(monitor, Messages.ResyncProgressText, this.syncLocsWithRepos.size());
            SyncEngine engine = new SyncEngine(Agent.getInstance());
            for (SyncLocation aLoc : this.syncLocsWithRepos) {
                if (aLoc.requiresReSynchronization()) {
                    log.debug("Need to resync: " + aLoc.getLocation());
                    IStatus status = SyncUtil.checkAgentRequirement(aLoc, true);
                    if (status.isOK()) {
                        status = engine.performSynchronization(aLoc, spm.next());
                        boolean bl = this.repositoryError = this.repositoryError || status.isOK();
                    }
                    if (!status.isOK()) {
                        log.debug("Errors in resynchronization: " + aLoc.getLocation());
                        log.status(status);
                        errors.add(Statuses.ST.createMultiStatusWithChild(status, aLoc.getLocation(), new Object[0]));
                    } else {
                        log.debug("Success in resynchronization: " + aLoc.getLocation());
                        successes.add(aLoc.getLocation());
                    }
                }
                if (!monitor.isCanceled()) continue;
                log.debug("User cancels resynchronization.");
                CicMultiStatus cancelStatus = Statuses.ST.createMultiStatus(8, Messages.OperationCancelled, new Object[0]);
                if (!errors.isEmpty()) {
                    cancelStatus.add((IStatus)this.addChildrenToMultiStatus(Statuses.ST.createMultiStatus(8, Messages.ResyncError_Locations, new Object[0]), errors, 8));
                    cancelStatus.add((IStatus)new Status(1, pluginId, ""));
                }
                if (!successes.isEmpty()) {
                    cancelStatus.add((IStatus)this.addChildrenToMultiStatus(Statuses.ST.createMultiStatus(8, Messages.ResyncSuccess_Locations, new Object[0]), successes, 8));
                }
                return cancelStatus;
            }
            if (!errors.isEmpty()) {
                syncStatus = Statuses.ST.createMultiStatus(4, "", new Object[0]);
                ((CicMultiStatus)syncStatus).add((IStatus)this.addChildrenToMultiStatus(Statuses.ST.createMultiStatus(4, Messages.ResyncError_Locations, new Object[0]), errors));
                if (!successes.isEmpty()) {
                    ((CicMultiStatus)syncStatus).add((IStatus)new Status(1, pluginId, ""));
                    ((CicMultiStatus)syncStatus).add((IStatus)this.addChildrenToMultiStatus(Statuses.ST.createMultiStatus(1, Messages.ResyncSuccess_Locations, new Object[0]), successes, 1));
                }
            }
            spm.done();
        }
        return syncStatus;
    }

    public boolean hasSynchronizableLocations() {
        return this.syncLocsWithRepos.size() > 0;
    }

    protected List addNewElementsToList(List fromList, List toList) {
        int i = 0;
        while (i < fromList.size()) {
            if (!toList.contains(fromList.get(i))) {
                toList.add(fromList.get(i));
            }
            ++i;
        }
        return toList;
    }

    protected CicMultiStatus addChildrenToMultiStatus(CicMultiStatus parent, List children) {
        return this.addChildrenToMultiStatus(parent, children, 4);
    }

    protected CicMultiStatus addChildrenToMultiStatus(CicMultiStatus parent, List children, int childrenSeverity) {
        for (Object child : children) {
            if (child instanceof String) {
                parent.add((IStatus)new Status(childrenSeverity, pluginId, (String)child));
                continue;
            }
            if (!(child instanceof IStatus)) continue;
            parent.add((IStatus)child);
        }
        return parent;
    }

    public boolean hasRepositoryError() {
        return this.repositoryError;
    }
}

