/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.pak.core.internal.install;

import com.ibm.ws.pak.core.PakMessages;
import com.ibm.ws.pak.core.internal.Engine;
import com.ibm.ws.pak.core.internal.action.InitProductPluginsAction;
import com.ibm.ws.pak.core.internal.action.NGIAction;
import com.ibm.ws.pak.core.internal.action.PakInstallAction;
import com.ibm.ws.pak.core.internal.failurerecovery.IPakFailureRecovery;
import com.ibm.ws.pak.core.internal.failurerecovery.PakFailureRecovery;
import com.ibm.ws.pak.core.internal.install.IPakInstaller;
import com.ibm.ws.pak.internal.NIFConstants;
import com.ibm.ws.pak.internal.NIFException;
import com.ibm.ws.pak.internal.NIFPluginImplOverridePlugin;
import com.ibm.ws.pak.internal.install.metadata.NIFHistory;
import com.ibm.ws.pak.internal.install.metadata.NIFStack;
import com.ibm.ws.pak.internal.install.registry.NIFRegistryPlugin;
import com.ibm.ws.pak.internal.utils.URIUtils;
import com.ibm.ws.pak.internal.utils.filesystems.FileSystem;
import com.ibm.ws.pak.internal.utils.filesystems.FileSystemEntry;
import com.ibm.ws.pak.internal.utils.installtoolkitbridge.InstallToolkitBridge;
import com.ibm.ws.pak.internal.utils.logging.Logr;
import com.ibm.ws.pak.internal.utils.macroresolvers.MacroResolver;
import com.ibm.ws.pak.internal.utils.product.ProductPlugin;
import java.beans.PropertyChangeEvent;
import java.io.File;
import java.util.Enumeration;
import java.util.Properties;

public class PakInstaller
extends Engine
implements IPakInstaller {
    static final String className = "PakInstaller";
    static InstallToolkitBridge m_itb = null;
    IPakFailureRecovery m_PakFailureRecovery = null;

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        Logr.debug((String)("PakInstaller.propertyChange() PropertyChangeEvent=" + evt.getPropertyName() + " old=" + evt.getOldValue() + " value=" + evt.getNewValue() + " source=" + evt.getSource()));
        if (evt.getPropertyName().equals("PakInstallAction")) {
            this.firePropertyChange("pakInstallOverallProgress", (Integer)evt.getOldValue(), (Integer)evt.getNewValue());
        } else {
            this.firePropertyChange("pakProcessingComponent", (String)evt.getOldValue(), (String)evt.getNewValue());
        }
    }

    private InstallToolkitBridge initializePakInstaller(Properties properties) throws Exception {
        MacroResolver.cleanCachedMacros();
        FileSystem.flushAllFileSystems();
        NIFStack.close();
        NIFHistory.close();
        InstallToolkitBridge itb = this.getInstallToolkitBridgeObject(properties);
        NIFPluginImplOverridePlugin.bootstrapPluginImplOverrides((InstallToolkitBridge)itb);
        this.initializeProductProviders(properties, itb);
        this.initializeMaintenanceInfoPlugin(properties, itb);
        return itb;
    }

    @Override
    public int installPak(Properties properties) throws Exception {
        Logr.methodEntry((String)className, (String)"installPak");
        if (this.isOS390()) {
            throw new Exception(PakMessages.PAK_PAK_ACTION_NOT_SUPPORTED_ZOS);
        }
        if (this.isOS400()) {
            throw new Exception(PakMessages.PAK_PAK_ACTION_NOT_SUPPORTED_OS400);
        }
        int rc = this.initializeProperties(properties);
        if (rc == 1) {
            Logr.error((String)PakMessages.PAK_INSTALLER_PROPERTIES_EMPTY);
            return 1;
        }
        try {
            m_itb = this.initializePakInstaller(properties);
            this.initializeFailureRecovery(properties, m_itb);
            rc = this.installPak(properties, m_itb);
            this.settleNIFRegistry(m_itb);
            Logr.methodReturn((String)className, (String)"installPak", (Object)new Integer(rc).toString());
            Logr.methodExit((String)className, (String)"installPak");
            return rc;
        }
        catch (Exception e) {
            Logr.error((String)className, (String)"installPak", (String)e.getMessage(), (Exception)e);
            throw e;
        }
    }

    private int initializeProperties(Properties properties) {
        Logr.methodEntry((String)className, (String)"initializeProperties");
        if (properties == null || properties.size() == 0) {
            Logr.debug((String)"PakInstaller.initializeProperties() : install properties.size=0");
            return 1;
        }
        Enumeration<Object> e = properties.keys();
        while (e.hasMoreElements()) {
            Object k = e.nextElement();
            Object v = properties.get(k);
            Logr.debug((String)("PakInstaller : property key=" + k + " value=" + v));
        }
        System.setProperty("installSource", properties.getProperty("installSource"));
        System.setProperty("user.dir", properties.getProperty("installSource"));
        NIFConstants.setBackuppath((String)properties.getProperty("backuppath"));
        NIFConstants.setProperty((String)"com.ibm.was.process.type", (String)properties.getProperty("nifregistryInstallType"));
        if (properties.getProperty("metadata.dir") != null) {
            NIFConstants.setMetadataDirectory((String)properties.getProperty("metadata.dir"));
        }
        Logr.methodExit((String)className, (String)"initializeProperties");
        return 0;
    }

    private int initializeFailureRecovery(Properties properties, InstallToolkitBridge itb) throws Exception {
        this.m_PakFailureRecovery = new PakFailureRecovery();
        if (this.m_PakFailureRecovery.initializeFailureRecovery(properties, itb) != 0) {
            return 1;
        }
        if (properties.getProperty("pakengineoperation").equals("INSTALL")) {
            this.m_PakFailureRecovery.setInstallAsCurrentStage();
        } else if (properties.getProperty("pakengineoperation").equals("UNINSTALL")) {
            this.m_PakFailureRecovery.setUninstallAsCurrentStage();
        }
        return 0;
    }

    private int performFailureRecovery(InstallToolkitBridge itb) {
        if (this.m_PakFailureRecovery == null) {
            this.m_PakFailureRecovery = new PakFailureRecovery();
        }
        try {
            return this.m_PakFailureRecovery.executeFailureRecovery();
        }
        catch (Exception e) {
            Logr.warn((String)className, (String)"performFailureRecovery", (String)e.getMessage(), (Exception)e);
            return 1;
        }
    }

    private int initializeProductProviders(Properties properties, InstallToolkitBridge itb) throws Exception {
        Logr.methodEntry((String)className, (String)"initializeProductProviders");
        File productproviderPath = null;
        String sPathToProductProvidersXML = properties.getProperty("productProvidersXML");
        productproviderPath = sPathToProductProvidersXML == null || sPathToProductProvidersXML.equals("") ? new File(String.valueOf(NIFConstants.getMetadataDirectory()) + "/framework/productproviders.xml") : new File(sPathToProductProvidersXML);
        if (!productproviderPath.exists()) {
            String msg = PakMessages.bind((String)PakMessages.PAK_PAK_ACTION_PRODUCTPROVIDER_NOT_FOUND, (Object)productproviderPath.getAbsoluteFile());
            Logr.error((String)msg);
            throw new Exception(msg);
        }
        Logr.debug((String)("Loading productprovider : " + productproviderPath.getAbsolutePath()));
        FileSystemEntry fseProductProviders = URIUtils.convertPathToDefaultSourceMachineFSE((String)productproviderPath.getAbsolutePath(), (InstallToolkitBridge)itb);
        String sProductProviderXMLURI = null;
        sProductProviderXMLURI = fseProductProviders.getURI().toString();
        InitProductPluginsAction initProductProviders = new InitProductPluginsAction(itb, new String[]{sProductProviderXMLURI}, new String[]{"products/supported-products"});
        initProductProviders.execute();
        ProductPlugin.cacheAggregatedProductPlugin();
        ProductPlugin.resetProductPluginIfNeeded((String)properties.getProperty("wsglobalinstallconstantsProductBean.customProperties,productType"), (String)properties.getProperty("productgaversion"));
        return 0;
    }

    private int initializeMaintenanceInfoPlugin(Properties properties, InstallToolkitBridge itb) throws Exception {
        Logr.methodEntry((String)className, (String)"initializeMaintenanceInfoPlugin");
        FileSystemEntry fseMeta = URIUtils.convertPathToDefaultSourceMachineFSE((String)properties.getProperty("wsglobalinstallconstantsProductBean.selectedMaintenancePackages"), (InstallToolkitBridge)itb);
        String sMaintenanceXMLURI = new FileSystemEntry(fseMeta.getURI(), "maintenance.xml", itb).getURI().toString();
        NGIAction initMaintenanceInfoPlugin = new NGIAction(itb, new String[]{sMaintenanceXMLURI}, new String[]{"install-package/information"});
        initMaintenanceInfoPlugin.execute();
        Logr.methodExit((String)className, (String)"initializeMaintenanceInfoPlugin");
        return 0;
    }

    private int installPak(Properties properties, InstallToolkitBridge itb) throws Exception {
        Logr.methodEntry((String)className, (String)"installPak");
        FileSystemEntry fseMeta = URIUtils.convertPathToDefaultSourceMachineFSE((String)properties.getProperty("wsglobalinstallconstantsProductBean.selectedMaintenancePackages"), (InstallToolkitBridge)itb);
        String sMaintenanceXMLURI = new FileSystemEntry(fseMeta.getURI(), "maintenance.xml", itb).getURI().toString();
        Logr.debug((String)("Starting the installation of " + properties.getProperty("wsglobalinstallconstantsProductBean.selectedMaintenancePackages")));
        PakInstallAction installAction = new PakInstallAction(itb, new String[]{sMaintenanceXMLURI}, new String[]{"install-package/deploy-satellites"});
        installAction.addPropertyChangeListener(this);
        int rtn = installAction.execute();
        if (rtn != 0) {
            this.performFailureRecovery(itb);
        }
        installAction.removePropertyChangeListener(this);
        if (rtn != 0) {
            String sMsg = PakMessages.bind((String)PakMessages.PAK_PAK_ACTION_FAILED, (Object)new Integer(rtn).toString());
            Logr.error((String)sMsg);
            throw new NIFException(sMsg);
        }
        Logr.debug((String)("Finished the installation of " + properties.getProperty("wsglobalinstallconstantsProductBean.selectedMaintenancePackages")));
        Logr.methodReturn((String)className, (String)"installPak", (Object)new Integer(rtn).toString());
        return rtn;
    }

    public void settleNIFRegistry(InstallToolkitBridge itb) {
        try {
            Logr.methodEntry((String)className, (String)"settleNIFRegistry");
            NIFRegistryPlugin nifrp = NIFRegistryPlugin.getNIFRegistryPlugin((InstallToolkitBridge)itb);
            String sInstallType = NIFConstants.getProperty((String)"com.ibm.was.process.type");
            nifrp.processCurrentOfferingRegistryEntry(sInstallType, null);
            Logr.methodExit((String)className, (String)"settleNIFRegistry");
        }
        catch (Exception e) {
            Logr.error((String)className, (String)"settleNIFRegistry", (String)e.getMessage(), (Exception)e);
        }
    }

    private boolean isOS390() {
        return System.getProperty("os.name").equalsIgnoreCase("z/OS") || System.getProperty("os.name").equalsIgnoreCase("zos");
    }

    private boolean isOS400() {
        return System.getProperty("os.name").equalsIgnoreCase("OS/400") || System.getProperty("os.name").equalsIgnoreCase("os400");
    }
}

