/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.security.storage;

import com.ibm.cic.common.core.auth.PasswordChangeDirection;
import com.ibm.cic.common.core.auth.PasswordManager;
import com.ibm.cic.common.core.cmd.KeyringCommands;
import com.ibm.cic.common.core.preferences.CicCommonSettings;
import com.ibm.cic.common.core.utils.ApplicationArguments;
import com.ibm.cic.common.core.utils.Encodings;
import com.ibm.cic.common.core.utils.FileUtil;
import com.ibm.cic.common.core.utils.StandardInputDetector;
import com.ibm.cic.common.downloads.CredentialInfo;
import com.ibm.cic.common.downloads.CredentialPrompter;
import com.ibm.cic.common.downloads.CredentialRequested;
import com.ibm.cic.common.downloads.ICredentialPrompter;
import com.ibm.cic.common.downloads.ICredentialValidator;
import com.ibm.cic.common.logging.Logger;
import com.ibm.cic.common.ui.internal.dialogs.StorageLoginDialog;
import com.ibm.cic.common.ui.utils.DisplayKeeper;
import com.ibm.cic.common.ui.utils.WindowUtils;
import com.ibm.cic.security.storage.Messages;
import java.io.File;
import java.io.IOException;
import java.util.Scanner;
import javax.crypto.spec.PBEKeySpec;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.equinox.security.storage.EncodingUtils;
import org.eclipse.equinox.security.storage.provider.IPreferencesContainer;
import org.eclipse.equinox.security.storage.provider.PasswordProvider;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class CicPasswordProvider
extends PasswordProvider {
    private static final String PREMADE_PASSWORD = "hu6RucrUsTuS5uQaprUY";
    private boolean triedPremadePassword = false;
    private boolean displayedBadMasterPasswordFileError = false;
    private static final Logger log = Logger.getLogger(CicPasswordProvider.class);

    private boolean isRunningGUI() {
        return CicCommonSettings.isZOS() ? false : WindowUtils.runningUI();
    }

    public PBEKeySpec getPassword(IPreferencesContainer container, int passwordType) {
        PBEKeySpec result = null;
        String password = null;
        boolean showUI = this.isRunningGUI();
        boolean newPassword = (passwordType & 1) != 0;
        boolean passwordChange = (passwordType & 2) != 0;
        String location = container.getLocation().getFile();
        ApplicationArguments appArguments = ApplicationArguments.getInstance();
        String passwordFilePath = appArguments.getNextArg(KeyringCommands.CMD_MASTER_PASSWORD_FILE);
        if (passwordFilePath != null) {
            try {
                password = Encodings.DEFAULT.read(new File(passwordFilePath)).trim();
            }
            catch (IOException e) {
                log.error(Messages.CicPasswordProvider_ProblemReadingMasterPasswordFile, new Object[]{passwordFilePath, e.getMessage()});
            }
        } else if (appArguments.contains("-prompt") || this.isConsoleMode() || showUI) {
            if (!this.triedPremadePassword && !newPassword) {
                password = PREMADE_PASSWORD;
                this.triedPremadePassword = true;
            } else if (!showUI) {
                password = this.isConsoleMode() && passwordChange && newPassword && PasswordManager.INSTANCE.getChangeDirection() == PasswordChangeDirection.TO_DEFAULT ? PREMADE_PASSWORD : this.obtainPasswordCmdLine(newPassword);
            } else if (passwordChange && newPassword && PasswordManager.INSTANCE.getChangeDirection() == PasswordChangeDirection.TO_DEFAULT) {
                password = PREMADE_PASSWORD;
            } else {
                final StorageLoginDialog loginDialog = new StorageLoginDialog(newPassword, passwordChange, location);
                if (!passwordChange) {
                    this.antiDeadlock();
                }
                final String[] dialogResult = new String[1];
                PasswordManager.INSTANCE.setPasswordDialogCanceled(false);
                PlatformUI.getWorkbench().getDisplay().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (loginDialog.open() == 0) {
                            dialogResult[0] = loginDialog.usesMasterPassword() ? loginDialog.getPassword() : CicPasswordProvider.PREMADE_PASSWORD;
                        } else {
                            dialogResult[0] = null;
                            PasswordManager.INSTANCE.setPasswordDialogCanceled(true);
                        }
                    }
                });
                password = dialogResult[0];
            }
        } else {
            password = PREMADE_PASSWORD;
        }
        PasswordManager.INSTANCE.useDefault(password != null && password.equals(PREMADE_PASSWORD));
        if (password != null && !password.equals("")) {
            password = EncodingUtils.encodeBase64((byte[])Encodings.UTF8.toBytes(password));
            result = new PBEKeySpec(password.toCharArray());
        }
        return result;
    }

    private String obtainPasswordCmdLine(boolean newPassword) {
        String password;
        if (newPassword) {
            while (true) {
                boolean validEntry;
                String passwordConf;
                if (System.console() != null) {
                    password = FileUtil.readPasswordFromStdIn((String)Messages.CicPasswordProvider_NewSetupPrompt);
                    passwordConf = FileUtil.readPasswordFromStdIn((String)Messages.CicPasswordProvider_NewSetupPromptConfirmation);
                } else {
                    Scanner scanner = new Scanner(System.in);
                    System.out.println(Messages.CicPasswordProvider_NewSetupPrompt);
                    password = scanner.nextLine();
                    System.out.println(Messages.CicPasswordProvider_NewSetupPromptConfirmation);
                    passwordConf = scanner.nextLine();
                    scanner.close();
                }
                boolean bl = validEntry = password != null && !password.equals("");
                if (!validEntry) {
                    System.out.println(Messages.CicPasswordProvider_EmptyPassword);
                    continue;
                }
                if (!password.contentEquals(passwordConf)) {
                    System.out.println(Messages.CicPasswordProvider_NewSetupPromptConfirmationError);
                    continue;
                }
                break;
            }
        } else {
            password = FileUtil.readPasswordFromStdIn((String)Messages.CicPasswordProvider_UnlockPrompt);
        }
        return password;
    }

    private boolean isConsoleMode() {
        ApplicationArguments appArguments = ApplicationArguments.getInstance();
        return appArguments.contains("-c") || appArguments.contains("-consoleMode");
    }

    public boolean retryOnError(Exception e, IPreferencesContainer container) {
        if (ApplicationArguments.getInstance().contains(KeyringCommands.CMD_MASTER_PASSWORD_FILE)) {
            this.antiDeadlock();
            if (!this.displayedBadMasterPasswordFileError) {
                this.showError(Messages.exceptionBadPasswordInFile);
                this.displayedBadMasterPasswordFileError = true;
            }
            return false;
        }
        if (PasswordManager.INSTANCE.isDefault()) {
            return true;
        }
        if (!this.isRunningGUI()) {
            String location = container.getLocation().getFile();
            System.out.println(NLS.bind((String)Messages.CicPasswordProvider_incorrectMasterPasswordSilentModeMessage, (Object)location));
            if (StandardInputDetector.INSTANCE.isActive()) {
                CredentialPrompter.INSTANCE.setPrompter(new ICredentialPrompter(){

                    public IStatus askUserIdAndPassword(ICredentialValidator validator, String connectMessage, CredentialRequested requested, CredentialInfo previous, CredentialInfo[] ret) {
                        return Status.CANCEL_STATUS;
                    }
                });
                return false;
            }
            return true;
        }
        this.showError(Messages.exceptionDecode);
        return true;
    }

    private void antiDeadlock() {
        try {
            Thread.sleep(805L);
        }
        catch (InterruptedException e) {
            log.warning((Throwable)e);
        }
    }

    private void showError(final String message) {
        if (this.isRunningGUI()) {
            DisplayKeeper.INSTANCE.getDisplay().syncExec(new Runnable(){

                @Override
                public void run() {
                    MessageDialog.openError((Shell)WindowUtils.calculateShell(), (String)Messages.exceptionTitle, (String)message);
                }
            });
        } else {
            System.out.println(message);
        }
    }
}

