/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.licensing.policy.ui.viewers;

import com.ibm.cic.licensing.common.util.LicensePolicyData;
import com.ibm.cic.licensing.policy.ui.Messages;
import com.ibm.cic.licensing.policy.ui.dialogs.OfferingDialog;
import com.ibm.cic.licensing.policy.ui.dialogs.TableItemEditDialog;
import com.ibm.cic.licensing.policy.ui.viewers.EditableTableViewer;
import com.ibm.cic.licensing.policy.ui.viewers.LicensePolicyViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.osgi.framework.Version;

public class OfferingMapViewer
extends LicensePolicyViewer {
    public OfferingMapViewer(Composite parent, EditableTableViewer.IFormAdapter formAdapter) {
        super(parent, formAdapter);
    }

    public OfferingMapViewer(Composite parent, EditableTableViewer.IFormAdapter formAdapter, int buttonsMask) {
        super(parent, formAdapter, buttonsMask);
    }

    public OfferingMapViewer(Composite parent) {
        this(parent, null);
    }

    protected Control createControl(Composite parent) {
        Composite outerContainer = (Composite)super.createControl(parent);
        this.setReadonlyCheckButtonText(Messages.offeringsReadonlyCheckButtonText);
        this.createTable(outerContainer);
        return outerContainer;
    }

    public Object getValue(Object element, String property) {
        LicensePolicyData.OfferingData offering = (LicensePolicyData.OfferingData)element;
        if (property.equals(Messages.offeringIdColumnTitleText)) {
            return offering.getId();
        }
        if (property.equals(Messages.offeringVersionColumnTitleText)) {
            return offering.getVersion().toString();
        }
        return null;
    }

    public void modify(Object element, String property, Object value) {
        TableItem item = (TableItem)element;
        LicensePolicyData.OfferingData offering = (LicensePolicyData.OfferingData)item.getData();
        if (property.equals(Messages.offeringIdColumnTitleText)) {
            offering.setId((String)value);
        } else if (property.equals(Messages.offeringVersionColumnTitleText)) {
            offering.setVersion(new Version((String)value));
        }
        this.tableViewer.update((Object)offering, null);
    }

    protected TableItemEditDialog createNewDialog() {
        return this.createOfferingDialog(this.getControl().getShell(), Messages.newOffering, null);
    }

    protected TableItemEditDialog createEditDialog(String[] initialValues) {
        return this.createOfferingDialog(this.getControl().getShell(), Messages.editOffering, initialValues);
    }

    protected TableItemEditDialog createOfferingDialog(Shell shell, String title, String[] initialValues) {
        return new OfferingDialog(shell, title, initialValues);
    }

    protected Object createNewData(String[] values) {
        LicensePolicyData.OfferingMapData offeringMapData = (LicensePolicyData.OfferingMapData)this.data;
        LicensePolicyData.OfferingData offeringData = new LicensePolicyData.OfferingData(values[0], new Version(values[1]), values[2]);
        if (offeringMapData.getOffering(offeringData.toKeyString()) == null) {
            offeringMapData.addOffering(offeringData);
            return offeringData;
        }
        return null;
    }

    protected void setDataValues(Object data, String[] values) {
        LicensePolicyData.OfferingData offering = (LicensePolicyData.OfferingData)data;
        offering.setId(values[0]);
        offering.setVersion(new Version(values[1]));
    }

    private void createTable(Composite parent) {
        this.createTable(parent, "", 4);
        final Table table = this.tableViewer.getTable();
        TableColumn idColumn = new TableColumn(table, 0);
        idColumn.setWidth(150);
        idColumn.setText(Messages.offeringIdColumnTitleText);
        TableColumn verColumn = new TableColumn(table, 0);
        verColumn.setWidth(this.fontMetrics.getAverageCharWidth() * Math.max(2 * Messages.offeringVersionColumnTitleText.length(), 15));
        verColumn.setText(Messages.offeringVersionColumnTitleText);
        this.initializeCellEditors();
        this.tableViewer.setLabelProvider((IBaseLabelProvider)new EditableTableViewer.AbstractTableLabelProvider(){

            public String getColumnText(Object element, int columnIndex) {
                if (element instanceof LicensePolicyData.OfferingData) {
                    LicensePolicyData.OfferingData offeringData = (LicensePolicyData.OfferingData)element;
                    switch (columnIndex) {
                        case 0: {
                            return offeringData.getName();
                        }
                        case 1: {
                            return offeringData.getVersion().toString();
                        }
                    }
                }
                return null;
            }
        });
        table.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                int tableWidth = table.getClientArea().width;
                TableColumn idCol = table.getColumn(0);
                TableColumn typeCol = table.getColumn(1);
                idCol.setWidth(tableWidth - typeCol.getWidth());
            }
        });
    }

    public TableViewer getTableViewer() {
        return this.tableViewer;
    }
}

