/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.licensing.policy.ui.dialogs;

import java.util.Arrays;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public abstract class TableItemEditDialog
extends Dialog {
    private final String title;
    private final String[] labels;
    protected String[] itemValues;
    protected Control[] itemControl;

    public TableItemEditDialog(Shell parentShell, String title, String[] labels, String[] initialValues) {
        super(parentShell);
        this.setShellStyle(this.getShellStyle() | 0x10);
        this.title = title;
        this.labels = labels;
        this.itemValues = new String[labels.length];
        if (initialValues == null) {
            Arrays.fill(this.itemValues, "");
        } else {
            int i = 0;
            while (i < initialValues.length) {
                this.itemValues[i] = initialValues[i];
                ++i;
            }
        }
    }

    public String[] getItemValues() {
        return this.itemValues;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(this.title);
    }

    protected void createButtonsForButtonBar(Composite parent) {
        super.createButtonsForButtonBar(parent);
        this.validateInput();
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        Font font = composite.getFont();
        Composite outerContainer = new Composite(composite, 0);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.numColumns = 2;
        outerContainer.setLayout((Layout)layout);
        outerContainer.setLayoutData((Object)new GridData(1808));
        outerContainer.setFont(font);
        this.itemControl = new Control[this.labels.length];
        int i = 0;
        while (i < this.labels.length) {
            Label label = new Label(outerContainer, 0);
            label.setText(this.labels[i]);
            label.setLayoutData((Object)new GridData());
            label.setFont(font);
            this.itemControl[i] = this.createItemControl(outerContainer, i);
            ++i;
        }
        return composite;
    }

    protected Control createItemControl(Composite parent, int itemIndex) {
        Font font = parent.getFont();
        Text text = new Text(parent, 2052);
        text.setLayoutData((Object)new GridData(768));
        text.setFont(font);
        text.setText(this.itemValues[itemIndex]);
        text.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                TableItemEditDialog.this.validateInput();
            }
        });
        return text;
    }

    protected String getItemControlText(int itemIndex) {
        Text text = (Text)this.itemControl[itemIndex];
        return text.getText();
    }

    protected void buttonPressed(int buttonId) {
        if (buttonId == 0) {
            int i = 0;
            while (i < this.itemControl.length) {
                this.itemValues[i] = this.getItemControlText(i).trim();
                ++i;
            }
        }
        super.buttonPressed(buttonId);
    }

    protected void validateInput() {
        Button okButton = this.getButton(0);
        okButton.setEnabled(this.isValidInput());
    }

    protected boolean isValidInput() {
        int i = 0;
        while (i < this.itemControl.length) {
            if (this.getItemControlText(i).trim().length() == 0) {
                return false;
            }
            ++i;
        }
        return true;
    }
}

