/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.install.info;

import com.ibm.cic.install.info.IInstallInfo;
import com.ibm.cic.install.info.ILocation;
import com.ibm.cic.install.info.ILocationFilter;
import com.ibm.cic.install.info.IPackage;
import com.ibm.cic.install.info.IPackageFilter;
import com.ibm.cic.install.info.internal.InstallInfoParser;
import com.ibm.cic.install.info.internal.Messages;
import com.ibm.cic.install.launcher.internal.Activator;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.service.datalocation.Location;
import org.eclipse.osgi.util.NLS;

public class InstallInfoUtils {
    public static final String INSTALLATION_MANAGER_PACKAGE_ID = "com.ibm.cic.agent";
    public static final String AGENT_LAUNCHER_PROPERTY = "agent.launcher";
    public static final String CIC_APP_DATA_LOCATION = "cic.appDataLocation";
    public static final String INSTALLED_XML = "installed.xml";
    private static long lastModified = 0L;
    private static IInstallInfo installInfo = null;
    private static ILocation imLocation = null;
    private static IPackage imPackage = null;
    private static String imLauncherPath = null;
    private static ILocation currentLocation = null;

    public static synchronized IInstallInfo getInstallInfo() throws CoreException {
        File installInfoFile = InstallInfoUtils.getInstallInfoFile();
        long modified = installInfoFile.lastModified();
        if (installInfo == null || modified == 0L || modified != lastModified) {
            lastModified = modified;
            installInfo = null;
            imLocation = null;
            imPackage = null;
            imLauncherPath = null;
            currentLocation = null;
            installInfo = InstallInfoUtils.getInstallInfo(installInfoFile);
        }
        return installInfo;
    }

    public static IInstallInfo getInstallInfo(File installInfoFile) throws CoreException {
        InstallInfoParser parser = new InstallInfoParser();
        IStatus status = parser.parse(installInfoFile);
        if (!status.isOK()) {
            throw new CoreException(status);
        }
        return parser.getInstallInfo();
    }

    public static ILocation getInstallationManagerLocation() throws CoreException {
        IInstallInfo info = InstallInfoUtils.getInstallInfo();
        if (imLocation == null) {
            ILocationFilter locationFilter = new ILocationFilter(){

                public boolean accept(ILocation location) {
                    return "self".equals(location.getKind());
                }
            };
            ILocation[] locations = info.getLocations(locationFilter);
            if (locations.length != 1) {
                throw InstallInfoUtils.newCoreException(Messages.InstallInfoUtils_missingImLocation);
            }
            imLocation = locations[0];
        }
        return imLocation;
    }

    public static IPackage getInstallationManagerPackage() throws CoreException {
        ILocation imLoc = InstallInfoUtils.getInstallationManagerLocation();
        if (imPackage == null) {
            IPackageFilter packageFilter = new IPackageFilter(){

                public boolean accept(IPackage pkg) {
                    return InstallInfoUtils.INSTALLATION_MANAGER_PACKAGE_ID.equals(pkg.getId());
                }
            };
            IPackage[] packages = imLoc.getPackages(packageFilter);
            if (packages.length != 1) {
                throw InstallInfoUtils.newCoreException(Messages.InstallInfoUtils_missingImPackage);
            }
            imPackage = packages[0];
        }
        return imPackage;
    }

    public static String getInstallationManagerLauncherPath() throws CoreException {
        ILocation imLoc = InstallInfoUtils.getInstallationManagerLocation();
        if (imLauncherPath == null) {
            InstallInfoUtils.getInstallationManagerPackage();
            String path = imLoc.getProperty(AGENT_LAUNCHER_PROPERTY);
            if (path == null || path.trim().length() == 0) {
                throw InstallInfoUtils.newCoreException(Messages.InstallInfoUtils_missingImLauncherPath);
            }
            File file = new File(path);
            if (!file.isFile() || !file.canRead()) {
                String msg = NLS.bind((String)Messages.InstallInfoUtils_missingImLauncher, (Object)path);
                throw InstallInfoUtils.newCoreException(msg);
            }
            imLauncherPath = path;
        }
        return imLauncherPath;
    }

    public static ILocation getCurrentLocation() throws CoreException {
        IInstallInfo info = InstallInfoUtils.getInstallInfo();
        if (currentLocation == null) {
            final String installLocation = InstallInfoUtils.getInstallLocation();
            ILocationFilter locationFilter = new ILocationFilter(){

                public boolean accept(ILocation location) {
                    String path = "existingEclipse".equals(location.getKind()) ? location.getProperty("eclipseLocation") : location.getPath();
                    path = InstallInfoUtils.getCanonicalPath(path);
                    return installLocation.equals(path);
                }
            };
            ILocation[] locations = info.getLocations(locationFilter);
            if (locations.length != 1) {
                throw InstallInfoUtils.newCoreException(Messages.InstallInfoUtils_missingInstallLocation);
            }
            currentLocation = locations[0];
        }
        return currentLocation;
    }

    public static File getInstallInfoFile() throws CoreException {
        String loc = System.getProperty(CIC_APP_DATA_LOCATION);
        if (loc == null) {
            throw InstallInfoUtils.newCoreException(NLS.bind((String)Messages.InstallInfoUtils_missingCicAppDataLocation, (Object)CIC_APP_DATA_LOCATION));
        }
        File file = new File(loc, INSTALLED_XML);
        return file;
    }

    private static String getCanonicalPath(String path) {
        File file = new File(path);
        try {
            return file.getCanonicalPath();
        }
        catch (IOException iOException) {
            return file.getPath();
        }
    }

    private static String getInstallLocation() throws CoreException {
        URL installURL;
        String locProp = System.getProperty("PRODUCT_INSTALL_LOCATION");
        if (locProp != null) {
            return locProp;
        }
        Location location = Platform.getInstallLocation();
        if (location != null && (installURL = location.getURL()) != null) {
            IPath path = new Path(installURL.getFile()).removeTrailingSeparator();
            return InstallInfoUtils.getCanonicalPath(path.toOSString());
        }
        throw InstallInfoUtils.newCoreException(Messages.InstallInfoUtils_noInstallLocation);
    }

    private static CoreException newCoreException(String msg) {
        return InstallInfoUtils.newCoreException(msg, null);
    }

    private static CoreException newCoreException(String msg, Throwable t) {
        Status status = new Status(4, Activator.getPluginId(), 4, msg, t);
        return new CoreException((IStatus)status);
    }

    private InstallInfoUtils() {
    }
}

