/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.xml.core.serial.internal;

import com.ibm.cic.common.xml.core.XMLString;
import com.ibm.cic.common.xml.core.internal.Messages;
import com.ibm.cic.common.xml.core.model.IProcessingInstruction;
import com.ibm.cic.common.xml.core.model.ITextModelItem;
import com.ibm.cic.common.xml.core.model.IXMLComment;
import com.ibm.cic.common.xml.core.model.IXMLModel;
import com.ibm.cic.common.xml.core.model.IXMLTextModelItem;
import com.ibm.cic.common.xml.core.serial.IXMLSerializer;
import java.util.TreeSet;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class XMLModelSerializer
implements IXMLSerializer {
    private static final String XMLNS = "xmlns:";
    private static final String EQ_SINGLE_Q = "='";
    private static final String END_ELEMENT_START = "</";
    private static final String XML_END = "/>";
    private static final String COMM_END = "-->";
    private static final String COMM_START = "<!--";
    private static final String PROC_END = "?>";
    private static final String PROC_START = "<?";
    private boolean fFormat;
    private boolean fNoWhiteSpace;
    private boolean fTabs;
    private int fSpaces = 4;
    private int fIndentDepth = -1;
    private String fDelim = DEFAULT_LINE_DELIMITER;
    private StringBuffer fIndentBuffer;
    private boolean fNoComments;

    @Override
    public String serializeElement(IXMLTextModelItem element) {
        if (this.fIndentDepth == -1) {
            this.determineIndentDepth(element);
        }
        StringBuffer buf = new StringBuffer();
        this.writeElement(element, buf, -1);
        return buf.toString();
    }

    private void determineIndentDepth(IXMLTextModelItem element) {
        while ((element = element.getParent()) != null) {
            ++this.fIndentDepth;
        }
    }

    @Override
    public void setNoComments(boolean val) {
        this.fNoComments = val;
    }

    @Override
    public String serialize(IXMLModel root) throws CoreException {
        ITextModelItem element;
        this.fIndentDepth = 0;
        if (!root.isWellFormed()) {
            Status err = new Status(4, "com.ibm.cic.common.xml.core", Messages.err_malformed_document);
            throw new CoreException((IStatus)err);
        }
        IXMLTextModelItem[] children = root.getChildren();
        IProcessingInstruction[] inst = root.getProcessingInstructions();
        StringBuffer doc = new StringBuffer("<?xml version='1.0' encoding='UTF-8'?>");
        this.delim(doc);
        ITextModelItem[] iTextModelItemArray = inst;
        int n = inst.length;
        int n2 = 0;
        while (n2 < n) {
            element = iTextModelItemArray[n2];
            String pInst = this.makeString((IProcessingInstruction)element);
            doc.append(pInst);
            ++n2;
        }
        iTextModelItemArray = children;
        n = children.length;
        n2 = 0;
        while (n2 < n) {
            element = iTextModelItemArray[n2];
            if (element instanceof IXMLComment) {
                this.writeElement((IXMLComment)element, doc);
            } else {
                this.writeElement((IXMLTextModelItem)element, doc, -1);
            }
            ++n2;
        }
        return doc.toString();
    }

    @Override
    public String serializeElement(IXMLTextModelItem element, int elementDepth) {
        if (this.fIndentDepth == -1) {
            this.determineIndentDepth(element);
        }
        StringBuffer buf = new StringBuffer();
        this.writeElement(element, buf, elementDepth);
        return buf.toString();
    }

    String makeString(IProcessingInstruction instr) {
        StringBuffer buffer = new StringBuffer(PROC_START);
        buffer.append(instr.getTarget());
        buffer.append(' ');
        buffer.append(instr.getData());
        buffer.append(PROC_END);
        this.delim(buffer);
        return buffer.toString();
    }

    void indent(StringBuffer buffer) {
        int i;
        if (!this.fFormat || this.fNoWhiteSpace) {
            return;
        }
        if (!this.fTabs && this.fIndentBuffer == null) {
            this.fIndentBuffer = new StringBuffer(this.fSpaces);
            i = 0;
            while (i < this.fSpaces) {
                this.fIndentBuffer.append(' ');
                ++i;
            }
        }
        i = 0;
        while (i < this.fIndentDepth) {
            if (!this.fTabs) {
                buffer.append(this.fIndentBuffer.toString());
            } else {
                buffer.append('\t');
            }
            ++i;
        }
    }

    void writeElement(IXMLComment comment, StringBuffer buffer) {
        if (!this.fNoComments) {
            this.indent(buffer);
            buffer.append(COMM_START);
            buffer.append(comment.getBody());
            buffer.append(COMM_END);
            this.delim(buffer);
        }
    }

    void writeElement(IXMLTextModelItem item, StringBuffer buffer, int serDepth) {
        IXMLTextModelItem[] children;
        this.indent(buffer);
        buffer.append('<');
        buffer.append(item.getName());
        this.writeAttributes(item, buffer);
        if (serDepth != -1) {
            --serDepth;
        }
        if ((children = item.getChildren()).length == 0 && item.getElementCDATA() == null) {
            buffer.append(XML_END);
            this.delim(buffer);
            return;
        }
        if (item.getElementCDATA() != null || item.getChildren().length > 0) {
            buffer.append('>');
            this.delim(buffer);
            if (item.getElementCDATA() != null) {
                if (this.fFormat) {
                    this.formatCDATA(item.getElementCDATA(), buffer);
                } else if (this.fNoWhiteSpace) {
                    buffer.append(item.getElementCDATA().trim());
                } else {
                    buffer.append(item.getElementCDATA());
                }
            }
        }
        ++this.fIndentDepth;
        if (serDepth == -1 || serDepth > 0) {
            IXMLTextModelItem[] iXMLTextModelItemArray = children;
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                IXMLTextModelItem element = iXMLTextModelItemArray[n2];
                if (element instanceof IXMLComment) {
                    this.writeElement((IXMLComment)element, buffer);
                } else {
                    this.writeElement(element, buffer, serDepth);
                }
                ++n2;
            }
        }
        --this.fIndentDepth;
        this.indent(buffer);
        buffer.append(END_ELEMENT_START);
        buffer.append(item.getName());
        buffer.append('>');
        this.delim(buffer);
    }

    private void delim(StringBuffer buffer) {
        if (!this.fNoWhiteSpace) {
            buffer.append(this.fDelim);
        }
    }

    private String[] newOrderSort(String[] attrs) {
        TreeSet<String> set = new TreeSet<String>();
        String[] stringArray = attrs;
        int n = attrs.length;
        int n2 = 0;
        while (n2 < n) {
            String attr = stringArray[n2];
            set.add(attr);
            ++n2;
        }
        String[] ret = new String[set.size()];
        ret = set.toArray(ret);
        set.clear();
        return ret;
    }

    void writeNS(IXMLTextModelItem item, StringBuffer buffer) {
        String[] ns;
        String[] stringArray = ns = item.getDefinedNamespaces();
        int n = ns.length;
        int n2 = 0;
        while (n2 < n) {
            String element = stringArray[n2];
            buffer.append(' ');
            buffer.append(XMLNS);
            buffer.append(element);
            buffer.append(EQ_SINGLE_Q);
            buffer.append(item.getDeclaredNamespaceURI(element));
            buffer.append('\'');
            ++n2;
        }
    }

    void writeAttributes(IXMLTextModelItem item, StringBuffer buffer) {
        String[] attrs;
        if (item.getDefinedNamespaces().length > 0) {
            this.writeNS(item, buffer);
        }
        if ((attrs = item.getAttributeNames()).length == 0) {
            return;
        }
        String[] stringArray = attrs = this.newOrderSort(attrs);
        int n = attrs.length;
        int n2 = 0;
        while (n2 < n) {
            String attr = stringArray[n2];
            buffer.append(' ');
            buffer.append(attr);
            String value = XMLString.encode(item.getAttributeValue(attr));
            buffer.append(EQ_SINGLE_Q);
            if (value != null) {
                buffer.append(value);
            }
            buffer.append('\'');
            ++n2;
        }
    }

    public void doFormatting(boolean value) {
        this.fFormat = value;
    }

    public void setTabs(boolean value) {
        this.fTabs = value;
    }

    private void formatCDATA(String cdata, StringBuffer buffer) {
        if (this.isWhitespace(cdata)) {
            return;
        }
        this.indent(buffer);
        buffer.append(XMLString.encode(cdata.trim()));
        this.delim(buffer);
    }

    private boolean isWhitespace(String str) {
        int i = 0;
        while (i < str.length()) {
            char c = str.charAt(i);
            switch (c) {
                case '\t': 
                case '\n': 
                case '\r': 
                case ' ': {
                    break;
                }
                default: {
                    return false;
                }
            }
            ++i;
        }
        return true;
    }

    @Override
    public void setSpaceSize(int size) {
        if (this.fSpaces != size) {
            this.fSpaces = size;
            this.fIndentBuffer = null;
        }
    }

    @Override
    public void setUseTabs(boolean tabs) {
        this.fTabs = tabs;
    }

    @Override
    public void setInitialTabDepth(int val) {
        this.fIndentDepth = val;
    }

    @Override
    public void setLineDelimiter(String delim) {
        this.fDelim = delim;
    }

    @Override
    public void setNoWhiteSpace(boolean value) {
        this.fNoWhiteSpace = value;
    }
}

