/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.xml.core.internal.model.schema;

import com.ibm.cic.common.xml.core.ISourceConverter;
import com.ibm.cic.common.xml.core.model.IXMLTextModelItem;
import com.ibm.cic.common.xml.core.model.schema.ISchema;
import com.ibm.cic.common.xml.core.model.schema.ISchemaRule;
import com.ibm.cic.common.xml.core.model.schema.ISchemaRuleVisitor;
import java.util.ArrayList;
import java.util.Iterator;

public class SchemaRuleVisitor
implements ISchemaRuleVisitor {
    private final ArrayList fRules;
    private final ISchema fSchema;
    private final ISourceConverter fConverter;

    public SchemaRuleVisitor(ISchema schema, ISourceConverter converter) {
        this.fSchema = schema;
        this.fRules = new ArrayList(3);
        this.fConverter = converter;
    }

    @Override
    public void addSchemaRule(ISchemaRule rule) {
        this.fRules.add(rule);
    }

    @Override
    public ISchemaRule[] getRules() {
        ISchemaRule[] ret = new ISchemaRule[this.fRules.size()];
        return this.fRules.toArray(ret);
    }

    @Override
    public void removeSchemaRule(ISchemaRule rule) {
        this.fRules.remove(rule);
    }

    @Override
    public boolean visit(IXMLTextModelItem item) {
        if (item.getNSPrefix() == null || item.getNSPrefix().equals(this.fSchema.getNamespace())) {
            Iterator iter = this.fRules.iterator();
            while (iter.hasNext()) {
                ((ISchemaRule)iter.next()).check(this.fSchema, this.fConverter, item);
            }
            return true;
        }
        return false;
    }
}

