/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.xml.core.internal.model.schema;

import com.ibm.cic.common.xml.core.model.schema.IElementDefinition;
import com.ibm.cic.common.xml.core.model.schema.ISchema;
import com.ibm.cic.common.xml.core.model.schema.ISchemaResolver;
import com.ibm.cic.common.xml.core.model.schema.IValueRestriction;
import com.ibm.cic.common.xml.core.model.schema.IXMLPath;
import com.ibm.cic.common.xml.core.model.schema.XMLPathFactory;
import java.util.ArrayList;
import java.util.HashMap;

public class SchemaDefinition
implements ISchema {
    private final ArrayList fElements;
    private final ISchemaResolver fResolver;
    private final HashMap fCustomRules;
    private final String fNamespace;

    public SchemaDefinition(String namespace, ISchemaResolver resolver) {
        this.fNamespace = namespace;
        this.fElements = new ArrayList();
        this.fResolver = resolver;
        this.fCustomRules = new HashMap(0);
    }

    @Override
    public ISchemaResolver getResolver() {
        return this.fResolver;
    }

    @Override
    public IElementDefinition[] getRootElements() {
        IElementDefinition[] ret = new IElementDefinition[this.fElements.size()];
        return this.fElements.toArray(ret);
    }

    public void addElement(IElementDefinition element) {
        if (!this.fElements.contains(element)) {
            this.fElements.add(element);
        }
    }

    public IElementDefinition getElement(String qname) {
        for (IElementDefinition def : this.fElements) {
            if (!def.getReferenceName().equals(qname)) continue;
            return def;
        }
        return null;
    }

    @Override
    public String getNamespace() {
        return this.fNamespace;
    }

    @Override
    public IElementDefinition findByPath(IXMLPath path) {
        path.setChild(null);
        IXMLPath root = XMLPathFactory.getRootSegment(path);
        root = root.getChild();
        if (root == null) {
            return null;
        }
        for (IElementDefinition def : this.fElements) {
            if (!def.getName().equals(root.getSegmentName())) continue;
            while (root.getChild() != null) {
                if ((def = def.getElementByName((root = root.getChild()).getSegmentName())) == null) {
                    return null;
                }
                if (!root.equals(path)) continue;
                return def;
            }
            return def;
        }
        return null;
    }

    @Override
    public void addTypeRule(String typeName, IValueRestriction rule) {
        this.fCustomRules.put(typeName, rule);
    }

    @Override
    public IValueRestriction getCustomTypeRule(String typeName) {
        return (IValueRestriction)this.fCustomRules.get(typeName);
    }
}

