/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.ui.internal.views;

import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.widgets.ILayoutExtension;

class WizardAreaLayout
extends Layout
implements ILayoutExtension {
    public int marginWidth = 5;
    public int marginHeight = 5;
    public int minimumWidth = 0;
    public int minimumHeight = 0;
    private Control permanent = null;

    public WizardAreaLayout(int mw, int mh, int minW, int minH) {
        this.marginWidth = mw;
        this.marginHeight = mh;
        this.minimumWidth = minW;
        this.minimumHeight = minH;
    }

    public void setPermanent(Control control) {
        this.permanent = control;
    }

    public Point computeSize(Composite composite, int wHint, int hHint, boolean force) {
        if (wHint != -1 && hHint != -1) {
            return new Point(wHint, hHint);
        }
        Point permanentSize = this.permanent != null ? this.permanent.computeSize(-1, hHint, force) : new Point(0, 0);
        Point result = null;
        Control[] children = composite.getChildren();
        if (children.length > 0) {
            result = new Point(0, 0);
            Control[] controlArray = children;
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                Control element = controlArray[n2];
                if (element.isVisible()) {
                    result = element.computeSize(wHint, hHint, force);
                }
                ++n2;
            }
            result.x += 2 * this.marginWidth;
            result.y += 2 * this.marginHeight;
        } else {
            Rectangle rect = composite.getClientArea();
            result = new Point(rect.width, rect.height);
        }
        result.x = Math.max(Math.max(result.x, permanentSize.x), this.minimumWidth);
        result.y = Math.max(result.y + permanentSize.y, this.minimumHeight);
        if (wHint != -1) {
            result.x = wHint;
        }
        if (hHint != -1) {
            result.y = hHint;
        }
        return result;
    }

    public Rectangle getClientArea(Composite c) {
        Rectangle rect = c.getClientArea();
        rect.x += this.marginWidth;
        rect.y += this.marginHeight;
        rect.width -= 2 * this.marginWidth;
        rect.height -= 2 * this.marginHeight;
        return rect;
    }

    public void layout(Composite composite, boolean force) {
        Control[] children;
        Rectangle rect = this.getClientArea(composite);
        if (this.permanent != null) {
            Point permanentSize = this.permanent.computeSize(rect.width, -1, true);
            Rectangle permanentBounds = new Rectangle(rect.x, rect.y, permanentSize.x, permanentSize.y);
            this.permanent.setBounds(permanentBounds);
            rect = new Rectangle(rect.x, rect.y + permanentBounds.height, rect.width, rect.height - permanentBounds.height);
        }
        Control[] controlArray = children = composite.getChildren();
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            Control element = controlArray[n2];
            if (element != this.permanent) {
                element.setBounds(rect);
            }
            ++n2;
        }
    }

    public int computeMinimumWidth(Composite parent, boolean changed) {
        return this.computeSize((Composite)parent, (int)0, (int)-1, (boolean)changed).x;
    }

    public int computeMaximumWidth(Composite parent, boolean changed) {
        return this.computeSize((Composite)parent, (int)-1, (int)-1, (boolean)changed).x;
    }
}

