/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.ui.internal.parts;

import java.util.Enumeration;
import java.util.Hashtable;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class BillboardPart {
    private Label label;
    private int fTotalWork = 1;
    private int progress;
    private int lastIndex;
    private ImageDescriptor[] descriptors;
    private Hashtable images;

    public void dispose() {
        if (this.images != null) {
            Enumeration enm = this.images.elements();
            while (enm.hasMoreElements()) {
                Image image = (Image)enm.nextElement();
                image.dispose();
            }
        }
        this.images = null;
    }

    public void setImages(ImageDescriptor[] desc) {
        this.dispose();
        this.descriptors = desc;
        if (desc != null) {
            if (this.images == null) {
                this.images = new Hashtable();
            } else {
                this.images.clear();
            }
        }
    }

    public Image getImage(ImageDescriptor id) {
        Image image = (Image)this.images.get(id);
        if (image == null) {
            image = id.createImage();
            this.images.put(id, image);
        }
        return image;
    }

    public void createControl(FormToolkit toolkit, Composite parent) {
        this.label = toolkit.createLabel(parent, null);
        this.label.setAlignment(0x1000000);
    }

    public Control getControl() {
        return this.label;
    }

    public void beginTask(int totalWork) {
        this.fTotalWork = totalWork;
        this.progress = 0;
        this.lastIndex = -1;
        this.worked(0);
    }

    public void worked(int units) {
        if (this.descriptors == null) {
            return;
        }
        this.progress += units;
        int index = this.progress * this.descriptors.length / this.fTotalWork;
        if ((index = Math.min(this.descriptors.length - 1, index)) == this.lastIndex) {
            return;
        }
        ImageDescriptor desc = this.descriptors[index];
        Image image = this.getImage(desc);
        this.label.setImage(image);
        this.lastIndex = index;
    }

    public void done() {
        this.label.setImage(null);
        this.descriptors = null;
    }
}

