/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.ui.internal.dialogs;

import com.ibm.cic.common.core.console.shared.manager.DiskChangePrompt;
import com.ibm.cic.common.core.repository.CicFileLocation;
import com.ibm.cic.common.core.repository.ICicLocation;
import com.ibm.cic.common.core.volrepo.IDiskInsertedValidator;
import com.ibm.cic.common.ui.internal.CommonImages;
import com.ibm.cic.common.ui.internal.Messages;
import com.ibm.cic.common.ui.services.IBaseDialogService;
import com.ibm.cic.common.ui.services.UiServices;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class InsertDiskDialog
extends TitleAreaDialog {
    private final String dlgTitle;
    private Text pathText;
    private Button browseButton;
    private final Map images = new HashMap();
    private final DiskChangePrompt diskPrompt;
    private IStatus okStatus;
    private static final int DEFAULT_DLG_WIDTH = 460;

    public InsertDiskDialog(Shell parentShell, IDiskInsertedValidator validator, ICicLocation rootDir, String diskLabel, int diskNum) {
        super(parentShell);
        this.dlgTitle = Messages.InsertDiskDialog_title;
        this.diskPrompt = new DiskChangePrompt(validator, rootDir, diskLabel, diskNum);
        this.setShellStyle(this.getShellStyle() | 0x10);
    }

    public void create() {
        super.create();
        this.setTitle(Messages.InsertDiskDialog_title);
        this.setTitleImage(this.getImageItem(CommonImages.WIZ_NEXTDISC));
        String msg = NLS.bind((String)Messages.InsertDiskDialog_insertDiskExplanation, (Object)this.diskPrompt.diskNum);
        this.setMessage(msg);
    }

    protected Control createDialogArea(Composite parent) {
        Composite parentComposite = (Composite)super.createDialogArea(parent);
        Font font = parentComposite.getFont();
        Composite comp = new Composite(parentComposite, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        comp.setLayout((Layout)layout);
        GridData gridData = new GridData(1808);
        gridData.widthHint = 350;
        comp.setLayoutData((Object)gridData);
        Label insertDiskLabel = new Label(comp, 64);
        insertDiskLabel.setFont(font);
        insertDiskLabel.setText(this.diskPrompt.getPromptMessage());
        GridData gdLabel = new GridData();
        gdLabel.horizontalAlignment = 4;
        gdLabel.grabExcessHorizontalSpace = true;
        insertDiskLabel.setLayoutData((Object)gdLabel);
        this.pathText = new Text(comp, 2048);
        GridData data = new GridData();
        data.horizontalAlignment = 4;
        data.grabExcessHorizontalSpace = true;
        data.grabExcessVerticalSpace = true;
        this.pathText.setLayoutData((Object)data);
        this.pathText.setFont(font);
        this.pathText.setText(this.diskPrompt.getPathLocation());
        this.pathText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                InsertDiskDialog.this.modifyPathText();
            }
        });
        this.browseButton = new Button(comp, 8);
        this.browseButton.setFont(font);
        data = new GridData();
        data.horizontalAlignment = 3;
        this.browseButton.setLayoutData((Object)data);
        this.browseButton.setText(Messages.InsertDiskDialog_browseButtonText);
        this.browseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                InsertDiskDialog.this.browseButtonPressed();
            }
        });
        return parentComposite;
    }

    private void clearError() {
        this.setErrorMessage(null);
        String msg = NLS.bind((String)Messages.InsertDiskDialog_insertDiskExplanation, (Object)this.diskPrompt.diskNum);
        this.setMessage(msg);
    }

    protected void modifyPathText() {
        this.clearError();
    }

    protected void browseButtonPressed() {
        IBaseDialogService service = UiServices.getInstance().getDirectoryDialog(this.getShell()).title(Messages.InsertDiskDialog_browseDirectory_title).filterPath(this.pathText.getText());
        if (this.diskPrompt.diskLabel != null) {
            service.message(NLS.bind((String)Messages.InsertDiskDialog_browseDirectory_messageWithSetLabel, (Object)this.diskPrompt.diskNum, (Object)this.diskPrompt.diskLabel));
        } else {
            service.message(NLS.bind((String)Messages.InsertDiskDialog_browseDirectory_message, (Object)this.diskPrompt.diskNum));
        }
        String selectedDirectoryName = service.run();
        if (selectedDirectoryName != null) {
            this.pathText.setText(selectedDirectoryName);
            this.clearError();
        }
    }

    protected void configureShell(Shell newShell) {
        newShell.setText(this.dlgTitle);
        super.configureShell(newShell);
    }

    public Button getOkButton() {
        return this.getButton(0);
    }

    protected void cancelPressed() {
        super.cancelPressed();
    }

    protected void okPressed() {
        String path = this.pathText.getText().trim();
        CicFileLocation location = new CicFileLocation(path);
        this.okStatus = this.diskPrompt.validator.validateDisk((ICicLocation)location);
        if (this.okStatus.matches(4)) {
            this.setErrorMessage(this.okStatus.getMessage());
            return;
        }
        super.okPressed();
    }

    protected Point getInitialSize() {
        Point origSize = super.getInitialSize();
        return new Point(Math.max(this.convertHorizontalDLUsToPixels(460), origSize.x), origSize.y);
    }

    public IStatus getOkStatus() {
        return this.okStatus;
    }

    private Image getImageItem(ImageDescriptor imageDes) {
        if (imageDes != null) {
            Image image = (Image)this.images.get(imageDes);
            if (image == null) {
                image = imageDes.createImage();
                this.images.put(imageDes, image);
            }
            return image;
        }
        return null;
    }

    public boolean close() {
        this.disposeMyImages();
        return super.close();
    }

    private void disposeMyImages() {
        Iterator iter = this.images.values().iterator();
        while (iter.hasNext()) {
            ((Image)iter.next()).dispose();
        }
    }
}

