/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.transports.httpclient.internal.ntlm;

import com.ibm.cic.common.logging.Logger;
import com.ibm.cic.common.transports.httpclient.internal.ntlm.CustomNTLM;
import com.ibm.cic.common.transports.httpclient.internal.ntlm.portable.BitUtil;
import com.ibm.cic.common.transports.httpclient.internal.ntlm.portable.LogNTLMMessage;
import com.ibm.cic.common.transports.httpclient.internal.ntlm.portable.NTLMConstants;
import com.ibm.cic.common.transports.httpclient.internal.ntlm.portable.NTLMUtil;
import com.ibm.cic.common.transports.httpclient.internal.ntlm.portable.NTLMv1MessageGenerator;
import com.ibm.cic.common.transports.httpclient.ntlm.INTLMAuthGenerator;
import com.ibm.cic.common.transports.httpclient.ntlm.NTLMAuthGeneratorException;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.NTCredentials;
import org.apache.commons.httpclient.auth.AuthChallengeParser;
import org.apache.commons.httpclient.auth.AuthScheme;
import org.apache.commons.httpclient.auth.AuthenticationException;
import org.apache.commons.httpclient.auth.InvalidCredentialsException;
import org.apache.commons.httpclient.auth.MalformedChallengeException;
import org.apache.commons.httpclient.util.EncodingUtil;

public class CustomNTLMScheme
implements AuthScheme,
NTLMConstants {
    private static final int UNINITIATED = 0;
    private static final int INITIATED = 1;
    private static final int TYPE1_MSG_GENERATED = 2;
    private static final int TYPE2_MSG_RECEIVED = 3;
    private static final int TYPE3_MSG_GENERATED = 4;
    private static final int FAILED = Integer.MAX_VALUE;
    private int state = 0;
    private String ntlmchallenge = null;
    private INTLMAuthGenerator ntlmGenerator;
    private static final Logger log = CustomNTLM.log;

    public String authenticate(Credentials credentials, HttpMethod method) throws AuthenticationException {
        NTLMv1MessageGenerator.log.debug("enter NTLMScheme.authenticate(Credentials, HttpMethod)");
        if (this.state == 0) {
            throw new IllegalStateException("NTLM authentication process has not been initiated");
        }
        NTCredentials ntcredentials = null;
        try {
            ntcredentials = (NTCredentials)credentials;
        }
        catch (ClassCastException e) {
            throw new InvalidCredentialsException("Credentials cannot be used for NTLM authentication: " + credentials.getClass().getName());
        }
        try {
            if (this.ntlmGenerator == null) {
                this.ntlmGenerator = CustomNTLM.newNTLMMessageGenerator(method, ntcredentials);
            }
            String response = this.genResponse();
            return "NTLM " + response;
        }
        catch (NTLMAuthGeneratorException e) {
            throw new AuthenticationException(e.getMessage(), (Throwable)e);
        }
    }

    private String genResponse() throws NTLMAuthGeneratorException {
        String response;
        if (this.state == 1 || this.state == Integer.MAX_VALUE) {
            response = this.genType1Message();
            this.state = 2;
        } else {
            response = this.genType3Message(this.ntlmchallenge);
            this.state = 4;
        }
        return response;
    }

    private String genType1Message() throws NTLMAuthGeneratorException {
        byte[] bytes = this.ntlmGenerator.genType1Message();
        if (!this.ntlmGenerator.isLoggingDetails()) {
            LogNTLMMessage.logNTLMMessage(log, bytes, 1);
        }
        int flagsOffset = NTLMConstants.SIGNATURE_BYTES.length + 4;
        int flags = BitUtil.LEtoInt(bytes, flagsOffset);
        if (log.isDebugLoggable()) {
            log.debug("NTLM send NEGOTIATE {0}", new Object[]{NTLMUtil.getFlagsDebugString(flags)});
        }
        return EncodingUtil.getAsciiString((byte[])Base64.encodeBase64((byte[])bytes));
    }

    private String genType3Message(String base64Challenge) throws NTLMAuthGeneratorException {
        log.debug("NTLM received challenge: {0}", new Object[]{base64Challenge});
        byte[] bytes = Base64.decodeBase64((byte[])EncodingUtil.getBytes((String)base64Challenge, (String)"ASCII"));
        if (log.isDebugLoggable()) {
            log.debug("NTLM received challenge: {0}", new Object[]{BitUtil.bytesToHexString(bytes)});
            if (!this.ntlmGenerator.isLoggingDetails()) {
                LogNTLMMessage.logNTLMMessage(log, bytes, 2);
            }
        }
        byte[] authenticate = this.ntlmGenerator.genType3Message(bytes);
        if (log.isDebugLoggable() && !this.ntlmGenerator.isLoggingDetails()) {
            LogNTLMMessage.logNTLMMessage(log, authenticate, 3);
        }
        if (log.isDebugLoggable()) {
            log.debug("NTLM computed authenticate: {0}", new Object[]{BitUtil.bytesToHexString(authenticate)});
        }
        return EncodingUtil.getAsciiString((byte[])Base64.encodeBase64((byte[])authenticate));
    }

    @Deprecated
    public String authenticate(Credentials credentials, String method, String uri) throws AuthenticationException {
        return null;
    }

    @Deprecated
    public String getID() {
        return null;
    }

    public String getParameter(String name) {
        if (name == null) {
            throw new IllegalArgumentException("Parameter name may not be null");
        }
        return null;
    }

    public String getRealm() {
        return null;
    }

    public String getSchemeName() {
        return "ntlm";
    }

    public boolean isComplete() {
        return this.state == 4 || this.state == Integer.MAX_VALUE;
    }

    public boolean isConnectionBased() {
        return true;
    }

    public void processChallenge(String challenge) throws MalformedChallengeException {
        String s = AuthChallengeParser.extractScheme((String)challenge);
        if (!s.equalsIgnoreCase(this.getSchemeName())) {
            throw new MalformedChallengeException("Invalid NTLM challenge: " + challenge);
        }
        int i = challenge.indexOf(32);
        if (i != -1) {
            s = challenge.substring(i, challenge.length());
            this.ntlmchallenge = s.trim();
            this.state = 3;
        } else {
            this.ntlmchallenge = "";
            this.ntlmGenerator = null;
            this.state = this.state == 0 ? 1 : Integer.MAX_VALUE;
        }
    }
}

