/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.transports.httpclient;

import com.ibm.cic.common.downloads.DownloadHandlerRequest;
import com.ibm.cic.common.downloads.HttpRequestEvents;
import com.ibm.cic.common.downloads.IDownloadContext;
import com.ibm.cic.common.downloads.handlerImpl.DownloadHandlerUtil;
import com.ibm.cic.common.downloads.messages.AbstractLazyProtocolMessage;
import com.ibm.cic.common.downloads.messages.IProtocolMessage;
import com.ibm.cic.common.downloads.messages.MessageDirection;
import com.ibm.cic.common.downloads.messages.ProtocolHeader;
import com.ibm.cic.common.transports.httpclient.HttpClientEvents;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpConnection;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpState;
import org.apache.commons.httpclient.URIException;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.HeadMethod;
import org.apache.commons.httpclient.methods.PostMethod;

public class MethodMessageHelper {
    private static final HttpRequestEvents.HttpReceivedStatusLineAdapter RECEIVE_STATUS_ADAPTER = new HttpClientReceivedStatusLineAdapter();

    public static abstract class CicGetMethod
    extends GetMethod
    implements IMethodWithRequestLine {
        private HttpRequestLine lastRequestLine;

        public CicGetMethod() {
        }

        public CicGetMethod(String uri) {
            super(uri);
        }

        public boolean getDoAuthentication() {
            HttpClientEvents.FIRE.onEvent(new HttpClientEvents.UnauthorizedEvent((HttpMethod)this));
            return super.getDoAuthentication();
        }

        protected void writeRequestLine(HttpState state, HttpConnection conn) throws IOException, HttpException {
            super.writeRequestLine(state, conn);
            this.lastRequestLine = HttpRequestLine.create(CicGetMethod.generateRequestLine((HttpConnection)conn, (String)this.getName(), (String)this.getPath(), (String)this.getQueryString(), (String)this.getEffectiveVersion().toString()));
        }

        protected void processResponseHeaders(HttpState state, HttpConnection conn) {
            super.processResponseHeaders(state, conn);
            DownloadHandlerRequest request = this.getDownloadRequest();
            HttpRequestEvents.getFire((IDownloadContext)request.getDownloadContext()).onEvent((HttpRequestEvents.HttpRequestEvent)new HttpRequestEvents.ReceivedStatusLineEvent((Object)this, RECEIVE_STATUS_ADAPTER));
        }

        protected abstract DownloadHandlerRequest getDownloadRequest();

        @Override
        public void resetRequestLine() {
            this.lastRequestLine = null;
        }

        @Override
        public HttpRequestLine getLastRequestLine() {
            return this.lastRequestLine;
        }
    }

    public static abstract class CicHeadMethod
    extends HeadMethod
    implements IMethodWithRequestLine {
        private HttpRequestLine lastRequestLine;

        public CicHeadMethod() {
        }

        public CicHeadMethod(String uri) {
            super(uri);
        }

        public boolean getDoAuthentication() {
            HttpClientEvents.FIRE.onEvent(new HttpClientEvents.UnauthorizedEvent((HttpMethod)this));
            return super.getDoAuthentication();
        }

        protected void writeRequestLine(HttpState state, HttpConnection conn) throws IOException, HttpException {
            super.writeRequestLine(state, conn);
            this.lastRequestLine = HttpRequestLine.create(CicHeadMethod.generateRequestLine((HttpConnection)conn, (String)this.getName(), (String)this.getPath(), (String)this.getQueryString(), (String)this.getEffectiveVersion().toString()));
        }

        protected void processResponseHeaders(HttpState state, HttpConnection conn) {
            super.processResponseHeaders(state, conn);
            DownloadHandlerRequest request = this.getDownloadRequest();
            HttpRequestEvents.getFire((IDownloadContext)request.getDownloadContext()).onEvent((HttpRequestEvents.HttpRequestEvent)new HttpRequestEvents.ReceivedStatusLineEvent((Object)this, RECEIVE_STATUS_ADAPTER));
        }

        protected abstract DownloadHandlerRequest getDownloadRequest();

        @Override
        public HttpRequestLine getLastRequestLine() {
            return this.lastRequestLine;
        }

        @Override
        public void resetRequestLine() {
            this.lastRequestLine = null;
        }
    }

    public static abstract class CicPostMethod
    extends PostMethod
    implements IMethodWithRequestLine {
        private HttpRequestLine lastRequestLine;

        public CicPostMethod() {
        }

        public CicPostMethod(String uri) {
            super(uri);
        }

        protected void writeRequestLine(HttpState state, HttpConnection conn) throws IOException, HttpException {
            super.writeRequestLine(state, conn);
            this.lastRequestLine = HttpRequestLine.create(CicPostMethod.generateRequestLine((HttpConnection)conn, (String)this.getName(), (String)this.getPath(), (String)this.getQueryString(), (String)this.getEffectiveVersion().toString()));
        }

        protected void processResponseHeaders(HttpState state, HttpConnection conn) {
            super.processResponseHeaders(state, conn);
            DownloadHandlerRequest request = this.getDownloadRequest();
            HttpRequestEvents.getFire((IDownloadContext)request.getDownloadContext()).onEvent((HttpRequestEvents.HttpRequestEvent)new HttpRequestEvents.ReceivedStatusLineEvent((Object)this, RECEIVE_STATUS_ADAPTER));
        }

        protected abstract DownloadHandlerRequest getDownloadRequest();

        @Override
        public void resetRequestLine() {
            this.lastRequestLine = null;
        }

        @Override
        public HttpRequestLine getLastRequestLine() {
            return this.lastRequestLine;
        }
    }

    static class HttpClientReceivedStatusLineAdapter
    extends HttpClientRequestAdapter
    implements HttpRequestEvents.HttpReceivedStatusLineAdapter {
        public String getStatusLine(Object request) {
            HttpMethod method = (HttpMethod)request;
            return method.getStatusLine().toString();
        }

        public int getCode(Object request) {
            HttpMethod method = (HttpMethod)request;
            return method.getStatusLine().getStatusCode();
        }
    }

    static class HttpClientRequestAdapter
    implements HttpRequestEvents.HttpRequestAdapter {
        private static final String RESPONSE_NAME = "Response";
        private static final String REQUEST_NAME = "Request";
        private static final String RESPONSE_KEY = "response";
        private static final String REQUEST_KEY = "request";

        protected HttpClientRequestAdapter() {
        }

        public String getMethodName(Object request) {
            HttpMethod method = (HttpMethod)request;
            return method.getName();
        }

        public String getUrlString(Object request) {
            HttpMethod method = (HttpMethod)request;
            try {
                return method.getURI().toString();
            }
            catch (URIException e) {
                DownloadHandlerUtil.dlTrace.error((Throwable)e);
                return null;
            }
        }

        public IProtocolMessage getRequestMessage(Object request) {
            final HttpMethod method = (HttpMethod)request;
            return new AbstractLazyProtocolMessage("HTTP11", MessageDirection.MD_OUT, REQUEST_KEY){

                protected void addHeadersToList(List headers, String key) {
                    if (key == null || key.equals(HttpClientRequestAdapter.REQUEST_KEY)) {
                        headers.add(new ProtocolHeader(HttpClientRequestAdapter.REQUEST_KEY, HttpClientRequestAdapter.REQUEST_NAME, ((IMethodWithRequestLine)method).getLastRequestLine().toString()));
                    }
                    Header[] hs = key == null ? method.getRequestHeaders() : method.getRequestHeaders(key);
                    headers.addAll(this.toGenericHeaderList(hs));
                }

                public Set getHeaderKeys() {
                    Header[] hs = method.getRequestHeaders();
                    LinkedHashSet<String> keys = new LinkedHashSet<String>(hs.length);
                    keys.add(HttpClientRequestAdapter.REQUEST_KEY);
                    Header[] headerArray = hs;
                    int n = hs.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Header header = headerArray[n2];
                        keys.add(header.getName().toLowerCase(Locale.ENGLISH));
                        ++n2;
                    }
                    return keys;
                }
            };
        }

        public IProtocolMessage getResponseMessage(Object request) {
            final HttpMethod method = (HttpMethod)request;
            return new AbstractLazyProtocolMessage("HTTP11", MessageDirection.MD_IN, RESPONSE_KEY){

                protected void addHeadersToList(List headers, String key) {
                    Header[] hs = key == null ? method.getResponseHeaders() : method.getResponseHeaders(key);
                    headers.add(new ProtocolHeader(HttpClientRequestAdapter.RESPONSE_KEY, HttpClientRequestAdapter.RESPONSE_NAME, method.getStatusLine().toString()));
                    ArrayList list = this.toGenericHeaderList(hs);
                    headers.addAll(list);
                }

                public Set getHeaderKeys() {
                    Header[] hs = method.getResponseHeaders();
                    LinkedHashSet<String> keys = new LinkedHashSet<String>(hs.length);
                    keys.add(HttpClientRequestAdapter.RESPONSE_KEY);
                    Header[] headerArray = hs;
                    int n = hs.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Header header = headerArray[n2];
                        keys.add(header.getName().toLowerCase(Locale.ENGLISH));
                        ++n2;
                    }
                    return keys;
                }
            };
        }

        private ArrayList toGenericHeaderList(Header[] hs) {
            ArrayList<ProtocolHeader> list = new ArrayList<ProtocolHeader>(hs.length);
            Header[] headerArray = hs;
            int n = hs.length;
            int n2 = 0;
            while (n2 < n) {
                Header header = headerArray[n2];
                String name = header.getName();
                list.add(new ProtocolHeader(name.toLowerCase(Locale.ENGLISH), name, header.getValue()));
                ++n2;
            }
            return list;
        }
    }

    static class HttpRequestLine {
        private final String requestLine;
        private final String method;
        private final String uri;
        private final String version;

        public static HttpRequestLine create(String requestLine) {
            assert (requestLine != null);
            int indexBlank1 = requestLine.indexOf(32);
            if (indexBlank1 == -1) {
                return null;
            }
            String method = requestLine.substring(0, indexBlank1);
            int indexBlank2 = requestLine.indexOf(32, indexBlank1 + 1);
            if (indexBlank2 == -1) {
                return null;
            }
            String uri = requestLine.substring(indexBlank1 + 1, indexBlank2);
            int end = requestLine.indexOf(32, indexBlank2 + 1);
            if (end == -1) {
                end = requestLine.indexOf(13, indexBlank2 + 1);
            }
            if (end == -1) {
                end = requestLine.indexOf(10, indexBlank2 + 1);
            }
            String version = end != -1 ? requestLine.substring(indexBlank2 + 1, end) : requestLine.substring(indexBlank2 + 1);
            return new HttpRequestLine(requestLine, method, uri, version);
        }

        public HttpRequestLine(String requestLine, String method, String uri, String version) {
            assert (requestLine != null);
            assert (method != null);
            assert (uri != null);
            assert (version != null);
            this.requestLine = requestLine;
            this.method = method;
            this.uri = uri;
            this.version = version;
        }

        public String getHttpVersion() {
            return this.version;
        }

        public String getMethod() {
            return this.method;
        }

        public String getRequestURI() {
            return this.uri;
        }

        public String toString() {
            return this.requestLine;
        }
    }

    public static interface IMethodWithRequestLine {
        public void resetRequestLine();

        public HttpRequestLine getLastRequestLine();
    }
}

