/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.transports.commons.net;

import com.ibm.cic.common.core.internal.utils.CicCommonCoreTrace;
import com.ibm.cic.common.core.utils.UserOptions;
import com.ibm.cic.common.downloads.CredentialStore;
import com.ibm.cic.common.downloads.DownloadTrace;
import com.ibm.cic.common.downloads.ITransferSession;
import com.ibm.cic.common.downloads.ITransferSessionListener;
import com.ibm.cic.common.downloads.TransferSessionManager;
import java.io.IOException;
import java.net.SocketException;
import java.net.URI;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class FtpConnectionManager
implements ITransferSessionListener {
    protected static final CicCommonCoreTrace traceMcpConnect = DownloadTrace.traceMcpConnect;
    protected static final CicCommonCoreTrace traceMcpLease = DownloadTrace.traceMcpLease;
    private static final int maxConnections = Math.max(UserOptions.getAddThreads() * 3, 3);
    private boolean listening = false;
    private final List sessionConnections = new LinkedList();

    FtpConnectionManager() {
        CredentialStore.INSTANCE.addCredentialStoreListener(new CredentialStore.ICredentialStoreListener(){

            public void clearCachedCredentials() {
                FtpConnectionManager.this.releaseAll();
            }

            public boolean isAnyCredentialSaved() {
                return !FtpConnectionManager.this.sessionConnections.isEmpty();
            }
        });
    }

    private synchronized IFTPConnection getConnection(ITransferSession session, String authority) {
        Iterator iter = this.sessionConnections.iterator();
        while (iter.hasNext()) {
            SessionConnections connections = (SessionConnections)iter.next();
            if (!connections.getSession().equals(session)) continue;
            IFTPConnection connection = connections.getConnection(authority);
            if (connections.isEmpty() && connection != null) {
                iter.remove();
            }
            return connection;
        }
        return null;
    }

    public IFTPConnection getFtpConnection(IFTPConnectionFactory factory, URI uri) throws SocketException, IOException {
        ITransferSession session = TransferSessionManager.INSTANCE.getSession();
        IFTPConnection connection = this.getConnection(session, uri.getAuthority());
        if (connection != null) {
            try {
                connection.assureConnected();
                if (FtpConnectionManager.traceMcpConnect.enabled) {
                    traceMcpConnect.getLog().debug("Reusing connection from pool {0} for {1}.", new Object[]{connection, uri});
                }
            }
            catch (IOException ioe) {
                if (FtpConnectionManager.traceMcpConnect.enabled) {
                    traceMcpConnect.getLog().debug("IO exception while trying to assureConnected(): trying new connection for {0}: {1}\n{2}", new Object[]{uri.getAuthority(), uri, ioe});
                }
                try {
                    connection.disconnect();
                }
                catch (IOException ioe2) {
                    traceMcpConnect.getLog().debug("IOException during disconnect of {0}: {1}", new Object[]{connection, ioe2});
                }
                connection = null;
            }
        }
        if (connection == null) {
            if (FtpConnectionManager.traceMcpConnect.enabled) {
                traceMcpConnect.println("Creating connection for {0}: {1}", uri.getAuthority(), uri.toString());
            }
            connection = factory.createConnection(uri);
        }
        return connection;
    }

    public synchronized void returnConnection(IFTPConnection connection) {
        ITransferSession session = TransferSessionManager.INSTANCE.getSession();
        if (!this.listening) {
            TransferSessionManager.INSTANCE.addSessionListener((ITransferSessionListener)this);
            this.listening = true;
        }
        if (FtpConnectionManager.traceMcpLease.enabled) {
            traceMcpLease.getLog().debug("Returning connection {0}", new Object[]{connection});
        }
        for (SessionConnections connections : this.sessionConnections) {
            if (!connections.getSession().equals(session)) continue;
            connections.returnConnection(connection);
            if (FtpConnectionManager.traceMcpLease.enabled) {
                traceMcpLease.println("... new count={0}", Integer.toString(connections.size()));
            }
            return;
        }
        SessionConnections connections = this.createSessionConnections(session);
        connections.returnConnection(connection);
        this.sessionConnections.add(connections);
        if (FtpConnectionManager.traceMcpLease.enabled) {
            traceMcpLease.println("... new count={0}", Integer.toString(connections.size()));
        }
    }

    protected SessionConnections createSessionConnections(ITransferSession session) {
        return new SessionConnections(session);
    }

    public synchronized void releaseAll() {
        if (FtpConnectionManager.traceMcpConnect.enabled) {
            traceMcpConnect.println("Releasing all connections.");
        }
        for (SessionConnections connections : this.sessionConnections) {
            connections.releaseAll();
        }
        this.sessionConnections.clear();
    }

    public synchronized void close(ITransferSession session) {
        this.listening = false;
        if (FtpConnectionManager.traceMcpConnect.enabled) {
            traceMcpConnect.println("Closing session {0}", session.toString());
        }
        Iterator iter = this.sessionConnections.iterator();
        while (iter.hasNext()) {
            SessionConnections connections = (SessionConnections)iter.next();
            if (!connections.getSession().equals(session)) continue;
            connections.releaseAll();
            iter.remove();
            return;
        }
    }

    public static interface IFTPConnection {
        public String getAuthority();

        public void disconnect() throws IOException;

        public void assureConnected() throws IOException;
    }

    public static interface IFTPConnectionFactory {
        public IFTPConnection createConnection(URI var1) throws SocketException, IOException;
    }

    protected static class SessionConnections {
        private final ITransferSession session;
        private final List connectionList = new LinkedList();

        public SessionConnections(ITransferSession session) {
            this.session = session;
        }

        public ITransferSession getSession() {
            return this.session;
        }

        protected List getConnections() {
            return this.connectionList;
        }

        public IFTPConnection getConnection(String authority) {
            Iterator iter = this.getConnections().iterator();
            while (iter.hasNext()) {
                IFTPConnection connection = (IFTPConnection)iter.next();
                if (!connection.getAuthority().equals(authority)) continue;
                iter.remove();
                return connection;
            }
            return null;
        }

        public boolean isEmpty() {
            return this.getConnections().isEmpty();
        }

        public void returnConnection(IFTPConnection connection) {
            List connections = this.getConnections();
            connections.add(connection);
            if (connections.size() > maxConnections) {
                IFTPConnection removed = (IFTPConnection)connections.remove(0);
                try {
                    removed.disconnect();
                }
                catch (IOException e) {
                    DownloadTrace.traceIssues.getLog().error((Throwable)e);
                }
            }
        }

        public void releaseAll() {
            List connections = this.getConnections();
            for (IFTPConnection conn : connections) {
                try {
                    conn.disconnect();
                }
                catch (IOException e) {
                    DownloadTrace.traceIssues.getLog().error((Throwable)e);
                }
            }
            connections.clear();
        }

        public int size() {
            return this.getConnections().size();
        }
    }
}

