/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.logging;

import com.ibm.cic.common.core.internal.Messages;
import com.ibm.cic.common.core.utils.CallStack;
import com.ibm.cic.common.core.utils.Check;
import com.ibm.cic.common.core.utils.ICicStatus;
import com.ibm.cic.common.core.utils.StatusFormatter;
import com.ibm.cic.common.core.utils.Statuses;
import com.ibm.cic.common.logging.FileLog;
import com.ibm.cic.common.logging.ILogListener;
import com.ibm.cic.common.logging.Level;
import com.ibm.cic.common.logging.LogEntry;
import com.ibm.cic.common.logging.LogManager;
import com.ibm.cic.common.logging.LogUtil;
import com.ibm.cic.common.logging.SupplementaryFileLog;
import com.ibm.cic.common.logging.UidUtil;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.LinkedList;
import java.util.Map;
import java.util.TreeMap;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;

public class Logger {
    private static final String GLOBAL_NAME = "global";
    public static final String NEWLINE = LogUtil.NEWLINE;
    private final String name;
    private int minLevel;
    private Map attrs = Collections.EMPTY_MAP;
    private LinkedList started = null;
    private LogStackFilter stackFilter = LogStackFilter.NULL;
    private static IStatus prevStatus = null;

    public static Logger getLogger(String name) {
        return LogManager.getLogger(name);
    }

    public static Logger getLogger(Class clazz) {
        return Logger.getLogger(clazz.getName().replace('$', '.'));
    }

    public static Logger getLogger() {
        return LogManager.getLogger(CallStack.getCallingClass().replace('$', '.'));
    }

    public static Logger getLogger(Logger logger, String suffix) {
        return LogManager.getLogger(String.valueOf(logger.getName()) + '.' + suffix);
    }

    public static Logger getLogger(Class clazz, Plugin plugin) {
        return Logger.getLogger(clazz.getName().replace('$', '.'), plugin);
    }

    public static Logger getLogger(String name, Plugin plugin) {
        Logger logger = Logger.getLogger(name);
        logger.setLevelFromDebug(plugin);
        return logger;
    }

    public static Logger getLoggerUsingDebug(String debugOption) {
        Logger logger = Logger.getLogger(debugOption);
        logger.setLevelFromDebug(debugOption);
        return logger;
    }

    public static Logger getLoggerUsingDebug(String name, Plugin plugin) {
        return Logger.getLoggerUsingDebug(LogManager.getDebugOption(name, plugin));
    }

    public static Logger getLogger(Class clazz, String debugOption) {
        Logger logger = Logger.getLogger(clazz.getName());
        if (Boolean.valueOf(Platform.getDebugOption((String)debugOption)).booleanValue()) {
            logger.setMinLevel(Level.DEBUG);
        }
        return logger;
    }

    public static SupplementaryLogger getSupplementaryLogger(String name) {
        return new SupplementaryLogger(name);
    }

    public static Logger getGlobalLogger() {
        return Logger.getLogger(GLOBAL_NAME);
    }

    protected Logger(String name) {
        this.name = name;
        this.minLevel = Level.INFO;
    }

    public String toString() {
        return String.valueOf(this.name) + ' ' + Level.getName(this.minLevel);
    }

    public String getName() {
        return this.name;
    }

    public String getSimpleName() {
        return LogUtil.getSimpleName(this.name);
    }

    public void setMinLevel(int level) {
        if (level == -1) {
            return;
        }
        this.minLevel = level;
        LogManager.setLevelAll(level, this);
    }

    public void setLevel(int level, ILogListener listener) {
        if (level < this.minLevel) {
            this.minLevel = level;
        }
        LogManager.setLevel(Level.DEBUG, this, listener);
    }

    public String getAttr(String attrName) {
        return (String)this.attrs.get(attrName.toLowerCase());
    }

    void setAttr(String name, String value) {
        if (this.attrs == Collections.EMPTY_MAP) {
            this.attrs = new TreeMap();
        }
        this.attrs.put(name.toLowerCase(), value);
    }

    void clearAttrs() {
        this.attrs = Collections.EMPTY_MAP;
    }

    public void setStackFilter(LogStackFilter stackFilter) {
        assert (stackFilter != null);
        this.stackFilter = stackFilter;
    }

    private void setLevelFromDebug(Plugin plugin) {
        this.setMinLevel(LogManager.getLevelFromDebug(this.getSimpleName(), plugin));
    }

    private void setLevelFromDebug(String debugOption) {
        this.setMinLevel(LogManager.getLevelFromDebug(debugOption));
    }

    public boolean isLoggable(int level) {
        return level >= this.minLevel;
    }

    public LogEntry log(int level, Throwable exception, String msg, Object ... args) {
        return this.log(level, null, 0, null, exception, msg, args);
    }

    public LogEntry log(int level, String href, String msg, Object[] args) {
        return this.log(level, href, 0, null, null, msg, args);
    }

    public LogEntry log(int level, String href, int startNum, String uid, Throwable exception, String msg, Object ... args) {
        if (!this.isLoggable(level)) {
            return null;
        }
        return this.log(level, href, startNum, uid, null, null, null, exception, msg, args);
    }

    private LogEntry log(int level, String href, int startNum, String uid, String explanation, String userAction, String additionalInfo, Throwable exception, String msg, Object ... args) {
        if (!this.isLoggable(level)) {
            return null;
        }
        LogEntry entry = new LogEntry(this, level, startNum, exception, msg, args);
        if (uid != null) {
            entry.setUid(uid);
        }
        if (href != null) {
            entry.setHref(href);
        }
        if (additionalInfo != null) {
            entry.setAdditionalInfo(additionalInfo);
        }
        if (explanation != null) {
            entry.setExplanation(explanation);
        }
        if (userAction != null) {
            entry.setUserAction(userAction);
        }
        return this.log(entry);
    }

    protected LogEntry log(LogEntry entry) {
        LogManager.logAll(entry);
        return entry;
    }

    public boolean isDebugLoggable() {
        return this.isLoggable(Level.DEBUG);
    }

    public boolean isInfoLoggable() {
        return this.isLoggable(Level.INFO);
    }

    public boolean isNoteLoggable() {
        return this.isLoggable(Level.NOTE);
    }

    public boolean isWarningLoggable() {
        return this.isLoggable(Level.WARNING);
    }

    public boolean isErrorLoggable() {
        return this.isLoggable(Level.ERROR);
    }

    public LogEntry statusNotOK(IStatus status) {
        if (status.isOK()) {
            return null;
        }
        return this.status(status);
    }

    public LogEntry status(String msg, IStatus status) {
        if (msg != null) {
            return this.status(Statuses.ST.createMultiStatusWithChild(status, msg, new Object[0]));
        }
        return this.status(status);
    }

    private static boolean matchesPrevStatus(IStatus status) {
        if (status == prevStatus) {
            return true;
        }
        prevStatus = status;
        return false;
    }

    public LogEntry status(IStatus status) {
        if (Logger.matchesPrevStatus(status)) {
            return null;
        }
        IStatus[] children = status.getChildren();
        if (status.getMessage().isEmpty() && children.length > 0) {
            LogEntry entry = null;
            IStatus[] iStatusArray = children;
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                IStatus child = iStatusArray[n2];
                entry = this.status(child);
                ++n2;
            }
            return Check.notNull(entry);
        }
        int level = status.matches(12) ? Level.ERROR : (status.matches(2) ? Level.WARNING : Level.NOTE);
        String explanation = null;
        String userAction = null;
        String message = status.getMessage();
        Object[] args = null;
        if (status instanceof ICicStatus) {
            ICicStatus cicStatus = (ICicStatus)status;
            explanation = cicStatus.getExplanation();
            userAction = cicStatus.getUserAction();
            message = cicStatus.getOrigMessage();
            args = cicStatus.getMessageArgs();
        }
        return this.log(level, null, 0, UidUtil.getUid(status), explanation, userAction, new StatusFormatter().indent().formatChildren(status), status.getException(), message, args);
    }

    public LogEntry debug(Object obj) {
        return this.log(Level.DEBUG, obj.toString());
    }

    public LogEntry debug(String str) {
        return this.log(Level.DEBUG, str);
    }

    public LogEntry info(String msg) {
        return this.log(Level.INFO, msg);
    }

    public LogEntry error(String msg) {
        return this.status(Statuses.ERROR.get(msg, new Object[0]));
    }

    public LogEntry warning(String msg) {
        return this.status(Statuses.WARNING.get(msg, new Object[0]));
    }

    public LogEntry log(int level, String msg) {
        return this.log(level, (Throwable)null, msg, new Object[0]);
    }

    public LogEntry debug(Throwable e) {
        return this.log(Level.DEBUG, e, Messages.Logger_Unexpected_Exception_Info, new Object[0]);
    }

    public LogEntry info(Throwable e) {
        return this.log(Level.INFO, e, Messages.Logger_Unexpected_Exception_Info, new Object[0]);
    }

    public LogEntry note(Throwable e) {
        return this.status(Statuses.INFO.get(e, Messages.Logger_Unexpected_Exception_Info, new Object[0]));
    }

    public LogEntry warning(Throwable e) {
        return this.status(Statuses.WARNING.get(e, Messages.Logger_Unexpected_Exception_Warning, new Object[0]));
    }

    public LogEntry error(Throwable e) {
        return this.status(Statuses.ERROR.get(e, Messages.Logger_Unexpected_Exception_Error, new Object[0]));
    }

    public LogEntry debug(String msg, Object ... args) {
        return this.log(Level.DEBUG, (Throwable)null, msg, args);
    }

    public LogEntry info(String msg, Object ... args) {
        return this.log(Level.INFO, (Throwable)null, msg, args);
    }

    public LogEntry warning(String msg, Object ... args) {
        return this.status(Statuses.WARNING.get(msg, args));
    }

    public LogEntry warningNoUid(String msg, Object ... args) {
        return this.log(Level.WARNING, null, 0, null, null, null, null, null, msg, args);
    }

    public LogEntry error(Throwable e, String msg, Object ... args) {
        return this.status(Statuses.ERROR.get(e, msg, args));
    }

    public LogEntry error(String msg, Object ... args) {
        return this.status(Statuses.ERROR.get(msg, args));
    }

    public LogEntry errorNoUid(String msg, Object ... args) {
        return this.log(Level.ERROR, null, 0, null, null, null, null, null, msg, args);
    }

    public LogEntry note(String msg, Object ... args) {
        return this.status(Statuses.INFO.get(msg, args));
    }

    public synchronized void start(LogEntry entry) {
        if (this.started == null) {
            this.started = new LinkedList();
        }
        this.started.addFirst(entry);
    }

    public synchronized void stop() {
        if (this.started == null || this.started.size() == 0) {
            this.warning(Messages.Logger_Stop_Called_Without_Matching_Start);
            return;
        }
        LogEntry entry = (LogEntry)this.started.removeFirst();
        if (entry != null) {
            LogEntry stopEntry = new LogEntry(this, entry.getLevel(), entry.getNum(), null, Messages.Logger_Elapsed_Time_Seconds_For, LogUtil.toElapsedTime(System.currentTimeMillis() - entry.getTime()), entry.getFormattedMessage());
            LogManager.logAll(stopEntry);
        }
    }

    public boolean isLogger(StackTraceElement ste) {
        return this.stackFilter.isLogger(ste) || LogUtil.isLogger(ste.getClassName());
    }

    public static interface LogStackFilter {
        public static final LogStackFilter NULL = new LogStackFilter(){

            @Override
            public boolean isLogger(StackTraceElement ste) {
                return false;
            }
        };

        public boolean isLogger(StackTraceElement var1);
    }

    public static class SupplementaryLogger
    extends Logger {
        private final FileLog fileLog;

        private SupplementaryLogger(String name) {
            super(name);
            SupplementaryFileLog myFileLog;
            LogManager.setLevelAll(Level.MAX, this);
            try {
                myFileLog = new SupplementaryFileLog(name);
                this.setLevel(Level.DEBUG, myFileLog);
            }
            catch (IOException e) {
                SupplementaryLogger.getGlobalLogger().error(e);
                myFileLog = null;
            }
            this.fileLog = myFileLog;
        }

        @Override
        protected LogEntry log(LogEntry entry) {
            return super.log(entry);
        }

        public int getErrorCount() {
            return this.fileLog == null ? 0 : this.fileLog.getErrorCount();
        }

        public int getWarningCount() {
            return this.fileLog == null ? 0 : this.fileLog.getErrorCount();
        }

        public String getPath() {
            return this.fileLog == null ? null : this.fileLog.getFile().getPath();
        }

        public void delete() {
            if (this.fileLog != null) {
                this.fileLog.close();
                File file = this.fileLog.getFile();
                if (file != null) {
                    file.delete();
                    file.getParentFile().delete();
                }
            }
        }

        public void close() {
            if (this.fileLog != null) {
                this.fileLog.close();
            }
        }
    }
}

