/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.logging;

import com.ibm.cic.common.core.internal.Messages;
import com.ibm.cic.common.core.utils.FileUtil;
import com.ibm.cic.common.core.utils.SortedProperties;
import com.ibm.cic.common.core.utils.TempUtil;
import com.ibm.cic.common.logging.ConsoleLog;
import com.ibm.cic.common.logging.ExceptionUtil;
import com.ibm.cic.common.logging.FileLog;
import com.ibm.cic.common.logging.ILogListener;
import com.ibm.cic.common.logging.Level;
import com.ibm.cic.common.logging.LogEntry;
import com.ibm.cic.common.logging.LogUtil;
import com.ibm.cic.common.logging.Logger;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.osgi.util.NLS;

public class LogManager {
    private static final String DEBUG_OPTION_NAME = "debug";
    private static final String DEBUG_OPTION = "/debug/";
    private static final String LOGGING_OPTION = "/logging/";
    private static final String SAMPLE_PROPERTIES = "sample.properties";
    private static Logger log;
    private static Map loggers;
    private static Properties debugProperties;
    private static List listeners;
    private static List logDirChangeListeners;
    private static File logDirectory;
    private static FileLog fileLog;

    static {
        debugProperties = new SortedProperties();
        listeners = new LinkedList();
        logDirChangeListeners = Collections.EMPTY_LIST;
        logDirectory = null;
        fileLog = null;
    }

    private LogManager() {
    }

    static synchronized Logger getLogger(String name) {
        Logger oldLogger;
        if (loggers == null) {
            loggers = new HashMap();
            LogManager.initialize();
        }
        if ((oldLogger = (Logger)loggers.get(name)) != null) {
            return oldLogger;
        }
        debugProperties.setProperty(name, Level.getName(Level.DEBUG));
        Logger newLogger = new Logger(name);
        loggers.put(name, newLogger);
        LogProperties.setLevel(newLogger);
        return newLogger;
    }

    public static synchronized void addListener(ILogListener listener) {
        LogManager.addListener(listener, -1);
    }

    public static synchronized void addListener(ILogListener listener, int level) {
        ListenerWrapper wrapper = new ListenerWrapper(listener, level);
        listeners.add(wrapper);
        LogProperties.setLevel(wrapper);
        LogManager.setDirectory(listener);
    }

    public static synchronized void removeListener(ILogListener listener) {
        ListIterator i = listeners.listIterator();
        while (i.hasNext()) {
            ListenerWrapper wrapper = (ListenerWrapper)i.next();
            if (!wrapper.getListener().equals(listener)) continue;
            i.remove();
            return;
        }
    }

    public static synchronized List getListeners(Class cls) {
        ArrayList<ILogListener> list = new ArrayList<ILogListener>();
        ListIterator i = listeners.listIterator();
        while (i.hasNext()) {
            ListenerWrapper wrapper = (ListenerWrapper)i.next();
            if (!wrapper.getListener().getClass().equals(cls)) continue;
            list.add(wrapper.getListener());
        }
        return list;
    }

    public static synchronized void reportError(Exception e) {
        System.err.println(NLS.bind((String)Messages.LogListener_Unexpected_Exception_During_Logging, (Object)e));
        e.printStackTrace();
    }

    public static synchronized void reportError(String str) {
        System.err.println(str);
    }

    public static synchronized File getLogPropertiesFile() {
        return LogProperties.getFile();
    }

    public static synchronized File getDefaultLogFile() {
        return fileLog.getFile();
    }

    public static synchronized File createSupplementaryLogFile(String subDirectory, String fileExtension) {
        File subDirectoryFile = new File(logDirectory, subDirectory);
        File result = LogUtil.createLogFile(subDirectoryFile, System.currentTimeMillis(), fileExtension);
        if (result == null) {
            Logger.getGlobalLogger().error(Messages.LogManager_Failed_To_Create_Supplementary_Logger, subDirectoryFile.getAbsolutePath());
        }
        return result;
    }

    public static void addLogDirChangeListener(ILogDirChangeListener listener) {
        if (logDirChangeListeners == Collections.EMPTY_LIST) {
            logDirChangeListeners = new LinkedList();
        }
        logDirChangeListeners.add(listener);
    }

    public static void removeLogDirChangeListener(ILogDirChangeListener listener) {
        logDirChangeListeners.remove(listener);
    }

    public static synchronized void setDirectory(String dirName) {
        LogManager.setDirectory(new File(dirName));
    }

    public static synchronized void setDirectory(File dir) {
        logDirectory = dir;
        dir.mkdirs();
        for (ListenerWrapper wrapper : listeners) {
            LogManager.setDirectory(wrapper.getListener());
        }
        LogManager.rereadProperties();
        for (ILogDirChangeListener l : logDirChangeListeners) {
            l.logDirChanged(dir);
        }
    }

    public static File getDirectory() {
        return logDirectory;
    }

    private static void rereadProperties() {
        try {
            LogProperties.readProperties(logDirectory);
        }
        catch (IOException e) {
            log.error(Messages.LogManager_Error_Reading_Log_Properties, LogProperties.getFile(), e);
            return;
        }
        LogProperties.setListenerLevels(listeners);
        LogProperties.setLoggerLevels(loggers.values());
    }

    public static synchronized int setDefaultLevel(String name, int level) {
        return LogProperties.setDefaultLevel(name, level);
    }

    public static synchronized Integer getListenerDefaultLevel(String name) {
        ListIterator i = listeners.listIterator();
        while (i.hasNext()) {
            ListenerWrapper wrapper = (ListenerWrapper)i.next();
            if (!wrapper.getListener().getClass().getName().equals(name)) continue;
            return wrapper.getDefaultLevel();
        }
        return null;
    }

    public static synchronized void resetDirectory() {
        logDirectory = null;
        for (ListenerWrapper wrapper : listeners) {
            ILogListener listener = wrapper.getListener();
            if (!(listener instanceof FileLog)) continue;
            ((FileLog)listener).resetDirectory();
        }
    }

    public static File createExternalLogFile(String prefix, String suffix) {
        File result = LogUtil.createLogFile(logDirectory, prefix, System.currentTimeMillis(), suffix);
        if (result == null) {
            Logger.getGlobalLogger().error(Messages.LogManager_Fail_Create_External_Log_File);
        }
        return result;
    }

    static synchronized void logAll(LogEntry entry) {
        for (ListenerWrapper wrapper : listeners) {
            if (!wrapper.isLoggable(entry)) continue;
            wrapper.getListener().logEntry(entry);
        }
    }

    static synchronized void setLevel(int level, Logger logger, ILogListener listener) {
        ListIterator i = listeners.listIterator();
        while (i.hasNext()) {
            ListenerWrapper wrapper = (ListenerWrapper)i.next();
            if (!wrapper.getListener().equals(listener)) continue;
            wrapper.setLevel(level, logger);
        }
    }

    static synchronized void setLevelAll(int level, Logger logger) {
        for (ListenerWrapper wrapper : listeners) {
            wrapper.setLevel(level, logger);
        }
    }

    static String getDebugOption(String name, Plugin plugin) {
        String pluginId = plugin != null ? plugin.getBundle().getSymbolicName() : "";
        return String.valueOf(pluginId) + DEBUG_OPTION + name;
    }

    static int getLevelFromDebug(String name, Plugin plugin) {
        return LogManager.getLevelFromDebug(LogManager.getDebugOption(name, plugin));
    }

    static synchronized int getLevelFromDebug(String debugOption) {
        String loggingOption = LogManager.getLoggingOption(debugOption);
        debugProperties.setProperty(debugOption, Boolean.TRUE.toString());
        if (loggingOption != null) {
            debugProperties.setProperty(loggingOption, Level.getName(Level.DEBUG));
        }
        if (Boolean.valueOf(Platform.getDebugOption((String)debugOption)).booleanValue()) {
            return Level.DEBUG;
        }
        if (loggingOption != null) {
            return Level.getLevel(Platform.getDebugOption((String)loggingOption));
        }
        return -1;
    }

    private static String getLoggingOption(String debugOption) {
        int i = debugOption.indexOf(DEBUG_OPTION);
        return i < 0 ? null : String.valueOf(debugOption.substring(0, i)) + LOGGING_OPTION + debugOption.substring(i + DEBUG_OPTION.length());
    }

    private static void initialize() {
        try {
            ConsoleLog consoleLog = new ConsoleLog();
            LogManager.addListener(consoleLog, Level.NOTE);
        }
        catch (Throwable t) {
            System.err.println(NLS.bind((String)Messages.LogManager_Error_Setting_Up_Logging, (Object)t));
        }
        try {
            fileLog = new FileLog();
            LogManager.addListener(fileLog, Level.INFO);
        }
        catch (Throwable t) {
            System.err.println(NLS.bind((String)Messages.LogManager_Error_Setting_Up_Logging, (Object)t));
        }
        log = Logger.getLogger(LogManager.class);
        if (logDirectory == null) {
            LogManager.setDirectory(LogManager.getTempLogDir());
        }
        log.info(Messages.LogManager_Initial_Log_File, fileLog);
        try {
            if (Platform.isRunning()) {
                Platform.addLogListener((org.eclipse.core.runtime.ILogListener)new PlatformLogListener());
            }
        }
        catch (Throwable t) {
            System.err.println(NLS.bind((String)Messages.LogManager_Error_Setting_Up_Logging, (Object)t));
        }
        Runtime.getRuntime().addShutdownHook(new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    LogManager.closeAll();
                }
                catch (Throwable t) {
                    ExceptionUtil.ignore(t);
                }
            }
        }));
    }

    private static void setDirectory(ILogListener listener) {
        if (logDirectory != null && listener instanceof FileLog) {
            ((FileLog)listener).setDirectory(logDirectory);
        }
    }

    public static synchronized void closeAll() {
        if (!listeners.isEmpty()) {
            for (ListenerWrapper wrapper : listeners) {
                wrapper.getListener().close();
            }
            listeners.clear();
            LogManager.saveDebugProperties();
        }
    }

    private static void saveDebugProperties() {
        block6: {
            if (logDirectory == null) {
                return;
            }
            File file = new File(logDirectory, SAMPLE_PROPERTIES);
            FileOutputStream out = null;
            try {
                try {
                    out = new FileOutputStream(file);
                    debugProperties.store(out, NLS.bind((String)Messages.LogManager_Sample_Debug_Properties, (Object)"log.properties"));
                }
                catch (IOException e) {
                    LogManager.reportError(e);
                    FileUtil.close(out);
                    break block6;
                }
            }
            catch (Throwable throwable) {
                FileUtil.close(out);
                throw throwable;
            }
            FileUtil.close(out);
        }
    }

    private static File getTempLogDir() {
        try {
            String user = System.getProperty("user.name");
            String prefix = "ciclogs";
            if (user != null && user.length() > 0) {
                prefix = String.valueOf(prefix) + "_" + user;
            }
            File tempDir = TempUtil.getJavaTempDir();
            return new File(tempDir, prefix);
        }
        catch (CoreException e) {
            return new File(System.getProperty("java.io.tmpdir"));
        }
    }

    public static interface ILogDirChangeListener {
        public void logDirChanged(File var1);
    }

    private static class ListenerWrapper {
        private static final int DEFAULT_LEVEL = Level.INFO;
        private final Map loggerLevel = new HashMap();
        private int defaultLevel;
        private int minLevel = DEFAULT_LEVEL;
        private final String name;
        private final ILogListener listener;

        public ListenerWrapper(ILogListener listener, int defaultLevel) {
            this.listener = listener;
            this.name = listener.getClass().getName();
            this.defaultLevel = defaultLevel == -1 ? DEFAULT_LEVEL : defaultLevel;
        }

        public int getDefaultLevel() {
            return this.defaultLevel;
        }

        public String toString() {
            return String.valueOf(this.name) + ' ' + Level.getName(this.defaultLevel);
        }

        public ILogListener getListener() {
            return this.listener;
        }

        public String getName() {
            return this.name;
        }

        public void setDefaultLevel(int defaultLevel) {
            this.defaultLevel = defaultLevel;
            this.minLevel = this.computeMinLevel();
        }

        public void setLevel(int level, Logger logger) {
            if (level == -1) {
                this.loggerLevel.remove(logger.getName());
            } else {
                this.loggerLevel.put(logger.getName(), level);
            }
            this.minLevel = this.computeMinLevel();
        }

        public boolean isLoggable(LogEntry entry) {
            int level;
            if (entry.getLevel() < this.minLevel) {
                return false;
            }
            Integer intLevel = (Integer)this.loggerLevel.get(entry.getLoggerName());
            int n = level = intLevel == null ? this.defaultLevel : intLevel;
            return entry.getLevel() >= level;
        }

        private int computeMinLevel() {
            int result = this.defaultLevel;
            for (Integer level : this.loggerLevel.values()) {
                if (level >= result) continue;
                result = level;
            }
            return result;
        }
    }

    private static class LogProperties {
        private static final String LOG_PROPERTIES_PROPERTY = "com.ibm.cic.common.logging.config";
        private static final String LOG_PROPERTIES_FILE = "log.properties";
        private static Map props = new TreeMap();
        private static Map defaultProps = new TreeMap();
        private static LoggerAttrs attrs = new LoggerAttrs();
        private static File propFile = null;
        private static Logger myLog = null;

        private LogProperties() {
        }

        public static File getFile() {
            return propFile;
        }

        private static boolean isDebugProperty(String name) {
            int i = name.indexOf("/debug");
            if (i == -1) {
                return false;
            }
            if ((i = i + 1 + LogManager.DEBUG_OPTION_NAME.length()) == name.length()) {
                return true;
            }
            return name.charAt(i) == '/';
        }

        public static void readProperties(File logDir) throws IOException {
            if (myLog == null) {
                myLog = Logger.getLogger(LogProperties.class);
            }
            propFile = LogProperties.getLogPropertiesFile(logDir);
            props.clear();
            props.putAll(defaultProps);
            attrs.clear();
            if (propFile == null) {
                myLog.info(Messages.LogManager_No_Log_Properties_File_Found, logDir);
            } else {
                Properties properties = new Properties();
                try (FileInputStream is = new FileInputStream(propFile);){
                    properties.load(is);
                }
                Enumeration<?> e = properties.propertyNames();
                while (e.hasMoreElements()) {
                    String name = (String)e.nextElement();
                    String value = properties.getProperty(name).trim();
                    if (LogProperties.isDebugProperty(name)) {
                        attrs.add(name, value);
                        Boolean b = Boolean.valueOf(value);
                        if (!b.equals(Boolean.TRUE)) continue;
                        props.put(name, b);
                        continue;
                    }
                    if (attrs.add(name, value)) continue;
                    String levelName = value;
                    int level = Level.getLevel(levelName);
                    if (level == -1) {
                        myLog.warning(Messages.LogManager_Bad_Level_Name, propFile, levelName);
                        continue;
                    }
                    props.put(name, level);
                }
                myLog.info(Messages.LogManager_Log_Properties_File, propFile);
            }
        }

        public static int setDefaultLevel(String name, int level) {
            Object result = level == -1 ? defaultProps.remove(name) : defaultProps.put(name, level);
            LogManager.rereadProperties();
            return result == null ? -1 : (Integer)result;
        }

        public static void setListenerLevels(List listeners) {
            for (ListenerWrapper wrapper : listeners) {
                LogProperties.setLevel(wrapper);
            }
        }

        public static void setLoggerLevels(Collection loggers) {
            for (Logger logger : loggers) {
                LogManager.setLevelAll(-1, logger);
                logger.clearAttrs();
                LogProperties.setLevel(logger);
            }
        }

        public static void setLevel(ListenerWrapper wrapper) {
            for (Map.Entry entry : props.entrySet()) {
                String name = (String)entry.getKey();
                if (LogProperties.isDebugProperty(name)) {
                    if (!name.equals(wrapper.getName())) continue;
                    wrapper.setDefaultLevel(Level.DEBUG);
                    continue;
                }
                if (!LogProperties.matches(name, wrapper)) continue;
                int level = (Integer)entry.getValue();
                wrapper.setDefaultLevel(level);
            }
        }

        public static void setLevel(Logger logger) {
            for (Map.Entry entry : props.entrySet()) {
                String name = (String)entry.getKey();
                if (LogProperties.isDebugProperty(name)) {
                    if (!name.equals(logger.getName())) continue;
                    logger.setMinLevel(Level.DEBUG);
                    continue;
                }
                if (!LogProperties.matches(name, logger)) continue;
                int level = (Integer)entry.getValue();
                logger.setMinLevel(level);
            }
            for (String name : attrs.getLoggerNames()) {
                if (!LogProperties.matches(name, logger)) continue;
                for (Map.Entry attr : attrs.getAttrs(name).entrySet()) {
                    logger.setAttr((String)attr.getKey(), (String)attr.getValue());
                }
            }
        }

        private static boolean matches(String name, ListenerWrapper wrapper) {
            String listenerName = wrapper.getName();
            return listenerName.equals(name) || LogUtil.getSimpleName(listenerName).equals(name);
        }

        private static boolean matches(String name, Logger logger) {
            String loggerName = logger.getName();
            return loggerName.equals(name) || loggerName.startsWith(String.valueOf(name) + '.') || loggerName.endsWith(String.valueOf('.') + name);
        }

        private static File getLogPropertiesFile(File logDir) {
            File logFile;
            String def = System.getProperty(LOG_PROPERTIES_PROPERTY);
            if (def != null) {
                return new File(def);
            }
            if (logDir != null && (logFile = new File(logDir, LOG_PROPERTIES_FILE)).exists()) {
                return logFile;
            }
            logFile = new File(System.getProperty("user.home"), LOG_PROPERTIES_FILE);
            if (logFile.exists()) {
                return logFile;
            }
            return null;
        }
    }

    private static class LoggerAttrs {
        private final Map map = new TreeMap();

        public String toString() {
            return this.map.toString();
        }

        public boolean add(String propName, String propValue) {
            String loggerName;
            TreeMap<String, String> attrs;
            int i = propName.indexOf(47);
            if (i <= 0) {
                return false;
            }
            String attrName = propName.substring(i + 1);
            if (attrName.startsWith(LogManager.DEBUG_OPTION_NAME)) {
                if (attrName.length() == LogManager.DEBUG_OPTION_NAME.length()) {
                    return false;
                }
                if (attrName.charAt(LogManager.DEBUG_OPTION_NAME.length()) == '/') {
                    int debugLen = LogManager.DEBUG_OPTION_NAME.length() + 1;
                    i += debugLen;
                    attrName = attrName.substring(debugLen);
                }
            }
            if ((attrs = (TreeMap<String, String>)this.map.get(loggerName = propName.substring(0, i))) == null) {
                attrs = new TreeMap<String, String>();
                this.map.put(loggerName, attrs);
            }
            attrs.put(attrName, propValue);
            return true;
        }

        public Set getLoggerNames() {
            return this.map.keySet();
        }

        public Map getAttrs(String loggerName) {
            Map attrs = (Map)this.map.get(loggerName);
            return attrs != null ? attrs : Collections.EMPTY_MAP;
        }

        public void clear() {
            this.map.clear();
        }
    }

    private static class PlatformLogListener
    implements org.eclipse.core.runtime.ILogListener {
        private PlatformLogListener() {
        }

        public void logging(IStatus status, String plugin) {
            log.status(status);
        }
    }
}

