/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.downloads;

import com.ibm.cic.common.core.artifactrepo.impl.Messages;
import com.ibm.cic.common.core.internal.ComIbmCicCommonCorePlugin;
import com.ibm.cic.common.core.internal.utils.CicCommonCoreDebugOptions;
import com.ibm.cic.common.core.internal.utils.CicCommonCoreTrace;
import com.ibm.cic.common.core.utils.ICicStatus;
import com.ibm.cic.common.core.utils.Statuses;
import com.ibm.cic.common.downloads.DownloadHandler;
import com.ibm.cic.common.downloads.ProxySupport;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IRegistryChangeEvent;
import org.eclipse.core.runtime.IRegistryChangeListener;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.osgi.util.NLS;

public class TransferManager
implements IRegistryChangeListener {
    private static final CicCommonCoreTrace trace = new CicCommonCoreTrace(ComIbmCicCommonCorePlugin.getDefault(), CicCommonCoreDebugOptions.DOWNLOAD_HANDLER_MANAGEMENT);
    private static final String PT_DOWNLOAD_HANDLERS = "downloadHandlers";
    private static final String ELEMENT_DOWNLOAD_HANDLER = "downloadHandler";
    private static final String ATTRIBUTE_CLASS = "class";
    private static final String ATTRIBUTE_TYPE = "type";
    private static final String ATTRIBUTE_IS_DEFAULT_HANDLER = "defaultHandler";
    private static final String[] DEFAULT_HANDLER_ORDER = new String[]{"com.ibm.cic.common.transports.httpclient.HttpClientDownloadHandler", "com.ibm.cic.common.transports.commons.net.FtpCommonsNetDownloadHandler"};
    private static final String DOWNLOAD_HANDLER_EXTENSION_POINT = "com.ibm.cic.common.core.downloadHandlers";
    public static final TransferManager INSTANCE = new TransferManager();
    private final HashMap mapHandlers = new HashMap();
    private List<String> fromListOrder = Arrays.asList(DEFAULT_HANDLER_ORDER);

    private static boolean isDefaultHandler(IConfigurationElement handler) {
        String strIsDefaultHandler = handler.getAttribute(ATTRIBUTE_IS_DEFAULT_HANDLER);
        boolean isDefaultHandler = strIsDefaultHandler != null && Boolean.valueOf(strIsDefaultHandler).equals(Boolean.TRUE);
        return isDefaultHandler;
    }

    private void initHandler(String protocol) {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        registry.addRegistryChangeListener((IRegistryChangeListener)this, DOWNLOAD_HANDLER_EXTENSION_POINT);
        IConfigurationElement[] elements = registry.getConfigurationElementsFor(ComIbmCicCommonCorePlugin.getPluginId(), PT_DOWNLOAD_HANDLERS);
        try {
            IConfigurationElement ceHandler;
            ArrayList<IConfigurationElement> listNonDefaultHandlers = new ArrayList<IConfigurationElement>();
            ArrayList<IConfigurationElement> listDefaultHandlers = new ArrayList<IConfigurationElement>();
            ArrayList<IConfigurationElement> listAllHandlers = new ArrayList<IConfigurationElement>();
            IConfigurationElement[] iConfigurationElementArray = elements;
            int n = elements.length;
            int n2 = 0;
            while (n2 < n) {
                ceHandler = iConfigurationElementArray[n2];
                if (ELEMENT_DOWNLOAD_HANDLER.equalsIgnoreCase(ceHandler.getName())) {
                    String type = ceHandler.getAttribute(ATTRIBUTE_TYPE);
                    if (TransferManager.trace.enabled) {
                        String cls;
                        if (TransferManager.isDefaultHandler(ceHandler)) {
                            cls = ceHandler.getAttribute(ATTRIBUTE_CLASS);
                            trace.println("{0} handler: registry defines default handler {1},", type, cls);
                        } else {
                            cls = ceHandler.getAttribute(ATTRIBUTE_CLASS);
                            trace.println("{0} handler: registry defines non-default handler {1},", type, cls);
                        }
                    }
                    if (protocol.equals(type)) {
                        listAllHandlers.add(ceHandler);
                        if (TransferManager.isDefaultHandler(ceHandler)) {
                            listDefaultHandlers.add(ceHandler);
                        } else {
                            listNonDefaultHandlers.add(ceHandler);
                        }
                    }
                }
                ++n2;
            }
            if (TransferManager.trace.enabled) {
                if (this.fromListOrder.size() > 0) {
                    trace.println("Effective order list:");
                    Iterator<String> iterator = this.fromListOrder.iterator();
                    while (iterator.hasNext()) {
                        String element;
                        String className = element = iterator.next();
                        trace.println("... ''{0}''", className);
                    }
                } else {
                    trace.println("Effective order list is EMPTY");
                }
            }
            if (listAllHandlers.size() > 0 && this.fromListOrder.size() > 0) {
                Iterator<String> iterator = this.fromListOrder.iterator();
                while (iterator.hasNext()) {
                    String element2;
                    String className = element2 = iterator.next();
                    for (IConfigurationElement element : listAllHandlers) {
                        String classNameElement = element.getAttribute(ATTRIBUTE_CLASS);
                        if (!className.equals(classNameElement)) continue;
                        DownloadHandler handler = (DownloadHandler)element.createExecutableExtension(ATTRIBUTE_CLASS);
                        this.mapHandlers.put(protocol, handler);
                        if (TransferManager.trace.enabled) {
                            trace.println("Picked {0}", classNameElement);
                        }
                        return;
                    }
                }
                if (TransferManager.trace.enabled) {
                    trace.println("Effective order list has no matches");
                }
            }
            ceHandler = null;
            if (listNonDefaultHandlers.size() > 0) {
                ceHandler = (IConfigurationElement)listNonDefaultHandlers.get(0);
                if (TransferManager.trace.enabled) {
                    String cls = ceHandler.getAttribute(ATTRIBUTE_CLASS);
                    trace.println("Picking first non-default handler: {0}", cls);
                }
            } else if (listDefaultHandlers.size() > 0) {
                ceHandler = (IConfigurationElement)listDefaultHandlers.get(0);
                if (TransferManager.trace.enabled) {
                    String cls = ceHandler.getAttribute(ATTRIBUTE_CLASS);
                    trace.println("No non-default handler specified");
                    trace.println("Picking first default handler: {0}", cls);
                }
            } else if (TransferManager.trace.enabled) {
                trace.println("{0} handler: None available", protocol);
            }
            DownloadHandler handler = null;
            if (ceHandler != null) {
                handler = (DownloadHandler)ceHandler.createExecutableExtension(ATTRIBUTE_CLASS);
            }
            this.mapHandlers.put(protocol, handler);
            return;
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        catch (ClassCastException e) {
            e.printStackTrace();
        }
        this.mapHandlers.put(protocol, null);
    }

    public synchronized DownloadHandler getHandler(String protocol) {
        if (!this.mapHandlers.containsKey(protocol)) {
            this.initHandler(protocol);
        }
        DownloadHandler handler = (DownloadHandler)this.mapHandlers.get(protocol);
        return handler;
    }

    public DownloadHandler getHandlerNotNull(String protocol) throws CoreException {
        DownloadHandler handler = this.getHandler(protocol);
        if (handler == null) {
            String msg = NLS.bind((String)Messages.no_download_handler_available, (Object)protocol);
            ICicStatus status = Statuses.ERROR.get(103, msg, new Object[0]);
            throw new CoreException((IStatus)status);
        }
        return handler;
    }

    public void setOrderList(List<String> list) {
        this.fromListOrder = new ArrayList<String>(list);
        this.mapHandlers.clear();
        if (TransferManager.trace.enabled) {
            trace.println("TransferManager, effective order list changed: clearing cache.");
        }
    }

    public void registryChanged(IRegistryChangeEvent event) {
        this.mapHandlers.clear();
        if (TransferManager.trace.enabled) {
            trace.println("TransferManager registry changed: clearing cache.");
        }
    }

    public ProxySupport getProxySupport(String protocol) {
        DownloadHandler handler = this.getHandler(protocol);
        if (handler != null) {
            return handler.getProxySupport();
        }
        return null;
    }

    public boolean shouldUseMultipleThreads(URL url) {
        DownloadHandler handler = this.getHandler(url.getProtocol());
        if (handler != null) {
            return handler.shouldUseMultipleThreads(url);
        }
        return false;
    }
}

