/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.downloads;

import com.ibm.cic.common.downloads.ContentInfo;
import com.ibm.cic.common.downloads.DigestValue;
import com.ibm.cic.common.downloads.IContentInfo;
import com.ibm.cic.common.downloads.IMessageDigests;
import com.ibm.cic.common.downloads.IMutableContentInfo;
import com.ibm.cic.common.downloads.SizeInfo;
import java.util.AbstractList;
import java.util.AbstractSet;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;

public class SimpleContentInfo
implements IMutableContentInfo {
    private SizeInfo sizeInfo = new SizeInfo();
    private DigestValue[] digests;
    private static final DigestValue[] NO_DIGESTS = new DigestValue[0];

    public SimpleContentInfo(long size) {
        this();
        this.setSize(size);
    }

    public SimpleContentInfo() {
        this.digests = NO_DIGESTS;
    }

    public SimpleContentInfo(IContentInfo ci) {
        this(ci.getSizeInfo(), ci);
    }

    public SimpleContentInfo(SizeInfo sizeInfo, IMessageDigests digests) {
        SizeInfo cpSizeInfo = new SizeInfo();
        if (sizeInfo != null) {
            cpSizeInfo.setDownloadSize(sizeInfo.getDownloadSize());
            cpSizeInfo.setInstallSize(sizeInfo.getInstallSize());
        }
        this.sizeInfo = cpSizeInfo;
        List<DigestValue> listDigests = digests.getDigests();
        if (listDigests.isEmpty()) {
            this.digests = NO_DIGESTS;
        }
        this.digests = new DigestValue[listDigests.size()];
        int i = 0;
        for (DigestValue dv : listDigests) {
            this.digests[i++] = dv;
        }
    }

    @Override
    public void setDigests(IMessageDigests digests) {
        for (DigestValue dv : digests.getDigests()) {
            this.setDigestValue(dv);
        }
    }

    public long getSize() {
        return this.getSizeInfo().getDownloadSize();
    }

    @Override
    public void setSize(long size) {
        this.getSizeInfo().setDownloadSize(size);
    }

    @Override
    public SizeInfo getSizeInfo() {
        return this.sizeInfo;
    }

    @Override
    public void setSizeInfo(SizeInfo sizeInfo) {
        this.sizeInfo = sizeInfo;
    }

    private int findAlgorithmIndex(String algorithm) {
        int i = 0;
        while (i < this.digests.length) {
            String str = this.digests[i].getAlgorithm();
            if (str.equalsIgnoreCase(algorithm)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    @Override
    public void setDigestValue(String algorithm, String digestString) {
        DigestValue dv = new DigestValue(algorithm, digestString);
        this.setDigestValue(dv);
    }

    @Override
    public void setDigestValue(DigestValue dv) {
        assert (dv != null);
        String algorithm = dv.getAlgorithm();
        int i = this.findAlgorithmIndex(algorithm);
        if (i == -1) {
            DigestValue[] newDigests = new DigestValue[this.digests.length + 1];
            int j = 0;
            while (j < this.digests.length) {
                DigestValue d;
                newDigests[j] = d = this.digests[j];
                ++j;
            }
            newDigests[this.digests.length] = dv;
            this.digests = newDigests;
        } else {
            this.digests[i] = dv;
        }
    }

    @Override
    public boolean removeDigest(String algorithm) {
        if (algorithm == null) {
            throw new IllegalArgumentException();
        }
        int i = this.findAlgorithmIndex(algorithm);
        if (i != -1) {
            DigestValue[] newDigests = new DigestValue[this.digests.length - 1];
            int ni = 0;
            int j = 0;
            while (j < this.digests.length) {
                if (j != i) {
                    DigestValue d = this.digests[j];
                    newDigests[ni++] = d;
                }
                ++j;
            }
            this.digests = newDigests;
            return true;
        }
        return false;
    }

    @Override
    public void clearDigests() {
        this.digests = NO_DIGESTS;
    }

    @Override
    public DigestValue getDigestValue(String algorithm) {
        if (algorithm == null) {
            throw new IllegalArgumentException();
        }
        int i = this.findAlgorithmIndex(algorithm);
        if (i == -1) {
            return null;
        }
        return this.digests[i];
    }

    @Override
    public String getMessageDigestAsString(String algorithm) {
        DigestValue dv = this.getDigestValue(algorithm);
        if (dv == null) {
            return null;
        }
        return dv.getDigestAsString();
    }

    @Override
    public int getAvailableDigestsCount() {
        return this.digests.length;
    }

    @Override
    public Set<String> getDigestAlgorithmSet() {
        return new AbstractSet<String>(){

            @Override
            public Iterator<String> iterator() {
                return new Iterator<String>(){
                    int i = 0;

                    @Override
                    public boolean hasNext() {
                        return this.i < SimpleContentInfo.this.digests.length;
                    }

                    @Override
                    public String next() {
                        if (!this.hasNext()) {
                            throw new NoSuchElementException();
                        }
                        return SimpleContentInfo.this.digests[this.i++].getAlgorithm();
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }

            @Override
            public int size() {
                return SimpleContentInfo.this.digests.length;
            }
        };
    }

    @Override
    public List<String> getDigestAlgorithms() {
        return new AbstractList<String>(){

            @Override
            public int size() {
                return SimpleContentInfo.this.digests.length;
            }

            @Override
            public String get(int index) {
                return SimpleContentInfo.this.digests[index].getAlgorithm();
            }
        };
    }

    @Override
    public Set<DigestValue> getDigestSet() {
        return new AbstractSet<DigestValue>(){

            @Override
            public Iterator<DigestValue> iterator() {
                return new Iterator<DigestValue>(){
                    private int i = 0;

                    @Override
                    public boolean hasNext() {
                        return this.i < SimpleContentInfo.this.digests.length;
                    }

                    @Override
                    public DigestValue next() {
                        if (!this.hasNext()) {
                            throw new NoSuchElementException();
                        }
                        return SimpleContentInfo.this.digests[this.i++];
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }

            @Override
            public int size() {
                return SimpleContentInfo.this.digests.length;
            }
        };
    }

    @Override
    public List<DigestValue> getDigests() {
        return new AbstractList<DigestValue>(){

            @Override
            public int size() {
                return SimpleContentInfo.this.digests.length;
            }

            @Override
            public DigestValue get(int index) {
                return SimpleContentInfo.this.digests[index];
            }
        };
    }

    public String toString() {
        return ContentInfo.toString(this);
    }
}

