/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.downloads;

import com.ibm.cic.common.downloads.AbstractHostInfo;
import com.ibm.cic.common.downloads.CredentialInfo;
import com.ibm.cic.common.downloads.CredentialRequested;
import com.ibm.cic.common.downloads.ICredentialValidator;
import com.ibm.cic.common.downloads.RequestStatus;
import com.ibm.cic.common.downloads.SocketEvents;
import com.ibm.cic.common.downloads.handlerImpl.AbstractAuthenticator;
import java.net.Authenticator;
import java.net.InetAddress;
import java.net.PasswordAuthentication;
import org.eclipse.core.runtime.IStatus;

public class JavaProxyAuthenticator
extends Authenticator
implements ICredentialValidator {
    public static final JavaProxyAuthenticator INSTANCE = new JavaProxyAuthenticator();
    private final AbstractAuthenticator authenticator = new AbstractAuthenticator(){

        @Override
        protected String getTraceName() {
            return "JavaProxyAuthenticator";
        }
    };

    private JavaProxyAuthenticator() {
    }

    @Override
    protected PasswordAuthentication getPasswordAuthentication() {
        String host = this.getRequestingHost();
        if (host == null) {
            InetAddress site = this.getRequestingSite();
            if (site == null) {
                return null;
            }
            host = site.getHostAddress();
        }
        String schemeName = this.getRequestingScheme();
        String realm = this.getRequestingPrompt();
        int port = this.getRequestingPort();
        final CredentialRequested requested = new CredentialRequested(schemeName, host, port, realm, null);
        AbstractAuthenticator.CredentialResult credResult = this.authenticator.getCredentials(requested, true);
        if (credResult != null) {
            if (credResult.getStatus().isOK()) {
                String reqProtocol = this.getRequestingProtocol();
                SocketEvents.SocketListener listener = null;
                if (reqProtocol != null && reqProtocol.startsWith("SOCKS")) {
                    final AbstractHostInfo ahostInfo = this.authenticator.getHostInfo(requested);
                    final Thread authenticationCallerThread = Thread.currentThread();
                    listener = new SocketEvents.SocketListener(){

                        @Override
                        public void onSocketConnected(SocketEvents.SocketToConnect stc) {
                            if (Thread.currentThread() == authenticationCallerThread) {
                                JavaProxyAuthenticator.this.authenticator.setResult(ahostInfo, RequestStatus.SUCCEEDED);
                                this.remove();
                            }
                        }

                        @Override
                        public void onSocketConnectFailed(SocketEvents.SocketToConnect stc, Throwable t) {
                            if (Thread.currentThread() == authenticationCallerThread) {
                                JavaProxyAuthenticator.this.authenticator.setNotAuthorized(requested);
                                this.remove();
                            }
                        }

                        private void remove() {
                            SocketEvents.INSTANCE.removeSocketListener(this);
                        }
                    };
                    SocketEvents.INSTANCE.addSocketListener(listener);
                }
                CredentialInfo credInfo = credResult.getCredentialInfo();
                return new PasswordAuthentication(credInfo.getUid(), credInfo.getPwd().toCharArray());
            }
            assert (credResult.getStatus().matches(8));
        }
        return null;
    }

    public AbstractAuthenticator getAuthenticator() {
        return this.authenticator;
    }

    @Override
    public IStatus validate(CredentialInfo credInfo) {
        return this.authenticator.validate(credInfo);
    }
}

