/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.downloads;

import com.ibm.cic.common.core.utils.FileURLUtil;
import com.ibm.cic.common.core.utils.FileUtil;
import com.ibm.cic.common.core.utils.NLS;
import com.ibm.cic.common.downloads.ByteRange;
import com.ibm.cic.common.downloads.ByteRangeMonitorInputStream;
import com.ibm.cic.common.downloads.DownloadEvents;
import com.ibm.cic.common.downloads.DownloadHandler;
import com.ibm.cic.common.downloads.DownloadHandlerRequest;
import com.ibm.cic.common.downloads.DownloadProperties;
import com.ibm.cic.common.downloads.ICanOpenStream;
import com.ibm.cic.common.downloads.ICanOpenStreamAtRange;
import com.ibm.cic.common.downloads.IContentInfo;
import com.ibm.cic.common.downloads.IDownloadListener;
import com.ibm.cic.common.downloads.IDownloadStream;
import com.ibm.cic.common.downloads.ITransferMonitor;
import com.ibm.cic.common.downloads.Messages;
import com.ibm.cic.common.downloads.ProgressInputStream;
import com.ibm.cic.common.downloads.ProxySupport;
import com.ibm.cic.common.downloads.SimpleContentInfo;
import com.ibm.cic.common.downloads.handlerImpl.DownloadHandlerUtil;
import com.ibm.cic.common.downloads.handlerImpl.DownloadStream;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.core.runtime.Path;

public class FileDownloadHandler
extends DownloadHandler
implements ICanOpenStream,
ICanOpenStreamAtRange {
    @Override
    protected IContentInfo implementDownload(DownloadHandlerRequest.DownloadRequest request, ITransferMonitor transferPerformance, long[] outBytesRead) throws IOException {
        return DownloadHandlerUtil.downloadUsingOpenStreamAtRange((ICanOpenStreamAtRange)this, request, transferPerformance, outBytesRead);
    }

    @Override
    protected IContentInfo implementDownload(DownloadHandlerRequest.DownloadSinkRequest request, ITransferMonitor transferPerformance, long[] outBytesRead) throws IOException {
        return DownloadHandlerUtil.downloadUsingOpenStreamAtRange((ICanOpenStreamAtRange)this, request, transferPerformance, outBytesRead);
    }

    @Override
    public InputStream openStream(DownloadHandlerRequest.OpenStreamRequest request, ITransferMonitor transferPerformance, IContentInfo[] outContentInfo) throws IOException {
        return super.privateOpenStream(request, transferPerformance, outContentInfo);
    }

    @Override
    public IDownloadStream openStreamAtRange(DownloadHandlerRequest.OpenStreamForRangeRequest request, ITransferMonitor transferPerformance, IContentInfo[] outContentInfo) throws IOException {
        DownloadStream downloadStream;
        block6: {
            if (outContentInfo != null && outContentInfo.length != 1) {
                throw new IllegalArgumentException();
            }
            String urlString = request.getUrlString();
            IDownloadListener.Access access = new IDownloadListener.Access(request);
            ByteRange requestedRange = request.getByteRange();
            FilterInputStream inputToCloseOnError = null;
            try {
                long start;
                BufferedInputStream buf;
                String fileString = FileURLUtil.toFileString(urlString);
                File sourceFile = new File(fileString);
                inputToCloseOnError = buf = new BufferedInputStream(new FileInputStream(sourceFile));
                long fileLength = sourceFile.length();
                ByteRangeMonitorInputStream.checkForStartOutOfBoundsException(urlString, requestedRange, fileLength, null);
                if (requestedRange.getStart() > 0L && (start = buf.skip(requestedRange.getStart())) != requestedRange.getStart()) {
                    throw new IOException(NLS.bind(Messages.FileDownloadHandler_SkipFailed, requestedRange.getStart(), urlString, start));
                }
                ByteRangeMonitorInputStream mstream = ByteRangeMonitorInputStream.checkAndWrap(urlString, buf, requestedRange, fileLength);
                inputToCloseOnError = mstream;
                ProgressInputStream.EmitDownloadEvents emitEvents = new ProgressInputStream.EmitDownloadEvents(access, DownloadEvents.getFire(request.getDownloadContext()));
                ProgressInputStream input = new ProgressInputStream(emitEvents, mstream, mstream.getEffectiveRange().size(), mstream.getEffectiveRange().size(), transferPerformance, true);
                inputToCloseOnError = input;
                if (outContentInfo != null) {
                    SimpleContentInfo ci = new SimpleContentInfo();
                    ci.setSize(mstream.getEffectiveRange().size());
                    outContentInfo[0] = ci;
                }
                DownloadStream ds = new DownloadStream(urlString, requestedRange, mstream.getEffectiveRange(), input, false);
                inputToCloseOnError = null;
                downloadStream = ds;
                if (inputToCloseOnError == null) break block6;
            }
            catch (Throwable throwable) {
                if (inputToCloseOnError != null) {
                    FileUtil.close(inputToCloseOnError);
                }
                throw throwable;
            }
            FileUtil.close(inputToCloseOnError);
        }
        return downloadStream;
    }

    @Override
    protected InputStream implementOpenStream(DownloadHandlerRequest.OpenStreamRequest request, ITransferMonitor transferPerformance, IContentInfo[] outContentInfo) throws IOException {
        DownloadHandlerRequest.OpenStreamForRangeRequest rangeRequest = DownloadHandlerRequest.FACTORY.createOpenStreamForRange(request.getDownloadContext(), request.getUrlString(), ByteRange.RANGE_ALL_BYTES);
        rangeRequest.setParentRequest(request);
        IDownloadStream dlStream = this.openStreamAtRange(rangeRequest, transferPerformance, outContentInfo);
        return dlStream.getInputStream();
    }

    @Override
    protected boolean implementExists(DownloadHandlerRequest.ExistsRequest request) throws IOException {
        String urlString = request.getUrlString();
        try {
            String fileString = FileURLUtil.toFileString(urlString);
            File sourceFile = new File(fileString);
            boolean exists = sourceFile.exists();
            if (FileDownloadHandler.dlTraceHappy.enabled) {
                if (exists) {
                    dlTraceHappy.getLog().debug("SUCCESS: file {0} exists", urlString);
                } else {
                    dlTraceHappy.println("SUCCESS: file {0} does NOT exist", urlString);
                }
            }
            return exists;
        }
        catch (MalformedURLException e) {
            dlTrace.getLog().debug("exists({0}) rethrowing exception: {1}", urlString, e);
            throw e;
        }
    }

    @Override
    public boolean canQueryProperties() {
        return true;
    }

    @Override
    protected DownloadProperties implementQueryProperties(DownloadHandlerRequest.QueryContentInfoRequest request) throws MalformedURLException {
        String urlString = request.getUrlString();
        try {
            String fileString = FileURLUtil.toFileString(urlString);
            File sourceFile = new File(fileString);
            long len = sourceFile.length();
            DownloadProperties dlp = new DownloadProperties();
            dlp.setContentInfo(new SimpleContentInfo(len));
            dlp.setLastModified(sourceFile.lastModified());
            if (FileDownloadHandler.dlTraceHappy.enabled) {
                dlTraceHappy.getLog().debug("SUCCESS: queryProperties length={0}, lastModified={1} for file {2}", dlp.getLastModified(), len, urlString);
            }
            return dlp;
        }
        catch (MalformedURLException e) {
            dlTrace.getLog().debug("queryProperties({0}) rethrowing exception: {1}", urlString, e);
            throw e;
        }
    }

    @Override
    public ProxySupport getProxySupport() {
        return null;
    }

    @Override
    public boolean shouldUseMultipleThreads(URL url) {
        assert (url.getProtocol().equalsIgnoreCase("file"));
        Path p = new Path(url.getPath());
        return p.isUNC();
    }
}

