/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.downloads;

import com.ibm.cic.common.core.downloads.TransferUtils;
import com.ibm.cic.common.core.repository.ICicLocation;
import com.ibm.cic.common.core.repository.URLContentLocator;
import com.ibm.cic.common.core.utils.PathUtil;
import com.ibm.cic.common.downloads.ContentInfo;
import com.ibm.cic.common.downloads.IContentInfo;
import com.ibm.cic.common.downloads.IDownloadSession;
import com.ibm.cic.common.downloads.IDownloadedFile;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;

public class DownloadUtil {
    public static InputStream getValidatedStream(IDownloadSession session, URL url, IContentInfo expectedContentInfo, IProgressMonitor monitor) throws CoreException, FileNotFoundException, IOException {
        URLContentLocator urlLocator = expectedContentInfo != null && expectedContentInfo.getAvailableDigestsCount() > 0 ? new URLContentLocator(url, expectedContentInfo) : new URLContentLocator(url, (IContentInfo)ContentInfo.EMPTY_CONTENT_INFO);
        String simpleName = PathUtil.getSimpleName(url.getPath());
        return TransferUtils.getValidatedStream(session, monitor, urlLocator, simpleName);
    }

    public static IStatus download(IDownloadSession session, ICicLocation source, File destination, IContentInfo expectedContentInfo, IProgressMonitor monitor) {
        assert (source != null);
        assert (destination != null);
        URL url = source.toURL();
        assert (url != null);
        if (session == null) {
            try (IDownloadSession singleCallSession = IDownloadSession.FACTORY.createDownloadSession();){
                IStatus iStatus = DownloadUtil.download(singleCallSession, source, destination, expectedContentInfo, monitor);
                return iStatus;
            }
        }
        URLContentLocator urlLocator = new URLContentLocator(url, expectedContentInfo);
        IDownloadedFile dlf = urlLocator.downloadToFile(session, (IPath)new Path(destination.toString()), monitor);
        return dlf.getStatus();
    }

    public static InputStream getStreamForURL(URL url, IProgressMonitor monitor) throws FileNotFoundException, CoreException {
        return TransferUtils.getValidatedStreamForURLDirectForFiles(url, monitor);
    }
}

