/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.downloads;

import com.ibm.cic.common.core.internal.ComIbmCicCommonCorePlugin;
import com.ibm.cic.common.core.utils.CicMultiStatus;
import com.ibm.cic.common.core.utils.FileUtil;
import com.ibm.cic.common.core.utils.ICicStatus;
import com.ibm.cic.common.core.utils.Statuses;
import com.ibm.cic.common.core.utils.TempUtil;
import com.ibm.cic.common.core.utils.UserOptions;
import com.ibm.cic.common.downloads.DigestValue;
import com.ibm.cic.common.downloads.ITransferSession;
import com.ibm.cic.common.downloads.ITransferSessionListener;
import com.ibm.cic.common.downloads.Messages;
import com.ibm.cic.common.downloads.TransferSessionManager;
import com.ibm.cic.common.logging.Logger;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.osgi.util.NLS;

public class DownloadInProgressManager
implements ITransferSessionListener {
    private static final String CICDIP = "cicdip";
    private static final String NON_VALIDATED_ARTIFACTS = "na";
    private static final String NON_VALIDATED_FILES = "nf";
    private static final String VALIDATED = "v";
    private static final String FAILED_DIR = "failed";
    private static final Logger log = Logger.getLogger(DownloadInProgressManager.class, (Plugin)ComIbmCicCommonCorePlugin.getDefault());
    public static final DownloadInProgressManager INSTANCE = new DownloadInProgressManager();
    private Map<String, List<ValidatedDownload>> validatedRequests;
    private Map<Object, List<NonValidatedDownload>> nonValidatedRequests;
    private Set<DipUniqueTempDir> rootDirs;
    private List<File> morgueDirs;

    public static IPath getValidatedInProgressPath(File dipRoot, DigestValue dv, String resumeableDownloadId) {
        String algorithm = dv.getAlgorithm();
        String digest = dv.getDigestAsString();
        return DownloadInProgressManager.convertToPath(dipRoot).append(VALIDATED).append(algorithm).append(String.valueOf(digest) + '_' + resumeableDownloadId);
    }

    public static TempUtil.UniqueTempDir createUniqueDownloadInProgressRoot(File tmpDir, int uniqueMask) throws CoreException {
        TempUtil.UniqueTempDir utd = DownloadInProgressManager.getUniqueDownloadInProgressRoot(tmpDir, uniqueMask);
        utd.create();
        return utd;
    }

    public static TempUtil.UniqueTempDir getUniqueDownloadInProgressRoot(File tmpDir, int uniqueMask) {
        if (UserOptions.getDownloadAlwaysUseTempForDip()) {
            log.debug("UserOption -D{0}=true: Ignoring root location ''{1}''", UserOptions.CIC_DOWNLOAD_ALWAYS_TEMP_FOR_DIP, tmpDir);
            tmpDir = null;
        }
        return new DipUniqueTempDir(TempUtil.getUniqueTempDir(tmpDir, CICDIP, uniqueMask));
    }

    public static void getAllPartialFiles(File dipRoot, List<File> files) {
        try {
            FileUtil.listFiles(dipRoot, files);
        }
        catch (IOException e) {
            log.warning(e);
        }
    }

    private DownloadInProgressManager() {
        this.initRequestMaps();
    }

    private void initRequestMaps() {
        this.validatedRequests = new HashMap<String, List<ValidatedDownload>>();
        this.nonValidatedRequests = new HashMap<Object, List<NonValidatedDownload>>();
        this.rootDirs = new HashSet<DipUniqueTempDir>();
        this.morgueDirs = new ArrayList<File>();
    }

    public List<IDownloadInProgress> getPartialRequests() {
        ArrayList<IDownloadInProgress> list = new ArrayList<IDownloadInProgress>();
        for (Map.Entry<String, List<ValidatedDownload>> entry : this.validatedRequests.entrySet()) {
            List<ValidatedDownload> requests = entry.getValue();
            if (requests == null) continue;
            for (ValidatedDownload dlr : requests) {
                if (dlr.getState() != State.PARTIAL) continue;
                list.add(dlr);
            }
        }
        return list;
    }

    public void cleanMorgueDirs() {
        for (File morgueDir : this.morgueDirs) {
            FileUtil.rm_r(morgueDir, true);
        }
        this.morgueDirs.clear();
    }

    public boolean checkAndCleanMorgueFile(DigestValue dv) {
        File morgueFile;
        for (File file : this.morgueDirs) {
            morgueFile = DownloadInProgressManager.getMorgueFile(file, dv);
            if (!morgueFile.exists()) continue;
            morgueFile.delete();
            try {
                FileUtil.deleteEmptyDirs(file);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            file.getParentFile().delete();
            return true;
        }
        for (TempUtil.UniqueTempDir uniqueTempDir : this.rootDirs) {
            morgueFile = DownloadInProgressManager.getMorgueFile(uniqueTempDir.getUniqueTempDir(), dv);
            if (!morgueFile.exists()) continue;
            morgueFile.delete();
            uniqueTempDir.cleanEmptyDirsLogIOE();
            return true;
        }
        return false;
    }

    private static File getMorgueFile(File dipRoot, DigestValue dv) {
        return new File(DownloadInProgressManager.getMorgueDir(dipRoot), String.valueOf(dv.getAlgorithm().toLowerCase()) + '/' + dv.getDigestAsString());
    }

    private static File getMorgueDir(File dipRoot) {
        return new File(dipRoot, FAILED_DIR);
    }

    private static IPath convertToPath(File f) {
        return new Path(f.getAbsolutePath());
    }

    public static IPath getNonValidatedArtifactDir(File udipDir) {
        return DownloadInProgressManager.convertToPath(udipDir).append(NON_VALIDATED_ARTIFACTS);
    }

    public static IPath getNonValidatedFileDir(File udipDir) {
        assert (udipDir != null);
        return DownloadInProgressManager.convertToPath(udipDir).append(NON_VALIDATED_FILES);
    }

    private void addValidatedRequest(ValidatedDownload dr) {
        String resumeableId = dr.getResumeableId();
        List<ValidatedDownload> requests = this.validatedRequests.get(resumeableId);
        if (requests == null) {
            requests = new ArrayList<ValidatedDownload>();
            this.validatedRequests.put(resumeableId, requests);
        }
        requests.add(dr);
        this.rootDirs.add(dr.getDipRoot());
        log.debug("Added download request for: {0}", dr);
    }

    private void addNonValidatedRequest(NonValidatedDownload dr) {
        Object key = dr.getArtifact();
        List<NonValidatedDownload> requests = this.nonValidatedRequests.get(key);
        if (requests == null) {
            requests = new ArrayList<NonValidatedDownload>();
            this.nonValidatedRequests.put(key, requests);
        }
        requests.add(dr);
        this.rootDirs.add(dr.getDipRoot());
        log.debug("Added download request for: {0}", dr);
    }

    private NonValidatedDownload findNonValidatedRequest(NonValidatedDownload dr) {
        Object key = dr.getArtifact();
        List<NonValidatedDownload> requests = this.nonValidatedRequests.get(key);
        if (requests == null) {
            return null;
        }
        for (NonValidatedDownload dlr : requests) {
            if (dlr.getState() != State.INITIAL || !dlr.getTargetLocation().equals((Object)dr.getTargetLocation())) continue;
            return dlr;
        }
        return null;
    }

    private static boolean removeRequest(IDownloadInProgress dip, boolean removeInitialsAsWell) {
        DownloadRequest dr = (DownloadRequest)dip;
        return dr.removeRequest(removeInitialsAsWell);
    }

    private ValidatedDownload findValidatedRequest(ValidatedDownload dr) {
        String resumeableId = dr.getResumeableId();
        List<ValidatedDownload> requests = this.validatedRequests.get(resumeableId);
        if (requests == null) {
            return null;
        }
        for (ValidatedDownload dlr : requests) {
            if (dlr.getState() != State.INITIAL && dlr.getState() != State.PARTIAL || !dlr.getTargetLocation().equals((Object)dr.getTargetLocation())) continue;
            return dlr;
        }
        return null;
    }

    private int countOpenRequests(IDownloadInProgress dip) {
        List<DownloadRequest> requests;
        if (dip instanceof ValidatedDownload) {
            ValidatedDownload rd = (ValidatedDownload)dip;
            requests = this.validatedRequests.get(rd.getResumeableId());
        } else {
            requests = this.nonValidatedRequests.get(dip.getArtifact());
        }
        if (requests == null) {
            return 0;
        }
        int count = 0;
        for (DownloadRequest dlr : requests) {
            if (dlr.getState() != State.INITIAL && dlr.getState() != State.PARTIAL) continue;
            ++count;
        }
        return count;
    }

    public synchronized NonValidatedDownload getNonValidatedDownload(Object artifact, TempUtil.UniqueTempDir dipRoot, IPath inProgressPath, IPath downloadLocation) {
        TransferSessionManager.INSTANCE.addSessionListener(this);
        assert (dipRoot instanceof DipUniqueTempDir);
        NonValidatedDownload dr = new NonValidatedDownload(artifact, (DipUniqueTempDir)dipRoot, inProgressPath, downloadLocation);
        NonValidatedDownload open = this.findNonValidatedRequest(dr);
        if (open != null) {
            log.debug("Download already requested: {0}", open);
            return open;
        }
        FileUtil.ensureDestinationDirectory(dr.getInProgressLocation().toFile());
        this.addNonValidatedRequest(dr);
        return dr;
    }

    public synchronized ValidatedDownload getValidatedDownload(Object artifact, TempUtil.UniqueTempDir dipRoot, DigestValue dv, String resumeableId, IPath inProgressPath, IPath downloadLocation) {
        assert (dipRoot instanceof DipUniqueTempDir);
        assert (inProgressPath != null);
        assert (dv != null);
        ValidatedDownload dr = new ValidatedDownload(artifact, (DipUniqueTempDir)dipRoot, dv, inProgressPath, downloadLocation, resumeableId);
        TransferSessionManager.INSTANCE.addSessionListener(this);
        ValidatedDownload open = this.findValidatedRequest(dr);
        if (open != null) {
            log.debug("Download already requested: {0}", open);
            return open;
        }
        FileUtil.ensureDestinationDirectory(dr.getInProgressLocation().toFile());
        this.addValidatedRequest(dr);
        return dr;
    }

    public ValidatedDownload getValidatedDownload(ValidatedDownload drPrevious) {
        return this.getValidatedDownload(drPrevious.getArtifact(), drPrevious.getDipRoot(), drPrevious.getDigestValue(), drPrevious.getResumeableId(), drPrevious.getInProgressLocation(), drPrevious.getTargetLocation());
    }

    public synchronized void completed(DownloadRequest dip, IProgressMonitor monitor) throws CoreException {
        int n = this.countOpenRequests(dip);
        boolean lastRequester = n == 1;
        File file = dip.getInProgressLocation().toFile();
        IPath finalLocation = dip.getTargetLocation();
        try {
            File finalFile = finalLocation.toFile();
            if (lastRequester) {
                FileUtil.mv(file, finalFile, true, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                log.debug("Moving file to target location as this is the last request\nMoved from {0} to {1}\nrequest={2}", file, finalFile, dip);
            } else {
                FileUtil.copyFile(file, finalFile, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                log.debug("Copied file to target location as there are {3} other requests\nCopied from {0} to {1}\nrequest={2}", file, finalFile, dip, n - 1);
            }
            dip.setState(State.SUCCEEDED);
            DownloadInProgressManager.removeRequest(dip, false);
        }
        catch (FileNotFoundException e) {
            log.debug(e);
            throw new CoreException((IStatus)Statuses.ERROR.get(6100, e, Messages.DownloadInProgressManager_Downloaded_File_Not_Found, dip.getInProgressLocation()));
        }
        catch (IOException e) {
            log.debug(e);
            throw new CoreException((IStatus)Statuses.ERROR.get(6100, e, Messages.DownloadInProgressManager_Move_To_Final_Destination_Failed, dip.getInProgressLocation(), finalLocation));
        }
    }

    public IStatus failedRetryWillFail(ValidatedDownload dip, File[] outBadFile, Object problem) {
        return this.failedMoveBadFileToMorgue(dip, outBadFile, problem);
    }

    public IStatus failedWrongDigest(ValidatedDownload dip, File[] outBadFile) {
        return this.failedMoveBadFileToMorgue(dip, outBadFile, "Digest mismatch moving file to morgue");
    }

    private synchronized IStatus failedMoveBadFileToMorgue(ValidatedDownload dip, File[] outBadFile, Object problem) {
        File file = dip.getInProgressLocation().toFile();
        DigestValue dv = dip.getDigestValue();
        File morgue = DownloadInProgressManager.getMorgueFile(dip.getDipRoot().getUniqueTempDir(), dv);
        try {
            FileUtil.ensureDestinationDirectory(morgue);
            FileUtil.mv(file, morgue, true, null);
            if (outBadFile != null) {
                outBadFile[0] = morgue;
            }
            log.debug("{0}\nMoved from {1} to {2}\nrequest={3}", problem, file, morgue, dip);
            ICicStatus iCicStatus = Statuses.INFO.get(Messages.DownloadInProgressManager_moved_dip_file_to_morgue, file, morgue);
            return iCicStatus;
        }
        catch (IOException e) {
            ICicStatus status2;
            log.debug(e);
            String msg = NLS.bind((String)Messages.DownloadInProgressManager_handle_moved_dip_file_to_morgue_failed, (Object)file, (Object)morgue);
            CicMultiStatus ms = Statuses.ST.createMultiStatus(msg, new Object[0]);
            ICicStatus status1 = Statuses.ERROR.get(e, Messages.DownloadInProgressManager_moved_dip_file_to_morgue_failed, file.toString(), morgue.toString());
            ms.merge(status1);
            FileUtil.rm(file);
            if (file.exists()) {
                status2 = Statuses.ERROR.get(Messages.DownloadInProgressManager_removed_dip_file_failed, file.toString());
                if (outBadFile != null) {
                    outBadFile[0] = file;
                }
            } else {
                status2 = Statuses.INFO.get(Messages.DownloadInProgressManager_removed_dip_file, file.toString());
            }
            ms.merge(status2);
            CicMultiStatus cicMultiStatus = ms;
            return cicMultiStatus;
        }
        finally {
            dip.setState(State.FAILED);
            DownloadInProgressManager.removeRequest(dip, false);
        }
    }

    public synchronized void failedNotDone(ValidatedDownload dip) {
        dip.setState(State.PARTIAL);
        log.debug("Download failed (not complete). Keep downloaded part around\nrequest={0}", dip);
    }

    public synchronized void failedNotFound(ValidatedDownload dip) {
        File file = dip.getInProgressLocation().toFile();
        FileUtil.rm(file);
        dip.setState(State.FAILED);
        DownloadInProgressManager.removeRequest(dip, false);
        log.debug("Download failed (not found). Removed {0}\nrequest={1}", file, dip);
    }

    public synchronized void forget(NonValidatedDownload dip) {
        File file = dip.getInProgressLocation().toFile();
        FileUtil.rm(file);
        dip.setState(State.FAILED);
        DownloadInProgressManager.removeRequest(dip, false);
        log.debug("Download failed. Removed {0}\nrequest={1}", file, dip);
    }

    private synchronized void deleteEmptyDirs(DipUniqueTempDir rootDir) {
        File morgueDir = DownloadInProgressManager.getMorgueDir(rootDir.getUniqueTempDir());
        if (morgueDir.isDirectory()) {
            this.morgueDirs.add(rootDir.getUniqueTempDir());
        }
        this.rootDirs.remove(rootDir);
    }

    @Override
    public void close(ITransferSession session) {
        this.checkAllAreClosed();
        this.initRequestMaps();
    }

    public void checkAllAreClosed() {
        if (!this.rootDirs.isEmpty()) assert (false) : "Failed to close: " + this.rootDirs;
    }

    public void release(IDownloadInProgress dip) {
        int n = this.countOpenRequests(dip);
        boolean lastRequester = n == 1;
        File file = dip.getInProgressLocation().toFile();
        dip.setState(State.RELEASED);
        DownloadInProgressManager.removeRequest(dip, true);
        if (lastRequester) {
            log.debug("Release: Deleting in progress file {0}\nreleased request{1}", file, dip);
            FileUtil.rm(file);
        } else {
            log.debug("Release: Not deleting progress file as there are {1} other requests\nrequest={0}", dip, n - 1);
        }
    }

    public void forgetPartialRequest(IDownloadInProgress dip) {
        if (dip.getState().equals((Object)State.PARTIAL)) {
            DownloadInProgressManager.removeRequest(dip, true);
        }
    }

    private static class DipUniqueTempDir
    extends TempUtil.UniqueTempDir {
        DipUniqueTempDir(TempUtil.UniqueTempDir utd) {
            super(utd.getBaseDir(), utd.getPath());
        }

        @Override
        public void cleanEmptyDirs() throws IOException {
            super.cleanEmptyDirs();
            INSTANCE.deleteEmptyDirs(this);
        }
    }

    private static abstract class DownloadRequest
    implements IDownloadInProgress {
        private final Object artifact;
        private final DipUniqueTempDir dipRoot;
        private final IPath inProgressLocation;
        private final IPath targetLocation;
        private State state;

        DownloadRequest(Object artifact, DipUniqueTempDir dipRoot, IPath inProgressLocation, IPath targetLocation) {
            this.artifact = artifact;
            this.dipRoot = dipRoot;
            this.inProgressLocation = inProgressLocation;
            this.targetLocation = targetLocation;
            this.state = State.INITIAL;
        }

        @Override
        public Object getArtifact() {
            return this.artifact;
        }

        DipUniqueTempDir getDipRoot() {
            return this.dipRoot;
        }

        @Override
        public State getState() {
            return this.state;
        }

        @Override
        public void setState(State state) {
            this.state = state;
        }

        @Override
        public IPath getInProgressLocation() {
            return this.inProgressLocation;
        }

        @Override
        public IPath getTargetLocation() {
            return this.targetLocation;
        }

        abstract boolean removeRequest(boolean var1);

        boolean removeRequest(Object key, Map<?, ?> map, boolean removeInitialsAsWell) {
            List requests = (List)map.get(key);
            if (requests == null) {
                return false;
            }
            if ((removeInitialsAsWell || this.state != State.INITIAL && this.state != State.PARTIAL) && requests.remove(this)) {
                if (requests.isEmpty()) {
                    map.remove(key);
                }
                return true;
            }
            return false;
        }

        void toString(StringBuilder sb) {
            sb.append("artifact='").append(this.artifact).append('\'');
            sb.append(" state='").append((Object)this.state).append('\'');
            sb.append(" dipRoot='").append(this.dipRoot).append('\'');
            sb.append(" inProgressLoc='").append(this.inProgressLocation).append('\'');
            sb.append(" targetLocation='").append(this.targetLocation).append('\'');
        }
    }

    public static interface IDownloadInProgress {
        public Object getArtifact();

        public State getState();

        public void setState(State var1);

        public IPath getInProgressLocation();

        public IPath getTargetLocation();

        public boolean isValidated();
    }

    public class NonValidatedDownload
    extends DownloadRequest {
        NonValidatedDownload(Object artifact, DipUniqueTempDir dipRoot, IPath inProgressLocation, IPath targetLocation) {
            super(artifact, dipRoot, inProgressLocation, targetLocation);
        }

        @Override
        public boolean isValidated() {
            return false;
        }

        @Override
        boolean removeRequest(boolean removeInitialsAsWell) {
            return this.removeRequest(this.getArtifact(), DownloadInProgressManager.this.nonValidatedRequests, removeInitialsAsWell);
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("NonValidated ");
            super.toString(sb);
            return sb.toString();
        }
    }

    public static enum State {
        INITIAL,
        FAILED,
        SUCCEEDED,
        PARTIAL,
        RELEASED;

    }

    public class ValidatedDownload
    extends DownloadRequest {
        private final DigestValue digestValue;
        private final String resumeableId;

        ValidatedDownload(Object artifact, DipUniqueTempDir dipRoot, DigestValue digestValue, IPath inProgressLocation, IPath targetLocation, String resumeableId) {
            super(artifact, dipRoot, inProgressLocation, targetLocation);
            this.digestValue = digestValue;
            this.resumeableId = resumeableId;
        }

        @Override
        public boolean isValidated() {
            return true;
        }

        DigestValue getDigestValue() {
            return this.digestValue;
        }

        String getResumeableId() {
            return this.resumeableId;
        }

        @Override
        boolean removeRequest(boolean removeInitialsAsWell) {
            return this.removeRequest(this.getResumeableId(), DownloadInProgressManager.this.validatedRequests, removeInitialsAsWell);
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("Validated ").append(this.digestValue);
            sb.append(" resumeableId='").append(this.resumeableId).append("' ");
            super.toString(sb);
            return sb.toString();
        }
    }
}

