/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.core.utils;

import com.ibm.cic.common.core.definitions.CommonDef;
import com.ibm.cic.common.core.model.ParserStatus;
import com.ibm.cic.common.core.utils.CicMultiStatus;
import com.ibm.cic.common.core.utils.IXMLConstants;
import com.ibm.cic.common.core.utils.Messages;
import com.ibm.cic.common.core.utils.NLS;
import com.ibm.cic.common.core.utils.Statuses;
import com.ibm.cic.common.core.utils.UnsupportedOperationException;
import com.ibm.cic.common.core.utils.Util;
import com.ibm.cic.common.logging.Logger;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Version;
import org.osgi.util.tracker.ServiceTracker;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public abstract class XMLParser
extends DefaultHandler
implements IXMLConstants {
    protected static final String[] NO_STRINGS = new String[0];
    protected StateStack stateStack = null;
    protected BundleContext context;
    protected String pluginId;
    protected CicMultiStatus status = null;
    protected StringBuffer characters = null;
    protected Locator locator = null;
    private int lastCharactersLineNumber = 0;
    private static ServiceTracker xmlTracker = null;

    protected abstract Logger getLogger();

    protected abstract Object getRootObject();

    protected abstract String getErrorMessage();

    protected abstract String processCharacters(String var1);

    public XMLParser(BundleContext context, String pluginId) {
        this.context = context;
        this.pluginId = pluginId;
    }

    public IStatus getStatus() {
        return this.status == null ? Status.OK_STATUS : this.status;
    }

    private static synchronized SAXParserFactory acquireXMLParsing(BundleContext context) {
        if (xmlTracker == null && context != null) {
            xmlTracker = new ServiceTracker(context, "javax.xml.parsers.SAXParserFactory", null);
            xmlTracker.open();
        }
        if (xmlTracker != null) {
            return (SAXParserFactory)xmlTracker.getService();
        }
        return SAXParserFactory.newInstance();
    }

    protected static void releaseXMLParsing() {
        if (xmlTracker != null) {
            xmlTracker.close();
        }
    }

    protected SAXParser getParser() throws ParserConfigurationException, SAXException {
        SAXParserFactory factory = XMLParser.acquireXMLParsing(this.context);
        if (factory == null) {
            throw new SAXException(Messages.XMLParser_no_sax_parser);
        }
        factory.setNamespaceAware(true);
        try {
            factory.setFeature("http://xml.org/sax/features/string-interning", true);
        }
        catch (SAXException sAXException) {
            // empty catch block
        }
        factory.setValidating(false);
        return factory.newSAXParser();
    }

    @Override
    public void setDocumentLocator(Locator locator) {
        this.locator = locator;
    }

    @Override
    public void characters(char[] chars, int start, int length) {
        if (this.characters == null) {
            this.characters = new StringBuffer();
        }
        this.characters.append(chars, start, length);
        this.lastCharactersLineNumber = this.getLineNumber();
    }

    protected String finishCharacters() {
        if (this.characters == null || this.characters.length() == 0) {
            return null;
        }
        if (XMLParser.allWhiteSpace(this.characters)) {
            this.characters.setLength(0);
            return null;
        }
        try {
            String trimmedChars = this.characters.toString().trim();
            if (trimmedChars.length() == 0) {
                System.err.println("Unexpected non-whitespace characters: " + trimmedChars);
                return null;
            }
            this.processCharacters(trimmedChars);
            String string = trimmedChars;
            return string;
        }
        finally {
            this.characters.setLength(0);
        }
    }

    private static boolean allWhiteSpace(StringBuffer sb) {
        int length = sb.length();
        int i = 0;
        while (i < length) {
            if (!Character.isWhitespace(sb.charAt(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    protected PropertyPair parseProperty(Attributes attributes) {
        String[] values = this.parseRequiredAttributes("property", attributes, "name", "value");
        return new PropertyPair(values[0], values[1]);
    }

    @Override
    public void error(SAXParseException ex) {
        this.addError(ex);
    }

    @Override
    public void fatalError(SAXParseException ex) throws SAXException {
        this.addError(ex);
        throw ex;
    }

    protected void addError(SAXParseException ex) {
        this.addError(ex.getMessage());
    }

    protected String getErrorPrefix() {
        return null;
    }

    protected String getErrorSuffix() {
        return null;
    }

    public int getLineNumber() {
        if (this.locator != null) {
            return this.locator.getLineNumber();
        }
        return 0;
    }

    public int getLastCharactersLineNumber() {
        return this.lastCharactersLineNumber;
    }

    public final void addError(String key, Object ... args) {
        this.addError(NLS.bind(key, args));
    }

    public final void addError(String msg) {
        int line = 0;
        int column = 0;
        String key = msg;
        Object[] args = new Object[]{};
        if (this.locator != null) {
            String name = this.locator.getSystemId();
            line = this.locator.getLineNumber();
            column = this.locator.getColumnNumber();
            if (name == null) {
                String root;
                String string = root = this.getRootObject() == null ? "" : " (" + this.getRootObject() + ')';
                if (line > 0) {
                    if (column <= 0) {
                        key = Messages.XMLParser_error_at_line;
                        args = new Object[]{line, root, msg};
                    } else {
                        key = Messages.XMLParser_error_at_line_column;
                        args = new Object[]{line, column, root, msg};
                    }
                }
            } else if (line > 0) {
                if (column <= 0) {
                    key = Messages.XMLParser_error_at_name_line;
                    args = new Object[]{name, line, msg};
                } else {
                    key = Messages.XMLParser_error_at_name_line_column;
                    args = new Object[]{name, line, column, msg};
                }
            }
        }
        String errMsg = NLS.bind(key, args);
        String prefix = this.getErrorPrefix();
        String suffix = this.getErrorSuffix();
        if (prefix != null) {
            errMsg = String.valueOf(prefix) + errMsg;
        }
        if (suffix != null) {
            errMsg = String.valueOf(errMsg) + suffix;
        }
        this.getLogger().warning(errMsg);
        ParserStatus currStatus = new ParserStatus(4, 0, errMsg, line, column);
        this.addStatus(currStatus);
    }

    protected void addStatus(IStatus newStatus) {
        if (this.status == null) {
            this.status = Statuses.ST.createMultiStatus(this.pluginId, 0, 0, new IStatus[]{newStatus}, null, this.getErrorMessage());
        } else {
            this.status.add(newStatus);
        }
    }

    protected void unexpectedElementError(String element) {
        this.unexpectedElementError(element, null);
    }

    protected void unexpectedElementError(String element, Attributes attributes) {
        this.unexpectedElement(element, attributes);
        this.stateStack.push(0, "unexpected element: " + element);
    }

    protected void trace(String string) {
        if (!this.getLogger().isDebugLoggable()) {
            return;
        }
        int indentSize = this.stateStack.size();
        StringBuffer sb = new StringBuffer(string.length() + indentSize);
        int i = 0;
        while (i < indentSize) {
            sb.append(' ');
            ++i;
        }
        sb.append(string);
        this.getLogger().debug(sb.toString());
    }

    protected void trace(String element, Attributes attributes) {
        if (!this.getLogger().isDebugLoggable()) {
            return;
        }
        int indentSize = this.stateStack.size();
        StringBuffer sb = new StringBuffer(64);
        int i = 0;
        while (i < indentSize) {
            sb.append(' ');
            ++i;
        }
        sb.append('<');
        if (attributes != null) {
            sb.append(element);
            XMLParser.toString(sb, attributes);
        } else {
            sb.append('/').append(element);
        }
        sb.append('>');
        this.getLogger().debug(sb.toString());
    }

    private static String toString(Attributes attributes) {
        StringBuffer result = new StringBuffer();
        XMLParser.toString(result, attributes);
        return result.toString();
    }

    private static void toString(StringBuffer sb, Attributes attributes) {
        int i = 0;
        while (i < attributes.getLength()) {
            String name = attributes.getLocalName(i);
            String value = attributes.getValue(i).trim();
            sb.append(' ').append(name);
            sb.append('=').append('\"');
            sb.append(value);
            sb.append('\"');
            ++i;
        }
    }

    public void error(String msg) {
        this.addError(msg);
    }

    public void checkRequiredAttribute(String element, String name, Object value) {
        if (value == null) {
            this.addError(NLS.bind(Messages.XMLParser_missing_required_attribute, (Object)element, (Object)name));
        }
    }

    public String checkRequiredAttribute(String element, String name, String value, String defaultValue) {
        if (value == null) {
            this.addError(NLS.bind(Messages.XMLParser_missing_required_attribute, (Object)element, (Object)name));
            return defaultValue;
        }
        return value;
    }

    public String checkRequiredAttributeStdDefault(String element, String name, String value) {
        if (value == null) {
            this.addError(NLS.bind(Messages.XMLParser_missing_required_attribute, (Object)element, (Object)name));
            return "no-" + name;
        }
        return value;
    }

    public void unexpectedAttribute(String element, Attr attr) {
        this.unexpectedAttribute(element, attr.name, attr.value);
    }

    public void unexpectedAttribute(String element, String attribute, String value) {
        this.addError(NLS.bind(Messages.XMLParser_unexpected_attribute, element, attribute, value));
    }

    public void invalidAttributeValue(String element, Attr attr) {
        this.invalidAttributeValue(element, attr.name, attr.value);
    }

    public void invalidAttributeValue(String element, String attribute, String value) {
        this.addError(NLS.bind(Messages.XMLParser_illegal_value_for_attribute, attribute, element, value));
    }

    public void unexpectedElement(String element, Attributes attributes) {
        String msg;
        String attrString;
        String string = attrString = attributes == null ? "" : XMLParser.toString(attributes);
        if (this.stateStack == null) {
            msg = NLS.bind(Messages.XMLParser_unexpected_element2, (Object)element, (Object)attrString);
        } else {
            Object object;
            String name = this.stateStack.peekStateName();
            if (this.stateStack.peekState() == 1 && (object = this.stateStack.peekObject()) instanceof String) {
                name = object.toString();
            }
            msg = NLS.bind(Messages.XMLParser_unexpected_element, name, element, attrString);
        }
        this.addError(msg);
    }

    public void unexpectedCharacterData(String cdata) {
        this.addError(NLS.bind(Messages.XMLParser_unexpected_character_data, (Object)this.stateStack.peekStateName(), (Object)cdata.trim()));
    }

    public void checkParentState(int expectedState, String element) {
        if (expectedState != this.stateStack.peekState(1)) {
            this.addError(NLS.bind(Messages.XMLParser_element_not_allowed, (Object)element, (Object)this.stateStack.peekStateName(1)));
        }
    }

    protected void push(int state, Object object) {
        this.stateStack.push(state, object);
    }

    protected void pop() {
        this.stateStack.pop();
    }

    protected int peekParentState() {
        return this.stateStack.peekState(1);
    }

    protected Object peekParentObject() {
        return this.stateStack.peekObject(1);
    }

    protected <T> T peekParentObject(Class<T> clazz) {
        Object parent = this.peekParentObject();
        if (!clazz.isInstance(parent)) {
            throw new BadStateError(clazz, parent.getClass());
        }
        return (T)parent;
    }

    protected int peekState() {
        return this.stateStack.peekState();
    }

    protected Object peekObject() {
        return this.stateStack.peekObject();
    }

    protected <T> T peekObject(Class<T> clazz) {
        T result = this.peekObjectOpt(clazz);
        if (result == null) {
            throw new BadStateError(clazz, this.peekObject().getClass());
        }
        return result;
    }

    protected <T> T peekObjectOpt(Class<T> clazz) {
        Object object = this.peekObject();
        if (!clazz.isInstance(object)) {
            return null;
        }
        return (T)object;
    }

    protected void checkNoAttributes(String element, Attributes attributes) {
        this.parseAttributes(element, attributes, NO_STRINGS, NO_STRINGS);
    }

    protected String parseOptionalAttribute(String element, Attributes attributes, String name) {
        return this.parseAttributes(element, attributes, NO_STRINGS, new String[]{name})[0];
    }

    protected String parseRequiredAttribute(String element, Attributes attributes, String name) {
        return this.parseRequiredAttributes(element, attributes, new String[]{name})[0];
    }

    protected String[] parseRequiredAttributes(String element, Attributes attributes, String name1, String name2) {
        return this.parseRequiredAttributes(element, attributes, new String[]{name1, name2});
    }

    protected String[] parseRequiredAttributes(String element, Attributes attributes, String[] required) {
        return this.parseAttributes(element, attributes, required, NO_STRINGS);
    }

    protected String[] parseAttributes(String element, Attributes attributes, String[] required, String[] optional) {
        String[] result = new String[required.length + optional.length];
        int i = 0;
        while (i < attributes.getLength()) {
            String name = attributes.getLocalName(i);
            String value = attributes.getValue(i).trim();
            int j = Util.indexOf(required, name);
            if (j >= 0) {
                result[j] = value;
            } else {
                j = Util.indexOf(optional, name);
                if (j >= 0) {
                    result[required.length + j] = value;
                } else {
                    this.unexpectedAttribute(element, name, value);
                }
            }
            ++i;
        }
        i = 0;
        while (i < required.length) {
            this.checkRequiredAttribute(element, required[i], result[i]);
            ++i;
        }
        return result;
    }

    protected boolean parseBoolean(String booleanString, boolean defaultValue) {
        if (booleanString == null) {
            return defaultValue;
        }
        if (CommonDef.True.equalsIgnoreCase(booleanString)) {
            return true;
        }
        if (CommonDef.False.equalsIgnoreCase(booleanString)) {
            return false;
        }
        this.addError(NLS.bind(Messages.XMLParser_Invalid_Boolean, (Object)booleanString));
        return defaultValue;
    }

    protected Version parseVersion(String versionString) {
        try {
            return Version.parseVersion((String)versionString);
        }
        catch (IllegalArgumentException e) {
            this.addError(NLS.bind(Messages.XMLParser_Invalid_Version, (Object)versionString));
            return Version.emptyVersion;
        }
    }

    protected static class Attr {
        public final String name;
        public final String value;

        public static Iterable<Attr> iterable(Attributes attributes) {
            return new AttrIterable(attributes);
        }

        Attr(String name, String value) {
            this.name = name;
            this.value = value;
        }

        public boolean is(String n) {
            return this.name.equals(n);
        }

        private static class AttrIterable
        implements Iterable<Attr> {
            private final Attributes attributes;

            AttrIterable(Attributes attributes) {
                this.attributes = attributes;
            }

            @Override
            public Iterator<Attr> iterator() {
                return new Iter(this.attributes);
            }

            private static class Iter
            implements Iterator<Attr> {
                private final Attributes attributes;
                private final int length;
                private int next = 0;

                public Iter(Attributes attributes) {
                    this.attributes = attributes;
                    this.length = attributes.getLength();
                }

                @Override
                public boolean hasNext() {
                    return this.next < this.length;
                }

                @Override
                public Attr next() {
                    int i = this.next++;
                    return new Attr(this.attributes.getLocalName(i), this.attributes.getValue(i).trim());
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            }
        }
    }

    public class BadStateError
    extends AssertionError {
        public BadStateError() {
            this("unexpected state: {0}", xMLParser.stateStack);
        }

        public BadStateError(Class expected, Class actual) {
            this("Expected {0} on stack, found {1}; current state is: {2}", expected, actual, xMLParser.stateStack);
        }

        public BadStateError(String element) {
            this("unexpected state for {0}: {1}", element, xMLParser.stateStack);
        }

        private BadStateError(String msg, Object ... args) {
            super((Object)NLS.bind(msg, args));
        }
    }

    protected static class PropertyPair {
        public final String name;
        public final String value;

        public PropertyPair(String name, String value) {
            this.name = name;
            this.value = value;
        }

        public String toString() {
            return String.valueOf(this.name) + '=' + this.value;
        }

        public String getName() {
            return this.name;
        }

        public String getValue() {
            return this.value;
        }

        public boolean isValid() {
            return this.name != null && this.value != null;
        }
    }

    protected static class StateStack {
        public static final int IGNORED_STATE = 0;
        public static final int NO_CONTENT_STATE = 1;
        public static final int INITIAL_STATE = 2;
        private final List stack = new ArrayList();
        private final String[] stateNames;

        public StateStack() {
            this(NO_STRINGS);
        }

        public StateStack(String[] stateNames) {
            assert (stateNames != null);
            this.stateNames = stateNames;
        }

        public void pop() {
            this.stack.remove(this.stack.size() - 1);
        }

        public int peekState() {
            return this.peek((int)1).state;
        }

        public int peekState(int offset) {
            return this.peek((int)(offset + 1)).state;
        }

        public Object peekObject() {
            return this.peek((int)1).object;
        }

        public Object peekObject(int offset) {
            return this.peek((int)(offset + 1)).object;
        }

        public String peekStateName() {
            return this.stateName(this.peekState());
        }

        public String peekStateName(int offset) {
            return this.stateName(this.peekState(offset));
        }

        public void push(int state, Object object) {
            this.stack.add(new Element(state, object));
        }

        public void clear() {
            this.stack.clear();
        }

        public int size() {
            return this.stack.size();
        }

        public String toString() {
            StringBuffer result = new StringBuffer();
            result.append('[');
            int i = this.stack.size() - 1;
            while (i >= 0) {
                Element e = (Element)this.stack.get(i);
                if (i < this.stack.size() - 1) {
                    result.append(',');
                }
                result.append(' ');
                result.append(this.stateName(e.state));
                --i;
            }
            result.append(' ').append(']');
            return result.toString();
        }

        private Element peek(int offset) {
            return (Element)this.stack.get(this.stack.size() - offset);
        }

        String stateName(int state) {
            if (state >= 0 && state < this.stateNames.length) {
                return this.stateNames[state];
            }
            return "State " + state;
        }

        private static class Element {
            public final int state;
            public final Object object;

            public Element(int state, Object object) {
                this.state = state;
                this.object = object;
            }

            public String toString() {
                return String.valueOf(Integer.toString(this.state)) + ' ' + this.object;
            }
        }
    }
}

