/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.core.utils;

import com.ibm.cic.common.core.utils.Encodings;
import com.ibm.cic.common.core.utils.Messages;
import com.ibm.cic.common.core.utils.NLS;
import com.ibm.cic.common.core.utils.NativeUtils;
import com.ibm.cic.common.logging.Logger;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;

public class SystemCharSets {
    public static final String ASCII_codeset = "ISO8859-1";
    public static final String OS400_EBCDIC_codeset = "Cp037";
    public static final String EBCDIC_codeset = "IBM-1047";
    private static final String PLUGIN_ID = "com.ibm.cic.agent.zos.utils.SystemCharSets";
    private static final String chcp_COMMAND = "chcp -q";
    private static final String osgi_os = System.getProperty("osgi.os");
    private static final String m_os = osgi_os != null && !osgi_os.equals("") ? osgi_os : Platform.getOS();
    private static final boolean m_isZOS = "zos".equals(m_os);
    private static final boolean m_isOS400 = "os400".equals(m_os);
    private String systemASCII;
    private String systemEBCDIC;

    public SystemCharSets() {
        block6: {
            this.setSystemASCII(ASCII_codeset);
            this.setSystemEBCDIC(EBCDIC_codeset);
            if (m_isOS400) {
                this.setSystemEBCDIC(OS400_EBCDIC_codeset);
            }
            try {
                if (m_isZOS) {
                    this.getSystemASCIIandEBCDICvalues();
                } else if (m_isOS400) {
                    this.getOS400SystemEBCDICvalues();
                }
            }
            catch (CoreException e) {
                Logger.getGlobalLogger().error(e.getMessage());
                this.setSystemASCII(ASCII_codeset);
                this.setSystemEBCDIC(EBCDIC_codeset);
                if (!m_isOS400) break block6;
                this.setSystemEBCDIC(OS400_EBCDIC_codeset);
            }
        }
    }

    public String getSystemASCII() {
        return this.systemASCII;
    }

    private void setSystemASCII(String systemASCII) {
        this.systemASCII = systemASCII;
    }

    public String getSystemEBCDIC() {
        return this.systemEBCDIC;
    }

    private void setSystemEBCDIC(String systemEBCDIC) {
        this.systemEBCDIC = systemEBCDIC;
    }

    private void getSystemASCIIandEBCDICvalues() throws CoreException {
        String command = chcp_COMMAND;
        StringBuilder m_sErr = new StringBuilder();
        int nRetVal = -1;
        try {
            String line;
            Logger.getGlobalLogger().debug("executing command: " + command);
            Process process = Runtime.getRuntime().exec(command);
            InputStream inputstream = process.getInputStream();
            BufferedReader bufferedreader = new BufferedReader(Encodings.DEFAULT.reader(inputstream));
            InputStream errorstream = process.getErrorStream();
            BufferedReader errorbufferedreader = new BufferedReader(Encodings.DEFAULT.reader(errorstream));
            String ascii_regex = "^.*ASCII.*:\\s*(.*)$";
            String ebcdic_regex = "^.*EBCDIC.*:\\s*(.*)$";
            while ((line = bufferedreader.readLine()) != null) {
                Logger.getGlobalLogger().debug("Searching for Pattern " + ascii_regex + " in String " + line);
                Pattern p = Pattern.compile(ascii_regex);
                Matcher m = p.matcher(line);
                boolean doesMatch = m.matches();
                if (doesMatch) {
                    Logger.getGlobalLogger().debug("Patther match found: " + m.group(1));
                    m.group();
                    this.setSystemASCII(m.group(1));
                    continue;
                }
                Logger.getGlobalLogger().debug("Searching for Pattern " + ebcdic_regex + " in String " + line);
                p = Pattern.compile(ebcdic_regex);
                m = p.matcher(line);
                doesMatch = m.matches();
                if (!doesMatch) continue;
                Logger.getGlobalLogger().debug("Patther match found: " + m.group(1));
                m.group();
                this.setSystemEBCDIC(m.group(1));
            }
            while ((line = errorbufferedreader.readLine()) != null) {
                m_sErr.append(String.valueOf(line) + "\n");
            }
            process.waitFor();
            nRetVal = process.exitValue();
            errorbufferedreader.close();
            errorstream.close();
            bufferedreader.close();
            inputstream.close();
        }
        catch (IOException e) {
            m_sErr = new StringBuilder(e.getLocalizedMessage());
            nRetVal = -1;
        }
        catch (IllegalThreadStateException e) {
            m_sErr = new StringBuilder(e.getLocalizedMessage());
            nRetVal = -1;
        }
        catch (InterruptedException e) {
            m_sErr = new StringBuilder(e.getLocalizedMessage());
            nRetVal = -1;
        }
        if (nRetVal != 0) {
            throw new CoreException((IStatus)new Status(4, PLUGIN_ID, 1, NLS.bind(Messages.exec_error, (Object)nRetVal, (Object)m_sErr.toString()), null));
        }
    }

    private void getOS400SystemEBCDICvalues() {
        try {
            ClassLoader loader = NativeUtils.class.getClassLoader();
            Class<?> cls = loader.loadClass("com.ibm.cic.common.core.os400.utils.DetectCodePage");
            Method method = cls.getMethod("getCodePage", new Class[0]);
            Object object = method.invoke(null, new Object[0]);
            this.setSystemEBCDIC(object.toString());
        }
        catch (Exception e) {
            Logger.getLogger(this.getClass()).error(e);
            this.setSystemEBCDIC(OS400_EBCDIC_codeset);
        }
    }
}

