/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.core.utils;

import java.io.File;
import org.eclipse.core.runtime.IPath;

public class PathUtil {
    private static final char SEGMENT_FORWARD_SLASH = '/';
    private static final char SEGMENT_SEPARATOR = '/';
    private static final String SEGMENT_SEPARATOR_STRING = "/";
    private static final char SEGMENT_BACK_SLASH = '\\';
    public static final String EMPTY_STRING = "";
    public static final int PATH_CODING_TO_RESTRICTED = 1;
    public static final int PATH_CODING_FROM_RESTRICTED = 2;
    public static final int PATH_CODING_LEAVE_ALONE = 3;

    public static boolean isSeparator(char c) {
        return c == '/' || c == '\\';
    }

    public static String getSimpleName(String path) {
        int i = path.lastIndexOf(47);
        if (i == -1) {
            i = path.lastIndexOf(92);
        }
        return i == -1 ? path : path.substring(i + 1);
    }

    public static String fixSlashes(String path) {
        return path == null || File.separatorChar == '/' ? path : path.replace('/', File.separatorChar);
    }

    public static String forwardSlashify(String filePath) {
        if (filePath.indexOf(File.separatorChar) != -1) {
            return filePath.replace(File.separatorChar, '/');
        }
        return filePath;
    }

    public static String addTrailingSlash(String path) {
        if (path.length() == 0) {
            return SEGMENT_SEPARATOR_STRING;
        }
        char c = path.charAt(path.length() - 1);
        if (!PathUtil.isSeparator(c)) {
            return path.concat(SEGMENT_SEPARATOR_STRING);
        }
        return path;
    }

    public static String getExtension(String path) {
        String simpleName = PathUtil.getSimpleName(path);
        int i = simpleName.lastIndexOf(46);
        return i == -1 ? EMPTY_STRING : simpleName.substring(i + 1);
    }

    public static boolean hasExtension(String path, String extension, boolean ignoreCase) {
        String ext = PathUtil.getExtension(path);
        return ignoreCase ? ext.equalsIgnoreCase(extension) : ext.equals(extension);
    }

    public static String removeSimpleName(String path) {
        int i = path.lastIndexOf(47);
        if (i == -1) {
            i = path.lastIndexOf(92);
        }
        return i == -1 ? EMPTY_STRING : path.substring(0, i);
    }

    public static IPath makeRelative(IPath basePath, IPath absPath) {
        boolean isDir = basePath.hasTrailingSeparator();
        IPath baseDir = isDir ? basePath : basePath.removeLastSegments(1);
        IPath relativePath = absPath;
        if (baseDir.isPrefixOf(absPath)) {
            relativePath = absPath.removeFirstSegments(baseDir.segmentCount());
            relativePath = relativePath.setDevice(null);
        }
        return relativePath;
    }

    public static String flatten(IPath path, char sep) {
        int len = 0;
        int i = 0;
        while (i < path.segmentCount()) {
            String s = path.segment(i);
            len += s.length() + 1;
            ++i;
        }
        StringBuffer sb = new StringBuffer(len);
        int i2 = 0;
        while (i2 < path.segmentCount()) {
            String s = path.segment(i2);
            if (i2 > 0) {
                sb.append(sep);
            }
            sb.append(s);
            ++i2;
        }
        return sb.toString();
    }

    public static IPath makeAbsolute(IPath basePath, IPath relPath) {
        IPath absPath;
        if (relPath.isAbsolute()) {
            absPath = relPath;
        } else {
            boolean isDir = basePath.hasTrailingSeparator();
            IPath baseDir = isDir ? basePath : basePath.removeLastSegments(1);
            absPath = baseDir.append(relPath);
        }
        return absPath;
    }

    public static String concatPathSegments(String a, String b) {
        return PathUtil.concatPathSegments(a, b, '/');
    }

    public static String concatPathSegments(String a, String b, char sep) {
        boolean aEndsWithSeparator = a.length() == 0 ? false : PathUtil.isSeparator(a.charAt(a.length() - 1));
        boolean bBeginsWithSeparator = b.length() == 0 ? false : PathUtil.isSeparator(b.charAt(0));
        StringBuffer sb = new StringBuffer(a.length() + b.length() + 1);
        sb.append(a);
        if (!aEndsWithSeparator && !bBeginsWithSeparator) {
            sb.append(sep);
        }
        sb.append(b);
        return sb.toString();
    }

    public static String massagePath(String ppath, boolean dropPreDriveSlash, int pathEncoding, boolean useForwardFileSep) {
        String path = ppath;
        if (dropPreDriveSlash) {
            path = PathUtil.dropPreDeviceSlash(path);
        }
        if (pathEncoding == 1) {
            path = PathUtil.encodeSpaces(path);
        }
        if (pathEncoding == 2) {
            path = PathUtil.decodeSpaces(path);
        }
        if (useForwardFileSep) {
            path = PathUtil.useForwardFileSepInPath(path);
        }
        return path;
    }

    private static String dropPreDeviceSlash(String path) {
        int iColon = path.indexOf(58);
        while (iColon != -1 && PathUtil.isSeparator(path.charAt(0))) {
            path = path.substring(1);
        }
        return path;
    }

    private static String encodeSpaces(String path) {
        if (path.indexOf(32) != -1) {
            path = path.replaceAll(" ", "%20");
        }
        return path;
    }

    private static String decodeSpaces(String path) {
        if (path.indexOf("%20") != -1) {
            path = path.replaceAll("%20", " ");
        }
        return path;
    }

    private static String useForwardFileSepInPath(String path) {
        if (path.indexOf(92) != -1) {
            path = path.replace('\\', '/');
        }
        return path;
    }

    public static String formatZeroPaddedCount(int n, int value) {
        String str = Integer.toString(value);
        if (str.length() < n) {
            StringBuffer sb = new StringBuffer(n);
            int i = 0;
            while (i < n - str.length()) {
                sb.append('0');
                ++i;
            }
            sb.append(str);
            str = sb.toString();
        }
        return str;
    }
}

