/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.core.utils;

import com.ibm.cic.common.core.utils.Messages;
import com.ibm.cic.common.core.utils.Statuses;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class ParserUtil {
    public static IStatus validateId(String id) {
        IdValidator v = new IdValidator();
        return v.validate(id);
    }

    public static boolean isTokenChar(char c) {
        return c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z' || c >= '0' && c <= '9' || c == '_' || c == '-';
    }

    public static boolean isLetterChar(char c) {
        return c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z';
    }

    public static boolean isNumberChar(char c) {
        return c >= '0' && c <= '9';
    }

    public static boolean isUnderScoreOrDashChar(char c) {
        return c == '_' || c == '-';
    }

    public static class IdValidator {
        public IStatus validate(String id) {
            assert (id != null);
            int len = id.length();
            if (len <= 0) {
                return Statuses.ERROR.get(Messages.ParserUtil_emptyNotValid, new Object[0]);
            }
            int i = 0;
            while (i < len) {
                char c = id.charAt(i);
                IStatus status = this.checkValidChar(id, i, c);
                if (status.matches(4)) {
                    return status;
                }
                ++i;
            }
            return Status.OK_STATUS;
        }

        protected IStatus checkValidChar(String id, int i, char c) {
            if (!ParserUtil.isTokenChar(c)) {
                return Statuses.ERROR.get(Messages.ParserUtil_invalidCharAtPos, id, Character.valueOf(c), i + 1);
            }
            return Status.OK_STATUS;
        }
    }
}

