/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.core.utils;

import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;

public class HashMapSet {
    private final Map map;

    public HashMapSet() {
        this(4);
    }

    public HashMapSet(int initialMapCapacity) {
        this.map = new LinkedHashMap(initialMapCapacity);
    }

    public String toString() {
        return this.toString("");
    }

    public String toString(String indent) {
        if (this.map.isEmpty()) {
            return String.valueOf(indent) + "(empty)";
        }
        StringBuffer sb = new StringBuffer(64 * this.map.size());
        for (Object key : this.map.keySet()) {
            Set set = this.getOrCreate(key);
            sb.append(indent).append(key).append(':');
            this.append(sb, String.valueOf(indent) + "  ", set);
        }
        sb.setLength(sb.length() - 1);
        return sb.toString();
    }

    protected Set createSet() {
        return new LinkedHashSet(4);
    }

    protected void append(StringBuffer sb, String indent, Set set) {
        if (set.size() == 0) {
            sb.append(" (empty)\n");
        } else {
            sb.append('\n');
            Iterator i = set.iterator();
            while (i.hasNext()) {
                sb.append(indent).append(i.next()).append('\n');
            }
        }
    }

    public int size() {
        return this.map.size();
    }

    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    public boolean isEmpty(Object key) {
        return this.get(key).isEmpty();
    }

    public Set keySet() {
        return this.map.keySet();
    }

    public boolean contains(Object key, Object value) {
        return this.get(key).contains(value);
    }

    public boolean contains(Object key) {
        return this.get(key) != Collections.EMPTY_SET;
    }

    public Set getOrCreate(Object key) {
        Set set = this.get(key);
        if (set == Collections.EMPTY_SET) {
            set = this.createSet();
            this.map.put(key, set);
        }
        return set;
    }

    public Set get(Object key) {
        Set set = (Set)this.map.get(key);
        return set != null ? set : Collections.EMPTY_SET;
    }

    public boolean add(Object key, Object value) {
        return this.getOrCreate(key).add(value);
    }

    public boolean remove(Object key, Object value) {
        return this.get(key).remove(value);
    }

    public Set remove(Object key) {
        return (Set)this.map.remove(key);
    }
}

