/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.core.repository.nls;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;

public class NLSUtils {
    private static final String NL_ID = "%";

    public static List calculateBundleNames(String include) {
        String variant;
        int variantLength;
        String country;
        int countryLength;
        Locale locale = Locale.getDefault();
        ArrayList<String> return_value = new ArrayList<String>();
        String language = locale.getLanguage();
        int languageLength = language.length();
        if (languageLength + (countryLength = (country = locale.getCountry()).length()) + (variantLength = (variant = locale.getVariant()).length()) != 0) {
            StringBuffer temp = new StringBuffer();
            if (languageLength > 0) {
                temp.append(language);
                return_value.add(temp.toString());
                if (countryLength > 0) {
                    temp.append('_');
                    temp.append(country);
                    return_value.add(0, temp.toString());
                    if (variantLength > 0) {
                        temp.append('_');
                        temp.append(variant);
                        return_value.add(0, temp.toString());
                    }
                }
            }
        }
        if (include != null) {
            return_value.add(include);
        }
        return return_value;
    }

    public static boolean isNLKey(String str) {
        return str != null && str.startsWith(NL_ID);
    }

    public static String normalizeKey(String key) {
        StringBuffer buffer = new StringBuffer();
        if (!key.startsWith(NL_ID)) {
            buffer.append(NL_ID);
        }
        return buffer.append(key).toString();
    }

    public static void addKeyToCollectionIfNlKey(String key, Collection dest) {
        if (NLSUtils.isNLKey(key)) {
            dest.add(key.substring(1));
        }
    }
}

