/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.core.repository;

import com.ibm.cic.common.core.artifactrepo.FileContentLocator;
import com.ibm.cic.common.core.artifactrepo.IArtifactLocator;
import com.ibm.cic.common.core.artifactrepo.IContentLocator;
import com.ibm.cic.common.core.artifactrepo.impl.AbstractContentLocator;
import com.ibm.cic.common.core.artifactrepo.impl.Messages;
import com.ibm.cic.common.core.downloads.DownloadContextThreadLocalInheritedAndGlobal;
import com.ibm.cic.common.core.downloads.TransferUtils;
import com.ibm.cic.common.core.internal.downloads.DownloadedIncompleteUsingFile;
import com.ibm.cic.common.core.model.adapterdata.IArtifactKey;
import com.ibm.cic.common.core.utils.ICicStatus;
import com.ibm.cic.common.core.utils.JettyDataKeeper;
import com.ibm.cic.common.core.utils.PathUtil;
import com.ibm.cic.common.core.utils.Statuses;
import com.ibm.cic.common.core.utils.TempUtil;
import com.ibm.cic.common.core.utils.UserNames;
import com.ibm.cic.common.core.utils.UserOptions;
import com.ibm.cic.common.downloads.DownloadCanceledException;
import com.ibm.cic.common.downloads.DownloadHandler;
import com.ibm.cic.common.downloads.DownloadInProgressManager;
import com.ibm.cic.common.downloads.DownloadRetryLevel;
import com.ibm.cic.common.downloads.DownloadedFile;
import com.ibm.cic.common.downloads.IContentInfo;
import com.ibm.cic.common.downloads.IDownloadSession;
import com.ibm.cic.common.downloads.IDownloadedFile;
import com.ibm.cic.common.downloads.ITransferMonitor;
import com.ibm.cic.common.downloads.ResumableDownloadProgress;
import com.ibm.cic.common.downloads.TransferManager;
import com.ibm.cic.common.logging.Logger;
import java.io.File;
import java.io.FileNotFoundException;
import java.net.URL;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;

public class URLContentLocator
extends AbstractContentLocator {
    private final URL url;

    public URLContentLocator(URL url, IContentInfo locatorContentInfo) {
        super(locatorContentInfo);
        this.url = url;
    }

    public URLContentLocator(URL url, IContentInfo locatorContentInfo, IContentInfo expectedContentInfo) {
        super(locatorContentInfo, expectedContentInfo);
        this.url = url;
    }

    public static IStatus validateURLExists(int severity, UserNames context, IContentLocator locator, URL url, IProgressMonitor monitor) {
        try {
            boolean exists = TransferUtils.existsURL(url, monitor);
            if (exists) {
                return Status.OK_STATUS;
            }
            return URLContentLocator.makeDoesNotExistStatus(severity, context, locator, null);
        }
        catch (CoreException e) {
            return e.getStatus();
        }
        catch (Exception e) {
            String msg = NLS.bind((String)Messages.exist_check_failed, (Object)locator.getUserNames().getLogicalName());
            return Statuses.ERROR.get(4, e, msg, new Object[0]);
        }
    }

    @Override
    public IStatus validateExists(int severity, IProgressMonitor monitor) {
        return URLContentLocator.validateURLExists(severity, null, this, this.url, monitor);
    }

    public URL getWebURL() {
        return this.url;
    }

    @Override
    protected DownloadRetryLevel retryLevel(Exception exception) {
        DownloadHandler handler = TransferManager.INSTANCE.getHandler(this.url.getProtocol());
        if (handler == null) {
            return super.retryLevel(exception);
        }
        return handler.retryLevel(exception);
    }

    public static IDownloadedFile downloadToFileNoValidationNoResumeRetry(AbstractContentLocator locator, IDownloadSession session, URL url, IPath destinationLocation, ITransferMonitor transferPerformance, ResumableDownloadProgress.IResumableDownloadProgress progress, long[] outReadBytes) {
        DownloadHandler handler = TransferManager.INSTANCE.getHandler(url.getProtocol());
        File destination = destinationLocation.toFile();
        if (handler == null) {
            String msg = NLS.bind((String)Messages.no_download_handler_available, (Object)url.getProtocol());
            ICicStatus statusDetail = Statuses.ERROR.get(103, msg, new Object[0]);
            return new DownloadedFile(statusDetail, null);
        }
        if (progress.isCanceled() && !JettyDataKeeper.INSTANCE.isUISessionDestroyed()) {
            return new DownloadedFile(ICicStatus.CANCEL_STATUS, null);
        }
        DownloadedIncompleteUsingFile downloadIncomplete = new DownloadedIncompleteUsingFile(destination);
        try {
            IArtifactLocator artifactLocator;
            IArtifactKey key;
            long expectedSize = locator.getContentInfo().getSizeInfo().getDownloadSize();
            if (expectedSize == Long.MIN_VALUE) {
                expectedSize = -1L;
            }
            if (UserOptions.CIC_REPO_ATOC_IGNORE_DOWNLOADSIZE_FOR_KNOWN_BUILD_ISSUE.isSet() && expectedSize != -1L && locator instanceof IArtifactLocator && (key = (artifactLocator = (IArtifactLocator)((Object)locator)).getArtifactKey()).getNamespace().equals("eclipse") && key.getQualifier().equals("plugin") && key.getId().getId().equals("org.eclipse.test")) {
                expectedSize = -1L;
                Logger.getGlobalLogger().warning("Not using expected download size from table of contents for ''{0}'' as there were inconsistencies breaking the build", url);
            }
            IContentInfo ciDownload = handler.download(DownloadContextThreadLocalInheritedAndGlobal.CONTEXT, url.toExternalForm(), destination.toString(), expectedSize, transferPerformance, outReadBytes);
            if (progress.isCanceled()) {
                return new DownloadedFile(ICicStatus.CANCEL_STATUS, destination, ciDownload, downloadIncomplete);
            }
            return new DownloadedFile(ICicStatus.OK_STATUS, destination, ciDownload, downloadIncomplete);
        }
        catch (FileNotFoundException e) {
            ICicStatus status = AbstractContentLocator.makeDoesNotExistStatus(4, locator, null);
            return new DownloadedFile(status, null, null, downloadIncomplete);
        }
        catch (DownloadCanceledException e) {
            ICicStatus status = TransferUtils.convertDownloadCancelToStatus(e);
            return new DownloadedFile(status, destination, null, downloadIncomplete);
        }
        catch (Exception e) {
            ICicStatus status = locator.createErrorDownloadToFile(destination, e);
            return new DownloadedFile(status, null, null, downloadIncomplete);
        }
    }

    @Override
    protected DownloadInProgressManager.NonValidatedDownload createNonValidatedDownloadRequest(TempUtil.UniqueTempDir dipRoot, IPath destination) throws CoreException {
        String simpleName = "URLL" + PathUtil.getSimpleName(this.url.getPath());
        return FileContentLocator.createNonValidatedDownloadRequest(this, dipRoot, simpleName, destination);
    }

    @Override
    protected IDownloadedFile doDownloadToFileNoValidationNoResumeRetry(IDownloadSession session, IPath destinationLocation, ITransferMonitor transferPerformance, ResumableDownloadProgress.IResumableDownloadProgress progress, long[] outReadBytes) {
        return URLContentLocator.downloadToFileNoValidationNoResumeRetry(this, session, this.url, destinationLocation, transferPerformance, progress, outReadBytes);
    }

    @Override
    public UserNames getUserNames() {
        return new UserNames(null, this.url.toString());
    }

    public String toString() {
        return this.url.toString();
    }
}

