/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.core.repository;

import com.ibm.cic.common.core.internal.Messages;
import com.ibm.cic.common.core.internal.artifactrepo.IRevealArtifactFileLocations;
import com.ibm.cic.common.core.internal.utils.CicConstants;
import com.ibm.cic.common.core.model.IOffering;
import com.ibm.cic.common.core.repository.AbstractFileBasedRepository;
import com.ibm.cic.common.core.repository.IRepository;
import com.ibm.cic.common.core.repository.IRepositoryInfo;
import com.ibm.cic.common.core.repository.IRevealFileLocations;
import com.ibm.cic.common.core.repository.LayoutPolicyDefaultLayout;
import com.ibm.cic.common.core.repository.RemoteArtifactRepository;
import com.ibm.cic.common.core.repository.RepositoryFileBasedSiteProperties;
import com.ibm.cic.common.core.repository.RepositoryStatus;
import com.ibm.cic.common.logging.Logger;
import java.io.File;
import java.io.IOException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;

public class RemoteRepository
extends AbstractFileBasedRepository {
    public static final String REPOSITORY_TYPE = "Remote";
    public static final String REPOSITORY_VERSION = "0.0.0.1";
    private static final Logger log = Logger.getLogger(RemoteRepository.class);

    public RemoteRepository() {
        this(REPOSITORY_TYPE, REPOSITORY_VERSION, true);
    }

    public RemoteRepository(String type, String version, boolean setLpAndProp) {
        super(type, version);
        this.setArtifactRepository(new RemoteArtifactRepository(){

            @Override
            public IRepository getRepository() {
                return RemoteRepository.this;
            }
        });
        if (setLpAndProp) {
            this.setLayoutPolicy(new LayoutPolicyDefaultLayout(this));
            this.setSiteProperties(new RepositoryFileBasedSiteProperties(this.getLP()));
        }
    }

    @Override
    public IStatus initializeRepository(IRepositoryInfo repInfo, IProgressMonitor progressMonitor) {
        IStatus return_value = super.initializeRepository(repInfo, progressMonitor);
        if (return_value.isOK()) {
            if (!CicConstants.hasArchiveInPath(repInfo.getLocation())) {
                return_value = this.getStatus(false, null);
                if (return_value.isOK()) {
                    return_value = this.getArtifactRepository().initializeArtifactRepository(repInfo);
                }
            } else {
                return_value = RepositoryStatus.createErrorMultiStatus(6014, Messages.ERROR_CANT_CREATE_REPOSITORY_OF_TYPE, this.getType(), this.getLocationStr(), return_value);
            }
        }
        return return_value;
    }

    @Override
    public Object getAdapter(Class adapter) {
        if (adapter == IRevealFileLocations.class) {
            IRevealArtifactFileLocations ral = (IRevealArtifactFileLocations)this.getAdapter(IRevealArtifactFileLocations.class);
            if (ral != null) {
                return new RevealFileLocations(ral);
            }
            return null;
        }
        return super.getAdapter(adapter);
    }

    @Override
    protected void updateRepositoryInfo(IRepositoryInfo repInfo) throws CoreException, IOException {
        super.updateRepositoryInfo(repInfo);
        this.setWritable(false);
    }

    public IStatus setUpdateOffering(IOffering updateOffering, IOffering baseOffering) {
        throw new UnsupportedOperationException();
    }

    @Override
    public IStatus unsetUpdateOffering(IOffering updateOffering) {
        throw new UnsupportedOperationException();
    }

    @Override
    protected IStatus doImportP2Repository(File p2RepositoryFile, IProgressMonitor progressMonitor) {
        return RepositoryStatus.createErrorStatus(Messages.Repo_CantImportP2RepositoryReadOnly, this, 6071, log);
    }

    class RevealFileLocations
    implements IRevealFileLocations {
        private final IRevealArtifactFileLocations ral;

        public RevealFileLocations(IRevealArtifactFileLocations ral) {
            this.ral = ral;
        }

        @Override
        public File[] revealUsedArtifactRoots() {
            return this.ral.revealUsedArtifactRoots();
        }

        @Override
        public String[] revealArtifactRootNames() {
            return this.ral.revealArtifactRootNames();
        }

        @Override
        public File getTempDir() {
            return null;
        }

        @Override
        public File getExtraDir() {
            return null;
        }

        @Override
        public IRepository getRepository() {
            return RemoteRepository.this;
        }
    }
}

