/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.core.preferences;

import com.ibm.cic.common.core.preferences.CicCommonSettings;
import com.ibm.cic.common.core.utils.AbstractPlatformPolicyFactory;
import com.ibm.cic.common.core.utils.FileUtil;
import com.ibm.cic.common.core.utils.PlatformUtils;
import java.io.File;

public class PPSettings
extends AbstractPlatformPolicyFactory {
    public static final int MaxPathLength_Win32 = 256;
    public static final int MaxPathLength_Linux = 1024;
    private static String m_imCacheLocation;
    static PPSettings m_factory;

    static {
        m_factory = new PPSettings();
    }

    public static String getDefaultIMCacheLocation() {
        if (m_imCacheLocation == null) {
            m_imCacheLocation = FileUtil.getCanonicalPath(new File(PlatformUtils.getDefaultDataLocation(), PPSettings.getPolicy().getDefaultRelativeIMCacheLocation()));
        }
        return m_imCacheLocation;
    }

    public static void setDefaultIMCacheLocation(String imCacheLocation) {
        m_imCacheLocation = imCacheLocation;
    }

    @Override
    protected Object createLinuxPolicy() {
        return new PPLinux();
    }

    @Override
    protected Object createWindowsPolicy() {
        return new PPWindows();
    }

    @Override
    protected Object createZOSPolicy() {
        return new PPZOS();
    }

    public static PPCommon getPolicy() {
        return (PPCommon)m_factory.getPlatformPolicy();
    }

    public abstract class PPCommon {
        public abstract String getNonDbcsLumPath(String var1);

        public abstract String getExeSuffix();

        protected abstract String getDefaultRelativeIMCacheLocation();
    }

    class PPLinux
    extends PPCommon {
        PPLinux() {
        }

        @Override
        public String getNonDbcsLumPath(String appdatapath) {
            if (CicCommonSettings.isOS400() && CicCommonSettings.getAccessRightsMode().isAdminMode()) {
                return String.valueOf(PlatformUtils.getDefaultSharedLocation(null)) + "/InstallationManager";
            }
            return String.valueOf(PlatformUtils.getDefaultSharedLocation(null)) + "/ibm/InstallationManager";
        }

        @Override
        public String getExeSuffix() {
            return "";
        }

        @Override
        protected String getDefaultRelativeIMCacheLocation() {
            StringBuffer relativePath = new StringBuffer("/ibm/InstallationManager");
            if (CicCommonSettings.isOS400() && CicCommonSettings.getAccessRightsMode().isAdminMode()) {
                relativePath = new StringBuffer("/InstallationManager");
            }
            if (CicCommonSettings.getAccessRightsMode().isGroupMode()) {
                relativePath.append(CicCommonSettings.getGroupProperty());
            }
            if (CicCommonSettings.isBeta()) {
                relativePath.append(CicCommonSettings.getBetaProperty());
            }
            return relativePath.toString();
        }
    }

    class PPWindows
    extends PPCommon {
        PPWindows() {
        }

        @Override
        public String getNonDbcsLumPath(String appdatapath) {
            return String.valueOf(appdatapath.trim().charAt(0)) + ":/IBM/InstallationManager";
        }

        @Override
        public String getExeSuffix() {
            return ".exe";
        }

        @Override
        protected String getDefaultRelativeIMCacheLocation() {
            if (CicCommonSettings.isBeta()) {
                return "/IBM/Installation Manager " + CicCommonSettings.getBetaProperty();
            }
            return "/IBM/Installation Manager";
        }
    }

    class PPZOS
    extends PPCommon {
        PPZOS() {
        }

        @Override
        public String getNonDbcsLumPath(String appdatapath) {
            return String.valueOf(PlatformUtils.getDefaultSharedLocation(null)) + "/appdata";
        }

        @Override
        public String getExeSuffix() {
            return "";
        }

        @Override
        protected String getDefaultRelativeIMCacheLocation() {
            StringBuffer relativePath = new StringBuffer("/appdata");
            if (CicCommonSettings.isBeta()) {
                relativePath.append(CicCommonSettings.getBetaProperty());
            }
            return relativePath.toString();
        }
    }
}

