/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.core.preferences;

import com.ibm.cic.common.core.preferences.CicAbstractPreferenceHandler;
import com.ibm.cic.common.core.preferences.CicFileAndForwardPreferences;
import com.ibm.cic.common.core.preferences.CicFilePreferences;
import java.io.File;
import java.io.IOException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.osgi.service.prefs.BackingStoreException;

public class CicDirPreferenceHandler
extends CicAbstractPreferenceHandler {
    boolean m_isValid = true;
    IEclipsePreferences m_memoryPreferences = null;

    public CicDirPreferenceHandler(String thePreferenceStoreLocation, IEclipsePreferences memoryPreferences) {
        this.m_memoryPreferences = memoryPreferences;
        this.m_isValid = this.setPreferenceStore(thePreferenceStoreLocation);
    }

    public CicDirPreferenceHandler(String thePreferenceStoreLocation) {
        this(thePreferenceStoreLocation, null);
    }

    private boolean setPreferenceStore(String thePreferenceStoreLocation) {
        boolean return_value = true;
        File prefFile = new File(thePreferenceStoreLocation);
        CicFilePreferences filePS = this.m_memoryPreferences == null ? new CicFilePreferences(prefFile) : new CicFileAndForwardPreferences(prefFile, this.m_memoryPreferences);
        try {
            if (prefFile.exists()) {
                filePS.load();
            } else {
                File parent = prefFile.getParentFile();
                return_value = parent == null ? false : parent.exists() || parent.mkdirs();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            return_value = false;
        }
        this.setPreferences(filePS);
        return return_value;
    }

    @Override
    public boolean isValid() {
        return this.m_isValid;
    }

    @Override
    public boolean isReady() {
        return this.m_isValid;
    }

    @Override
    public void save() {
        try {
            CicFilePreferences store = (CicFilePreferences)this.getPreferences();
            store.flush();
        }
        catch (BackingStoreException e) {
            e.printStackTrace();
        }
    }

    @Override
    public IStatus getStatus() {
        return super.getStatus();
    }
}

